package diagram;

import com.sun.image.codec.jpeg.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import javax.swing.*;
import java.util.*;


/**
 * Title:        recocase
 * Description:  this object is used to create a "thumbnail" of a
 *               diagram so it can be saved to disk.
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author
 * @version 1.0
 */


public class DThumbnail extends JFrame implements ActionListener,AdjustmentListener,KeyListener  {
  private Image image;

  private JLabel qualityL;
  private JScrollBar qualityS ;

  private JTextField widthT;
  private JTextField heightT;
  private JCheckBox ratioC;
  private JTextField pathT;

  private  int width = 10;
  private  int height = 10;
  public DThumbnail( Image aimage,int awidth, int aheight ) {
    super("Save JPG");
    image = aimage;
    width = awidth;
    height = aheight;
    init();
  }

  public void init() {
    JPanel mainP = new JPanel();
    mainP.setLayout(new BoxLayout(mainP, BoxLayout.Y_AXIS));
//    mainP.setLayout(new FlowLayout(FlowLayout.CENTER, 1, 1));


    //quality ---------------------
    JPanel qualityP = new JPanel();
    qualityP.setLayout(new BorderLayout());
    qualityP.setBorder( BorderFactory.createTitledBorder("Quality:"));


    qualityS = new JScrollBar(JScrollBar.HORIZONTAL,80,5,0,100);
    qualityS.addAdjustmentListener(this);
    qualityL = new JLabel("Quality: 80%");
    qualityP.add(qualityS,BorderLayout.SOUTH);
    qualityP.add(qualityL,BorderLayout.NORTH);


    //----------SIZE
    JPanel sizeP = new JPanel();
    sizeP.setLayout(new BoxLayout(sizeP, BoxLayout.Y_AXIS));
    sizeP.setBorder( BorderFactory.createTitledBorder("size:"));


    JLabel widthL = new JLabel("Width:");
    widthT = new JTextField(""+width,5) ;
    widthT.setPreferredSize(new Dimension(80,20));
    widthT.setActionCommand("width");
    widthT.addActionListener(this);
    widthT.addKeyListener(this);

    JLabel heightL = new JLabel("Height:");
    heightT= new JTextField(""+height,5) ;
    heightT.setPreferredSize(new Dimension(80,20));
    heightT.setActionCommand("height");
    heightT.addActionListener(this);
    heightT.addKeyListener(this);

    JLabel ratioL = new JLabel("Original Ratio:");
    ratioC = new JCheckBox();
    ratioC.setSelected(true);

    sizeP.add(widthL);
    sizeP.add(widthT);
    sizeP.add(heightL);
    sizeP.add(heightT);
    sizeP.add(ratioL);
    sizeP.add(ratioC);




    //--------------- PATH
    JPanel pathP = new JPanel();
    pathP.setLayout(new BoxLayout(pathP, BoxLayout.Y_AXIS));
    pathP.setBorder( BorderFactory.createTitledBorder("path:"));

    pathT = new JTextField();
    pathT.setPreferredSize(new Dimension(80,20));
    if(business.Global.systemUnix){
      pathT.setText(business.Global.pathUnix+ "diagram.jpg");
    }else{
      pathT.setText(business.Global.pathWindows+ "diagram.jpg");
    }
    pathP.add(pathT);

    //---------------
    JButton saveB = new JButton("Save",business.Global.imageIconSaveJPG);
    saveB.setActionCommand("save");
    saveB.addActionListener(this);


    //
//    sizeP.setPreferredSize(new Dimension(200,150));
//    qualityP.setPreferredSize(new Dimension(200,60));
//    pathP.setPreferredSize(new Dimension(200,20));
//    mainP.setPreferredSize(new Dimension(700,300));

    mainP.add(sizeP);
    mainP.add(qualityP);
    mainP.add(pathP);
    mainP.add(saveB);

    //buttonP.setLayout(new BorderLayout());

    this.getContentPane().add(mainP,BorderLayout.CENTER);

    this.pack();
    this.show();
  }



//public boolean flag = true;

  public void actionPerformed(ActionEvent event) {
    String command = event.getActionCommand();

    if (command.equals("save")){

      int imgWidth = Integer.parseInt(widthT.getText());
      int imgHeight = Integer.parseInt(heightT.getText());
      int imgQuality = qualityS.getValue();
      String imgPath = pathT.getText();

      this.save(imgWidth,imgHeight,imgQuality,imgPath);
      this.hide();
    }
//    }else if (command.equals("width")){
//      if(flag){
//        flag = false;
//        if(ratioC.isSelected()){
//          int w =  Integer.parseInt(widthT.getText());
//          int h = (int)(((float)w/(float)width)*(float)height);
//          heightT.setText(h+"");
//        }
//        flag = true;
//      }
//    }else if (command.equals("height")){
//      if(flag){
//        flag = false;
//        if(ratioC.isSelected()){
//          int h =  Integer.parseInt(heightT.getText());
//          int w = (int)(((float)h/(float)height)*(float)width);
//          widthT.setText(h+"");
//        }
//        flag = true;
//      }
//    }


  }

  public void adjustmentValueChanged(AdjustmentEvent e){

    qualityL.setText("Quality:"+qualityS.getValue()+"%");

  }

  public void save(int imgWidth,int imgHeight,int quality, String path){
    try{
      // load image from INFILE
      MediaTracker mediaTracker = new MediaTracker(new Frame());
      mediaTracker.addImage(image, 0);
      mediaTracker.waitForID(0);
      // determine thumbnail size from WIDTH and HEIGHT
      int thumbWidth = imgWidth;
      int thumbHeight = imgHeight;
      double thumbRatio = (double)thumbWidth / (double)thumbHeight;
      int imageWidth = image.getWidth(null);
      int imageHeight = image.getHeight(null);
      double imageRatio = (double)imageWidth / (double)imageHeight;
      if (thumbRatio < imageRatio) {
        thumbHeight = (int)(thumbWidth / imageRatio);
      } else {
        thumbWidth = (int)(thumbHeight * imageRatio);
      }
      // draw original image to thumbnail image object and
      // scale it to the new size on-the-fly
      BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, BufferedImage.TYPE_INT_RGB);
      Graphics2D graphics2D = thumbImage.createGraphics();
      graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
      graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
      // save thumbnail image to OUTFILE
      BufferedOutputStream out = new BufferedOutputStream(new  FileOutputStream(path));
      JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
      JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(thumbImage);
      quality = Math.max(0, Math.min(quality, 100));
      param.setQuality((float)quality / 100.0f, false);
      encoder.setJPEGEncodeParam(param);
      encoder.encode(thumbImage);
      out.close();

    }
    catch (Exception ex) {
      JOptionPane.showMessageDialog(this,"ERROR SAVING JPG");
    }
  }


  public void keyTyped(KeyEvent e) {

  }

  /** Handle the key pressed event from the text field. */
  public void keyPressed(KeyEvent e) {

  }

    /** Handle the key released event from the text field. */
  public void keyReleased(KeyEvent e) {
    if(e.getSource().equals(widthT)){
      System.out.println("h");
      if(ratioC.isSelected()){
        int w =  Integer.parseInt(widthT.getText());
        int h = (int)(((float)w/(float)width)*(float)height);
        heightT.setText(h+"");
      }
    }
    if(e.getSource().equals(heightT)){
      System.out.println("w");
      if(ratioC.isSelected()){
        int h =  Integer.parseInt(heightT.getText());
        int w = (int)(((float)h/(float)height)*(float)width);
        widthT.setText(h+"");
      }
    }
  }

}
