package diagram;

import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.*;
import javax.swing.text.*;
import javax.swing.*;
import java.util.Vector;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */


public class DResolutionTable extends JFrame implements ActionListener,ItemListener {

    protected JFileChooser fileDialog = new JFileChooser();



    private  String fileName;
    private  JLabel nameL;
    private  String name = "no name";

    private  JComboBox comboBox;
    private  JButton CreateLatticeB;
    private  JCheckBox synonymsCB = null;
    private  JButton ShowSynonymTableB;
    private  JButton closeWindowB;
    private  JButton minimizeWindowB;


    private  JButton attrFindB;
    private  JButton attrFindExactB;
    private  JButton attrAddAllB;


    private  JButton objResetB;
    private  JButton objSetB;
    private  JButton objFindB;
    private  JButton objFindInB;
    private  JButton objCheckB;
    private  JButton objUncheckB;


    //DDiagram owner;

    //business.fca.ContextTable theContextTable;
    private business.fca.SimpleTable xtable;

    private JTable ObjTable;
    private Vector ObjRows = new Vector();
    private Vector ObjCols = new Vector();

    private JTable AttTable;
    private Vector AttRows = new Vector();
    private Vector AttCols = new Vector();

    private Vector FAttrRows = new Vector();
    private Vector FAttr = new Vector();
    private Vector FAttrBolean = new Vector();

    private JTable FAttrTable;
    private JButton FAttrAddB;
    private JButton FAttrDeleteB;

    /**
     * ResolutionTable
     * String contains the name of the file name of an FLT file
     * this file is opend and a lattice drawn
     */


    private String  resolutionId;
    public JFrame frameF ;

//    public ResolutionTable(String aResolutionId) {
//        //super("ResolutionTable");
//        this.resolutionId = aResolutionId;
//        business.fca.SimpleTable table =  persistence.CResolution.getSimpleTable(resolutionId);
//        init(table);
//    }



    public DResolutionTable(String Name, business.fca.SimpleTable table) {
      super("Table: "+Name);
      name = Name;
      init( table);
    }

    public String getName(){
      return name;
    }


    /**
     * Init
     * create menus
     * create tables (attributes and Objects) and insert data
     * display
     */

    private void init(business.fca.SimpleTable aTable) {
        frameF = this;
        frameF.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent e) {
          //frameF.dispose();
          closeWindow();
          //business.Global.contrViewpoint.closeResolutionTable (frameF);
          //do nothing
          }
        });
        business.Global.contrResolution.addResolutionTable(frameF);
        //business.fca.ContextTable aContextTable
        //this.owner = anOwner;
        this.xtable = aTable;


        //---------------------------------------------------------------------------
        // ATT TABLE
        //---------------------------------------------------------------------------

        AttCols.add("Phrases");

        for(int i = 0 ; i< this.xtable.getAttrSize() ; i++){
            //System.out.println(theContextTable.get_attr_name(i));
            Vector data = new Vector();
            data.add(xtable.getAttrName(i));
            AttRows.add(data);
        }


        AttTable = new JTable( new MyTableModel(AttRows, AttCols));
        if (AttRows.size() < 15){
          AttTable.setPreferredScrollableViewportSize(new Dimension(250, 20+(16*AttRows.size()) ));
        }else{
          AttTable.setPreferredScrollableViewportSize(new Dimension(250, 15*16 ));
        }
        javax.swing.table.TableColumn column = null;
        for (int i = 0; i < AttCols.size() ; i++) {
          column = AttTable.getColumnModel().getColumn(i);
          column.setPreferredWidth(250); //this column is bigger
        }

        JPanel attributesP = new JPanel();
        attributesP.setLayout(new BorderLayout());

        JPanel objectsP = new JPanel();
        objectsP.setLayout(new BorderLayout());

        JPanel tableP = new JPanel();
        tableP.setLayout(new BorderLayout());

        JPanel attrToolsP = new JPanel();
        attrToolsP.setLayout(new FlowLayout());//(new BorderLayout());

        JPanel objToolsP = new JPanel();
        objToolsP.setLayout(new FlowLayout());//(new BorderLayout());


        TitledBorder attrubitesT;
        attrubitesT = BorderFactory.createTitledBorder("Attributes");
        attributesP.setBorder(attrubitesT);



        //Create the scroll pane and add the table to it.
        JScrollPane scrollPane = new JScrollPane(AttTable);
        attributesP.add(scrollPane, BorderLayout.CENTER);

        //---------------------------------------------------------------------------
        //    TOOLS OBJ

        TitledBorder toolsAttrT;
        toolsAttrT = BorderFactory.createTitledBorder("Tools");
        attrToolsP.setBorder(toolsAttrT);

        this.attrFindB = new JButton("Find");
        this.attrFindB.setActionCommand("AttrFind");
        attrFindB.addActionListener(this);

        this.attrFindExactB = new JButton("Find Exact");
        this.attrFindExactB.setActionCommand("AttrFindExact");
        attrFindExactB.addActionListener(this);


        this.attrAddAllB = new JButton("Add To Synonyms");
        this.attrAddAllB.setActionCommand("AddAll");
        attrAddAllB.addActionListener(this);


        attrToolsP.add(attrFindB);
        attrToolsP.add(attrFindExactB);
//        attrToolsP.add(attrAddB);
        attrToolsP.add(attrAddAllB);


        //---------------------------------------------------------------------------
        // ADVANCED TOOLS
        //---------------------------------------------------------------------------


        JPanel AdvAttrP = new JPanel();
        AdvAttrP.setLayout(new BorderLayout());//(new FlowLayout())
        TitledBorder AdvAttrT;
        AdvAttrT = BorderFactory.createTitledBorder("Force Attribute");
        AdvAttrP.setBorder(AdvAttrT);


        Vector FAttrCols = new Vector();
        FAttrCols.add("#");
        FAttrCols.add("Attribute");
        FAttrCols.add("use");

//        Vector row = new Vector();
//        row.addElement("1");
//        row.addElement("2");
//        row.addElement(new Boolean(true));
//        FAttrRows.add(row);



        MyTableModel FAttrTableModel = new MyTableModel(FAttrRows,FAttrCols);
        FAttrTable = new JTable(FAttrTableModel);
        //Create the scroll pane and add the table to it.
        JScrollPane FAttrScrollPane = new JScrollPane(FAttrTable);

        FAttrTable.setPreferredScrollableViewportSize(new Dimension(250, 60));
        FAttrTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        FAttrTable.getColumnModel().getColumn(1).setPreferredWidth(500);
        FAttrTable.getColumnModel().getColumn(2).setPreferredWidth(30);




        this.FAttrAddB = new JButton("Add");
        this.FAttrAddB.setActionCommand("Add");
        FAttrAddB.addActionListener(this);


        this.FAttrDeleteB = new JButton("Delete");
        this.FAttrDeleteB.setActionCommand("Delete");
        FAttrDeleteB.addActionListener(this);


        AdvAttrP.add(FAttrScrollPane, BorderLayout.NORTH);


        JPanel FAttrBP = new JPanel();
        FAttrBP.setLayout(new FlowLayout());
        FAttrBP.add(FAttrAddB);
        FAttrBP.add(FAttrDeleteB);

        AdvAttrP.add(FAttrBP, BorderLayout.SOUTH);
        attributesP.add(AdvAttrP, BorderLayout.SOUTH);


        //---------------------------------------------------------------------------

        tableP.add(attrToolsP, BorderLayout.NORTH);
        attributesP.add(tableP, BorderLayout.NORTH);


        //---------------------------------------------------------------------------
        // OBJ TABLE
        //---------------------------------------------------------------------------

        TitledBorder objectsT;
        objectsT = BorderFactory.createTitledBorder("Objects");
        objectsP.setBorder(objectsT);


        Vector ObjCols = new Vector();
        ObjCols.add("#");
        ObjCols.add("Object");
        ObjCols.add("FCA");

        Vector selectedNodes = new Vector();



        ObjRows =  new Vector();

        for(int i = 0 ; i< this.xtable.getObjSize() ; i++){
           //System.out.println(theContextTable.get_obj_complete_name(i));
            Vector data = new Vector();
            data.add(i+"");
            data.add(xtable.getObj(i).getStep()+" : "+xtable.getObj(i).getAction());
            data.add(new Boolean(xtable.getObjInLattice(i)));
            //data.add(new Boolean(true));
            ObjRows.addElement(data);
        }

        MyTableModel ObjTableModel = new MyTableModel(ObjRows,ObjCols);
        ObjTable = new JTable(ObjTableModel);
        //Create the scroll pane and add the table to it.
        JScrollPane ObjScrollPane = new JScrollPane(ObjTable);

        if (AttRows.size() < 20){
          ObjTable.setPreferredScrollableViewportSize(new Dimension(560, 20+(16*AttRows.size()) ));
        }else{
          ObjTable.setPreferredScrollableViewportSize(new Dimension(560, 20*16 ));
        }
        ObjTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        ObjTable.getColumnModel().getColumn(1).setPreferredWidth(500);
        ObjTable.getColumnModel().getColumn(2).setPreferredWidth(30);

        objectsP.add(ObjScrollPane, BorderLayout.CENTER);
        //---------------------------------------------------------------------------
        //  TOOLS  OBJ

        TitledBorder toolsObjT;
        toolsObjT = BorderFactory.createTitledBorder("Tools");
        objToolsP.setBorder(toolsObjT);

        this.objFindInB = new JButton("Find within Selected");
        this.objFindInB.setActionCommand("ObjFind In");
        objFindInB.addActionListener(this);

        this.objFindB = new JButton("Find");
        this.objFindB.setActionCommand("ObjFind");
        objFindB.addActionListener(this);

        this.objResetB = new JButton("Reset All");
        this.objResetB.setActionCommand("ObjReset");
        objResetB.addActionListener(this);

        this.objSetB = new JButton("Set All");
        this.objSetB.setActionCommand("ObjSet");
        objSetB.addActionListener(this);

        this.objCheckB = new JButton("Include");
        this.objCheckB.setActionCommand("ObjCheck Selected");
        objCheckB.addActionListener(this);

        this.objUncheckB = new JButton("Don't Include");
        this.objUncheckB.setActionCommand("ObjUncheck Selected");
        objUncheckB.addActionListener(this);

        objToolsP.add(objFindB);
        objToolsP.add(objFindInB);
        objToolsP.add(objCheckB);
        objToolsP.add(objUncheckB);
        objToolsP.add(objResetB);
        objToolsP.add(objSetB);


        objectsP.add(objToolsP, BorderLayout.NORTH);

        //---------------------------------------------------------------------------



        this.ShowSynonymTableB = new JButton("Show Synonym Table",business.Global.imageIconSinonym);
        this.ShowSynonymTableB.setActionCommand("ShowSynonymTable");
        ShowSynonymTableB.addActionListener(this);

        JLabel synonymsL = new JLabel("using synonyms:");
        synonymsCB = new JCheckBox();
        synonymsCB.addItemListener(this);

        this.CreateLatticeB = new JButton("Create Diagram",business.Global.imageIconDiagram);
        this.CreateLatticeB.setActionCommand("CreateLattice");
        CreateLatticeB.addActionListener(this);

        this.closeWindowB = new JButton("Close",business.Global.imageIconClose);
        this.closeWindowB.setActionCommand("Close");
        closeWindowB.addActionListener(this);

        this.minimizeWindowB = new JButton("Minimize",business.Global.imageIconMinimize);
        this.minimizeWindowB.setActionCommand("minimize");
        minimizeWindowB.addActionListener(this);

        //-----------

    JPanel buttonPR = new JPanel();
    buttonPR.setLayout(new FlowLayout(FlowLayout.RIGHT, 1, 1));
    JPanel buttonPL = new JPanel();
    buttonPL.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));


        buttonPL.add(ShowSynonymTableB);
        buttonPL.add(CreateLatticeB);
        buttonPL.add(synonymsL);
        buttonPL.add(synonymsCB);

        buttonPR.add(minimizeWindowB);
        buttonPR.add(closeWindowB);


    JPanel buttonP = new JPanel();
    buttonP.setLayout(new BorderLayout());
    buttonP.add(buttonPL,BorderLayout.WEST);
    buttonP.add(buttonPR,BorderLayout.EAST);


        //---------------------------------------------------------------------------
        nameL = new JLabel("Table for Group Viwpoint: "+ this.name  +"   Project: "+business.Global.project.getName() );
        JPanel infoP = new JPanel();
        infoP.setLayout(new BorderLayout());

        TitledBorder infoT;
        infoT = BorderFactory.createTitledBorder("Info");
        infoP.setBorder(infoT);
        infoP.add(nameL,BorderLayout.WEST);

        //---------------------------------------------------------------------------

        JPanel topP = new JPanel();
        topP.setLayout(new BorderLayout());
        topP.add(buttonP, BorderLayout.NORTH);
        topP.add(infoP, BorderLayout.SOUTH);
//        getContentPane().add(infoP, BorderLayout.NORTH);
//        getContentPane().add(buttonP, BorderLayout.SOUTH);
        getContentPane().add(topP, BorderLayout.NORTH);
        getContentPane().add(attributesP, BorderLayout.WEST);
        getContentPane().add(objectsP, BorderLayout.EAST);

        this.pack();
        this.setVisible(true);
//        this.updateGUI();

        fileDialog.resetChoosableFileFilters();
        fileDialog.addChoosableFileFilter(new javax.swing.filechooser.FileFilter() {
          public boolean accept(File f) {
            String name = f.getName();
              if (f.isDirectory()) return true;
              if (name.regionMatches(true,name.length()-4,".flt",0,4)) return true;
              if (name.regionMatches(true,name.length()-4,".FLT",0,4)) return true;
              return false;
            }
            public String getDescription() {
              return "'*.flt','*.FLT'";
            }
          }
        );




    }

    private void printDebugData(JTable table) {

        int numRows = table.getRowCount();
        //int numCols = table.getColumnCount();
        javax.swing.table.TableModel model = table.getModel();

        System.out.println("Value of data: ");
        for (int i=0; i < numRows; i++) {
            if(!model.getValueAt(i, 2).equals("")){
              int num;
              try{
                num =  Integer.parseInt( model.getValueAt(i, 2).toString());
              }
              catch (Exception e)
              {
                num = -1;
              }
              if(num == -1){
                JOptionPane.showMessageDialog(null,"Error in row : "+i);
              }
              System.out.print( (i+1) + ":" + model.getValueAt(i, 2) +":"+num);
              System.out.println();
            }
        }
        //System.out.println("--------------------------");
    }

    /**
     * Close
     */
    public boolean closeWindow() {
            int option;
            option = JOptionPane.showConfirmDialog(this,"Do you want to Close it?","Close",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
            if (option == JOptionPane.OK_OPTION){
              business.Global.contrResolution.closeResolutionTable (frameF);
              return true;
            } else
            if (option == JOptionPane.CANCEL_OPTION){
                return false;
            } else
            if (option == JOptionPane.NO_OPTION){
                return false;
            }else{
              return false;
            }
    }

   /**
     * action performed
     */
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();

	if (command.equals("AttrFind"))
	{
          attrFind();
	}
       //find

       	if (command.equals("AttrFindExact")){
          findExact();
	}//find exact

	if (command.equals("ShowSynonymTable")){
          business.Global.project.getSynonymTableFrame().show();
        }

	if (command.equals("AddAll")){
          addAll();
        }

	if (command.equals("Add")){
          this.addFAttr();
        }

	if (command.equals("Delete")){
          this.deleteFAttr();
        }

	if (command.equals("ObjReset"))
	{
          for(int row = 0;row<ObjTable.getRowCount();row++){
              ObjTable.getModel().setValueAt(new Boolean(false),row,2);
          }
        }

	if (command.equals("ObjSet"))
	{
          for(int row = 0;row<ObjTable.getRowCount();row++){
              ObjTable.getModel().setValueAt(new Boolean(true),row,2);
          }
        }

	if (command.equals("ObjFind"))
	{
          String search = JOptionPane.showInputDialog(this,"Search for:");
          if (search != null){

            ObjTable.removeRowSelectionInterval(0,ObjTable.getRowCount()-1);
            for(int row = 0;row<ObjTable.getRowCount();row++){
              String test = " "+((String) ObjTable.getModel().getValueAt(row,1))+" ";
              boolean found = false;
              for(int x = 0;x<(test.length()-search.length()+1)&&found==false;x++){
                if(test.regionMatches(true,0+x,search,0,search.length())){
                    found = true;
                    ObjTable.changeSelection(row,0,true,false);
                }
              }//for
            }//for
          }//if
	}
	if (command.equals("ObjFind In"))
	{
          String search = JOptionPane.showInputDialog(this,"Search for:");
          if (search != null){
            for(int row = 0;row<ObjTable.getRowCount();row++){
              if(ObjTable.isRowSelected(row)){
                String test = " "+((String) ObjTable.getModel().getValueAt(row,1))+" ";
                boolean found = false;
                for(int x = 0;x<(test.length()-search.length()+1)&&found==false;x++){

                  if(test.regionMatches(true,0+x,search,0,search.length())){
                      found = true;
                  }//if
                }//for
                if(!found){
                  ObjTable.changeSelection(row,0,true,false);
                }
              }//if
            }
          }
	}
	if (command.equals("ObjCheck Selected"))
	{
          boolean foundSelected = false;
          for(int row = 0;row<ObjTable.getRowCount();row++){
            if(ObjTable.isRowSelected(row)){
              foundSelected = true;
              ObjTable.getModel().setValueAt(new Boolean(true),row,2);
            }
          }
          if(!foundSelected){
            JOptionPane.showMessageDialog(this,"You must select one or more rows first");
          }
	}
	if (command.equals("ObjUncheck Selected"))
	{
          boolean foundSelected = false;
          for(int row = 0;row<ObjTable.getRowCount();row++){
            if(ObjTable.isRowSelected(row)){
              foundSelected = true;
              ObjTable.getModel().setValueAt(new Boolean(false),row,2);
            }
          }
          if(!foundSelected){
            JOptionPane.showMessageDialog(this,"You must select one or more rows first");
          }
	}
	if (command.equals("Close"))
	{
            this.closeWindow();
	}
	if (command.equals("minimize"))
	{
            this.hide();
	}


	if (command.equals("CreateLattice"))
	{
            createLattice();
        }

    }

  /**
   * update Table
   */

    public void createLattice()
    {

        //get values
        FAttrBolean.clear();
        for(int i = 0 ; i < FAttr.size() ; i++){
          FAttrBolean.add( FAttrTable.getValueAt(i,2) );
        }

        xtable.clearForceAttributes();
        for(int i = 0;i<FAttr.size();i++){
          if( ((Boolean)FAttrBolean.elementAt(i)).booleanValue())
          {
            xtable.addForceAttribute((String) FAttr.elementAt(i));
          }
        }//for
        DDiagram diagram =  new DDiagram();//new DDiagram(false);
        if (this.updateT()){
          diagram.show();
          diagram.createFCA(xtable);
          //this.closeWindow();
        }

    }


  private boolean updateT(){
    xtable.reset();
    for(int row = 0 ; row < this.xtable.getObjSize() ; row++){
      if( ObjTable.getModel().getValueAt(row,2).equals( new Boolean(false))){
            this.xtable.removeobjfromlattice(row);
      }
    }
    return true;
  }//update

  public String getId(){
    return this.xtable.getId();
  }


  private void addAll(){
    business.Global.project.getSynonymTableFrame().show();
    for(int i = 0 ; i< this.xtable.getAttrSize() ; i++){
        business.Global.project.getSynonymTable().addPhrase(xtable.getAttrName(i));
    }
    business.Global.project.getSynonymTableFrame().updateTable();
  }

  public void attrFind(){
          String search = JOptionPane.showInputDialog(this,"Search for:");
          if (search != null){
            this.AttTable.removeRowSelectionInterval(0,this.AttTable.getRowCount()-1);

            Vector attrFound =  new Vector();
            for(int row = 0;row<this.AttTable.getRowCount();row++){
              String attr = ((String) this.AttTable.getModel().getValueAt(row,0));
              String test = " "+attr+" ";
              boolean found = false;
              for(int x = 0;x<(test.length()-search.length()+1)&&found==false;x++){
                if(test.regionMatches(true,0+x,search,0,search.length())){
                    found = true;
                    attrFound.addElement(attr);
                    this.AttTable.changeSelection(row,0,true,false);
                }
              }
            }

            //find the objects with the attributes found
            ObjTable.removeRowSelectionInterval(0,ObjTable.getRowCount()-1);
            for(int row = 0;row<xtable.rowSize() ;row++){
              boolean found = false;
              for(int i = 0 ;i<attrFound.size()&&found==false; i++){
                if (((Vector) xtable.getRow(row)).contains(attrFound.elementAt(i)))
                {
                    found = true;
                    ObjTable.changeSelection(row,0,true,false);
                }
              }
            }
         }//not cancel search
}

  private void findExact(){
          String search = JOptionPane.showInputDialog(this,"Search for:");
          if (search != null){
            this.AttTable.removeRowSelectionInterval(0,this.AttTable.getRowCount()-1);
            Vector attrFound =  new Vector();
            for(int row = 0;row<this.AttTable.getRowCount();row++){
              String attr = ((String) this.AttTable.getModel().getValueAt(row,0));
                if(attr.equals(search)){
                    attrFound.addElement(attr);
                    this.AttTable.changeSelection(row,0,true,false);
                }
            }
            //find the objects with the attributes found
            ObjTable.removeRowSelectionInterval(0,ObjTable.getRowCount()-1);
            for(int row = 0;row<xtable.rowSize() ;row++){
              boolean found = false;
              for(int i = 0 ;i<attrFound.size()&&found==false; i++){
                if (((Vector) xtable.getRow(row)).contains(attrFound.elementAt(i)))
                {
                    found = true;
                    ObjTable.changeSelection(row,0,true,false);
                }
              }
            }
          }
      }

  public void itemStateChanged(ItemEvent e){
    Object source = e.getItemSelectable();
      if (source == synonymsCB) {
        this.xtable.useSynonyms(synonymsCB.isSelected());
      }
    }


    public void deleteFAttr(){
      //get values
        FAttrBolean.clear();
        for(int i = 0 ; i < FAttr.size() ; i++){
          FAttrBolean.add( FAttrTable.getValueAt(i,2) );
        }
      //modify
        int row = FAttrTable.getSelectedRow();
        FAttr.remove( row );
        FAttr.remove( row );
        fixFAttrTable();
    }

    public void addFAttr(){
      //get values
        FAttrBolean.clear();
        for(int i = 0; i < FAttr.size();i++){
          FAttrBolean.add( FAttrTable.getValueAt(i,2) );
        }
      //modify
      String attrString = JOptionPane.showInputDialog(this,"Attribute");
      if (attrString != null && !attrString.equals("")){
        FAttr.addElement(attrString);
        FAttrBolean.add(new Boolean(true));
        fixFAttrTable();
      }//if
    }


    public void fixFAttrTable(){

        Vector FAttrCols = new Vector();
        FAttrCols.add("#");
        FAttrCols.add("Attribute");
        FAttrCols.add("use");

        FAttrRows = new Vector();
        for(int i = 0;i<FAttr.size();i++){
          Vector row = new Vector();
          row.addElement(i+"");
          row.addElement((String) FAttr.elementAt(i));
          row.addElement(( Boolean)FAttrBolean.elementAt(i));
          FAttrRows.add(row);
        }//for

        MyTableModel FAttrTableModel = new MyTableModel(FAttrRows,FAttrCols);
        FAttrTable.setModel(FAttrTableModel);

        FAttrTable.setPreferredScrollableViewportSize(new Dimension(250, 10+(14*FAttr.size())));
        FAttrTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        FAttrTable.getColumnModel().getColumn(1).setPreferredWidth(500);
        FAttrTable.getColumnModel().getColumn(2).setPreferredWidth(30);
    }



















class MyTableModel extends DefaultTableModel {
  public MyTableModel(Vector AData, Vector AColumnNames) {
    super(AData, AColumnNames);
  }

  public MyTableModel(Object[][] AData, Object[] AColumnNames) {
    super(AData, AColumnNames);
  }

  public MyTableModel(Object[] AColumnNames, int ACountObj) {
    super(AColumnNames, ACountObj);
  }

  public MyTableModel(Vector AColumnNames, int ACountObj) {
    super(AColumnNames, ACountObj);
  }

   public Class getColumnClass(int c) {
     return getValueAt(0, c).getClass();
   }

  public boolean isCellEditable(int row, int col) {
  //Note that the data/cell address is constant,
  //no matter where the cell appears onscreen.
    if (col < 2) {
        return false;
    } else {
        return true;
    }
  }
}



}
