package diagram;

import javax.swing.JFrame;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.applet.*;
import java.util.*;
import java.util.Vector;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.*;



/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class DReport extends JFrame {

  private JTextArea  comments;
  private DReport    thisReport;
  private JTable     resultsTable;
  private Vector cols = new Vector();
  private Vector rows = new Vector();
  private DGraph graph = null;
  private DDiagram diagram = null;

  private Vector allVPNames = new Vector();




  public DReport() {

        super("REPORT");
        this.setSize(600, 600);
        thisReport = this;


        JPanel finalPane = new JPanel();
        finalPane.setLayout(new BorderLayout());

        JPanel reportPane = new JPanel();
        reportPane.setLayout(new BorderLayout());

        JLabel commentsLabel = new JLabel("REPORT:");
        reportPane.add(commentsLabel,BorderLayout.NORTH);


        comments = new JTextArea();

        comments.setRows(10);
        //comments.setColumns(10);
        comments.setLineWrap(true);
        comments.setWrapStyleWord(true);
        JScrollPane commentsScroll = new JScrollPane(comments);
        reportPane.add(commentsScroll,BorderLayout.CENTER);

        JButton button = new JButton("close");
        finalPane.add(button,BorderLayout.SOUTH);
        button.addActionListener(
        new ActionListener() {
           public void actionPerformed(ActionEvent e) {thisReport.dispose();}
        });



        JMenuBar menuBar = new JMenuBar();
        JMenu MFile = new JMenu("[File]");
        JMenuItem MIExit = new JMenuItem("Exit");
        MFile.add(MIExit);
        MIExit.addActionListener(
        new ActionListener() {
           public void actionPerformed(ActionEvent e) {thisReport.dispose();}
        });
        menuBar.setEnabled(true);
        menuBar.add(MFile);

        this.setJMenuBar(menuBar);
        finalPane.add(reportPane,BorderLayout.CENTER);
        setContentPane(finalPane);


        this.resultsTable = new JTable();
        resultsTable.setPreferredScrollableViewportSize(new Dimension(350, 100));
        JScrollPane resultsPane = new JScrollPane(resultsTable);
        finalPane.add(resultsPane,BorderLayout.NORTH);

        show();
    }

    public void setText(String text ){
        comments.setText(text);
    }
    public void addToText(String text){
        comments.setText( comments.getText() + text);
    }


    public String getText(){
        return comments.getText();
    }

    public void setTable(){

      this.resultsTable.setModel( new MyTableModel(rows, cols));
      for(int i = 0;i<rows.size();i++){
        Vector row = (Vector) rows.elementAt(i);
        for(int ii = 0;ii<row.size();ii++){
          if(row.elementAt(ii)==null ){
            row.setElementAt("100%",ii);
          }
        }
      }

   }

   public void setTableResult(String Vp1,String Vp2,String result){
      Vector row;
      if(cols.size()==0)cols.add("Vp Name"); //col=1 is for vp names
      if(!cols.contains(Vp1)){
        cols.addElement(Vp1);
        row = new Vector();
        row.add(Vp1);
        rows.addElement(row);
      }
      if(!cols.contains(Vp2)){
        cols.addElement(Vp2);
        row = new Vector();
        row.add(Vp2);
        rows.addElement(row);
      }
      for(int i = 0;i<rows.size();i++){
        row = (Vector) rows.elementAt(i);
        row.setSize(cols.size());
      }

      row = (Vector) rows.elementAt(cols.indexOf(Vp1)-1);
      row.insertElementAt(result,cols.indexOf(Vp2));
      //this.resultsTable.setModel( new MyTableModel(rows, cols));


   }


  public void createReport(DDiagram adiagram,DGraph agraph){

    this.graph = agraph;
    this.diagram = adiagram;
    // find the botom node and get the objects in the nodes ready
    DNode bottomNode = null;

    for(int i=0 ; i<this.graph.nodes.size() ; i++){
        DNode node  = (DNode) this.graph.nodes.elementAt(i);
        //find bottom node
        if (bottomNode == null){bottomNode =node; }
        else
        if (node.attr_set().get_size() > bottomNode.attr_set().get_size()    ){
            bottomNode = node;
        }
        //get obj in node ready
        node.resetObjects();
    }
    bottomNode.setObjectsUnderNode(this.diagram);

    //find number of viewpoints
    allVPNames = new Vector();
    Vector allObjects = diagram.graph.getAllObjects();
    for(int i = 0;i<  allObjects.size();i++){
      String VP = (((business.fca.FCAObject)allObjects.elementAt(i)).getVPName());
        if(!VP.equals("") && !allVPNames.contains(VP)){
          allVPNames.add(VP);
        }
    }

    //sort viewpoints by name
    if(allVPNames.size()>1){
      for(int x = 0 ; x < allVPNames.size() ; x++){
        for(int y = 1 ; y < allVPNames.size() ; y++){
          String obj1 = (String) allVPNames.elementAt(y-1);
          String obj2 = (String) allVPNames.elementAt(y);
          if(obj1.compareTo(obj2)>0){
            allVPNames.setElementAt(obj1,y);
            allVPNames.setElementAt(obj2,y-1) ;
          }
        }
      }
    }

    //find distance of every VP compare to others VP
    float float0 =  ((new Float(0.0)).floatValue());
    String VPName;
    String compareVPName;
    boolean first = true;
    business.fca.FCAObject obj;
    Vector allAttr = new Vector();
    Vector attr = new Vector();
    Float objScore = new Float(0+"");
    float result ;

    for(int x = 0; x < allVPNames.size();x++){
      VPName = (String)allVPNames.elementAt(x);
      this.addToText("############################## "+VPName+" ##############################\n");
      first = true;
      for(int y = 0; y < allVPNames.size();y++){
        compareVPName = (String)allVPNames.elementAt(y);
        float sumScore = float0 ;
        float count = float0;
        if(!VPName.equals(compareVPName) ){
          if(!first){this.addToText("************************\n");}else{first = false;}
          for(int i = 0;i<allObjects.size();i++){
            obj = (business.fca.FCAObject) allObjects.elementAt(i);
            if(obj.getVPName().equals(VPName)){
              allAttr = new Vector();
              attr = new Vector();
              bottomNode.distance(compareVPName,obj,allAttr ,attr);
              if(attr.size()>0 && allAttr.size()>0){
                Float a = new Float(""+attr.size());
                Float b = new Float(""+allAttr.size());
                objScore = new Float(a.floatValue()/b.floatValue());
              }
              obj.setScoreAgainstVP(objScore, compareVPName);
              //make this.
              if(!obj.getFlag().equals("IGNORE")){
                sumScore = sumScore + objScore.floatValue();
                count = count + 1;
              }
              this.addToText(VPName + " compare with " + compareVPName + " : " + obj.getName() +" = " +objScore.toString() +" "+ obj.getFlag() +"\n");
            }//if obj.vpname = vpname
          }//for
          result = (sumScore/count)*100;
          //make report VPx vs VPy
          this.addToText("\n"+VPName + " against " + compareVPName + " = "+ result+"\n\n");
          Float resultFloat = new Float(result);
          this.setTableResult(VPName,compareVPName,resultFloat.intValue()+"%");
        }//if vpnames <>
      }//y
    }//x
    this.setTable();
  }


  /**===============================================================
   *
   *       c l a s s     M y T a b l e M o d e l
   *
   * ===============================================================
   */

class MyTableModel extends DefaultTableModel {
  public MyTableModel(Vector AData, Vector AColumnNames) {
    super(AData, AColumnNames);
  }

  public MyTableModel(Object[][] AData, Object[] AColumnNames) {
    super(AData, AColumnNames);
  }

  public MyTableModel(Object[] AColumnNames, int ACountObj) {
    super(AColumnNames, ACountObj);
  }

  public MyTableModel(Vector AColumnNames, int ACountObj) {
    super(AColumnNames, ACountObj);
  }

   public Class getColumnClass(int c) {
     return getValueAt(0, c).getClass();
   }

  public boolean isCellEditable(int row, int col) {
    //no matter where the cell appears onscreen.
    return false;
  }
}


}