package diagram;


import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;



/**
 * Title:        RECOCASE
 * Description:
 * Copyright:    Copyright (c) 2003
 * Company:      Macquarie Uni
 * @author       Oscar Aguilera
 * @version      1.0
 */


public class DNodeOptions extends JFrame implements ActionListener {

    private JComboBox comboBox;
    private JComboBox SentencesCB;
    private JButton closeB;
    private JButton addToUCB;
    private JButton addToUCmoveB;

    private JLabel label;
    private DNode node;
    private DCanvas canvas;

    private String sentence = "";

    public DNodeOptions(DNode aNode,DCanvas aCanvas) {
        super("NODE:"+aNode.attributes());

        this.node = aNode;
        this.canvas = aCanvas;

//---------------------
        JPanel flagOptionsPane = new JPanel();
        flagOptionsPane.setBorder(
          BorderFactory.createCompoundBorder(
            BorderFactory.createTitledBorder("Flag"),
            BorderFactory.createEmptyBorder(10,5,5,5)
          )
        );

        flagOptionsPane.setLayout(new BorderLayout());

        JLabel flagLabel = new JLabel("Flag on node:");
        flagOptionsPane.add(flagLabel, BorderLayout.NORTH);

        this.comboBox = new  JComboBox();
        this.comboBox.setActionCommand("ChangeResolution");
        this.comboBox.removeAllItems();
        for(int i = 0;i< this.node.flags.size();i++){
          this.comboBox.addItem( (String) this.node.flags.elementAt(i));
        }
//        this.comboBox.addItem("DONE");
//        this.comboBox.addItem("IGNORE");
//        this.comboBox.addItem("DELAY");
//        this.comboBox.addItem("-");
//        this.comboBox.addItem("ERROR"); //extra

        this.comboBox.setSelectedItem(this.node.getFlag() );
        flagOptionsPane.add(comboBox, BorderLayout.CENTER);

//---------------------
        JPanel UCOptionsPane = new JPanel();
        UCOptionsPane.setLayout(new BorderLayout());
        UCOptionsPane.setBorder(
          BorderFactory.createCompoundBorder(
            BorderFactory.createTitledBorder("Shared Use Case"),
            BorderFactory.createEmptyBorder(10,5,5,5)
          )
        );

        if(node.getSentences().size()>0){
          if( node.getStep() == null || node.getStep().equals("") ){
            JLabel UClabel = new JLabel("Add to Usecase");
            UCOptionsPane.add(UClabel, BorderLayout.NORTH);
          }else{
            JLabel UClabel = new JLabel("*NOTE: Sentence Already In Use Case");
            UCOptionsPane.add(UClabel, BorderLayout.NORTH);
          }

            SentencesCB = new  JComboBox();
            SentencesCB.setActionCommand("SentenceToAdd");
            for(int i = 0; i < node.getSentences().size();i++){
              SentencesCB.addItem((String) node.getSentences().elementAt(i));
            }
            SentencesCB.setSelectedIndex(0);

            UCOptionsPane.add( SentencesCB, BorderLayout.CENTER);

            JPanel buttons = new JPanel();
            this.addToUCB = new JButton("Add");
            this.addToUCB.setActionCommand("Add");
            this.addToUCB.addActionListener(this);
            buttons.add(addToUCB, BorderLayout.NORTH);

            this.addToUCmoveB = new JButton("Add and Select Position");
            this.addToUCmoveB.setActionCommand("AddMove");
            this.addToUCmoveB.addActionListener(this);
            buttons.add(addToUCmoveB, BorderLayout.SOUTH);
            UCOptionsPane.add(buttons, BorderLayout.SOUTH);


        }else{
          JLabel UClabel = new JLabel("No Sentence in node");
          UCOptionsPane.add(UClabel, BorderLayout.NORTH);
        }

//-------------------

        JPanel optionsPane = new JPanel();
        optionsPane.setLayout(new BorderLayout());

        this.label = new JLabel("OPTIONS:");

        optionsPane.add(label, BorderLayout.NORTH);
        optionsPane.add(flagOptionsPane, BorderLayout.CENTER);
        optionsPane.add(UCOptionsPane, BorderLayout.SOUTH);

        this.closeB = new JButton("Cancel");
        this.closeB.setActionCommand("Cancel");
        this.closeB.addActionListener(this);

//-------------------


        getContentPane().add(optionsPane, BorderLayout.NORTH);
        getContentPane().add(closeB, BorderLayout.SOUTH);

        setSize(300, 300);

//      should be working
//        this.setBounds(X,Y,200,100);
//        this.setBounds(500,500,300,300);




        this.setVisible(true);
        this.comboBox.addActionListener(this);
        this.show();
    }

     /**
       * action performed
       */
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
	if (command.equals("ChangeResolution"))
	{
          for(int i = 0; i < node.getSentences().size();i++){
            business.Global.contrDiagram.setSentenceFlag((String) node.getSentences().elementAt(i),(String) this.comboBox.getSelectedItem());
          }

          //this.node.setResolutionFlag ( (String) this.comboBox.getSelectedItem());
          this.canvas.repaint();
          this.hide();
        }

	if (command.equals("SentenceToAdd"))
	{
          this.sentence = ( (String) this.comboBox.getSelectedItem());
        }



	if (command.equals("Cancel")){
          this.hide();
          this.dispose(); //?? destroy ??
        }

 	if (command.equals("AddMove")){
          for(int i = 0; i < node.getSentences().size();i++){
            business.Global.contrDiagram.setSentenceFlag((String) node.getSentences().elementAt(i),"DONE");
          }

          String actionState =  sentence;
          if(sentence.equals("")){
            actionState =  (String) node.getSentences().elementAt(0);
          }
          this.hide();
          this.dispose();
          business.Global.contrUsecase.useCaseFrame().insert(actionState,true);

        }
	if (command.equals("Add")){
          for(int i = 0; i < node.getSentences().size();i++){
            System.out.println( (String) node.getSentences().elementAt(i)+"DONE");
            business.Global.contrDiagram.setSentenceFlag((String) node.getSentences().elementAt(i),"DONE");
          }

          String actionState =  sentence;
          if(sentence.equals("")){
            actionState =  (String) node.getSentences().elementAt(0);
          }
          this.hide();
          this.dispose();
          business.Global.contrUsecase.useCaseFrame().insert(actionState,false);


          //code moved to gui.usecaseF
//          business.CUsecase uc =  business.Global.usecase;
//          Vector steps = uc.getSuccessScenarioT1();
//          //          for(int i = 0; i<steps.size();i++){
//          //            int pos = ((business.CStep)steps.elementAt(i)).getPosition();
//          //            if( position < pos)position = pos;
//          //          }
//          //          position ++;
//          int position =0;
//          String step = "1";
//          business.CStep bigStep=null;
//
//          if(steps.size()>0){
//            bigStep = (business.CStep)steps.elementAt(steps.size()-1);
//            position = bigStep.getPosition() + 1;
//            step = (new Integer(bigStep.getLevel(0)).intValue()+1 ) + "";
//          }
//          String actionState =  sentence;
//          if(sentence.equals("")){
//            actionState =  (String) node.getSentences().elementAt(0);
//          }
//          business.CStepStrT1 newStep = new business.CStepStrT1( 0, position, step,actionState , "" );
//          newStep.redoExtrans();
//          if(bigStep == null){
//            newStep.insertStep(steps);
//          }else{
//            newStep.insertAfterStep(steps,bigStep);
//          }
//          if(business.Global.usecaseF != null)business.Global.usecaseF.reload();
//          this.hide();
//          this.dispose(); //?? destroy ??
//          business.Global.contrUsecase.showUseCase();

        }


    }

}

