package diagram;

import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

/**=====================================================================
 *
 */
public class DNode {
  public static boolean showHidden = true;
  public long tempId = 0;   //for opening diagrams

  //public static int nextId = 0;
  public int flagNumber = 0;
  public int height = 0;
  public int layoutFlag = 0;
  public String name;

  //save
  private boolean visibleFlag = true;
  boolean conector = false;
  private int id;
  private int nodeId;
  public int x;
  public int y;
  private int level = 0;

  private String flag = "-";

  //vec
  private Vector children = new Vector();
  private Vector parents = new Vector();
  private Vector edges = new Vector();




  private Vector vectorObjunderNode = new Vector();


  private Vector vectorObj = new Vector();  // business.fca.FCAObject
  private Vector vectorAttr = new Vector();
  //private String ResolutionFlag = "-";

  //used mainly for the creation of the diagram
  private business.fca.Set obj_Data;
  private business.fca.Set attr_Data;
  private business.fca.Set simple_attr_Data;


  public static Vector flags = new Vector();
  {
    flags.clear();
    flags.add("-");
    flags.add("DONE");
    flags.add("IGNORE");
    flags.add("DELAY");
    flags.add("ERROR");
  }


/**=====================================================================
 *
 * =====================================================================
 */

  protected DGraph graph;
  Vector colors = new Vector();


//  public DNode() {
//  }
//
  public DNode(DGraph agraph) {
    graph = agraph;

            //colors.addElement(Color.blue); confused with letters
            colors.addElement(Color.yellow);
            colors.addElement(Color.green);
            //colors.addElement(Color.pink); confused with selected node
            colors.addElement(Color.cyan);
            colors.addElement(Color.orange);
            colors.addElement(Color.magenta);


  }
/**=====================================================================
 *
 * =====================================================================
 */

  public void setId(int i){
    this.id=i;
  }
  public int getId(){
     return id;
  }

/**=====================================================================
 *
 * =====================================================================
 */

  public void setFlag(String f){
    flag = f;
  }
  public String getFlag(){
    this.flag = "-";
    for(int i = 0;i<this.getSentences().size();i++){
      String flag = business.Global.contrDiagram.getSentencesFlag((String) getSentences().elementAt(i));
      if(this.flag.equals("-") && !flag.equals("-")){
        this.flag = flag;
      }else if(!this.flag.equals("-") && !flag.equals("-")){
        if(!this.flag.equals(flag)){
          this.flag = this.flag + ":" +flag;
        }
      }
    }
    return this.flag;
  }
/**=====================================================================
 *
 * =====================================================================
 */
  public void setLevel(int alevel){
    this.level=alevel;
  }
  public int getLevel(){
     return level;
  }


  public int getChildrenSize(){
    return children.size();
  }
  public int getParentsSize(){
    return parents.size();
  }
  public int getEdgesSize(){
    return edges.size();
  }


  public boolean hasChild(DNode node){
    return children.contains(node);
  }
  public DNode getChild(int i){
    return ((DNode) children.elementAt(i));
  }
  public DNode getParent(int i){
    return ((DNode) parents.elementAt(i));
  }
  public Dedge getEdge(int i){
    return ((Dedge)edges.elementAt(i));
  }


  public boolean isConector(){
    return conector;
  }
  public void isConector(boolean b){
    conector = b;
  }

  public double getNodeSize(){
    double  sum = (double) 0;
    for(int i = 0;i < this.children.size();i++){
      DNode child = ((DNode ) this.children.elementAt(i) );
      sum = sum + (1/child.getParentsSize());
    }
    if(sum <1)sum = 1;
    return sum;
  }


/**=====================================================================
 *  should only be called by Dedge
 * =====================================================================
 */
  protected void addEdge(Dedge edge){
    //System.out.println(this.getFlag()+":"+edge.getParent().getFlag()+"->"+edge.getChild().getFlag());
    if(edge.getParent()==this){
      children.add(edge.getChild());
    }else if(edge.getChild()==this){
       parents.add(edge.getParent());
    }
    edges.add(edge);
  }

  protected void removeEdge(Dedge edge){
    //System.out.println(this.getFlag()+":"+edge.getParent().getFlag()+"->"+edge.getChild().getFlag());
    if(edge.getParent()==this){
      children.remove(edge.getChild());
    }else if(edge.getChild()==this){
       parents.remove(edge.getParent());
    }
    edges.remove(edge);
  }




/**=====================================================================
 * SET
 * =====================================================================
 */
  public business.fca.Set obj_set(){
    if (obj_Data == null) {
      System.out.println("WARNING node:obj_DATA =null");
      obj_Data = new business.fca.Set();
    }
    return obj_Data;
  }
  public void obj_set(business.fca.Set aSET){
    obj_Data = aSET;
  }
  public business.fca.Set simple_attr_set(){
    if (simple_attr_Data == null){
      System.out.println("WARNING node:simple_attr_Data=null");
      simple_attr_Data = new business.fca.Set();
    }
    return simple_attr_Data;
  }
  public void simple_attr_set(business.fca.Set aSET){
    simple_attr_Data = aSET;
  }
  public business.fca.Set attr_set(){
    if (attr_Data == null) {
      System.out.println("WARNING node:attr_DATA =null");
      attr_Data = new business.fca.Set();
    }
    return attr_Data;
  }
  public void attr_set(business.fca.Set aSET){
    attr_Data = aSET;
  }
  public void addAttribute(String attr){
    this.vectorAttr.add(attr);
  }

/**=====================================================================
 * name
 * =====================================================================
 */


  public void name(String n){
   name = "";
  }
/**=====================================================================
 *   OBJECTS
 * =====================================================================
 */

  public void add_object(business.fca.FCAObject obj){
     vectorObj.addElement(obj);
  }

  public Vector getObjects(){
    return vectorObj;
  }

  public String objectsString(){
          String objString = "";
          if(vectorObj.size()==0){
            return "";
          }
          for(int i = 0;i<vectorObj.size();i++){
            if(objString == ""){
              objString = ((business.fca.FCAObject) vectorObj.elementAt(i)).getVPName();
            }else{
              objString = objString +","+((business.fca.FCAObject) vectorObj.elementAt(i)).getVPName();
            }
          }
          if(getStep() == null || getStep() == ""){
            return "["+objString+"]";
          }else{
            return "("+objString+")";
          }

  }

  public String getStep(){
      String step = "";
      for(int i = 0;i<vectorObj.size();i++){
        if(step == "" || step == null){
          business.fca.FCAObject obj = (business.fca.FCAObject) vectorObj.elementAt(i);
          step =  business.Global.usecase.getStepOfSentence(obj.getAction());
        }
      }
      return step;
  }

/**=====================================================================
 *     attributes
 * =====================================================================
 */

  public String attributes(){
    String attributes = "";
    for(int i = 0;i<vectorAttr.size();i++){
      if(attributes == ""){
        attributes = (String) vectorAttr.elementAt(i);
      }else{
        attributes = attributes +"," + (String) vectorAttr.elementAt(i);
      }
    }
    return "["+attributes+"]";
  }

  public Vector getAttributes(){
    return vectorAttr;
  }

/**=====================================================================
 *    HIDE
 * =====================================================================
 */



  public boolean isHidden(){
    return (!visibleFlag);
  }

  public boolean isVisible(){
    return visibleFlag;
  }

  public void hide(){
    isVisible(false);
  }

  public void isVisible(boolean TF){
    visibleFlag = TF;
    if(!visibleFlag &&(!this.graph.undoList.contains(this)) ){
      this.graph.undoList.add(this);
    }
  }



/**=====================================================================
 *    DRAW
 * =====================================================================
 */
  public void draw(Graphics g, DGraph graph){
    if(business.Global.DEBUG)
      g.drawString("id:"+getId()+" w"+getWeight() ,x,y);



    if(this.isVisible()){
      //color
      int colorInt = this.getLevel();
      while(colorInt>(colors.size()-1) )colorInt = colorInt -colors.size();
      Color myColor = (Color) colors.elementAt(colorInt);

      //g.drawString(this.getId()+":"+this.tempId+":"+this.getLevel() ,x-5 ,y-5);

      if(this.isConector()){
          g.setColor(Color.red);
          g.drawOval(x+(height/2)-2,y+(height/2)-2,4,4);
      }else{
        if(this == graph.selectedNode){
          g.setColor(Color.red);
          g.drawRect(x+5,y+20,height-10,height-25);

          //options

          Image close = business.Global.imageIconNodeOptions.getImage();
          g.drawImage(close,x-20,y,15,45,Color.white,null);


        }
        g.setColor(myColor);
        if(getStep() == null || getStep() == ""){
          //is NOT in shared usecase
          g.drawRect(x,y,height,height);
        }else{
          //is in shared usecase
          g.drawRoundRect (x ,y+15,height,height-15,(height -10)/2,((height-10)/2) );

        }
        if(this.getFlag().equals("-") ){
          g.fillRect(x,y,height,15);
        }else{
          g.drawRect(x,y,height,15);
        }

      }

      g.setColor(Color.black);
      if(!this.isConector()){
        g.drawString(this.getFlag() ,x+5 ,y+12);
        g.drawString(this.attributes() ,x+5 ,y+30);
        g.setColor(Color.blue);
        g.drawString(this.objectsString() ,x+5 ,y+45);

        if(showHidden){
          Vector hiddenAttributes = this.getHiddenAttributes();
          for(int i = 0;i<hiddenAttributes.size();i++){
            g.drawString("["+ hiddenAttributes.elementAt(i)+"]" ,x +5,y+(15*i)+60);
          }
        }

      }
      g.setColor(Color.black);

      for(int c = 0;c<this.getChildrenSize();c++){
        DNode child = (DNode) (this.getChild(c));
        for(int i =0; i< this.getEdgesSize();i++){
          Dedge edge =   this.getEdge(i);
          if(edge.getParent()==this && !edge.isHidden() ){
            if(this.graph.mode == this.graph.NORMAL){
             edge.draw(g);
            }else{
              if(edge.getChild()!=this.graph.selectedNode ){
                edge.draw(g);
              }
            }
          }
        }
      }
    }
  }
/**=====================================================================
 *    destroy Node
 * =====================================================================
 */
  public void destroy(){
    for(int i =0;i<edges.size();i++){
      ((Dedge) edges.elementAt(i)).destroy();
    }

    while(this.graph.nodes.contains(this)){
       this.graph.nodes.remove(this);
    }
  }

/**=====================================================================
 * @return Vector of visible parents
 * =====================================================================
 */
  public Vector visibleParents(){
    Vector VParents = new Vector();
    for(int i = 0; i< parents.size();i++){
      DNode p = (DNode) parents.elementAt(i);
      if(p.isVisible())VParents.add(p);
    }
    return VParents;
  }


/**=====================================================================
 * @return Vector of visible children
 * =====================================================================
 */

  public Vector visibleChildren(){
    Vector VChildren = new Vector();
    for(int i = 0; i< children.size();i++){
      DNode c = (DNode) children.elementAt(i);
      if(c.isVisible())VChildren.add(c);
    }
    return VChildren;
  }

/**=====================================================================
 * @param boolean (All) if true hide the children children's recursively
 * does not hidde children with visible parents
 * =====================================================================
 */
  public void hideChildren(boolean all){
    for(int i = 0; i< children.size();i++){
      DNode c = (DNode) children.elementAt(i);
      if(c.visibleParents().size()==0){
        c.hide();
        if(all){
          c.hideChildren(all);
        }
      }
    }
  }

/**=====================================================================
 * @param boolean (All) if true hide the parent parent's recursively
 * does not hidde parent with visible children or with objects
 * =====================================================================
 */
  public void hideParents(boolean all){
    for(int i = 0; i< parents.size();i++){
      DNode node = (DNode) parents.elementAt(i);
      if(node.visibleChildren().size()==0 && node.vectorObj.size()==0){
        node.hide();
        if(all){
          node.hideParents(all);
        }
      }
    }
  }



  public void changeFlag(){
    flagNumber++;
    if(flagNumber>flags.size()){
      flagNumber = 0;
    }
    flag = (String) flags.elementAt(flagNumber);
    for(int i = 0; i < getSentences().size();i++){
      business.Global.contrDiagram.setSentenceFlag((String) this.getSentences().elementAt(i),flag);
    }
  }




/**=====================================================================
 * recursive function
 * the node lets all it parent nodes know what objects are below this node
 * and also what objects are in this node
 * at the end the top node will know what objects are below
 * and thefore will contain all objects in the tree
 *
 * @param diagram
 * =====================================================================
 */

  public void setObjectsUnderNode(DDiagram diagram)
  {

    for(int n=0;n<parents.size();n++){
      DNode Pnode = (DNode) parents.elementAt(n);
      for(int i = 0;i<vectorObj.size();i++){
        Pnode.addObjectUnderNode((business.fca.FCAObject)vectorObj.elementAt(i));
      }
      for(int i = 0;i<vectorObjunderNode.size();i++){
        Pnode.addObjectUnderNode((business.fca.FCAObject)vectorObjunderNode.elementAt(i));
      }
      Pnode.setObjectsUnderNode(diagram);
    }
    //add my objects
    for(int i = 0;i<vectorObj.size();i++){
      addObjectUnderNode((business.fca.FCAObject)vectorObj.elementAt(i));
    }
    if(parents.size()== 0){
      //I have no parents thefore i am top node and thefore all objects
      this.graph.setAllObjects(vectorObjunderNode);
    }
  }


/**
 *=====================================================================
 *=====================================================================
 */
  private void addObjectUnderNode(business.fca.FCAObject obj){
      if(!vectorObjunderNode.contains(obj)){
        vectorObjunderNode.addElement(obj);
      }
  }

  public void resetObjects(){
    //an object might be in more than one diagram
    //thefore we must reset the flags
    for(int i = 0; i < vectorObj.size();i++){
      ((business.fca.FCAObject) vectorObj.elementAt(i)).setFlag(flag);
    }
  }


  public void distance(String VPName,business.fca.FCAObject obj,Vector allAttr ,Vector attr){
    //System.out.print(" ["+allAttr.size()+ ":" +attr.size()+"] " );
    boolean foundVPName = false;
    //do i have VPName or under me
    for(int i = 0;i<vectorObjunderNode.size();i++ ){
      if(((business.fca.FCAObject) vectorObjunderNode.elementAt(i)).getVPName().equals(VPName)){
        foundVPName = true;
      }
    }
    //if we have this object then modify attr and allAttr
    if(vectorObjunderNode.contains(obj) ){
      boolean found;
      for(int i = 0 ; i < getAttributes().size() ; i++){
        found = false;
        for(int y = 0 ; y<attr.size();y++){
          if(((String)attr.elementAt(y)).equals((String) getAttributes().elementAt(i))){
            found = true;
          }
        }
        if (!found){
          allAttr.addElement((String) getAttributes().elementAt(i));
          if(foundVPName){
            attr.addElement((String) getAttributes().elementAt(i));
          }
        }
      }
    }
    //pass it along
    for(int i = 0; i< parents.size() ; i++)  {
      DNode Pnode = (DNode) parents.elementAt(i);
      Pnode.distance(VPName,obj, allAttr , attr);
    }


  }

  public void moveTo(int X, int Y){
    this.x = X;
    this.y = Y;
  }



  public Vector getSentences(){
    Vector sentences = new Vector();
    for(int i = 0;i<vectorObj.size();i++){
      business.fca.FCAObject obj = (business.fca.FCAObject) vectorObj.elementAt(i);
      sentences.add(obj.getAction());
    }
    return sentences;
  }
/**
 *=====================================================================
 *this is used for the layout
 *=====================================================================
 */

  private float weight = 0;
  private float weightFlag = 0;

  public void addWeight(float x){
    Vector v = new Vector();
    //the vector is used to stop going on an infinite loop
    addWeightR(x,v);

  }
  private void addWeightR(float x,Vector v){
    weight = weight +x;
    v.add(this);
    for(int i = 0;i<this.getParentsSize();i++){
      if(!v.contains( this.getParent(i))){
        this.getParent(i).addWeightR(x/2,v);
      }
    }
    for(int i = 0;i<this.getChildrenSize();i++){
      if(!v.contains( this.getChild(i))){
        this.getChild(i).addWeightR(x/2,v);
      }
    }

  }



  public void setWeight(float x){
    weight =x;
  }
  public float getWeight(){
    return weight;
  }


  private Vector getHiddenAttributes(){
    Vector notshownAttr = new Vector();
    int[] attributes =this.simple_attr_set().get_elements();
    for(int i = 0; i< attributes.length ;i++){
        if(attributes[i] != 0){
          String attr = this.graph.crosstable.get_attr_name(attributes[i]);
          if(!this.getAttributes().contains(attr)){
             notshownAttr.addElement(attr );
          }
        }
    }
    return    notshownAttr;
  }

}