package diagram;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;


/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

 /**=====================================================================
 *
 * =====================================================================
 */
public class DLayout{
  DGraph graph;
  Vector layoutMap = new Vector();
  Vector todoLayoutMap = new Vector();
  Vector visibleHierarchy = new Vector();

/**=====================================================================
 *
 * =====================================================================
 */
  public DLayout() {
  }
/**=====================================================================
 *
 * =====================================================================
 */
  public void setGraph(DGraph agraph){
    graph = agraph;
  }
/**=====================================================================
 *        D O       L A Y O U T
 * =====================================================================
 */
  public void doLayout(){
    conectNodes();
    initLayoutMap(); //updates visibleHierarchy ++

    //start chain reaction
    // addToLayout(this.graph.topNode);
    //sometimes the top node would be hidden and thefore
    //we must find the highest nodes and start from ther
    //once the top node is inserted the children will be
    //inserted and the children children and so on
    Vector topNodes = new Vector();
    findTopVisibleNodes(topNodes);
    for(int n=0; n<topNodes.size();n++){
      addToLayout(((DNode)topNodes.elementAt(n)));
    }

    int maxX = 0;
    for(int i = 0;i<visibleHierarchy.size();i++){
      Vector nodesV = ((Vector)visibleHierarchy.elementAt(i));
      if(maxX < nodesV.size()){
          maxX = nodesV.size();
      }
    }
    //in small diagrams ther could be presision problems with small numbers
    maxX = maxX *100;
    //set cordinates
    for(int h = 0 ; h<layoutMap.size();h++){
      Vector nodesV = ((Vector)layoutMap.elementAt(h));
      int sum = 0;
      for(int n = 0 ; n < nodesV.size();n++){
        DNode node = ((DNode)nodesV.elementAt(n));
        node.y = (h*10);
        int cal =(int)(((maxX/nodesV.size())*n)+((maxX/nodesV.size())/2));
        node.x = cal;
        //        System.out.println("cal11>"+ cal11 +" cal1 >"+cal1 +" cal2 >"+cal2+" cal= >"+cal );
      }
    }
  }

/**=====================================================================
 *
 * =====================================================================
 */

  private void initLayoutMap(){
    visibleHierarchy = graph.getVisibleHierarchy();

    layoutMap.clear();
    for(int i = 0; i<visibleHierarchy.size();i++){
      layoutMap.add( new Vector());
    }

    todoLayoutMap.clear();
    for(int i = 0; i<visibleHierarchy.size();i++){
      todoLayoutMap.add( new Vector());
    }

    for(int i = 0; i<this.graph.nodes.size();i++){
      DNode node = ((DNode)this.graph.nodes.elementAt(i));
      node.layoutFlag = 0;
      node.setWeight(0);
    }
  }


/**=====================================================================
 *        add to  L A Y O U T
 * =====================================================================
 */

  private void addToLayout(DNode node){



  //System.out.println("X"+node.attributes()+" "+node.getNodeId());

  //System.out.println("id: "+node.getId());
    //add node to layout
    if(!((Vector) layoutMap.elementAt(node.getLevel())).contains(node)){//******fix
      ((Vector) layoutMap.elementAt(node.getLevel())).add(node);
      node.layoutFlag = 1;
      node.addWeight(100);
      boolean found = true;
      while(found){
        DNode heavyNode = null;
        for(int i =0;i<node.getChildrenSize();i++){
          DNode testNode = node.getChild(i);
          if( testNode.layoutFlag == 0){
            if(heavyNode == null){
              heavyNode = testNode;
            }else{
              if(testNode.getWeight()>heavyNode.getWeight()){
                heavyNode = testNode;
              }//if
            }//if
          }//if
        }//for
        if(heavyNode == null){
          found = false;
        }else{
          found = true;
          addToLayout(heavyNode);
        }
      }//while
    }//if

//
//    //System.out.println("X"+node.attributes()+" "+node.getNodeId());
//    //add node to layout
//    if(!((Vector) layoutMap.elementAt(node.getLevel())).contains(node)){//******fix
//      ((Vector) layoutMap.elementAt(node.getLevel())).add(node);
//
//      //add parents to todo list and increse weight
//      for(int p = 0;p<node.getParentsSize();p++){
//        DNode parent = node.getParent(p);
//        if(!((Vector) layoutMap.elementAt(parent.getLevel())).contains(parent)){//******fix
//          addWeight(parent);
//        }
//      }
//
//
//      //do childs from todo list
//      if(node.getChildrenSize()>0){
//        boolean more = true;
//        while(more == true){
//          DNode child = getNextChildFromTodoList(node);
//          if(child == null){
//            more = false;
//          }else{
//            addToLayout(child);
//          }
//        }
//
//        //do nodes with 1 parent only first
//        for(int i = 0;i<node.getChildrenSize();i++){
//          DNode child = (DNode) node.getChild(i);
//          if(child.getParentsSize() ==1){
//            if(!((Vector) layoutMap.elementAt(child.getLevel())).contains(child)){//******fix
//              addToLayout(child);
//            }
//          }
//        }
//        //do the rest
//        for(int i = 0;i<node.getChildrenSize();i++){
//          DNode child = (DNode) node.getChild(i);
//          if(!((Vector) layoutMap.elementAt(child.getLevel())).contains(child)){//******fix
//              addToLayout(child);
//          }
//        }
//      }
//    }
  }
/**=====================================================================
 *
 * =====================================================================
 */
  public void addWeight(DNode node){
    //System.out.println("_"+node.attributes());
    Vector todoList = ((Vector) todoLayoutMap.elementAt(node.getLevel()));
    if(todoList.contains(node)){
      int index = todoList.indexOf(node);
      todoList.remove(node);
      int maxIndex = todoList.size()-1;//we start counting from index 0
      if((index+1) > maxIndex ){
        todoList.add(node);
      }else{
        todoList.add(index+1,node);
      }
    }else{
      todoList.add(node);
    }
  }

/**=====================================================================
 *
 *
 * =====================================================================
 */

  public DNode getNextChildFromTodoList(DNode node){
    Vector todoList = ((Vector) todoLayoutMap.elementAt(node.getLevel()+1));
    for(int t = 0;t<todoList.size();t++){
      DNode posibleChild = ((DNode)todoList.elementAt(t));
      if(node.hasChild(posibleChild)){
        todoList.remove(posibleChild);
        //System.out.println("."+node.attributes() +" "+posibleChild);
        return posibleChild;

      }
    }
    //System.out.println("."+node.attributes());
    return null;
  }



/**=====================================================================
 *
 * =====================================================================
 */

  public void resize( Dimension aScreenSize){
    Dimension screenSize = aScreenSize;
    visibleHierarchy = graph.getVisibleHierarchy();

    Vector nodes = this.graph.nodes;

    int maxX = 0;
    for(int i = 0;i<visibleHierarchy.size();i++){
      Vector nodesV = ((Vector)visibleHierarchy.elementAt(i));
      if(maxX < nodesV.size()){
          maxX = nodesV.size();
      }
    }
    int X =0;
    if(maxX<visibleHierarchy.size()){
      X = maxX;
    }else{
      X = visibleHierarchy.size();
    }
    int nodeH =  screenSize.height/(((X+2)*2));


    if(nodes.size()>=1){
      int bigestX = 0;
      int bigestY = 0;
      int smallestX = ((DNode)nodes.elementAt(0)).x;
      int smallestY = ((DNode)nodes.elementAt(0)).y;

      //find bigest x,y and smalles x,y
      for(int n = 0 ; n < nodes.size();n++){
        DNode node = ((DNode)nodes.elementAt(n));
        if(node.isVisible()){
          if(node.x > bigestX) bigestX = node.x;
          if(node.y > bigestY) bigestY = node.y;

          if(node.x < smallestX) smallestX = node.x;
          if(node.y < smallestY) smallestY = node.y;
        }
      }




      double yFactor;
      double xFactor;

      if(bigestX==smallestX){
        //xFactor = (screenSize.getWidth()-(nodeH*3))/(bigestX-smallestX);
        for(int n = 0 ; n < nodes.size();n++){
          DNode node = ((DNode)nodes.elementAt(n));
          if(node.isVisible()){
            node.x = (int) (screenSize.getWidth()/2)-(nodeH/2);
          }
        }
      }else{
        xFactor = (screenSize.getWidth()-(nodeH*3))/(bigestX-smallestX);
        for(int n = 0 ; n < nodes.size();n++){
          DNode node = ((DNode)nodes.elementAt(n));
          if(node.isVisible()){
            node.x = (int) (((node.x-smallestX) * xFactor)+(nodeH));
          }
        }
      }

      if(bigestY==smallestY){
        for(int n = 0 ; n < nodes.size();n++){
          DNode node = ((DNode)nodes.elementAt(n));
          if(node.isVisible()){
            node.height = nodeH;
            node.y = (int) (screenSize.getHeight()/2)-(nodeH/2);
          }
        }
      }else{
        yFactor = (screenSize.getHeight()-(nodeH*3))/(bigestY-smallestY);
        for(int n = 0 ; n < nodes.size();n++){
          DNode node = ((DNode)nodes.elementAt(n));
          if(node.isVisible()){
            node.y = (int) (((node.y-smallestY) * yFactor)+(nodeH));
          }
        }
      }

      for(int n = 0 ; n < nodes.size();n++){
        DNode node = ((DNode)nodes.elementAt(n));
        if(node.isVisible()){
          node.height = nodeH;
        }
      }
    }
  }


/**=====================================================================
 *
 * =====================================================================
 */

  public void conectNodes(){

    visibleHierarchy = graph.getVisibleHierarchy();
    //****** vvv important line
    this.graph.connectNodes();

    //add fake child (conector) to a parent who has no child at parent.getLevel()+1
    for(int i = 0;i<graph.nodes.size();i++){
      DNode parent = ((DNode) graph.nodes.elementAt(i));
      if(parent.isVisible()){
        for(int e = 0;e< parent.getEdgesSize();e++){
          Dedge edge = parent.getEdge(e);
          if(edge.isVisible()){
            if(edge.getParent().getLevel()+1 != edge.getChild().getLevel()){
              DNode newNode = graph.addNode();
              newNode.setLevel(edge.getParent().getLevel()+1);
              ((Vector)visibleHierarchy.elementAt(newNode.getLevel())).add(newNode);
              //((Vector)visibleHierarchy.elementAt(edge.getParent().getLevel()+1)).add(newNode);
              newNode.isConector(true);
              new Dedge(edge.getParent(),newNode);
              new Dedge(newNode,edge.getChild());
              edge.destroy();
              e=0;//we muststart from the begining again
            }
          }
        }
      }
    }

  }
/**=====================================================================
 *
 * =====================================================================
 */

  public void spread(){
    visibleHierarchy = graph.getVisibleHierarchy();
    //    for(int h = 0 ; h<layoutMap.size();h++){
    if(this.graph.selectedNode!=null){
      Vector nodesV = ((Vector)layoutMap.elementAt(this.graph.selectedNode.getLevel()));

      boolean up = true;
      for(int n=0;n<nodesV.size();n++){
        DNode node = (DNode) nodesV.elementAt(n);
        if(!node.isConector()){
          if(up){
            node.y = node.y+25;
          }else{
            node.y = node.y-25;
          }
        }
        up=!up;
      }
    }
  }
/**=====================================================================
 *
 * =====================================================================
 */

  public void findTopVisibleNodes(Vector vTopNodes){
    for(int i = 0;i<this.graph.nodes.size(); i++){
      DNode node = (DNode) this.graph.nodes.elementAt(i);
      if(node.getParentsSize()==0&&node.isVisible())vTopNodes.addElement(node);
    }
  }




/**=====================================================================
 *
 * =====================================================================
 */

}//end class