package diagram;

import java.awt.*;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class DGraph {

  public Graphics g;
  public Dimension screenSize;
  public DNode topNode;
  public DNode selectedNode = null;
  public DLayout layout = new DLayout();
  protected Vector undoList = new Vector();

  public Vector nodes = new Vector();
  public Vector edges = new Vector();

//  Vector colors = new Vector();

//=====================================================================
//=====================================================================
  public DGraph() {
    layout.setGraph(this);

  }

//=====================================================================
//=====================================================================

  long id = -1;
  public void setId(long i){
    this.id=i;
  }
  public long getId(){
     return id;
  }


//=====================================================================
//=====================================================================





  public int nodecounter = 0;
  public DNode addNode(){
    DNode newnode = new DNode(this);
    newnode.setId(nodecounter);
    nodes.add(newnode);
    nodecounter++;
    return newnode;
  }

//=====================================================================
//=====================================================================

    double oldHeight = 0;
    double oldWidth =  0;
    public static int NORMAL = 1;
    public static int DRAGNODE = 2;
    public int mode = 1;

  public void draw(Graphics aG, Dimension aScreenSize){
    screenSize = aScreenSize;
    g = aG;
    if(screenSize.getHeight() != oldHeight || screenSize.getWidth() != oldWidth){
      this.layout.resize(screenSize);
    }
    oldHeight =  screenSize.getHeight();
    oldWidth =  screenSize.getWidth();

    g.drawString("[ "+this.name+" ]",(int)(screenSize.getWidth()/2),20);

    if(selectedNode!=null){
      if(!this.selectedNode.isConector()){
        DNode node = this.selectedNode;
        g.drawString(node.getFlag() ,5 ,20);
        g.drawString(node.attributes() ,5 ,35);
        g.setColor(Color.blue);

        for(int i = 0;i<node.getObjects().size();i++){
          business.fca.FCAObject obj = (business.fca.FCAObject) node.getObjects().elementAt(i);
          g.drawString("[ "+obj.getStep()+": "+obj.getAction()+" by:"+obj.getOwner() + " ]" ,5 ,50+(i*15));
        }
      }
    }
    //draw nodes
    if(mode == NORMAL){
      for(int n = 0 ; n < this.nodes.size();n++){
        //System.out.println("N");
        ((DNode)nodes.elementAt(n)).draw(g,this);
      }
    }else if(mode == DRAGNODE) {
        //System.out.println("D");
      for(int n = 0 ; n < this.nodes.size();n++){
        DNode node = ((DNode)nodes.elementAt(n));
        if(node != this.selectedNode){
          node.draw(g,this);
        }
      }
    }

  }


//  public int findNewPos(DNode node){
//    int sumOfChildrenPositions = 0;
//    if(node.getChildrenSize()==0){
//      //keep same position
//      return   ((Vector)layout.elementAt(node.getLevel())).indexOf(node);
//    }else{
//      Vector childrenLevel = ((Vector)layout.elementAt(node.getLevel()+1));
//      for(int i = 0;i<node.getChildrenSize();i++){
//        DNode child =  node.getChild(i);
//        sumOfChildrenPositions = sumOfChildrenPositions + childrenLevel.indexOf(node);
//      }
//      return ((int)(sumOfChildrenPositions/node.getChildrenSize()));
//    }
//  }



//=====================================================================
//=====================================================================

  private String name;
  public void setName(String n){
    name = n;
    business.Global.recocase.reload(); //show name in recocase icon

  }
  public String getName(){
    return name;
  }



//=====================================================================
// this function uses set theory to conect the nodes
//
//   Vector PosibleParents = new Vector();
//
//  for each node1 find parent{
//      for every node2 check if node1 is a son {
//         if node2 is a posible parent of node1{
//            for every posibleParent (node3) check:{
//              if node 2 is a father of node 3 and thefore granfather (not father) of node 1
//              if node 3 is father of node 2 and thefore node3 was infact granfather of node1
//              if node 2 and node 3 are both probable fathers of node 1 (node 2 and node 3 are not related)
//            }
//         }
//      }
// }
//=====================================================================

  public void connectNodes(){


    Vector succesors = new Vector();
    Vector new_succesors = new Vector();
    business.fca.Set temp_set;


    //remove conectors
    Vector toBeDestroyed = new Vector();
    for(int i = 0;i<this.nodes.size();i++){
      DNode node = ((DNode) this.nodes.elementAt(i));
      if (node.conector)toBeDestroyed.add(node);
    }
    while(toBeDestroyed.size() > 0){
      DNode node = ((DNode) toBeDestroyed.elementAt(0));
      node.destroy();
      toBeDestroyed.remove(node);
    }


    //remove old edges
    while(edges.size()>0){
      Dedge edge = (Dedge) edges.firstElement();
      edge.destroy();
    }

    //make new conections
    for(int i=0;i<nodes.size();i++){
      DNode node1  = (DNode) nodes.elementAt(i);
      if(node1.isVisible()){
          business.fca.Set t_Set;
          t_Set = node1.attr_set();
          business.fca.Set t_Set_copy = t_Set.clone_set();
          node1.simple_attr_set(t_Set_copy);

          succesors = new Vector();
          new_succesors = new Vector();

          for(int x=0;x<nodes.size();x++){
            DNode node2  = (DNode) nodes.elementAt(x);
            if(node2.isVisible()){
              //Check if node 2 is a father
              if( node1.attr_set().get_size() > node2.attr_set().get_size()  ){
                temp_set = node2.attr_set().intersection(node1.attr_set());
                if (node2.attr_set().set_equal( temp_set )){
                      new_succesors = new Vector();
                      boolean is_succesor = true;
                      for(int j=succesors.size()-1 ; j > -1 ; j--){
                          //for(int j=0; j < succesors.size() ; j++){
                          DNode node3 = (DNode) succesors.elementAt(j);
                          temp_set = node2.attr_set().intersection(node3.attr_set());
                          if (node2.attr_set().set_equal(temp_set))
                          {
                              // node 2 is a father of node 3 and thefore
                              //granfather of node 1
                              is_succesor = false;
                              new_succesors.add(node3);
                          }else if (node3.attr_set().set_equal( temp_set )){
                              //node 3 is father of node 2 and thefore
                              //we do not add node3 to the new succesor list
                          }else{
                              //node 2 and node 3 are both probable fathers of node 1
                              //node 2 and node 3 are not related
                              new_succesors.add(node3);
                          }
                      }
                      if (is_succesor == true){
                          new_succesors.add(node2);
                      }
                }
                succesors = new_succesors;
              }//check for father
            }//if not hidden node 2
          }//found succesors

          //create edges
          for(int j=0; j < succesors.size() ; j++){
              DNode succesor_node = (DNode) succesors.elementAt(j);
              Dedge newEdge = new Dedge(succesor_node,node1);
              node1.simple_attr_set(succesor_node.attr_set().minus(node1.simple_attr_set()));
          }
        }//if not hidden node 1
      }// for each find parents
    }


//=====================================================================

//=====================================================================
        private int num_attributes;
        private int num_objects;
        private static int graphCount;
        public business.fca.ContextTable crosstable;

  public void createFCA( business.fca.ContextTable a_table){
    this.crosstable = a_table;

    this.nodecounter = 0;
    this.nodes.clear();
    this.edges.clear();


    this.setName(this.crosstable.getName());
    if(this.crosstable.getName().equals(""))this.setName("Diagram "+ (graphCount++));


    //    onFileNew();
    this.num_attributes = a_table.get_no_attr();
    this.num_objects = a_table.get_no_obj();
    business.fca.Set temp_set;
    //    String name = "";
    business.fca.ConceptGeneratorv2 a_cg = new business.fca.ConceptGeneratorv2(a_table);
    Vector extent = a_cg.get_extent();
    Vector intent = a_cg.get_intent();

    for (int i=0; i<intent.size(); i++) {
        business.fca.Set t_Set = (business.fca.Set) intent.elementAt(i);
        // ELEMENT 0 = EMPTY SET
        DNode newNode =  this.addNode();
        newNode.attr_set(t_Set);
        business.fca.Set t_Set_copy = t_Set.clone_set();
        newNode.simple_attr_set(t_Set_copy);
    }//for

    //conect nodes
    this.connectNodes();

    int ID = 0;
    for(int n=0;n<this.nodes.size();n++){
        DNode node  = (DNode) this.nodes.elementAt(n);
        String node_attr = "";
        String node_obj = "";
//      **** ATTRIBUTES
        int[] attributes = node.simple_attr_set().get_elements();
        for(int i = 0; i< attributes.length ;i++){
            if(attributes[i] != 0){
                 node.addAttribute( a_table.get_attr_name(attributes[i]));
            }
        }

//      **** OBJECTS
        business.fca.Set objSet = new  business.fca.Set();
        for (int j=1; j < num_objects+1 ; j++){
           temp_set = a_table.get_single_intent(j);
           if( node.attr_set().set_equal(temp_set)){
                node.add_object(a_table.get_obj(j));
                objSet.put_element(j);
            }
        }

        node.obj_set(objSet);
        node.name("["+ID+"]");
        ID++;
    }//node next

    // find the top node
    DNode top_node = null;
    for(int i=0;i<this.nodes.size();i++){
        DNode node  = (DNode) this.nodes.elementAt(i);
        if (top_node == null){top_node =node; }
        else
        if (node.attr_set().get_size() < top_node.attr_set().get_size()    ){
            top_node =node;
          //  System.out.println(node.attr_set().to_string() + empty_set.to_string() );
        }

    }
    topNode = top_node;


    System.out.println(this.nodes.size()+"+++++++++++");
    if(topNode==null)    System.out.println("top node = null");
    if(this.nodes.size()>0){
    setHierarchy();
    //set layout
    layout.doLayout();
    }
  }

  public Vector getVisibleHierarchy(){
    hierarchy = this.getHierarchy();
    Vector newHierarchy = new Vector();
    for(int i = 0;i< hierarchy.size() ;i++){
      Vector level = (Vector) hierarchy.elementAt(i);
      Vector newLevel = new Vector();
      for(int n = 0;n< level.size() ;n++){
        DNode node = (DNode) level.elementAt(n);
        if(node.isVisible()){
          newLevel.add(node);
        }
      }
      newHierarchy.add(newLevel);
    }
    return newHierarchy;
  }

/**==========================
 * @param Top node of graph
 * @return Vector all(level 1 Vector,level 2 Vector,...,level n Vector)
 * ==========================
 */

  public Vector getHierarchy(){
    if(hierarchy == null)hierarchy = setHierarchy();
    return hierarchy;
  }


  Vector hierarchy = null;

  public Vector setHierarchy(){
    if(topNode==null)return new Vector();

    Vector nodesToDo = new Vector();
    int highestLevel = 0;
    nodesToDo.add(topNode);
    topNode.setLevel(0);

    while( nodesToDo.size()>0){
      DNode father = (DNode) nodesToDo.firstElement();
      nodesToDo.remove(father);
      for(int i = 0;i<father.getChildrenSize();i++){
        DNode child = father.getChild(i);
        if(nodesToDo.contains(child)){
          //put child at the end of the list
          // ******************************************************************************************
          //                 this is 2 lines are not important any more (layout will fix it)?????????
          // ******************************************************************************************
           nodesToDo.remove(child);
           nodesToDo.add(child);
        }else{
          //add child to the todo list
          nodesToDo.add(child);
        }
        child.setLevel(father.getLevel()+1);
        if(highestLevel<child.getLevel())highestLevel=child.getLevel();
      }
    }
    // order them by level
    Vector newHierarchy = new Vector();
    for(int i = 0;i<highestLevel+1;i++){
      newHierarchy.add(new Vector());
    }
    for(int i = 0;i<nodes.size();i++){
      DNode node = ((DNode)nodes.elementAt(i));
      ((Vector)newHierarchy.elementAt(node.getLevel())).add(node);
    }
    hierarchy = newHierarchy;
    return newHierarchy;

  }


  public Vector getVisibleNodes(){
    Vector newNodes = new Vector();
    for(int i = 0;i<nodes.size(); i++ ){
      DNode node = (DNode) nodes.elementAt(i);
      if(node.isVisible()){
        newNodes.add(node);
      }
    }
    return newNodes;
  }

  public void hideSelectedNode(){
    if(this.selectedNode!= null){
      this.selectedNode.hide();
      this.connectNodes();
    }
  }

  public void hideSelectedNodeAndChildren(){
    if(this.selectedNode!= null){
      this.selectedNode.hide();
      this.selectedNode.hideChildren(true);
      this.connectNodes();
    }
  }

  public void hideSelectedNodeAndParents(){
    if(this.selectedNode!= null){
      this.selectedNode.hide();
      this.selectedNode.hideParents(true);
      this.connectNodes();
    }
  }

/**==========================
 * undo
 * ==========================
 */

  public void undo(){
    if(undoList.size()>0){
      DNode node = (DNode) undoList.lastElement();
      undoList.remove(node);
      node.isVisible(true);
      this.connectNodes();
    }
  }

  /**
   * set all objects that are in the diagram
   * (called by the top exnode during the cration of a report)
   */
  Vector allObjects = new Vector();
  protected void setAllObjects(Vector aAllObjects){
    allObjects = aAllObjects;
  }

  protected Vector getAllObjects(){
    return allObjects;
  }

  boolean needsSave = false;

  public boolean needsSaving(){
    return needsSave;
  }
  public void needsSaving(boolean NS){
    needsSave = NS;
  }
}