package diagram;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class DDiagram extends JFrame implements ActionListener {

  DCanvas canvas;
  DGraph graph = new DGraph();

  static int DiagramCount = 0;

  public DDiagram() {
    super("Diagram");
    this.init();
    Toolkit tk = this.getToolkit();
    // set the initial size of the example window
    this.setSize((int) (tk.getScreenSize().width * 0.60),(int) (tk.getScreenSize().height * 0.60));
    //    this.pack();
    this.show();
    business.Global.contrDiagram.addDiagram(this);
  }

//=====================================================================
//       I N I T
//=====================================================================
  public void init(){
    MenuBar menuBar = new MenuBar();

    //--------------FILE
    Menu menuFile = new Menu("[File]");

    MenuItem menuINew = new MenuItem("New Window");
    menuINew.setActionCommand("new");
    menuINew.setShortcut(new MenuShortcut('W'));
    menuINew.addActionListener(this);

    MenuItem menuISave = new MenuItem("Save");
    menuISave.setActionCommand("save");
    menuISave.setShortcut(new MenuShortcut('S'));
    menuISave.addActionListener(this);

    MenuItem menuISaveJPG = new MenuItem("Save JPG");
    menuISaveJPG.setActionCommand("saveJPG");
    menuISaveJPG.addActionListener(this);

    MenuItem menuIOpen = new MenuItem("Open");
    menuIOpen.setActionCommand("open");
    menuIOpen.setShortcut(new MenuShortcut('O'));
    menuIOpen.addActionListener(this);

    MenuItem menuIDelete = new MenuItem("Delete");
    menuIDelete.setActionCommand("delete");
    menuIDelete.setShortcut(new MenuShortcut('D'));
    menuIDelete.addActionListener(this);

    MenuItem menuIRename = new MenuItem("Rename As");
    menuIRename.setActionCommand("rename");
    menuIRename.addActionListener(this);

    MenuItem menuIClose = new MenuItem("Close");
    menuIClose.setActionCommand("close");
    menuIClose.addActionListener(this);


    menuFile.add(menuINew);
    menuFile.add(menuIOpen);
    menuFile.add(menuISave);
    menuFile.add(menuISaveJPG);
    menuFile.add(menuIDelete);
    menuFile.add(menuIRename);
    menuFile.add(menuIClose);

    //--------------VIEW
    Menu menuView = new Menu("[View]");



    MenuItem menuIHideNode = new MenuItem("Hide Node      (Delete key)");
    menuIHideNode.setActionCommand("hideNode");
    menuIHideNode.setShortcut(new MenuShortcut('H'));
    menuIHideNode.addActionListener(this);

    MenuItem menuIHideBranch = new MenuItem("Hide Branch    (End key)");
    menuIHideBranch.setActionCommand("hideBranch");
    menuIHideBranch.setShortcut(new MenuShortcut('H',true));
    menuIHideBranch.addActionListener(this);


    MenuItem menuIShowAll = new MenuItem( "Show All");
    menuIShowAll.setActionCommand("undoALL");
    menuIShowAll.addActionListener(this);

    MenuItem menuIUndoHide = new MenuItem(  "Undo Hide      (Insert key)");
    menuIUndoHide.setShortcut(new MenuShortcut('U'));
    menuIUndoHide.setActionCommand("undo");
    menuIUndoHide.addActionListener(this);


    menuView.add(menuIHideNode);
    menuView.add(menuIHideBranch);
       menuView.addSeparator();
    menuView.add(menuIShowAll);
    menuView.add(menuIUndoHide);




    //--------------Layout
    Menu menuLayout = new Menu("[Layout]");

    MenuItem menuILayout = new MenuItem("Applay Layout");
    menuILayout.setActionCommand("layout");
    menuILayout.setShortcut(new MenuShortcut('L'));
    menuILayout.addActionListener(this);

    MenuItem menuIResize = new MenuItem("Fit In Window");
    menuIResize.setActionCommand("resize");
    menuIResize.addActionListener(this);

    MenuItem menuISpread = new MenuItem("Spread on this Level");
    menuISpread.setActionCommand("spread");
    menuISpread.addActionListener(this);

    menuLayout.add(menuILayout);
    menuLayout.add(menuIResize);
    menuLayout.add(menuISpread);


    //--------------Tools
    Menu menuTools = new Menu("[Tools]");

    MenuItem menuIDistance = new MenuItem("Find Distance");
    menuIDistance.setActionCommand("distance");
    menuIDistance.addActionListener(this);

    menuTools.add(menuIDistance);



    //--------------add menus
    menuBar.add(menuFile);
    menuBar.add(menuView);
    menuBar.add(menuLayout);
    menuBar.add(menuTools);


    //--------------FILE
    this.setMenuBar(menuBar);

//==========================

    JButton openB = new JButton("Open",business.Global.imageIconDiagram);
    openB.setActionCommand("open");
    openB.addActionListener(this);

    JButton saveB = new JButton("Save",business.Global.imageIconSave);
    saveB.setActionCommand("save");
    saveB.addActionListener(this);

    JButton saveJPGB = new JButton("Save JPG",business.Global.imageIconSaveJPG);
    saveJPGB.setActionCommand("saveJPG");
    saveJPGB.addActionListener(this);

    JButton closeB = new JButton("Close",business.Global.imageIconClose);
    closeB.setActionCommand("close");
    closeB.addActionListener(this);

    JButton minimizeB = new JButton("Minimize",business.Global.imageIconMinimize);
    minimizeB.setActionCommand("minimize");
    minimizeB.addActionListener(this);

    JPanel buttonPR = new JPanel();
    buttonPR.setLayout(new FlowLayout(FlowLayout.RIGHT, 1, 1));
    JPanel buttonPL = new JPanel();
    buttonPL.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));

    buttonPL.add(openB);
    buttonPL.add(saveB);
    buttonPL.add(saveJPGB);

    buttonPR.add(minimizeB);
    buttonPR.add(closeB);

    JPanel buttonP = new JPanel();
    buttonP.setLayout(new BorderLayout());
    buttonP.add(buttonPL,BorderLayout.WEST);
    buttonP.add(buttonPR,BorderLayout.EAST);

    this.getContentPane().add(buttonP, BorderLayout.NORTH);

//==========================
    //DGraph graph = new  diagram.DGraph();
    canvas = new DCanvas(graph );
    this.getContentPane().add(this.canvas, BorderLayout.CENTER);
  }
//=====================================================================
//      A C T I O N          P E R F O R M E D
//=====================================================================
  public void actionPerformed(ActionEvent event) {
    String command = event.getActionCommand();

    if (command.equals("new")){
      JOptionPane.showMessageDialog(this,"fix me: NEW diagram  code goes here ");
    }else if (command.equals("save")){
      persistence.CDiagram.save(this.crosstable,this.graph);

    }else if (command.equals("saveJPG")){
      Rectangle rect = this.canvas.getBounds();
      Image fileImage =    createImage(rect.width,rect.height);
      Graphics g = fileImage.getGraphics();
      //write to the image
      this.canvas.paint(g);
      DThumbnail dt = new DThumbnail(fileImage,rect.width,rect.height);
      //dispose of the graphics content
      g.dispose();

    }else if (command.equals("delete")){
      System.out.println("Delete");
      if(this.graph.getId()!=-1){
        persistence.CDiagram.deleteDiagram(this.graph.getId());
        exitNoSave();
      }
    }else if (command.equals("open")){
      this.open();
    }else if (command.equals("close")){
      onFileExit();
    }else if (command.equals("rename")){
      this.rename();
    }else if (command.equals("hideNode")){
      this.graph.hideSelectedNode();
      this.canvas.repaint();
    }else if (command.equals("hideBranch")){
      this.graph.hideSelectedNodeAndChildren();
      this.canvas.repaint();
    }else if (command.equals("undo")){
      this.graph.undo();
      this.canvas.repaint();
    }else if (command.equals("undoAll")){
      this.canvas.repaint();
    }else if (command.equals("layout")){
      this.graph.layout.doLayout();
      this.graph.layout.resize(this.canvas.getSize());
      this.canvas.repaint();
    }else if (command.equals("resize")){
       this.fitInWindow();
    }else if (command.equals("spread")){
      graph.layout.spread();
      graph.layout.resize(this.canvas.getSize());
      this.canvas.repaint();
    }else if (command.equals("distance")){
      DReport report = new DReport();
      report.createReport(this,this.graph);
    }else if (command.equals("minimize")){
      this.hide();
    }

  }


//=====================================================================

//=====================================================================
  business.fca.ContextTable crosstable;

  public void createFCA( business.fca.SimpleTable a_simple_table){
    //do not use simple table to do any calculations or you wont be able to save and open diagrams
    business.fca.ContextTable a_table = a_simple_table.createContextTable();
    crosstable = a_table;
    createFCA(a_table);
  }
  public void createFCA( business.fca.ContextTable a_table){
    crosstable = a_table;
    if (business.Global.DEBUG){  a_table.print_table();  a_table.printTable(); }
    this.graph.createFCA(a_table);
  }

  public business.fca.ContextTable getCrosstable(){
    return crosstable;
  }

  public void rename(){
    if(this.graph.getId() == -1){
      persistence.CDiagram.save(this.crosstable,this.graph);
    }else{
      String name = this.graph.getName();
      String newname = JOptionPane.showInputDialog(null,"Name?");
      if(newname != null && !newname.equals("")){
        this.graph.setName(newname);
        if(! (persistence.CDiagram.save(this.crosstable,this.graph))){
          this.graph.setName(name);
          this.fitInWindow();
        }
      }
    }
  }



  public DGraph getGraph(){
    return graph;
  }



  public boolean open()
  {
    if(persistence.CDiagram.getDiagrams(null,null))
    {
      diagram.DOpenDiagram openDiagram = new diagram.DOpenDiagram(this);
      return openDiagram.returns();
    }else{
      JOptionPane.showMessageDialog(this,"No diagram for this usecase ");
      return false;
    }
  }



  public void exitNoSave()
  {
    business.Global.contrDiagram.closeDiagram(this);
    //this.frame.dispose();
  }

  /**
   * This method closes the application.
   */
  public void onFileExit()
  {
    int option = JOptionPane.NO_OPTION;
    if(this.graph.needsSaving()){
      option = JOptionPane.showConfirmDialog(this,"Do you want to save this diagram","Save",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
    }
    if (option == JOptionPane.OK_OPTION){
       persistence.CDiagram.save(this.crosstable,this.graph);
    }
    if (option != JOptionPane.CANCEL_OPTION){
       business.Global.contrDiagram.closeDiagram(this);
    }
  }

  public void fitInWindow(){
    graph.layout.resize(this.canvas.getSize());
    this.canvas.repaint();
  }

//=====================================================================
//        t h e        e n d
//=====================================================================

}