package diagram;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class DCanvas extends java.awt.Canvas {


/**=====================================================================
 *
 * =====================================================================
 */


  public DCanvas(DGraph aGraph) {
    super();
    this.enableEvents(
      AWTEvent.MOUSE_EVENT_MASK +
      AWTEvent.MOUSE_MOTION_EVENT_MASK +
      AWTEvent.KEY_EVENT_MASK
    );
    graph = aGraph;
  }

  DGraph graph;
  public void setGraph(DGraph aGraph){
    graph = aGraph;
  }

 public DGraph getGraph(){
  return graph;
 }

/**=====================================================================
 *
 * =====================================================================
 */
  public void paint(Graphics g) {
    this.update(g);
  }
/**=====================================================================
 *
 * =====================================================================
 */
  protected Graphics offscreenGraphics = null;
  protected Image offscreenImage;
  protected Dimension offscreenSize;

  public synchronized void update(Graphics g)
  {
    Dimension size = this.getSize();
    if ((this.offscreenGraphics == null) ||
      (this.offscreenSize.width != size.width) ||
      (this.offscreenSize.height != size.height))
    {
	// need to recreate the offscreen image initially, and if
	// the size of the window has changed.
	this.offscreenImage = this.createImage(size.width,size.height);
        this.offscreenGraphics = this.offscreenImage.getGraphics();
	this.offscreenSize = size;
    }
    // set up draw area only when re-scale is necessary
    this.offscreenGraphics.setColor(Color.white);
    this.offscreenGraphics.fillRect(0,0,this.offscreenSize.width,this.offscreenSize.height);
    this.offscreenGraphics.setColor(this.getForeground());
    this.graph.draw(this.offscreenGraphics,this.offscreenSize);
    g.drawImage(this.offscreenImage, 0, 0, this);

  }



/**=====================================================================
 *
 * =====================================================================
 */
  	/**
	 * This method processes the mouse press and release events.
	 *
	 * @param event  mouse event to be processed
	 */
  protected void processMouseEvent(MouseEvent event)
  {
    switch (event.getID())
    {
      case MouseEvent.MOUSE_PRESSED:
        this.onButtonDown(event);
	break;
      case MouseEvent.MOUSE_RELEASED:
        this.onButtonUp(event);
        break;
      }
      super.processMouseEvent(event);
  }

/**=====================================================================
 * This method processes the mouse drag events.
 *  @param event  mouse event to be processed
 * =====================================================================
 */
  protected void processMouseMotionEvent(MouseEvent event){


    if(event.getModifiers () == InputEvent.BUTTON1_MASK ){
      if (event.getID() == MouseEvent.MOUSE_DRAGGED){
          this.dragNode(event);


      }
      super.processMouseMotionEvent(event);
    }
  }

/**=====================================================================
 * This method performs the necessary operations when a key event
 * is detected. Currently, it checks if the delete key is pressed;
 * if so, the current selected node is deleted.
 *
 * @param event  the key event to be processed
 * =====================================================================
 */



  protected void processKeyEvent(KeyEvent event){
    if (event.getID() == KeyEvent.KEY_RELEASED){
      if (event.getKeyCode() == KeyEvent.VK_END){
        //if(this.graph.selectedNode!= null)this.graph.selectedNode.destroy();
        this.graph.hideSelectedNodeAndChildren();
        this.repaint();
      }
      if (event.getKeyCode() == KeyEvent.VK_DELETE){
        this.graph.hideSelectedNode();
        this.repaint();
      }
      if (event.getKeyCode() == KeyEvent.VK_INSERT){
        this.graph.undo();
        this.repaint();
      }
      if (event.getKeyCode() == KeyEvent.VK_UNDO){
        this.graph.undo();
        this.repaint();
      }
      if (event.getKeyCode() == KeyEvent.VK_U){
        this.graph.undo();
        this.repaint();
      }
    }
  }

/**=====================================================================
 * This method performs the necessary operations when a mouse-down
 * event is detected.
 *
 * @param event  the mouse event for processing
 *=====================================================================
 */

  protected synchronized void onButtonDown(MouseEvent event){
    //create un updated offsecreen image;
//    Dimension size = this.getSize();
//    this.offscreenImage = this.createImage(size.width,size.height);
//    this.offscreenGraphics = this.offscreenImage.getGraphics();
//    this.offscreenSize = size;


    int x = event.getX();
    int y = event.getY();

    if(!this.selectNode(x,y)){
      if(graph.selectedNode!=null){
        if(event.getModifiers () == InputEvent.BUTTON1_MASK ){
          int option = -1;
          if(x> graph.selectedNode.x-20 && x < graph.selectedNode.x && y>graph.selectedNode.y && y < graph.selectedNode.y+(15*3)){
            option = ((int)((y-graph.selectedNode.y)/15))  +1;
            if(option == 1){
              this.graph.hideSelectedNodeAndChildren();
            }else if(option == 2){
              this.graph.hideSelectedNode();
            }else if(option == 3){
              this.graph.selectedNode.changeFlag();
            }
          }
          if (option == -1){
            this.graph.selectedNode=null;
          }
        }
      }
    }else{
      if(graph.selectedNode!=null){
        if(event.getModifiers () == InputEvent.BUTTON2_MASK || event.getModifiers () == InputEvent.BUTTON3_MASK){
          showSelectedNodeOptions();
        }
      }
    }
  }

/**=====================================================================
 * This method performs the necessary operations when a mouse-up
 * event is detected.
 *
 * @param event  the mouse event for processing
 * =====================================================================
 */

  protected synchronized void onButtonUp(MouseEvent event){
    if(this.graph.mode == this.graph.DRAGNODE){
        this.graph.mode = this.graph.NORMAL;
    }
    int x = event.getX();
    int y = event.getY();
    if(event.getModifiers () == InputEvent.BUTTON1_MASK ){
      this.repaint();
    }
  }

/**=====================================================================
 * Select node
 *
 * @param x
 * @param y
 * =====================================================================
 */

  public boolean selectNode(int x , int y){
    Vector nodes = this.graph.getVisibleNodes();
    for(int i = 0;i< nodes.size();i++){
      DNode node = (DNode) (nodes.elementAt(i));
      if(x>=node.x && y>=node.y && x<=(node.x+node.height) && y<= (node.y+node.height) ){
        this.graph.selectedNode = node;
        this.repaint();
        return true;
      }
    }
    return false;
  }

  public void dragNode(MouseEvent event){
    if(this.graph.selectedNode!=null){
      int x = event.getX()-(this.graph.selectedNode.height/2);
      int y = event.getY()-(this.graph.selectedNode.height/2);
      DNode node =  this.graph.selectedNode;

      Graphics g;
      if(this.graph.mode == this.graph.NORMAL){
        this.graph.mode = this.graph.DRAGNODE;
        this.repaint();
        g = this.getGraphics();
        g.setXORMode(Color.white);
      }else{
        g = this.getGraphics();
        g.setXORMode(Color.white);
        // "delete" old shade
        if(node.isConector()){
          g.fillOval(node.x+(node.height/2)-5,node.y+(node.height/2)-5,10,10);
        }else{
          g.drawRect(node.x,node.y,node.height,node.height);
        }
        for(int i =0; i< node.getEdgesSize();i++){
          node.getEdge(i).draw(g);
        }

      }


      //new position
      node.x = x;
      node.y = y;
      //draw new shade
      if(node.isConector()){
        g.fillOval(x+(node.height/2)-5,y+(node.height/2)-5,10,10);
      }else{
        g.drawRect(x,y,node.height,node.height);
      }
      for(int i =0; i< node.getEdgesSize();i++){
        node.getEdge(i).draw(g);
      }
    }
  }
  public void showSelectedNodeOptions(){
    if(graph.selectedNode!=null){
      diagram.DNodeOptions options = new diagram.DNodeOptions(this.graph.selectedNode,this);
      options.show();
    }
  }

}