package contr;

import javax.swing.JFrame;
import javax.swing.JDialog;
import javax.swing.*;
import java.awt.Window;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * Description: controller for processing viewpoints
 *
 * @author Kathrin Boettger and Oscar Aguilera
 *
 * @version 1.0
 */
public class CViewpoint implements Runnable {

  JDialog dialogD = null;
  JFrame frameF = null;

  private Vector SaveViewpointV = new Vector();

  public CViewpoint() {}

  public void setDialog(JDialog ADialogD) {
    dialogD = ADialogD;
    frameF = null;
  }

  public void setFrame(JFrame AFrameF) {
    frameF = AFrameF;
    dialogD = null;
  }

  /** inserts viewpoint into database
  *  @param AViewpoint viewpoint to be inserted
  */
  public void createViewpoint(business.CViewpoint AViewpoint) {
    createViewpointDB(AViewpoint,0) ;
  }

  public void createViewpoint(business.CViewpoint AViewpoint,int opt) {
    createViewpointDB(AViewpoint,opt) ;
  }

  public void createViewpointDB(business.CViewpoint AViewpoint,int opt) {
                                                              //use 1 as default
//    if (AViewpoint.getOwner().getId() != business.Global.user.getId() && //vp dosent have owner
//        !business.Global.user.isAnalyst() &&
//        !business.Global.user.isAdmin()) {
//      CError.showNoRights(business.Global.recocase);
//      return;
//    }

    //AViewpoint.setUser(business.Global.user);
    if (AViewpoint.getClass().isInstance(new business.CViewpointUc())) {
      if (persistence.CViewpointUc.insertViewpointUc(
         (business.CViewpointUc) AViewpoint))
      {
          if(opt == 0) getActiveComponent().dispose();
//          this.addToSaveList( AViewpoint);
//              //Thread myThread = new Thread(this, "");
//              //myThread.start();
//          this.run();
      }

    } else {
      if (persistence.CViewpointSc.insertViewpointSc(
         (business.CViewpointSc) AViewpoint))
      {
          if(opt == 0) getActiveComponent().dispose();
//          this.addToSaveList( AViewpoint);
//          //Thread myThread = new Thread(this, "");
//          //myThread.start();
//          this.run();
      }
    }
  }

  /** opens scenario viewpoint
   *  @param AViewpointSc scenario viewpoint to be opened
   */
  private void openViewpoint(business.CViewpointSc AViewpointSc) {

//    AViewpointSc.getScenario().getUsecase().setActors(
//    persistence.CActor.getAllActorOfUsecase( AViewpointSc.getScenario().getUsecase().getId()));
//    AViewpointSc.getScenario().setAgents(persistence.CActor.getAllAgentOfScenario(
//    AViewpointSc.getScenario().getId()));

    AViewpointSc.setAgents(persistence.CActor.getAllAgentOfViewpointScenario(AViewpointSc.getId()));
    AViewpointSc.setUnstructText(persistence.CViewpointSc.getUnstructText(AViewpointSc));
    AViewpointSc.setStepStrT1(persistence.CViewpointSc.getStepStrT1(AViewpointSc));
    AViewpointSc.setStepStrT2(persistence.CViewpointSc.getStepStrT2(AViewpointSc));

  }





  public void showViewpoint(business.CViewpoint viewpoint) {
          boolean found = false;
          for (int i=0; found == false && i<business.Global.viewpointV.size(); i++) {
            if (((business.CViewpoint) business.Global.viewpointV.elementAt(i)).getId() == viewpoint.getId() ){
              found = true;
              business.Global.contrRecocase.showViewpoint(i);
              //System.out.println("FOUND");
            }
          }
  }

  /** opens viewpoint
   *  @param AViewpoint viewpoint to be opened
   */
  public void openViewpoint(business.CViewpoint AViewpoint) {

    if (AViewpoint != null) {

      if(dialogD != null) dialogD.dispose();

      // is viewpoint already open ?
      boolean found = false;
      for (int i=0; found == false && i<business.Global.viewpointV.size(); i++) {
        if (((business.CViewpoint) business.Global.viewpointV.elementAt(i)).getId() ==
           AViewpoint.getId())
           found = true;
      }

      if(found == false) { // no
        if (AViewpoint.getClass().isInstance(new business.CViewpointUc())) {
          business.Global.contrViewpoint.openViewpoint(
            (business.CViewpointUc) AViewpoint);
        } else {
          business.Global.contrViewpoint.openViewpoint(
            (business.CViewpointSc) AViewpoint);
        }

        business.Global.viewpointV.add(AViewpoint);
        business.Global.viewpointFV.add(null);
        business.Global.setViewpointIsOpen();
        business.Global.menuBar.reload();
        business.Global.recocase.reload();



      } else { // yes
        CError.showAlreadyOpen(business.Global.recocase);
      }
    } else {
      CError.showErrorMessage(dialogD, "choose viewpoint");
    }
  }

  /** opens use case viewpoint
   *  @param AViewpointUc use case viewpoint to be opened
   */
//   public void openViewpoint(business.CViewpointUc AViewpointUc) {
  private void openViewpoint(business.CViewpointUc AViewpointUc) {
    if (business.Global.DEBUG)  System.out.println("--->> contr.openViewpoint" );
    AViewpointUc.getUsecase().setActors(persistence.CActor.getAllActorOfUsecase(AViewpointUc.getUsecase().getId()));
    //AViewpointUc.setActors(persistence.CActor.getAllActorOfUsecase(AViewpointUc.getUsecase().getId()));

    AViewpointUc.setPrecond(persistence.CViewpointUc.getPrecond(AViewpointUc));
    AViewpointUc.setSuccessEndcond(persistence.CViewpointUc.getSuccessEndcond(AViewpointUc));
    AViewpointUc.setFailedEndcond(persistence.CViewpointUc.getFailedEndcond(AViewpointUc));

    AViewpointUc.setSuccessScenarioT1(persistence.CViewpointUc.getSuccessScenarioT1(AViewpointUc));
    AViewpointUc.setExtensionT1(persistence.CViewpointUc.getExtensionT1(AViewpointUc));
    AViewpointUc.setSubvariationT1(persistence.CViewpointUc.getSubvariationT1(AViewpointUc));

    AViewpointUc.setSuccessScenarioT2(persistence.CViewpointUc.getSuccessScenarioT2(AViewpointUc));
    AViewpointUc.setExtensionT2(persistence.CViewpointUc.getExtensionT2(AViewpointUc));
    AViewpointUc.setSubvariationT2(persistence.CViewpointUc.getSubvariationT2(AViewpointUc));
    if (business.Global.DEBUG)  System.out.println("<<--- contr.openViewpoint" );
  }

  /** saves viewpoint
   *  @param AViewpoint viewpoint to be saved
   */
  public void saveViewpoint(business.CViewpoint AViewpoint,boolean Visible ) {

    if (AViewpoint.getUser().getId() != business.Global.user.getId() &&
        !business.Global.user.isAnalyst() &&
        !business.Global.user.isAdmin())
    {
      CError.showNoRights(business.Global.recocase);
      return;
    }
    if (AViewpoint.getClass().isInstance(new business.CViewpointUc())) {
      //persistence.CViewpointUc.updateViewpointUc( (business.CViewpointUc) AViewpoint);
      this.addToSaveList( AViewpoint);
      //Thread myThread = new Thread(this, "");
      //myThread.start();
        this.run();
    } else {


      this.addToSaveList( AViewpoint);
      //Thread myThread = new Thread(this, "");
      //myThread.start();
        this.run();
    }
    business.Global.recocase.reload();
    if(Visible) getActiveComponent().setVisible(true);
  }

  /** saves all viewpoints
   */
  public void saveAllViewpoint() {

    for (int i=0; i<business.Global.viewpointFV.size(); i++) {
      if ((JFrame) business.Global.viewpointFV.elementAt(i) != null) {
        if (((JFrame) business.Global.viewpointFV.elementAt(i)).getClass().isInstance(
          new gui.CViewpointUseCaseF())) {
          ((gui.CViewpointUseCaseF) business.Global.viewpointFV.elementAt(i)).doSave();
        } else {
          ((gui.CViewpointScenarioF) business.Global.viewpointFV.elementAt(i)).doSave();
        }
      }
    }
  }

  /** closes viewpoint
   *  @param AViewpoint viewpoint to be closed
   */
  public void closeViewpoint(business.CViewpoint AViewpoint) {

    // ====== find index of viewpoint in vector
    int index = business.Global.viewpointV.indexOf(AViewpoint);
    business.Global.viewpointV.removeElementAt(index);
    if (business.Global.viewpointFV.elementAt(index) != null) {
      ((JFrame) business.Global.viewpointFV.elementAt(index)).dispose();
      business.Global.viewpointFV.removeElementAt(index);
    }
    if (business.Global.viewpointV.size() <= 0) {
      business.Global.setViewpointIsNotOpen();
      business.Global.menuBar.reload();
    }
    business.Global.recocase.reload();
  }

  /** closes all viewpoints */
  public void closeAllViewpoint() {

    for (int i=0; i<business.Global.viewpointFV.size(); i++) {
      if ((JFrame) business.Global.viewpointFV.elementAt(i) != null) {
        ((JFrame) business.Global.viewpointFV.elementAt(i)).dispose();
      }
    }
    business.Global.viewpointFV = new Vector();
    business.Global.viewpointV = new Vector();
    business.Global.setViewpointIsNotOpen();
    business.Global.menuBar.reload();
    business.Global.recocase.reload();
  }


  /** deletes viewpoint
   *  @param AViewpoint viewpoint to be deleted
   */
  public void deleteViewpoint(business.CViewpoint AViewpoint) {


    if (AViewpoint.getClass().isInstance(new business.CViewpointUc())) {
      if(persistence.CViewpointUc.deleteViewpointUc((business.CViewpointUc) AViewpoint))
      closeViewpoint(AViewpoint);
    } else {
      persistence.CViewpointSc.deleteViewpointSc((business.CViewpointSc) AViewpoint);
      closeViewpoint(AViewpoint);
    }
  }

  /** finds out if viewpoint agent followed guidelines
   *  @param AViewpoint viewpoint to be checked
   */
  public void verifyViewpoint(business.CViewpoint AViewpoint) {
    Vector allSentences = new Vector();
    if(AViewpoint.getType().equals( business.Global.TYPE_VP_USECASE)){
      business.CViewpointUc vp = (business.CViewpointUc) AViewpoint;
      if (AViewpoint.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
          allSentences.add(vp.getSuccessScenarioT1());
          allSentences.add(vp.getExtensionT1());
          allSentences.add(vp.getSubvariationT1());
      }else{

          allSentences.add(vp.getSuccessScenarioT2());
          allSentences.add(vp.getExtensionT2());
          allSentences.add(vp.getSubvariationT2());
      }
      allSentences.add(vp.getPrecond());
      allSentences.add(vp.getSuccessEndcond());
      allSentences.add(vp.getFailedEndcond());

    }else{
      business.CViewpointSc vp = (business.CViewpointSc) AViewpoint;
      if (AViewpoint.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
          allSentences.add(vp.getStepStrT1());
      }else{
          allSentences.add(vp.getStepStrT2());
      }
    }

    Vector sentences;
    sentences = new Vector();
    for(int v=0 ; v<allSentences.size() ; v++){
      sentences = (Vector) allSentences.elementAt(v);
      for (int i = 0 ; i<sentences.size() ; i++){
              business.Sentence aSentence =  (business.Sentence) sentences.elementAt(i);
              //gui.GSentence GUIstep =
              new gui.GSentence(null,aSentence,true,false);
      }//each step
    }//all steps
    getActiveComponent().setVisible(true);
  }

  /**
   *
   */

  private Window getActiveComponent() {
    if (dialogD != null) return dialogD;
    else if (frameF != null) return frameF;
    else return business.Global.recocase;
  }

  /** returns all shared scenarios of the shared use case */
//  public Vector getAllScenarioOfUsecase(business.CUsecase AUsecase) {
//    return persistence.CScenario.getAllScenariosOfUsecase(AUsecase);
//  }

  public synchronized void addToSaveList(business.CViewpoint AViewpoint) {
   SaveViewpointV.addElement( AViewpoint);
  }

  public synchronized  business.CViewpoint  nextInSaveList(){
    business.CViewpoint temp = (business.CViewpoint) SaveViewpointV.firstElement();
    SaveViewpointV.removeElement(temp);
    return temp;

  }

  public void run() {
    business.Global.SaveViewpoint.save(nextInSaveList());
  }


/**
 *
 *
 *
 * IMPORT Scenario
 *
 *
 */


  public void ImportScVP( business.CViewpointSc AViewpointSc1,
                          business.CViewpointSc AViewpointSc2){


       Vector VP1 = new Vector();
       Vector VP2 = new Vector();

       VP1 = AViewpointSc1.getStepStrT1();
       VP2 = persistence.CViewpointSc.getStepStrT1(AViewpointSc2);
       for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
       for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setStep(i+"");
       for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setPosition(i);
       AViewpointSc1.setStepStrT1(VP1);

       VP1 = AViewpointSc1.getStepStrT2();
       VP2 = persistence.CViewpointSc.getStepStrT2(AViewpointSc2);
       for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
       for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setStep(i+"");
       for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setPosition(i);
       AViewpointSc1.setStepStrT2(VP1);

  }




  //use for creating a NEW Group viewpoint
  //we can asume AViewpointUc1, is the NEW vp
  //and that AViewpointUc2, is the vp to be added
  // if AViewpointUc2, is open only the saved data will be imported
  public void ImportUCVP( business.CViewpointUc AViewpointUc1,
                       business.CViewpointUc AViewpointUc2,

                       boolean successPreCond,
                       boolean successEndCond,
                       boolean failedEndCond,
                       boolean successScenario,
                       boolean extension,
                       boolean variation)
{

   if (AViewpointUc1 != null && AViewpointUc2 != null ){

//          System.out.println( AViewpointUc1.toString() );
          System.out.println( AViewpointUc2.toString() );

          //************************************************************
          //************************************************************
        // Are viewpoints already open ?
        boolean found = false;
        for (int i=0; found == false && i<business.Global.viewpointV.size(); i++) {
          if (((business.CViewpoint) business.Global.viewpointV.elementAt(i)).getId() ==
            AViewpointUc1.getId()){

            int option = JOptionPane.showConfirmDialog(null,"Do you want to save" + AViewpointUc1.toString() ,"Save",JOptionPane.YES_NO_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
            if (option == JOptionPane.OK_OPTION){
              business.Global.SaveViewpoint.save(((business.CViewpoint) business.Global.viewpointV.elementAt(i)));
//              business.Global.SaveViewpoint.save(AViewpointUc1);
              // business.Global.contrViewpoint.saveViewpoint( )
              // persistence.CViewpointUc.updateViewpointUc(AViewpointUc1);
              //            business.Global.contrViewpoint.setFrame((javax.swing.JFrame) business.Global.viewpointFV.elementAt(i)  );
              //            business.Global.contrViewpoint.saveViewpoint((business.CViewpoint)    business.Global.viewpointV.elementAt(i));
            }
            if (option != JOptionPane.NO_OPTION){   }
            if (option != JOptionPane.CANCEL_OPTION){}

            business.Global.contrViewpoint.closeViewpoint((business.CViewpoint) business.Global.viewpointV.elementAt(i));
            found = true;//ERROR
          }
        }

//       business.Global.contrViewpoint.setDialog(this);
//       business.Global.contrViewpoint.openViewpoint(( business.CViewpoint) AViewpointUc1);
          //************************************************************
          //************************************************************

       Vector VP1 = new Vector();
       Vector VP2 = new Vector();

        if(successPreCond){
            VP1 = AViewpointUc1.getPrecond();
            VP2 = persistence.CViewpointUc.getPrecond(AViewpointUc2);
            for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
            for (int i = 0; i<VP1.size()  ; i++) ((business.CCondition)VP1.elementAt(i)).setNumber(i);
            AViewpointUc1.setPrecond(VP1);
          }

          if(successEndCond){
            VP1 = AViewpointUc1.getSuccessEndcond();
            VP2 = persistence.CViewpointUc.getSuccessEndcond(AViewpointUc2);
            for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
            for (int i = 0; i<VP1.size()  ; i++) ((business.CCondition)VP1.elementAt(i)).setNumber(i);
            AViewpointUc1.setSuccessEndcond(VP1);
          }

          if(failedEndCond){
            VP1 = AViewpointUc1.getFailedEndcond();
            VP2 = persistence.CViewpointUc.getFailedEndcond(AViewpointUc2);
            for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
            for (int i = 0; i<VP1.size()  ; i++) ((business.CCondition)VP1.elementAt(i)).setNumber(i);
            AViewpointUc1.setFailedEndcond(VP1);
          }

          if(successScenario){
            VP1 = AViewpointUc1.getSuccessScenarioT1();
            VP2 = persistence.CViewpointUc.getSuccessScenarioT1(AViewpointUc2);
            for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setStep(i+"");
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setPosition(i);
            AViewpointUc1.setSuccessScenarioT1(VP1);


            VP1 = AViewpointUc1.getSuccessScenarioT2();
            VP2 = persistence.CViewpointUc.getSuccessScenarioT2(AViewpointUc2);
            for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setStep(i+"");
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setPosition(i);
            AViewpointUc1.setSuccessScenarioT2(VP1);
          }

          if(extension){
            VP1 = AViewpointUc1.getExtensionT1();
            VP2 = persistence.CViewpointUc.getExtensionT1(AViewpointUc2);
            for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setStep(i+"");
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setPosition(i);
            AViewpointUc1.setExtensionT1(VP1);

            VP1 = AViewpointUc1.getExtensionT2();
            VP2 = persistence.CViewpointUc.getExtensionT2(AViewpointUc2);
            for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setStep(i+"");
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setPosition(i);
            AViewpointUc1.setExtensionT2(VP1);
          }

          if(variation){
            VP1 = AViewpointUc1.getSubvariationT1();
            VP2 = persistence.CViewpointUc.getSubvariationT1(AViewpointUc2);
            for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setStep(i+"");
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setPosition(i);
            AViewpointUc1.setSubvariationT1(VP1);

            VP1 = AViewpointUc1.getSubvariationT2();
            VP2 = persistence.CViewpointUc.getSubvariationT2(AViewpointUc2);
            for (int i = 0; i<VP2.size()  ; i++) VP1.add(VP2.elementAt(i));
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setStep(i+"");
            for (int i = 0; i<VP1.size()  ; i++) ((business.CStep)VP1.elementAt(i)).setPosition(i);
            AViewpointUc1.setSubvariationT2(VP1);
          }


//        found = false;
//        for (int i=0; found == false && i<business.Global.viewpointV.size(); i++) {
//          if (((business.CViewpoint) business.Global.viewpointV.elementAt(i)).getId() ==
//              AViewpointUc1.getId()){
//              found = true;
//              contr.CRecocase contrRecocase = new contr.CRecocase();
//              contrRecocase.showViewpoint(i);
//          }//if
//        }//for


      }//if
      else
      {
         System.out.println("NULL VIEWPOINT can not import" );
      }
  }//sub

//private Vector GroupVPFV = new Vector();

  public void closeGroupVP(JFrame AGroupVPF) {
      int index = business.Global.groupViewpointFV.indexOf(AGroupVPF);
      ((JFrame) business.Global.groupViewpointFV.elementAt(index)).dispose();
      business.Global.groupViewpointFV.removeElement(AGroupVPF);
      business.Global.menuBar.reload();
      business.Global.recocase.reload();
  }

  public void addGroupVP(JFrame AGroupVPF) {
      business.Global.groupViewpointFV.addElement(AGroupVPF);
      business.Global.menuBar.reload();
      business.Global.recocase.reload();
  }
//  public void openGroupVP(JFrame AGroupVPF) {
//    //Do NOT USE THIS because is not technically opening it
//    System.out.println("USE contr.CViewpoint.addGroupVP    insted of  contr.CViewpoint.openGroupVP");
//    addGroupVP(AGroupVPF);
//  }

  public void closeAllGroupViewpoint() {
    for(int i = 0 ; i < business.Global.groupViewpointFV.size() ; i++)
    {
       ((JFrame) business.Global.groupViewpointFV.elementAt(i)).dispose();
    }
    ((Vector) business.Global.groupViewpointFV).removeAllElements();
    business.Global.menuBar.reload();
  }

  public void saveAllGroupViewpoint() {
    for(int i = 0 ; i < business.Global.groupViewpointFV.size() ; i++)
    {
       ((gui.CGroupViewpoint) business.Global.groupViewpointFV.elementAt(i)).save();
    }
  }

  // ============

//  public void closeResolutionTable(JFrame AGroupVPF) {
//      int index = business.Global.resolutionTableFV.indexOf(AGroupVPF);
//      ((JFrame) business.Global.resolutionTableFV.elementAt(index)).dispose();
//      business.Global.resolutionTableFV.removeElement(AGroupVPF);
//  }
//
//  public void addResolutionTable(JFrame AGroupVPF) {
//      business.Global.resolutionTableFV.addElement(AGroupVPF);
//  }
//
//  public void closeAllResolutionTable() {
//    for(int i = 0 ; i < business.Global.resolutionTableFV.size() ; i++)
//    {
//       ((JFrame) business.Global.resolutionTableFV.elementAt(i)).dispose();
//    }
//    ((Vector) business.Global.resolutionTableFV).removeAllElements();
//
//  }

  // ============

  public Vector getOpenViewpointsOfUc(business.CUsecase UC){
    Vector Viewpoints = new Vector();
    for(int i = 0; i < business.Global.viewpointV.size() ; i++){
      business.CViewpoint VP = ((business.CViewpoint)business.Global.viewpointV.elementAt(i));
      if(VP.getUsecase().getId() == UC.getId()){
        Viewpoints.add(VP);
      }
    }
    return Viewpoints;
  }


  public void createGroupVP(){
    String GVPname = JOptionPane.showInputDialog( null,"Group Name ? ");
    if(GVPname != null && !GVPname.equals("")){
      String id = persistence.CGroupVP.CreateGroupVP(GVPname,false);
      new gui.CGroupViewpoint(id);
    }
  }

//  public void createGroupVPSC(){
//    String GVPname = JOptionPane.showInputDialog( null,"Group Name ? ");
//    if(GVPname != null && !GVPname.equals("")){
//      new gui.CGroupViewpoint( persistence.CGroupVP.CreateGroupVP(GVPname,business.Global.TYPE_VP_SCENARIO),business.Global.TYPE_VP_SCENARIO );
//    }
//  }

}