package contr;


import javax.swing.*;
import java.util.Vector;

/**
 * Title:        recocase
 * Description:  controller for processing shared use cases
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Kathrin and Oscar Aguilera
 * @version 1.0
 */

public class CUsecase {

  static JDialog dialogD = null;
  static JFrame frameF = null;

  public CUsecase() {}

  public static void setFrame(JFrame AFrameF) {
    frameF = AFrameF;
  }

  /** creates gui to open shared use case or
   *  opens gui of the already opened shared use case
   */
  public void showUseCase() {
    if (business.Global.usecaseF == null) {
      business.Global.usecaseF =
        new gui.CUseCaseF(business.Global.usecase);
    }
    business.Global.usecaseF.setVisible(true);
  }


  public gui.CUseCaseF useCaseFrame() {
    if (business.Global.usecaseF == null) {
      business.Global.usecaseF = new gui.CUseCaseF(business.Global.usecase);
      business.Global.usecaseF.hide();
    }
    return business.Global.usecaseF;
  }

  public static void setDialog(JDialog ADialogD) {
    dialogD = ADialogD;
  }


  /** inserts shared use case and shared scenario "none" into database
   *  @param AUsecase shared use case to be inserted
   */
  public void createUsecase(business.CUsecase AUsecase) {

    AUsecase.setProject(business.Global.project);
    boolean result = persistence.CUsecase.insertUsecase(AUsecase);
    if (result == true) {
//      business.CScenario scenario = new business.CScenario();
//      scenario.setUsecase(AUsecase);
//      scenario.setName("none");
//      persistence.CScenario.insertScenario(scenario);
      dialogD.dispose();
    }
  }

  /** opens shared use case if not open yet
   *  @param AUsecase usecase to be opened
   */
  public void openUsecase(business.CUsecase AUsecase) {

    if (AUsecase != null) {
      closeUsecase();
      dialogD.dispose();
      AUsecase.setActors(persistence.CActor.getAllActorOfUsecase(AUsecase.getId()));
      AUsecase.setPrecond(persistence.CUsecase.getPrecond(AUsecase));
      AUsecase.setSuccessEndcond(persistence.CUsecase.getSuccessEndcond(AUsecase));
      AUsecase.setFailedEndcond(persistence.CUsecase.getFailedEndcond(AUsecase));
      AUsecase.setSuccessScenarioT1(persistence.CUsecase.getSuccessScenarioT1(AUsecase));
      AUsecase.setExtensionT1(persistence.CUsecase.getExtensionT1(AUsecase));
      AUsecase.setSubvariationT1(persistence.CUsecase.getSubvariationT1(AUsecase));
      business.Global.usecase = AUsecase;
//      dialogD.dispose();
      business.Global.usecaseF = null;

      business.Global.setUsecaseIsOpen();
      business.Global.menuBar.reload();
      business.Global.recocase.reload();
    }
  }



  /** closes shared use case
   *  @param AUsecase shared use case to be closed
   */
  public void closeUsecase() {
    business.Global.contrDiagram.closeAll();
    business.Global.contrResolution.closeAllResolutionTable();
    business.Global.contrViewpoint.closeAllGroupViewpoint();
    business.Global.usecase = null;
    if (frameF != null) frameF.dispose();
    business.Global.setUsecaseIsNotOpen();
    business.Global.menuBar.reload();
    business.Global.recocase.reload();
  }

  /** hides gui of shared use case
   */
  public void hideUsecase() {
    business.Global.usecaseF.setVisible(false);
  }

  /** deletes shared use case
   *  @param AUsecase shared use case to be deleted
   */
  public void deleteUsecase(business.CUsecase AUsecase) {
    if (AUsecase != null)
      //JOptionPane.showMessageDialog(null,"THIS does not delete everything");

      persistence.CUsecase.deleteUsecase(AUsecase);
//
      business.Global.closeAll();

  }



  /** finds out if viewpoint agent followed guidelines
   *  @param AViewpoint viewpoint to be checked
   */
  public void verifyUsecase(business.CUsecase AUsecase) {
    Vector allSteps = new Vector();
    allSteps.add(AUsecase.getSuccessScenarioT1());
    allSteps.add(AUsecase.getExtensionT1());
    allSteps.add(AUsecase.getSubvariationT1());

    allSteps.add(AUsecase.getSuccessEndcond());
    allSteps.add(AUsecase.getFailedEndcond());
    allSteps.add(AUsecase.getPrecond());

    Vector steps;
    steps = new Vector();
    for(int v=0 ; v<allSteps.size() ; v++){
      steps = (Vector) allSteps.elementAt(v);
      for (int i = 0 ; i<steps.size() ; i++){
              business.Sentence step =  (business.Sentence) steps.elementAt(i);
              new gui.GSentence(null,step,true,false);
      }//each step
    }//all steps



  }





  /** saves shared use case
   *  @param AUsecase shared use case to be saved
   */
//  public void saveUsecase(business.CUsecase AUsecase) {
//    persistence.CUsecase.updateUsecase(AUsecase);
//    business.Global.recocase.reload();
//    business.Global.usecaseF.setVisible(true);
//  }






//  save
  public synchronized void saveUsecase(business.CUsecase AUsecase) {

  boolean DBnotOK = false ;

          Vector Allsteps = new Vector();
          Vector tmp;
          tmp = AUsecase.getSuccessScenarioT1();
          for(int i = 0 ; i< tmp.size() ; i++ ){
            Allsteps.addElement( tmp.elementAt(i) );
          }
          tmp = AUsecase.getExtensionT1();
          for(int i = 0 ; i< tmp.size() ; i++ ){
            Allsteps.addElement( tmp.elementAt(i) );
          }
          tmp = AUsecase.getSubvariationT1();
          for(int i = 0 ; i< tmp.size() ; i++ ){
            Allsteps.addElement( tmp.elementAt(i) );
          }
          //--
          tmp = AUsecase.getPrecond();
          for(int i = 0 ; i< tmp.size() ; i++ ){
            Allsteps.addElement( tmp.elementAt(i) );
          }
          tmp = AUsecase.getSuccessEndcond();
          for(int i = 0 ; i< tmp.size() ; i++ ){
            Allsteps.addElement( tmp.elementAt(i) );
          }
          tmp = AUsecase.getFailedEndcond();
          for(int i = 0 ; i< tmp.size() ; i++ ){
            Allsteps.addElement( tmp.elementAt(i) );
          }

          String actors = business.CRecocaseLogic.getActorS(AUsecase.getActors());
          actors = actors + "-" + business.Global.project.getSystem();

          for(int i = 0 ;i<Allsteps.size();i++)
          {
  //CCOndition
            if (Allsteps.elementAt(i).getClass().isInstance(new business.CCondition()) ){
              business.CCondition  step = (business.CCondition) Allsteps.elementAt(i);
              if(step.getSentenceChanged() || DBnotOK ){ step.analyse();
//                System.out.println(step.getText());
//                  business.CRecocaseLogic.analyseSentence(step.getText(),actors);
//
//                  Vector AllphrasesV = new Vector();
//                  Vector phrasesV  = business.CRecocaseLogic.convertToVector(business.CRecocaseLogic.getPhrases());
//                  for (int x=0; x<phrasesV.size(); x++) {
//                    String attr = (String) phrasesV.elementAt(x);
//                    if(attr.equals("keyw")){
//                    }else{
//                      System.out.println( attr );
//                      if (!AllphrasesV.contains(attr)) AllphrasesV.add(attr);
//                    }
//                  }
//                  Vector keyWords = business.CRecocaseLogic.getKeyWords();
//                  if (keyWords != null) {
//                      for (int x=0; x<keyWords.size(); x++) {
//                            String key = (String)
//                            business.CRecocaseLogic.convertToVector(
//                              (String) keyWords.elementAt(x)).elementAt(0);
//                            if (!AllphrasesV.contains(key)) AllphrasesV.add(key);
//                      }
//                  }
//                  String  extrans = ", ";
//                  for (int x=0; x<AllphrasesV.size(); x++) {
//                    extrans = extrans + AllphrasesV.elementAt(x)+ ", ";
//                  }
//                  step.setExtransText(extrans);
              }
            }else{
  //CStep
              business.CStep  step = (business.CStep) Allsteps.elementAt(i);
              if(step.getSentenceChanged() || DBnotOK ){ step.analyse();
//                System.out.println(step.getAction());
//
//                if (step.getClass().isInstance(new business.CStepStrT2())) {
//                  business.CRecocaseLogic.analyseSentence(
//                  ((business.CStepStrT2)step).getSentence() , actors);
//                }else{
//                    business.CRecocaseLogic.analyseSentence(step.getAction(),actors);
//                }
//
//                Vector AllphrasesV = new Vector();
//                Vector phrasesV  = business.CRecocaseLogic.convertToVector(business.CRecocaseLogic.getPhrases());
//                for (int x=0; x<phrasesV.size(); x++) {
//                  String attr = (String) phrasesV.elementAt(x);
//                  if(attr.equals("keyw")){
//                    //System.out.println("K:" + attr);
//                  }else{
//                    System.out.println( attr );
//                    if (!AllphrasesV.contains(attr)) AllphrasesV.add(attr);
//
//                  }
//                }
//
//                Vector keyWords = business.CRecocaseLogic.getKeyWords();
//                if (keyWords != null) {
//                    for (int x=0; x<keyWords.size(); x++) {
//                          String key = (String)
//                          business.CRecocaseLogic.convertToVector(
//                            (String) keyWords.elementAt(x)).elementAt(0);
//                          if (!AllphrasesV.contains(key)) AllphrasesV.add(key);
//                    }
//                }
//
//                String  extrans = ", ";
//                for (int x=0; x<AllphrasesV.size(); x++) {
//                  extrans = extrans + AllphrasesV.elementAt(x)+ ", ";
//                }
//                step.setPhrases(extrans);
              }
            }
          }

          persistence.CUsecase.updateUsecase(AUsecase);
          business.Global.recocase.reload();
          business.Global.usecaseF.setVisible(true);

  }


  public boolean isOpen(business.CUsecase UC){
    if(business.Global.usecase == null )return false;
    if(business.Global.usecase.getId() == UC.getId() )return true;
    return false;
  }

}