package contr;

import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 *
 * Description: controller for actions which are triggered by choosing options
 * from the main frame
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CRecocase {

  public CRecocase() {}

  /** controls login into system */
  public business.CUser showLogin() {

    business.CUser user = null;

    if (business.Global.TEST) {
      user = new business.CUser(4,"Kathrin", null, null, true, true,true);
      business.Global.user = user;
    } else {


      while ( user == null) {
        gui.CLoginD loginD = new gui.CLoginD(business.Global.recocase);
        business.CUser  aUser = loginD.showDialog();
        if (aUser != null) {// not cancel
          user = persistence.CUser.getUser(aUser.getLogin(), aUser.getPassword());
          if (user != null) { // user exist in database
            if (user.isValid()){
              business.Global.user = user;
              business.Global.clearMessage();
              business.Global.contrProject.closeProject();
              business.Global.addMessage("open a project !");
            }else{
              user = null;
            }
          } else {
            contr.CError.showNoLogin(business.Global.recocase);
          }
        }
      }
    }

    return user;
  }

  /** creates gui to open project or
   *  opens gui of the already opened project
   */
  public void showProject() {

    if (business.Global.projectF == null) {
      business.Global.projectF =
        new gui.CProjectF(business.Global.project);
    }
    business.Global.projectF.setVisible(true);
  }

  /** creates gui to open shared use case or
   *  opens gui of the already opened shared use case
   *
   * DO NOT USE, use             business.Global.contrRecocase.showUseCase();
   *
   */
  public void showUseCase() {

    if (business.Global.usecaseF == null) {
      business.Global.usecaseF =
        new gui.CUseCaseF(business.Global.usecase);
    }
    business.Global.usecaseF.setVisible(true);
  }

  /** creates gui to open shared scenario or
   *  opens gui of the AIndex. opened shared scenario
   */
//  public void showScenario(int AIndex) {
//
//    gui.CScenarioF scenarioF =
//      (gui.CScenarioF) business.Global.scenarioFV.elementAt(AIndex);
//    if (scenarioF == null) {
//      scenarioF =
//      new gui.CScenarioF(
//        (business.CScenario)
//         business.Global.scenarioV.elementAt(AIndex));
//      business.Global.scenarioFV.setElementAt(scenarioF, AIndex);
//    }
//    scenarioF.setVisible(true);
//  }

  /** creates gui to open viewpoint or
   *  opens gui of the AIndex. opened viewpoint
   */

  public void showViewpoint(int AIndex) {

    business.CViewpoint viewpoint =
      (business.CViewpoint) business.Global.viewpointV.elementAt(AIndex);

    if (viewpoint.getClass().isInstance(new business.CViewpointUc())) {
      // use case viewpoint

      gui.CViewpointUseCaseF viewpointUcF =
        (gui.CViewpointUseCaseF) business.Global.viewpointFV.elementAt(AIndex);

      if (viewpointUcF == null) {

        Vector usecaseV = persistence.CUsecase.getAllUsecasesOfProject(business.Global.project);
        if (usecaseV != null) {
          for (int i=0; i<usecaseV.size(); i++)
            ((business.CUsecase) usecaseV.elementAt(i)).setActors(
            persistence.CActor.getAllActorOfUsecase(
            ((business.CUsecase) usecaseV.elementAt(i)).getId()));
        }

        viewpointUcF =
          new gui.CViewpointUseCaseF(
           (business.CViewpointUc)
           business.Global.viewpointV.elementAt(AIndex),
           usecaseV);

        business.Global.viewpointFV.setElementAt(viewpointUcF, AIndex);
      }


      viewpointUcF.setVisible(true);
    } else {

      // scenario viewpoint
      business.CViewpointSc viewpointSc =
        (business.CViewpointSc) viewpoint;
      gui.CViewpointScenarioF viewpointScF =
        (gui.CViewpointScenarioF) business.Global.viewpointFV.elementAt(AIndex);

      if (viewpointScF == null) {

        Vector usecaseV =
          persistence.CUsecase.getAllUsecasesOfProject(business.Global.project);
        if (usecaseV != null) {
          for (int i=0; i<usecaseV.size(); i++)
            ((business.CUsecase) usecaseV.elementAt(i)).setActors(
            persistence.CActor.getAllActorOfUsecase(
            ((business.CUsecase) usecaseV.elementAt(i)).getId()));
        }

        Vector scenarioV = null;
//        if (viewpointSc.getScenario() != null) {
//          scenarioV = persistence.CScenario.getAllScenariosOfUsecase(
//            viewpointSc.getScenario().getUsecase()
//          );
//        } else if (usecaseV != null) {
//          scenarioV = persistence.CScenario.getAllScenariosOfUsecase(
//            (business.CUsecase) usecaseV.elementAt(0)
//          );
//        }

        viewpointScF =
          new gui.CViewpointScenarioF(
           (business.CViewpointSc)
           business.Global.viewpointV.elementAt(AIndex));//,
//           usecaseV,
//           scenarioV
//           );
        business.Global.viewpointFV.setElementAt(viewpointScF, AIndex);
      }
      viewpointScF.setVisible(true);
    }
  }



  public void closeResolutionTable(JFrame AGroupVPF) {
      int index = business.Global.resolutionTableFV.indexOf(AGroupVPF);
      ((JFrame) business.Global.resolutionTableFV.elementAt(index)).dispose();
      business.Global.resolutionTableFV.removeElement(AGroupVPF);
  }

  public void addResolutionTable(JFrame AGroupVPF) {
      business.Global.resolutionTableFV.addElement(AGroupVPF);
  }

  public void closeAllResolutionTable() {
    for(int i = 0 ; i < business.Global.resolutionTableFV.size() ; i++)
    {
       ((JFrame) business.Global.resolutionTableFV.elementAt(i)).dispose();
    }
    ((Vector) business.Global.resolutionTableFV).removeAllElements();
  }






}
