package contr;


import javax.swing.*;

/**
 *
 * Description: controller for processing projects
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CProject {

  static JDialog dialogD = null;
  static JFrame frameF = null;

  public CProject() {}

  public static void setFrame(JFrame AFrameF) {
    frameF = AFrameF;
  }

  public static void setDialog(JDialog ADialogD) {
    dialogD = ADialogD;
  }

  /** inserts project into database
   *  @param AProject project to be inserted
   */
  public void createProject(business.CProject AProject) {

    boolean result = persistence.CProject.insertProject(AProject);
    if (result == true) {

      //business.CUsecase usecase = new business.CUsecase();
      //usecase.setProject(AProject);
      //usecase.setName("none");
      //usecase.setFunctReq("none");
      //persistence.CUsecase.insertUsecase(usecase);
      //business.CScenario scenario = new business.CScenario();
      //scenario.setUsecase(usecase);
      //scenario.setName("none");
      //persistence.CScenario.insertScenario(scenario);
      //dialogD.dispose();
    }
  }

  /** opens project
   *  @param AProject project to be opened
   */
  public void openProject(business.CProject AProject) {
    int sure = JOptionPane.YES_OPTION;
    if(business.Global.project!=null){
        sure = JOptionPane.showConfirmDialog(
        frameF,
        "Opening the project will close the previous project \n Do you want to continue? ",
        "Open Project",
        JOptionPane.YES_NO_OPTION);

    }
    if (AProject != null && sure == JOptionPane.YES_OPTION) {
      if(closeProject()){
        //business.Global.closeAll();
        business.Global.clearMessage();

        business.Global.project = AProject;
        dialogD.dispose();
        business.Global.projectF = null;
        business.Global.setProjectIsOpen();
        business.Global.menuBar.reload();
        business.Global.recocase.reload();
      }
    }
  }

  /** saves project
   *  @param AProject project which has to be updated in database
   */
  public void saveProject(business.CProject AProject) {
    if (!business.Global.user.isAnalyst()) {
      contr.CError.showNoRights(business.Global.recocase);
      return;
    }
    persistence.CProject.updateProject(AProject);
    business.Global.recocase.reload();
    business.Global.projectF.setVisible(true);
  }

  /** closes project */
  public boolean closeProject() {
    int sure = JOptionPane.YES_OPTION;
    if(business.Global.project!=null && (business.Global.UseCaseIsOpen||business.Global.ViewpointIsOpen)){
      //if business.Global.UseCaseIsOpen this means thea vp anf gvp could be open
      sure = JOptionPane.showConfirmDialog(
      frameF,
      "Closing the project will close all viewpoints \n Do you want to continue? ",
      "Open Project",
      JOptionPane.YES_NO_OPTION);
    }
    if (sure == JOptionPane.YES_OPTION) {
      if(business.Global.project != null && business.Global.project.getSynonymTableFrame()!=null) business.Global.project.resetSynonymTable();//resetSynonymTable will dispose of frame
      business.Global.closeAll();
      business.Global.project = null;
      if (frameF != null) frameF.dispose();
      business.Global.setProjectIsNotOpen();
      business.Global.menuBar.reload();
      business.Global.recocase.reload();
      business.Global.clearMessage();
      return true;
    }else{
      return false;
    }


  }

  /** hides gui of project data */
  public void hideProject() {
    business.Global.projectF.setVisible(false);
  }

  /** deletes project
   *  @param AProject project to be deleted
   */
  public void deleteProject(business.CProject AProject) {
    if (AProject != null)
      if(closeProject()){
      persistence.CProject.deleteProject(AProject);
    }
  }
}