package contr;

import java.util.*;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;

/**
 * Description: controller for actions triggered by choosing a menuitem
 *
 * @author Kathrin Boettger and Oscar Aguilera
 *
 * @version 1.0
 */
public class CMenuBar {

  public CMenuBar() {
  }

  /** creates gui to create a new project */
  public void newProject() {
    new gui.CProjectNewD(business.Global.recocase).showDialog();
  }

  /** creates gui to choose a project to open it */
  public void openProject() {
    Vector projectV = new Vector();
    projectV = persistence.CProject.getAllProject();
    if (projectV.size() > 0) {
      gui.CProjectOpenD projectD =
        new gui.CProjectOpenD(business.Global.recocase, projectV);
      projectD.showDialog();
    } else {
      contr.CError.showNoProjects(business.Global.recocase);
    }
  }

  /** closes the current project */
  public boolean closeProject() {
    return business.Global.contrProject.closeProject();
  }

  /** saves the current project */
  public void saveProject() {
    if (business.Global.projectF != null)
      business.Global.projectF.save();
  }


  /** creates gui to create a new shared use case */
//  public void newUsecase() {
//    new gui.CUseCaseNewD(business.Global.recocase,
//                         business.Global.project
//                        ).showDialog();
//  }

  /** creates gui to choose a shared use case of the current project to open it */
  public void openUsecase() {
    if(business.Global.usecase == null){
      Vector usecaseV = persistence.CUsecase.getAllUsecasesOfProject(business.Global.project);
      if (usecaseV != null && usecaseV.size()>0) {
        new gui.CUseCaseOpenD(business.Global.recocase, usecaseV).showDialog();
      } else {
        JOptionPane.showMessageDialog(business.Global.recocase, "There are no usecases.");
      }
    }else{
      JOptionPane.showMessageDialog(null,"You can only have one shared use case open at a time");
    }
  }

  /** closes current shared use case */
  public void closeUseCase() {
    business.Global.contrUsecase.useCaseFrame().close();
  }

  /** saves the shared use case */
  public void saveUsecase() {
    if (business.Global.usecaseF != null)
      business.Global.usecaseF.doSave();
  }

  /** creates gui to create a new shared scenario */
  public void newScenario() {
     // new gui.CScenarioNewF(business.Global.recocase);
  }

  /** creates gui to choose a shared scenario of the current shared use case to open it */
  public void openScenario() {
  }


  /** creates gui to choose a viewpoint of the current project to open it */
  public void openViewpoint() {

//    Vector allViewpointV = new Vector();
//    allViewpointV = persistence.CProject.getAllViewpointOfProject(  business.Global.project);

//    if (allViewpointV.size() > 0) {
      business.Global.addMessage("mark a viewpoint and choose 'open viewpoint' !");
      new gui.CViewpointOpenD(business.Global.recocase).showDialog();
      business.Global.clearMessage();
//    } else {
//      contr.CError.showNoViewpoint(business.Global.recocase);
//    }

  }

  /** saves all viewpoints which are opened at the moment */
  public void saveAllViewpoint() {
    business.Global.contrViewpoint.saveAllViewpoint();
  }

  /** closes all viewpoints */
  public void closeAllViewpoint() {
    int sure = JOptionPane.showConfirmDialog(
      null,
      "Closing all viewpoints \n Do you want to continue? ",
      "Closing all viewpoints",
      JOptionPane.YES_NO_OPTION);

    if (sure == JOptionPane.YES_OPTION) {
      business.Global.contrViewpoint.closeAllViewpoint();
    }
  }

  public void closeAllGroupViewpoint(){
           business.Global.contrViewpoint.closeAllGroupViewpoint();
  }


  public void saveAllGroupViewpoint(){
    business.Global.contrViewpoint.saveAllGroupViewpoint();
  }

  public void createGroupVP() {
          business.Global.contrViewpoint.createGroupVP();
  }

  public void openGroupVP(){
    new gui.CGroupVP( null ) ;
  }


  /** creates gui to choose kind of viewpoints (scenario or use case) and
   *  creates the correspondent gui to choose viewpoints for FCA
   */
  public void newFCA(String result) {
    Vector allFCAViewpointV = new Vector();
    if (result != null) {
      if (result.equals(business.Global.TYPE_VP_USECASE)) { // FCA of use case viewpoints

         // Vector of Vector of (use case, Vector of use case viewpoint)
         Vector allUsecaseV =
         persistence.CUsecase.getAllUsecasesOfProject(business.Global.project);
         if (allUsecaseV != null) {
           for (int i=0; i<allUsecaseV.size(); i++) {
             Vector ucVpV = new Vector();
             ucVpV.add((business.CUsecase) allUsecaseV.elementAt(i));
             ucVpV.add(persistence.CViewpointUc.getAllViewpointUcOfUsecase(
             (business.CUsecase) allUsecaseV.elementAt(i)));
             allFCAViewpointV.add(ucVpV);
           }
         }
         // tree to choose final use case viewpoints for fca
         new gui.CFCAF(allFCAViewpointV, business.Global.TYPE_VP_USECASE);
      } else { // FCA of scenario viewpoints
      }
    }


  }
}
