package contr;

import java.util.Vector;
import java.io.*;
import javax.swing.*;


/**
 *
 * Description: controls creation of
 * flt-files
 * and crosstables
 * and later concept lattices
 *
 * @author Kathrin Boettger and Oscar Aguilera
 *
 * @version 1.0
 */
public class CFCA {

private Vector FLTcommentsV;

  /**
   * default flt-file for output of RECOCASE
   */

  public final static File defaultFLT =
    new File("results/data.flt");

  public CFCA() {}

  /**
   *  creates a file in FLT-format for 'scenarios' and 'scenario viewpoints'
   *
   * @param AVpV vector of 'scenarios'  and 'scenario viewpoints'
   */
//  public void createFltFileForSc(Vector AVpV) {
//    try {
//      if (AVpV != null) {
//
//        // find out filename
//        final JFileChooser fc = new JFileChooser();
//        fc.setToolTipText("choose flt-file");
//        int returnVal = fc.showOpenDialog(business.Global.recocase);
//        File file;
//        if (returnVal == JFileChooser.APPROVE_OPTION) {
//          file = fc.getSelectedFile();
//        } else {
//          file = defaultFLT;
//        }
//        business.CFLT flt = new business.CFLT(file);
//
//        for (int k=0; k<AVpV.size(); k++) {
//          String sentence = null;
//          Object obj = (Object) AVpV.elementAt(k);
//          if (obj.getClass().isInstance(new business.CScenario())) {
//            // shared scenario
//
//            business.CScenario sc = (business.CScenario) obj;
//            sc.setAgents(persistence.CActor.getAllAgentOfScenario(sc.getId()));
//            String agents = business.CRecocaseLogic.getAgentS(sc.getAgents());
//            sc.setScenarioT1(
//               persistence.CScenario.getScenarioT1(sc));
//            for (int l=0; l<sc.getScenarioT1().size(); l++) {
//               sentence =
//               ((business.CStepStrT1)
//               sc.getScenarioT1().elementAt(l)).getAction();
//               this.addToFLT(flt, agents, sentence,
//                  ((business.CStepStrT1)
//                  sc.getScenarioT1().elementAt(l)).getStep(),
//                  new String("S"),
//                  sc.getName());
//            }
//
//          } else {
//            // scenario viewpoint
//            business.CViewpointSc vpSc = (business.CViewpointSc) obj;
//            vpSc.setAgents(persistence.CActor.getAllAgentOfViewpointScenario(vpSc.getId()));
//            String agents = business.CRecocaseLogic.getAgentS(vpSc.getAgents());
//
//            if (vpSc.getStyle() == business.Global.STYLE_UNSTRUCT) {
//              // ... processing of unstructured text
//
//            } else if (vpSc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//                vpSc.setStepStrT1(
//                  persistence.CViewpointSc.getStepStrT1(vpSc));
//                for (int l=0; l<vpSc.getStepStrT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      vpSc.getStepStrT1().elementAt(l)).getAction();
//                   this.addToFLT(flt, agents, sentence,
//                     ((business.CStepStrT1)
//                      vpSc.getStepStrT1().elementAt(l)).getStep(),
//                      vpSc.getOwner().getName(),
//                      vpSc.getName());
//                }
//
//            } else { // business.Global.STYLE_STRUCT_WITH_ACTOR
//                vpSc.setStepStrT2(
//                  persistence.CViewpointSc.getStepStrT2(vpSc));
//                for (int l=0; l<vpSc.getStepStrT2().size(); l++) {
//
//                if (((business.CStepStrT2) vpSc.getStepStrT2().elementAt(l)).getAgent() != null) {
//                   sentence =
//                     " The " +
//                     ((business.CStepStrT2)
//                      vpSc.getStepStrT2().elementAt(l)).getAgent().getName()
//                      + " " +
//                     ((business.CStepStrT2)
//                      vpSc.getStepStrT2().elementAt(l)).getAction();
//
//                 }else if (((business.CStepStrT2) vpSc.getStepStrT2().elementAt(l)).isSystemStep()) {
//                   sentence =
//                     " The " +
//                     business.Global.project.getSystem()
//                      + " " +
//                     ((business.CStepStrT2)
//                      vpSc.getStepStrT2().elementAt(l)).getAction();
//                 } else {
//
//                   sentence =
//                     ((business.CStepStrT2)
//                      vpSc.getStepStrT2().elementAt(l)).getAction();
//                 }
//
//                 this.addToFLT(flt, agents, sentence,
//                     ((business.CStepStrT2)
//                      vpSc.getStepStrT2().elementAt(l)).getStep(),
//                      vpSc.getOwner().getName(),
//                      vpSc.getName());
//               }
//            }
//          }
//          flt.writeToFltFile();
//        }
//      }
//    } catch (Exception ex) {
//      String error = new String("error message: can't create flt-file \n");
//      error = contr.CError.createErrorMessage(error, ex);
//      contr.CError.showErrorMessage(business.Global.recocase, error);
//      if (business.Global.DEBUG) System.out.println(error);
//    }
//  }

  /**
   *  creates a file in FLT-format for 'use cases' and 'use case viewpoints'
   *
   * @param AVpV vector of 'use cases' and 'use case viewpoints'
   * @param APreCond flag if conversion of preconditions
   * @param ASuccessEndCond flag if conversion of success endconditions
   * @param AFailedEndCond flag if conversion of failed endcondition
   * @param ASuccessScenario flag if conversion of success scenario
   * @param AExtension flag if conversion of extensions
   * @param AVariation flag if conversion of variations
   */
//  public void createFltFileForUc(Vector AVpV,
//                         boolean APreCond,
//                         boolean ASuccessEndCond,
//                         boolean AFailedEndCond,
//                         boolean ASuccessScenario,
//                         boolean AExtension,
//                         boolean AVariation) {
//
//    try {
//      if (AVpV != null) {
//
//        // find out filename
//        final JFileChooser fc = new JFileChooser();
//        fc.setToolTipText("choose flt-file");
//        int returnVal = fc.showOpenDialog(business.Global.recocase);
//        File file;
//        if (returnVal == JFileChooser.APPROVE_OPTION) {
//          file = fc.getSelectedFile();
//        } else {
//          file = defaultFLT;
//        }
//        business.CFLT flt = new business.CFLT(file);
//
//        for (int k=0; k<AVpV.size(); k++) {
//
//          String sentence = null;
//          Object obj = (Object) AVpV.elementAt(k);
//          if (obj.getClass().isInstance(new business.CUsecase())) {
//            // shared Use case
//
//            business.CUsecase uc = (business.CUsecase) obj;
//            uc.setActors(persistence.CActor.getAllActorOfUsecase(uc.getId()));
//            String actors = business.CRecocaseLogic.getActorS(uc.getActors());
//            actors += business.Global.project.getSystem();
//
//            if (ASuccessScenario) {
//
//                uc.setSuccessScenarioT1(
//                  persistence.CUsecase.getSuccessScenarioT1(uc));
//                for (int l=0; l<uc.getSuccessScenarioT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      uc.getSuccessScenarioT1().elementAt(l)).getAction();
//                   this.addToFLT(flt, actors, sentence,
//                     ((business.CStepStrT1)
//                      uc.getSuccessScenarioT1().elementAt(l)).getStep(),
//                      new String("S"),
//                      uc.getName());
//                }
//            }
//
//            if (AExtension) {
//
//                uc.setExtensionT1(
//                  persistence.CUsecase.getExtensionT1(uc));
//                for (int l=0; l<uc.getExtensionT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      uc.getExtensionT1().elementAt(l)).getAction();
//                   this.addToFLT(flt, actors, sentence,
//                     ((business.CStepStrT1)
//                      uc.getExtensionT1().elementAt(l)).getStep(),
//                      new String("S"),
//                      uc.getName());
//                }
//
//            }
//
//            if (AVariation) {
//
//                uc.setSubvariationT1(
//                  persistence.CUsecase.getSubvariationT1(uc));
//                for (int l=0; l<uc.getSubvariationT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      uc.getSubvariationT1().elementAt(l)).getAction();
//                   this.addToFLT(flt, actors, sentence,
//                     ((business.CStepStrT1)
//                      uc.getSubvariationT1().elementAt(l)).getStep(),
//                      new String("S"),
//                      uc.getName());
//                }
//
//            }
//
//            if (APreCond) {
//                uc.setPrecond(
//                  persistence.CUsecase.getPrecond(uc));
//                for (int l=0; l<uc.getPrecond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      uc.getPrecond().elementAt(l)).getText();
//                   this.addToFLT(flt, actors, sentence,
//                     String.valueOf(((business.CCondition)
//                      uc.getPrecond().elementAt(l)).getNumber()),
//                      new String("S"),
//                      uc.getName());
//                }
//
//            }
//
//            if (ASuccessEndCond) {
//                uc.setSuccessEndcond(
//                  persistence.CUsecase.getSuccessEndcond(uc));
//                for (int l=0; l<uc.getSuccessEndcond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      uc.getSuccessEndcond().elementAt(l)).getText();
//                   this.addToFLT(flt, actors, sentence,
//                     String.valueOf(((business.CCondition)
//                      uc.getSuccessEndcond().elementAt(l)).getNumber()),
//                      new String("S"),
//                      uc.getName());
//                }
//            }
//
//            if (AFailedEndCond) {
//                uc.setFailedEndcond(
//                  persistence.CUsecase.getFailedEndcond(uc));
//                for (int l=0; l<uc.getFailedEndcond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      uc.getFailedEndcond().elementAt(l)).getText();
//                   this.addToFLT(flt, actors, sentence,
//                     String.valueOf(((business.CCondition)
//                      uc.getFailedEndcond().elementAt(l)).getNumber()),
//                      new String("S"),
//                      uc.getName());
//                }
//
//            }
//
//          } else if (obj.getClass().isInstance(new business.CViewpointUc())) {
//            // use case viewpoint
//            business.CViewpointUc vpUc = (business.CViewpointUc) obj;
//            vpUc.setActors(persistence.CActor.getAllActorOfViewpointUc(vpUc.getId()));
//            String actors = business.CRecocaseLogic.getActorS(vpUc.getActors());
//            actors += business.Global.project.getSystem();
//
//            if (ASuccessScenario) {
//
//              if (vpUc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//                vpUc.setSuccessScenarioT1(
//                  persistence.CViewpointUc.getSuccessScenarioT1(vpUc));
//                for (int l=0; l<vpUc.getSuccessScenarioT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      vpUc.getSuccessScenarioT1().elementAt(l)).getAction();
//                   this.addToFLT(flt, actors, sentence,
//                     ((business.CStepStrT1)
//                      vpUc.getSuccessScenarioT1().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//
//              } else { // business.Global.STYLE_STRUCT_WITH_ACTOR
//                vpUc.setSuccessScenarioT2(
//                  persistence.CViewpointUc.getSuccessScenarioT2(vpUc));
//                for (int l=0; l<vpUc.getSuccessScenarioT2().size(); l++) {
//
//                  if (((business.CStepStrT2) vpUc.getSuccessScenarioT2().elementAt(l)).getActor() != null) {
//
//                     sentence =
//                       " The " +
//                       ((business.CStepStrT2)
//                        vpUc.getSuccessScenarioT2().elementAt(l)).getActor().getType()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getSuccessScenarioT2().elementAt(l)).getAction();
//
//                  } else if (((business.CStepStrT2) vpUc.getSuccessScenarioT2().elementAt(l)).isSystemStep()) {
//
//                     sentence =
//                       " The " +
//                        business.Global.project.getSystem()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getSuccessScenarioT2().elementAt(l)).getAction();
//
//                  } else {
//
//                     sentence =
//                       ((business.CStepStrT2)
//                        vpUc.getSuccessScenarioT2().elementAt(l)).getAction();
//                  }
//
//                   this.addToFLT(flt, actors, sentence,
//                     ((business.CStepStrT2)
//                     vpUc.getSuccessScenarioT2().elementAt(l)).getStep(),
//                     vpUc.getOwner().getName(),
//                     vpUc.getName());
//                }
//              }
//
//            }
//
//            if (AExtension) {
//
//              if (vpUc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//                vpUc.setExtensionT1(
//                  persistence.CViewpointUc.getExtensionT1(vpUc));
//                for (int l=0; l<vpUc.getExtensionT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      vpUc.getExtensionT1().elementAt(l)).getAction();
//                   this.addToFLT(flt, actors, sentence,
//                     ((business.CStepStrT1)
//                      vpUc.getExtensionT1().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//              } else { // business.Global.STYLE_STRUCT_WITH_ACTOR
//                vpUc.setExtensionT2(
//                  persistence.CViewpointUc.getExtensionT2(vpUc));
//
//                for (int l=0; l<vpUc.getExtensionT2().size(); l++) {
//
//                  if (((business.CStepStrT2) vpUc.getExtensionT2().elementAt(l)).getActor() != null) {
//
//                     sentence =
//                       " The " +
//                       ((business.CStepStrT2)
//                        vpUc.getExtensionT2().elementAt(l)).getActor().getType()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getExtensionT2().elementAt(l)).getAction();
//
//                  } else if (((business.CStepStrT2) vpUc.getExtensionT2().elementAt(l)).isSystemStep()) {
//
//                     sentence =
//                       " The " +
//                        business.Global.project.getSystem()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getExtensionT2().elementAt(l)).getAction();
//
//                  } else {
//
//                     sentence =
//                       ((business.CStepStrT2)
//                        vpUc.getExtensionT2().elementAt(l)).getAction();
//
//                   }
//
//                   this.addToFLT(flt, actors, sentence,
//                     ((business.CStepStrT2)
//                      vpUc.getExtensionT2().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//              }
//            }
//
//            if (AVariation) {
//
//              if (vpUc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//                vpUc.setSubvariationT1(
//                  persistence.CViewpointUc.getSubvariationT1(vpUc));
//                for (int l=0; l<vpUc.getSubvariationT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      vpUc.getSubvariationT1().elementAt(l)).getAction();
//                   this.addToFLT(flt, actors, sentence,
//                     ((business.CStepStrT1)
//                      vpUc.getSubvariationT1().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//
//              } else { // business.Global.STYLE_STRUCT_WITH_ACTOR
//
//                vpUc.setSubvariationT2(
//                  persistence.CViewpointUc.getSubvariationT2(vpUc));
//                for (int l=0; l<vpUc.getSubvariationT2().size(); l++) {
//
//                  if (((business.CStepStrT2) vpUc.getSubvariationT2().elementAt(l)).getActor() != null) {
//
//                    sentence =
//                      " The " +
//                      ((business.CStepStrT2)
//                       vpUc.getSubvariationT2().elementAt(l)).getActor().getType()
//                       + " " +
//                      ((business.CStepStrT2)
//                       vpUc.getSubvariationT2().elementAt(l)).getAction();
//
//                  } else if (((business.CStepStrT2) vpUc.getSubvariationT2().elementAt(l)).isSystemStep()) {
//
//                     sentence =
//                       " The " +
//                        business.Global.project.getSystem()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getSubvariationT2().elementAt(l)).getAction();
//
//                   } else {
//
//                     sentence =
//                      ((business.CStepStrT2)
//                       vpUc.getSubvariationT2().elementAt(l)).getAction();
//                   }
//
//                   this.addToFLT(flt, actors, sentence,
//                                        ((business.CStepStrT2)
//                      vpUc.getSubvariationT2().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//              }
//            }
//
//            if (APreCond) {
//                vpUc.setPrecond(
//                  persistence.CViewpointUc.getPrecond(vpUc));
//                for (int l=0; l<vpUc.getPrecond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      vpUc.getPrecond().elementAt(l)).getText();
//                   this.addToFLT(flt, actors, sentence,
//                     String.valueOf(((business.CCondition)
//                      vpUc.getPrecond().elementAt(l)).getNumber()),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//            }
//
//            if (ASuccessEndCond) {
//                vpUc.setSuccessEndcond(
//                  persistence.CViewpointUc.getSuccessEndcond(vpUc));
//                for (int l=0; l<vpUc.getSuccessEndcond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      vpUc.getSuccessEndcond().elementAt(l)).getText();
//                   this.addToFLT(flt, actors, sentence,
//                     String.valueOf(((business.CCondition)
//                      vpUc.getSuccessEndcond().elementAt(l)).getNumber()),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//            }
//
//            if (AFailedEndCond) {
//                vpUc.setFailedEndcond(
//                  persistence.CViewpointUc.getFailedEndcond(vpUc));
//                for (int l=0; l<vpUc.getFailedEndcond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      vpUc.getFailedEndcond().elementAt(l)).getText();
//                   this.addToFLT(flt, actors, sentence,
//                     String.valueOf(((business.CCondition)
//                      vpUc.getFailedEndcond().elementAt(l)).getNumber()),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//            }
//          }
//          flt.writeToFltFile();
//        }
//      }
//    } catch (Exception ex) {
//
//      String error = new String("error message: can't create flt-file \n");
//      error = contr.CError.createErrorMessage(error, ex);
//      contr.CError.showErrorMessage(business.Global.recocase, error);
//      if (business.Global.DEBUG) System.out.println(error);
//    }
//  }

  /**
   *  creates RECOCASE-phrases for sentence
   *  and converts them into FLT-format
   *
   *  @param AFLT Output for FLT-File
   *  @param AActors actors in FLT-format "actor_1-actor_2-...-actor_n'
   *  @param ASentence sentence
   *  @param AStep step of sentence = first column of FLT-file
   *  @param AOwner 'viewpoint agent' = part of the second column of FLT-file
   */
//  private void addToFLT(business.CFLT AFLT,
//                        String AActors,
//                        String ASentence,
//                        String AStep,
//                        String AOwner,
//                        String ANameOfVp) {
//
//    // analyse sentence with RECOCASE-Logic
//    business.CRecocaseLogic.analyseSentence(ASentence, AActors);
//    String resultAnalyse = business.CRecocaseLogic.getPhrases();
//
//    //OSCAR************
//
//    Vector phrasesV = business.CRecocaseLogic.convertToVector(resultAnalyse);
//    String FLTrow = "";
//
//
//    for (int i=0; i<phrasesV.size(); i++) {
//      String attr = (String) phrasesV.elementAt(i);
//      if(attr.equals("keyw")){
//          System.out.println("WARNING: KEYWORDS FOUND HERE: " + attr);
//      }else{
//        if (FLTrow == ""){
//          FLTrow = "(" + attr + ")";
//        }else{
//          FLTrow = FLTrow + ";(" + attr + ")";
//        }
//      }
//    }
//
//    Vector keyWords = business.CRecocaseLogic.getKeyWords();
//    if (keyWords != null) {
//        for (int i=0; i<keyWords.size(); i++) {
//            String key = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) keyWords.elementAt(i)).elementAt(0);
//
//            if (FLTrow == ""){
//              FLTrow = "(" + key + ")";
//            }else{
//              FLTrow = FLTrow + ";(" + key + ")";
//            }
//        }
//    }
//
//    //*************
//
//
//    // transform in flt format
//    //    String row = AStep + "\t" + AOwner + "/" + ANameOfVp + "-%uoi\t" +
//    //      AFLT.createRowFormatForFltFile(resultAnalyse) + "\n";
//
//    String row = AStep + "\t" + AOwner + "/" + ANameOfVp + "-%uoi\t" + FLTrow + "\n";
//
//    if (business.Global.DEBUG)
//      System.out.println("----> contr.CFCA.addToFLT: \n " + row);
//
//    // add sentence to flt
//    AFLT.addRowForFltFile(row);
//  }

  /**
   *  creates a crosstable for 'scenarios' and 'scenario viewpoints'
   *
   * @param AVpV vector of 'scenarios'  and 'scenario viewpoints'
   */
//  public void createCrosstableForSc(Vector AVpV) {
//   gui.CCrosstable crosstableF = new gui.CCrosstable(
//               createBusinessCrosstableForSc(AVpV) );
//  }







//  public void createLatticeForSc(Vector AViewpointV) {
      //toms.CDiagram latticeD = new toms.CDiagram(true);
      //latticeD.LoadCrossTable( createBusinessCrosstableForSc(AVpV) );
      //business.fca.SimpleTable table =   createTableForSc(AGroupId,AViewpointV);
//      business.fca.SimpleTable table =   createTableForSc("",AViewpointV);
//      toms.CDiagram latticeD = new toms.CDiagram(true);
//      latticeD.show_frame();
//      latticeD.createFCA(table);
//
//
//  }



//  public business.CCrosstable createBusinessCrosstableForSc(Vector AVpV) {
//    business.CCrosstable crosstable = new business.CCrosstable();
//
//    try {
//      if (AVpV != null) {
//
//        for (int k=0; k<AVpV.size(); k++) {
//          String sentence = null;
//          Object obj = (Object) AVpV.elementAt(k);
//          if (obj.getClass().isInstance(new business.CScenario())) {
//            // shared scenario
//
//            business.CScenario sc = (business.CScenario) obj;
//            sc.setAgents(persistence.CActor.getAllAgentOfScenario(sc.getId()));
//            String agents = business.CRecocaseLogic.getAgentS(sc.getAgents());
//            sc.setScenarioT1(
//               persistence.CScenario.getScenarioT1(sc));
//            for (int l=0; l<sc.getScenarioT1().size(); l++) {
//               sentence =
//               ((business.CStepStrT1)
//               sc.getScenarioT1().elementAt(l)).getAction();
//               crosstable.addToCrosstable(
//                  agents, sentence,
//                  ((business.CStepStrT1) sc.getScenarioT1().elementAt(l)).getStep(),
//                  new String("S"),
//                  sc.getName());
//            }
//
//          } else {
//            // scenario viewpoint
//            business.CViewpointSc vpSc = (business.CViewpointSc) obj;
//            vpSc.setAgents(persistence.CActor.getAllAgentOfViewpointScenario(vpSc.getId()));
//            String agents = business.CRecocaseLogic.getAgentS(vpSc.getAgents());
//
//            if (vpSc.getStyle() == business.Global.STYLE_UNSTRUCT) {
//              // ... processing of unstructured text
//
//            } else if (vpSc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//                vpSc.setStepStrT1(
//                  persistence.CViewpointSc.getStepStrT1(vpSc));
//                for (int l=0; l<vpSc.getStepStrT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      vpSc.getStepStrT1().elementAt(l)).getAction();
//                   crosstable.addToCrosstable(
//                     agents, sentence,
//                     ((business.CStepStrT1) vpSc.getStepStrT1().elementAt(l)).getStep(),
//                      vpSc.getOwner().getName(),
//                      vpSc.getName());
//                }
//
//            } else { // business.Global.STYLE_STRUCT_WITH_ACTOR
//                vpSc.setStepStrT2(
//                  persistence.CViewpointSc.getStepStrT2(vpSc));
//                for (int l=0; l<vpSc.getStepStrT2().size(); l++) {
//
//                if (((business.CStepStrT2) vpSc.getStepStrT2().elementAt(l)).getAgent() != null) {
//                   sentence =
//                     " The " +
//                     ((business.CStepStrT2)
//                      vpSc.getStepStrT2().elementAt(l)).getAgent().getName()
//                      + " " +
//                     ((business.CStepStrT2)
//                      vpSc.getStepStrT2().elementAt(l)).getAction();
//
//                 } else if (((business.CStepStrT2) vpSc.getStepStrT2().elementAt(l)).isSystemStep()) {
//
//                   sentence =
//                     " The " +
//                     business.Global.project.getSystem()
//                      + " " +
//                     ((business.CStepStrT2)
//                      vpSc.getStepStrT2().elementAt(l)).getAction();
//                 } else {
//
//                   sentence =
//                     ((business.CStepStrT2)
//                      vpSc.getStepStrT2().elementAt(l)).getAction();
//                 }
//
//                 crosstable.addToCrosstable(
//                     agents, sentence,
//                     ((business.CStepStrT2) vpSc.getStepStrT2().elementAt(l)).getStep(),
//                      vpSc.getOwner().getName(),
//                      vpSc.getName());
//               }
//            }
//          }
//        }
//      }
//    } catch (Exception ex) {
//
//      String error = new String("error message: can't create crosstable \n");
//      error = contr.CError.createErrorMessage(error, ex);
//      contr.CError.showErrorMessage(business.Global.recocase, error);
//      if (business.Global.DEBUG) System.out.println(error);
//    }
//
//      //gui.CCrosstable crosstableF = new gui.CCrosstable(crosstable);
//      return crosstable;
//  }

  /**
   *  creates a crosstable for 'use cases' and 'use case viewpoints'
   *
   * @param AVpV vector of 'use cases' and 'use case viewpoints'
   * @param APreCond flag if conversion of preconditions
   * @param ASuccessEndCond flag if conversion of success endconditions
   * @param AFailedEndCond flag if conversion of failed endcondition
   * @param ASuccessScenario flag if conversion of success scenario
   * @param AExtension flag if conversion of extensions
   * @param AVariation flag if conversion of variations
   */

//   public void createCrosstableForUc(Vector AVpV,
//                         boolean APreCond,
//                         boolean ASuccessEndCond,
//                         boolean AFailedEndCond,
//                         boolean ASuccessScenario,
//                         boolean AExtension,
//                         boolean AVariation) {
//
//      gui.CCrosstable crosstableF = new gui.CCrosstable(
//             createBusinessCrosstableForUc(AVpV,
//                APreCond,
//                ASuccessEndCond,
//                AFailedEndCond,
//                ASuccessScenario,
//                AExtension,
//                AVariation) );
//
//    }




//  public  business.CCrosstable createBusinessCrosstableForUc(Vector AVpV,
//                         boolean APreCond,
//                         boolean ASuccessEndCond,
//                         boolean AFailedEndCond,
//                         boolean ASuccessScenario,
//                         boolean AExtension,
//                         boolean AVariation) {
//
//    business.CCrosstable crosstable = new business.CCrosstable();
//
//    try {
//      if (AVpV != null) {
//
//        for (int k=0; k<AVpV.size(); k++) {
//
//          String sentence = null;
//          Object obj = (Object) AVpV.elementAt(k);
//          if (obj.getClass().isInstance(new business.CUsecase())) {
//            // shared Use case
//
//            business.CUsecase uc = (business.CUsecase) obj;
//            uc.setActors(persistence.CActor.getAllActorOfUsecase(uc.getId()));
//
//            String actors = business.CRecocaseLogic.getActorS(uc.getActors());
//            actors += business.Global.project.getSystem();
//
//            if (ASuccessScenario) {
//
//                uc.setSuccessScenarioT1(
//                  persistence.CUsecase.getSuccessScenarioT1(uc));
//                for (int l=0; l<uc.getSuccessScenarioT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      uc.getSuccessScenarioT1().elementAt(l)).getAction();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     ((business.CStepStrT1) uc.getSuccessScenarioT1().elementAt(l)).getStep(),
//                      new String("S"),
//                      uc.getName());
//                }
//            }
//
//            if (AExtension) {
//
//                uc.setExtensionT1(
//                  persistence.CUsecase.getExtensionT1(uc));
//                for (int l=0; l<uc.getExtensionT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      uc.getExtensionT1().elementAt(l)).getAction();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     ((business.CStepStrT1) uc.getExtensionT1().elementAt(l)).getStep(),
//                      new String("S"),
//                      uc.getName());
//                }
//
//            }
//
//            if (AVariation) {
//
//                uc.setSubvariationT1(
//                  persistence.CUsecase.getSubvariationT1(uc));
//                for (int l=0; l<uc.getSubvariationT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      uc.getSubvariationT1().elementAt(l)).getAction();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     ((business.CStepStrT1) uc.getSubvariationT1().elementAt(l)).getStep(),
//                      new String("S"),
//                      uc.getName());
//                }
//
//            }
//
//            if (APreCond) {
//                uc.setPrecond(
//                  persistence.CUsecase.getPrecond(uc));
//                for (int l=0; l<uc.getPrecond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      uc.getPrecond().elementAt(l)).getText();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     String.valueOf(((business.CCondition)
//                       uc.getPrecond().elementAt(l)).getNumber()),
//                     new String("S"),
//                     uc.getName());
//                }
//
//            }
//
//            if (ASuccessEndCond) {
//                uc.setSuccessEndcond(
//                  persistence.CUsecase.getSuccessEndcond(uc));
//                for (int l=0; l<uc.getSuccessEndcond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      uc.getSuccessEndcond().elementAt(l)).getText();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     String.valueOf(((business.CCondition)
//                       uc.getSuccessEndcond().elementAt(l)).getNumber()),
//                     new String("S"),
//                     uc.getName());
//                }
//            }
//
//            if (AFailedEndCond) {
//                uc.setFailedEndcond(
//                  persistence.CUsecase.getFailedEndcond(uc));
//                for (int l=0; l<uc.getFailedEndcond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      uc.getFailedEndcond().elementAt(l)).getText();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     String.valueOf(((business.CCondition)
//                       uc.getFailedEndcond().elementAt(l)).getNumber()),
//                     new String("S"),
//                     uc.getName());
//                }
//
//            }
//
//          } else if (obj.getClass().isInstance(new business.CViewpointUc())) {
//            // use case viewpoint
//            business.CViewpointUc vpUc = (business.CViewpointUc) obj;
//            vpUc.setActors(persistence.CActor.getAllActorOfViewpointUc(vpUc.getId()));
//            String actors = business.CRecocaseLogic.getActorS(vpUc.getActors());
//            actors += business.Global.project.getSystem();
//
//            if (ASuccessScenario) {
//
//              if (vpUc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//                vpUc.setSuccessScenarioT1(
//                  persistence.CViewpointUc.getSuccessScenarioT1(vpUc));
//                for (int l=0; l<vpUc.getSuccessScenarioT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      vpUc.getSuccessScenarioT1().elementAt(l)).getAction();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     ((business.CStepStrT1) vpUc.getSuccessScenarioT1().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//
//              } else { // business.Global.STYLE_STRUCT_WITH_ACTOR
//                vpUc.setSuccessScenarioT2(
//                  persistence.CViewpointUc.getSuccessScenarioT2(vpUc));
//                for (int l=0; l<vpUc.getSuccessScenarioT2().size(); l++) {
//
//                  if (((business.CStepStrT2) vpUc.getSuccessScenarioT2().elementAt(l)).getActor() != null) {
//
//                     sentence =
//                       " The " +
//                       ((business.CStepStrT2)
//                        vpUc.getSuccessScenarioT2().elementAt(l)).getActor().getType()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getSuccessScenarioT2().elementAt(l)).getAction();
//
//                  } else if (((business.CStepStrT2) vpUc.getSuccessScenarioT2().elementAt(l)).isSystemStep()) {
//
//                     sentence =
//                       " The " +
//                        business.Global.project.getSystem()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getSuccessScenarioT2().elementAt(l)).getAction();
//
//                  } else {
//
//                     sentence =
//                       ((business.CStepStrT2)
//                        vpUc.getSuccessScenarioT2().elementAt(l)).getAction();
//                  }
//
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     ((business.CStepStrT2) vpUc.getSuccessScenarioT2().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//              }
//
//            }
//
//            if (AExtension) {
//
//              if (vpUc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//                vpUc.setExtensionT1(
//                  persistence.CViewpointUc.getExtensionT1(vpUc));
//                for (int l=0; l<vpUc.getExtensionT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      vpUc.getExtensionT1().elementAt(l)).getAction();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     ((business.CStepStrT1) vpUc.getExtensionT1().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//              } else { // business.Global.STYLE_STRUCT_WITH_ACTOR
//                vpUc.setExtensionT2(
//                  persistence.CViewpointUc.getExtensionT2(vpUc));
//
//                for (int l=0; l<vpUc.getExtensionT2().size(); l++) {
//
//                  if (((business.CStepStrT2) vpUc.getExtensionT2().elementAt(l)).getActor() != null) {
//
//                     sentence =
//                       " The " +
//                       ((business.CStepStrT2)
//                        vpUc.getExtensionT2().elementAt(l)).getActor().getType()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getExtensionT2().elementAt(l)).getAction();
//
//                  } else if (((business.CStepStrT2) vpUc.getExtensionT2().elementAt(l)).isSystemStep()) {
//
//                     sentence =
//                       " The " +
//                        business.Global.project.getSystem()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getExtensionT2().elementAt(l)).getAction();
//
//                  } else {
//
//                     sentence =
//                       ((business.CStepStrT2)
//                        vpUc.getExtensionT2().elementAt(l)).getAction();
//
//                   }
//
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     ((business.CStepStrT2) vpUc.getExtensionT2().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//              }
//            }
//
//            if (AVariation) {
//
//              if (vpUc.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//                vpUc.setSubvariationT1(
//                  persistence.CViewpointUc.getSubvariationT1(vpUc));
//                for (int l=0; l<vpUc.getSubvariationT1().size(); l++) {
//                   sentence =
//                     ((business.CStepStrT1)
//                      vpUc.getSubvariationT1().elementAt(l)).getAction();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     ((business.CStepStrT1) vpUc.getSubvariationT1().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//
//              } else { // business.Global.STYLE_STRUCT_WITH_ACTOR
//
//                vpUc.setSubvariationT2(
//                  persistence.CViewpointUc.getSubvariationT2(vpUc));
//                for (int l=0; l<vpUc.getSubvariationT2().size(); l++) {
//
//                  if (((business.CStepStrT2) vpUc.getSubvariationT2().elementAt(l)).getActor() != null) {
//
//                    sentence =
//                      " The " +
//                      ((business.CStepStrT2)
//                       vpUc.getSubvariationT2().elementAt(l)).getActor().getType()
//                       + " " +
//                      ((business.CStepStrT2)
//                       vpUc.getSubvariationT2().elementAt(l)).getAction();
//
//                  } else if (((business.CStepStrT2) vpUc.getSubvariationT2().elementAt(l)).isSystemStep()) {
//
//                     sentence =
//                       " The " +
//                        business.Global.project.getSystem()
//                        + " " +
//                       ((business.CStepStrT2)
//                        vpUc.getSubvariationT2().elementAt(l)).getAction();
//
//                   } else {
//
//                     sentence =
//                      ((business.CStepStrT2)
//                       vpUc.getSubvariationT2().elementAt(l)).getAction();
//                   }
//
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     ((business.CStepStrT2) vpUc.getSubvariationT2().elementAt(l)).getStep(),
//                      vpUc.getOwner().getName(),
//                      vpUc.getName());
//                }
//              }
//            }
//
//            if (APreCond) {
//                vpUc.setPrecond(
//                  persistence.CViewpointUc.getPrecond(vpUc));
//                for (int l=0; l<vpUc.getPrecond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      vpUc.getPrecond().elementAt(l)).getText();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     String.valueOf(((business.CCondition)
//                       vpUc.getPrecond().elementAt(l)).getNumber()),
//                     vpUc.getOwner().getName(),
//                     vpUc.getName());
//                }
//            }
//
//            if (ASuccessEndCond) {
//                vpUc.setSuccessEndcond(
//                  persistence.CViewpointUc.getSuccessEndcond(vpUc));
//                for (int l=0; l<vpUc.getSuccessEndcond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      vpUc.getSuccessEndcond().elementAt(l)).getText();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     String.valueOf(((business.CCondition)
//                       vpUc.getSuccessEndcond().elementAt(l)).getNumber()),
//                     vpUc.getOwner().getName(),
//                     vpUc.getName());
//                }
//            }
//
//            if (AFailedEndCond) {
//                vpUc.setFailedEndcond(
//                  persistence.CViewpointUc.getFailedEndcond(vpUc));
//                for (int l=0; l<vpUc.getFailedEndcond().size(); l++) {
//
//                   sentence =
//                     ((business.CCondition)
//                      vpUc.getFailedEndcond().elementAt(l)).getText();
//                   crosstable.addToCrosstable(
//                     actors, sentence,
//                     String.valueOf(((business.CCondition)
//                       vpUc.getFailedEndcond().elementAt(l)).getNumber()),
//                     vpUc.getOwner().getName(),
//                     vpUc.getName());
//                }
//            }
//          }
//        }
//      }
//    } catch (Exception ex) {
//
//      String error = new String("error message: can't create crosstable \n");
//      error = contr.CError.createErrorMessage(error, ex);
//      contr.CError.showErrorMessage(business.Global.recocase, error);
//      if (business.Global.DEBUG) System.out.println(error);
//    }
//return crosstable;
//  //    gui.CCrosstable crosstableF = new gui.CCrosstable(crosstable);
//  }


//  public business.CCrosstable openFLTFile(){
//
//        final JFileChooser fc = new JFileChooser();
//        //        fc.setToolTipText("choose flt-file");
//        fc.addChoosableFileFilter(new javax.swing.filechooser.FileFilter() {
//          public boolean accept(File f) {
//            String name = f.getName();
//            if (f.isDirectory()) return true;
//            if (name.regionMatches(true,name.length()-4,".flt",0,4)) return true;
//            return false;
//          }
//          public String getDescription() {
//            return "*.flt";
//          }
//        });
//
//        //        int returnVal = fc.showOpenDialog(this);
//        int returnVal = fc.showOpenDialog(null);
//        String fileName ;
//        if (returnVal == JFileChooser.APPROVE_OPTION) {
//            fileName = fc.getSelectedFile().getAbsolutePath() ;
//        //            System.out.println("OPENING:"+fc.getSelectedFile().getAbsolutePath()  );
//        } else {
//           //          fileName = "/home/comptest.flt";
//            fileName = "results/data.flt";
//        }
//        return openFLTFile(fileName);
//  }

  public Vector FLTcomments()
  {
      return this.FLTcommentsV;
  }

//  public business.CCrosstable openFLTFile(String fileName){
//      this.FLTcommentsV = new Vector();
//      try
//      {
//        boolean error = false;
//
//        FileReader file = new FileReader(fileName);
//        BufferedReader buff = new BufferedReader(file);
//        business.CCrosstable temp_crosstable= new business.CCrosstable();
//
//        boolean eof = false;
//        while (!eof){
//          String row = null;
//
//          row = buff.readLine();
//
//          if (row == null){ eof = true;
//          }else{
//
//            int size = row.length();
//            char[] data = new char[size] ;
//            row.getChars(0, size , data ,0);
//            if (size != 0 ) if(data[0] == '%'){
//               this.FLTcommentsV.add(row);
//               size = 0;
//            }
//            if (size > 0){
//
//                String AStep = "";
//                String ANameOfVp = "";
//                String AOwner = "";
//                String Data = "";
//                Vector rowAttr = new Vector();
//                int FSlashCounter = 0;
//                int tabCounter=0;
//                char prevChar = ' ';
//                boolean stop = false;
//
//
//
//                for(int i = 0 ; i < size ; i ++){
//
//                  if (data[i] == '\t'){
//                    tabCounter++;
//                  }
//                  if (tabCounter == 0  && data[i] != '\t')
//                  {
//                    AStep = AStep + data[i];
//                  }
//                  if (tabCounter == 1  && data[i] != '\t')
//                  {
//                    if (data[i] == '/'){
//                      FSlashCounter ++;
//                    }
//                    if (FSlashCounter == 0){
//                      AOwner = AOwner + data[i];
//                    }else if(FSlashCounter == 1){
//                      if (prevChar == '-' && data[i] == '%') {
//                       stop = true;
//                      }
//                      if (data[i] != '/' && data[i] != '-' && stop == false) ANameOfVp = ANameOfVp + data[i];
//                      prevChar = data[i] ;
//                    }else{
//                      System.out.println("ERROR in FLT file");
//                      error = true;
//                    }
//                  }
//                  if (tabCounter == 2  && data[i] != '\t')
//                  {
//                    if (data[i] == ')'){
//                      temp_crosstable.addAttribute(Data);
//                      rowAttr.add(Data);
//                      Data = "";
//                    }else{
//                      if (data[i] != '(' && data[i] != ';'){
//                          Data = Data + data[i];
//                      }
//                    }
//                  }//if tab = 2
//
//                }//for
//                if(tabCounter != 2)error = true;
//                //System.out.println( ANameOfVp + "*" + AOwner + "*" + AStep );
//
//
//
//                business.CRowOfCrosstable temp_row = new business.CRowOfCrosstable(ANameOfVp , AOwner , AStep );
//                for(int i = 0 ; i < rowAttr.size()  ; i ++){
//                temp_row.addAttribute((String) rowAttr.elementAt(i));
//                }
//                temp_crosstable.addRow(temp_row);
//            }//row.zize > 0
//          }//if not eof
//        }//while
//        buff.close();
//        file.close();
//        if(error){
//          JOptionPane.showMessageDialog(null,"ERROR OPENING FILE");
//          return null;
//        }else{
//            //gui.CCrosstable gui_crosstable = new gui.CCrosstable(temp_crosstable);
//            return temp_crosstable;
//        }
//      }
//      catch (Exception ex)
//      {
//	System.out.println("***  ERROR: Error trying to open file  " + fileName);
//        JOptionPane.showMessageDialog(null,"ERROR OPENING FILE");
//        return null;
//      }
//  }


//public business.fca.ContextTable convertTable(business.CCrosstable crosstable)
//    {
      // onFileNew();
      // this.graph = new ExDigraph();
      //      System.out.println("public business.fca.ContextTable convertTable(business.CCrosstable crosstable) ");




//  int num_objects = crosstable.getRows().size() + 1;//add objects (all)
//  int num_attributes= crosstable.getAttributes().size();
//
//  business.fca.ContextTable a_table = new business.fca.ContextTable(num_objects,num_attributes);
//  Vector columnNamesCt = new Vector();
//  for (int i=1; i<=crosstable.getAttributes().size(); i++)
//    columnNamesCt.add(String.valueOf(i));
//    columnNamesCt.insertElementAt(new String(""), 0);
//    for (int i=0; i<crosstable.getRows().size(); i++) {
//      business.CRowOfCrosstable row =
//        (business.CRowOfCrosstable)
//        crosstable.getRows().elementAt(i);
//      for (int j=1; j<columnNamesCt.size(); j++) {
//        if (row.getAttributes().contains(
//            (String) crosstable.getAttributes().elementAt(j-1))) {
//            a_table.set_box(i+1,j);
//        }
//      }
//    }
//
//    //the last object (all) has to have all the atributes
//    for (int i=1; i<=num_attributes; i++){
//           a_table.set_box(num_objects,i);
//    }
//
//    a_table.set_obj_complete_name(num_objects,"All");
//    a_table.set_obj_complete_name(num_objects-1,"Empty");
//
//    for (int i=0; i<crosstable.getAttributes().size(); i++) {
//      //      System.out.println( (String) crosstable.getAttributes().elementAt(i));
//      a_table.set_attr_name(i+1,(String) crosstable.getAttributes().elementAt(i));
//    }
//
//    for (int i=0; i<crosstable.getRows().size(); i++) {
//        //      System.out.println( (String) ((business.CCrosstable.CRowOfCrosstable)  crosstable.getRows().elementAt(i)).getNameOfRow() );
//        a_table.set_obj_complete_name(i+1,(String)((business.CRowOfCrosstable) crosstable.getRows().elementAt(i)).getNameOfRow() );
//    }
//    //a_table.print_table();
//
//
//business.fca.ContextTable a_table = new business.fca.ContextTable(num_objects,num_attributes);
//return a_table;
//
//  }


//     public void createLatticeForUcOLD(Vector AVpV,
//                         boolean APreCond,
//                         boolean ASuccessEndCond,
//                         boolean AFailedEndCond,
//                         boolean ASuccessScenario,
//                         boolean AExtension,
//                         boolean AVariation) {
//
//      toms.CDiagram latticeD = new toms.CDiagram(true);
//
//      latticeD.LoadCrossTable(
//             createBusinessCrosstableForUc(AVpV,
//                APreCond,
//                ASuccessEndCond,
//                AFailedEndCond,
//                ASuccessScenario,
//                AExtension,
//                AVariation) );
//
//    }


    /**
     *
     *
     */

//     public void createLatticeForUc(
//                        Vector AViewpointV,
//                        boolean APreCond,
//                        boolean ASuccessEndCond,
//                        boolean AFailedEndCond,
//                        boolean ASuccessScenario,
//                        boolean AExtension,
//                        boolean AVariation) {
//        createLatticeForUc("",AViewpointV,APreCond,ASuccessEndCond,AFailedEndCond,ASuccessScenario,AExtension,AVariation);
//    }

//     public void createLatticeForUc(
//                        String AGroupId,
//                        Vector AViewpointV,
//                        boolean APreCond,
//                        boolean ASuccessEndCond,
//                        boolean AFailedEndCond,
//                        boolean ASuccessScenario,
//                        boolean AExtension,
//                        boolean AVariation) {
//
//        business.fca.SimpleTable table =   createTableForUc(AGroupId,AViewpointV,APreCond,ASuccessEndCond,AFailedEndCond,ASuccessScenario,AExtension,AVariation);
//        toms.CDiagram latticeD = new toms.CDiagram(true);
//        latticeD.show_frame();
//        latticeD.createFCA(table);
//     }

    public void createLatticeUCSC(
                        Vector AViewpointV,
                        boolean APreCond,
                        boolean ASuccessEndCond,
                        boolean AFailedEndCond,
                        boolean ASuccessScenario,
                        boolean AExtension,
                        boolean AVariation)
    {
       createLatticeUCSC("",AViewpointV,APreCond,ASuccessEndCond,AFailedEndCond,ASuccessScenario,AExtension,AVariation);
    }

     public void createLatticeUCSC(
                        String AGroupId,
                        Vector AViewpointV,
                        boolean APreCond,
                        boolean ASuccessEndCond,
                        boolean AFailedEndCond,
                        boolean ASuccessScenario,
                        boolean AExtension,
                        boolean AVariation) {

        business.fca.SimpleTable table = createTableForUCSC(AGroupId,AViewpointV,APreCond,ASuccessEndCond,AFailedEndCond,ASuccessScenario,AExtension,AVariation);
        diagram.DDiagram latticeD = new diagram.DDiagram();//toms.CDiagram(true);
        latticeD.show();
        latticeD.createFCA(table);
     }








/**
 *
 */
    public void createResolutionTableUCSC(
                        String name,
                        String AGroupId,
                        Vector AViewpointV,
                        boolean APreCond,
                        boolean ASuccessEndCond,
                        boolean AFailedEndCond,
                        boolean ASuccessScenario,
                        boolean AExtension,
                        boolean AVariation)
    {

     business.fca.SimpleTable table = createTableForUCSC(AGroupId,AViewpointV,APreCond,ASuccessEndCond,
                                     AFailedEndCond,ASuccessScenario,AExtension,AVariation);

      diagram.DResolutionTable rt = new diagram.DResolutionTable(name,table);
      //rt.setName(name);

    }



/**
 *
 */
    public void createResolutionTableForUc(
                        String name,
                        String AGroupId,
                        Vector AViewpointV,
                        boolean APreCond,
                        boolean ASuccessEndCond,
                        boolean AFailedEndCond,
                        boolean ASuccessScenario,
                        boolean AExtension,
                        boolean AVariation)
    {
      business.fca.SimpleTable table =   createTableForUc(AGroupId,AViewpointV,APreCond,ASuccessEndCond,AFailedEndCond,ASuccessScenario,AExtension,AVariation);
      diagram.DResolutionTable rt = new diagram.DResolutionTable(name,table);
      //rt.setName(name);
    }
/**
 *
 */
    public void createResolutionTableForSc(
                            String name,
                            String AGroupId,
                            Vector AViewpointV){
      business.fca.SimpleTable table =   createTableForSc(AGroupId,AViewpointV);
      diagram.DResolutionTable rt = new diagram.DResolutionTable(name,table);
      //rt.setName(name);
    }


/**
 *
 */
     public business.fca.SimpleTable createTableForUc(
                        String AGroupId,
                        Vector AViewpointV,
                        boolean APreCond,
                        boolean ASuccessEndCond,
                        boolean AFailedEndCond,
                        boolean ASuccessScenario,
                        boolean AExtension,
                        boolean AVariation) {

       business.fca.SimpleTable ASimpleTable = new business.fca.SimpleTable(AGroupId);
       return addToTableUc(ASimpleTable,AViewpointV,APreCond,ASuccessEndCond,AFailedEndCond, ASuccessScenario,AExtension,AVariation);

     }







  public business.fca.SimpleTable createTableForUCSC(
                        String AGroupId,
                        Vector AViewpointV,
                        boolean APreCond,
                        boolean ASuccessEndCond,
                        boolean AFailedEndCond,
                        boolean ASuccessScenario,
                        boolean AExtension,
                        boolean AVariation){

      Vector viewpointUC = new Vector();
      Vector viewpointSC = new Vector();
      business.CUsecase UC =  null;
      for(int i = 0; i<AViewpointV.size();i++){
        if( AViewpointV.elementAt(i).getClass().isInstance(new business.CUsecase() )){
          UC = ((business.CUsecase) AViewpointV.elementAt(i));
          System.out.println( UC.toString());
          viewpointUC.add(AViewpointV.elementAt(i));
        }else{
          if(((business.CViewpoint)AViewpointV.elementAt(i)).getType().equals(business.Global.TYPE_VP_USECASE)){
            viewpointUC.add(AViewpointV.elementAt(i));
          }else if(((business.CViewpoint)AViewpointV.elementAt(i)).getType().equals(business.Global.TYPE_VP_SCENARIO)){
            viewpointSC.add(AViewpointV.elementAt(i));
          }
        }

      }
      business.fca.SimpleTable ASimpleTable = new business.fca.SimpleTable(AGroupId);
      ASimpleTable = addToTableUc(ASimpleTable,viewpointUC,APreCond,ASuccessEndCond,AFailedEndCond, ASuccessScenario,AExtension,AVariation);
      ASimpleTable = addToTableSc(ASimpleTable,viewpointSC);
      return ASimpleTable;
    }





  public business.fca.SimpleTable createTableForSc(String AGroupId,Vector AViewpointV)
  {
      business.fca.SimpleTable ASimpleTable = new business.fca.SimpleTable(AGroupId);
      return   addToTableSc(ASimpleTable, AViewpointV);
  }



  private business.fca.SimpleTable addToTableSc(business.fca.SimpleTable ASimpleTable, Vector AViewpointV)
  {
    for(int i = 0 ; i < AViewpointV.size() ; i++){
        if (AViewpointV.elementAt(i).getClass().isInstance(new business.CUsecase())) {
        }else{
          business.CViewpointSc viewpoint = (business.CViewpointSc) AViewpointV.elementAt(i);
          String ownerName = viewpoint.getUser().getName();

          Vector tempV;

            if (viewpoint.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
              tempV =  persistence.CViewpointSc.getStepStrT1(viewpoint);

            }else if (viewpoint.getStyle() == business.Global.STYLE_STRUCT_WITH_ACTOR) {
              tempV =  persistence.CViewpointSc.getStepStrT2(viewpoint);
            }else{
              tempV = new Vector();
              JOptionPane.showMessageDialog(null ,"viewpoint:"+viewpoint.getName()+"\n can not be included in the lattice");
            }
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CStep) tempV.elementAt(x)).getPhrases() ;
                String name = ((business.CStep) tempV.elementAt(x)).getSentence()+"/"+ownerName+"/"+((business.CStep) tempV.elementAt(x)).getStep();
  //              if(extrans != null && extrans != "")
                ASimpleTable.addRow(
                ((business.CStep) tempV.elementAt(x)).getSentence(),
                ownerName,
                ((business.CStep) tempV.elementAt(x)).getStep()+"",
                viewpoint.getName(),
                business.CRecocaseLogic.convertToVector( extrans));
            }
        }
    }


//      System.out.println("**---------------------------------------**");
//      ASimpleTable.printTable();
        return ASimpleTable;
    }


     private business.fca.SimpleTable addToTableUc(
                        business.fca.SimpleTable ASimpleTable,
                        Vector AViewpointV,
                        boolean APreCond,
                        boolean ASuccessEndCond,
                        boolean AFailedEndCond,
                        boolean ASuccessScenario,
                        boolean AExtension,
                        boolean AVariation)
    {
      //ASimpleTable.setGroupId(AGroupId); done when created
      for(int i = 0 ; i < AViewpointV.size() ; i++){
        if (AViewpointV.elementAt(i).getClass().isInstance(new business.CUsecase())) {
          business.CUsecase uc = (business.CUsecase) AViewpointV.elementAt(i);
          this.addToTableUsecase(ASimpleTable,uc,APreCond,ASuccessEndCond,AFailedEndCond,ASuccessScenario,AExtension,AVariation);
        }else if (AViewpointV.elementAt(i).getClass().isInstance(new business.CViewpointUc())) {
          business.CViewpointUc viewpoint = (business.CViewpointUc) AViewpointV.elementAt(i);
          String ownerName = viewpoint.getUser().getName();

          Vector tempV;
          if(APreCond){
            tempV =  persistence.CViewpointUc.getPrecond(viewpoint);
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CCondition) tempV.elementAt(x)).getPhrases() ;

  //              if(extrans != null && extrans != "")
                ASimpleTable.addRow(
                    ((business.CCondition) tempV.elementAt(x)).getText(),
                    ownerName,
                    ((business.CCondition) tempV.elementAt(x)).getId()+"" ,
                    viewpoint.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }
          }

          if(ASuccessEndCond){
            tempV =  persistence.CViewpointUc.getSuccessEndcond(viewpoint);
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CCondition) tempV.elementAt(x)).getPhrases() ;
  //              if(extrans != null && extrans != "")
                ASimpleTable.addRow(
                    ((business.CCondition) tempV.elementAt(x)).getText(),
                    ownerName,
                    ((business.CCondition) tempV.elementAt(x)).getId()+"",
                    viewpoint.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }
          }

          if(AFailedEndCond){
            tempV =  persistence.CViewpointUc.getFailedEndcond(viewpoint);
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CCondition) tempV.elementAt(x)).getPhrases() ;
                ASimpleTable.addRow(
                    ((business.CCondition) tempV.elementAt(x)).getText(),
                    ownerName,
                    ((business.CCondition) tempV.elementAt(x)).getId()+"",
                    viewpoint.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );            }
          }



          if(ASuccessScenario){
            if (viewpoint.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
              tempV =  persistence.CViewpointUc.getSuccessScenarioT1(viewpoint);
            }else{
              tempV =  persistence.CViewpointUc.getSuccessScenarioT2(viewpoint);
            }
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CStep) tempV.elementAt(x)).getPhrases() ;
                ASimpleTable.addRow(
                    ((business.CStep) tempV.elementAt(x)).getAction(),
                    ownerName,
                    ((business.CStep) tempV.elementAt(x)).getStep()+"",
                    viewpoint.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }
          }

          if(AExtension){
            if (viewpoint.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
            tempV =  persistence.CViewpointUc.getExtensionT1(viewpoint);
            }else{
            tempV =  persistence.CViewpointUc.getExtensionT2(viewpoint);
            }

            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CStep) tempV.elementAt(x)).getPhrases() ;
                ASimpleTable.addRow(
                    ((business.CStep) tempV.elementAt(x)).getAction(),
                    ownerName,
                    ((business.CStep) tempV.elementAt(x)).getStep()+"",
                    viewpoint.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }
          }

          if(AVariation) {
            if (viewpoint.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
            tempV =  persistence.CViewpointUc.getSubvariationT1(viewpoint);
            }else{
            tempV =  persistence.CViewpointUc.getSubvariationT2(viewpoint);
            }
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CStep) tempV.elementAt(x)).getPhrases() ;
                ASimpleTable.addRow(
                    ((business.CStep) tempV.elementAt(x)).getAction(),
                    ownerName,
                    ((business.CStep) tempV.elementAt(x)).getStep()+"",
                    viewpoint.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }
          }
        }else{
          System.out.println("ERROR at     contr.CFCA.addToTableUc");
        }

      }
//      System.out.println("**---------------------------------------**");
//      ASimpleTable.printTable();
        return ASimpleTable;
//        new toms.ResolutionTable(ASimpleTable);
//        lattice
    }








         private business.fca.SimpleTable addToTableUsecase(
                        business.fca.SimpleTable ASimpleTable,
                        business.CUsecase usecase,
                        boolean APreCond,
                        boolean ASuccessEndCond,
                        boolean AFailedEndCond,
                        boolean ASuccessScenario,
                        boolean AExtension,
                        boolean AVariation)
    {
      //ASimpleTable.setGroupId(AGroupId); done when created
          Vector tempV;// = new Vector();
          String ownerName = "Use Case";
          if(APreCond){
            tempV =  persistence.CUsecase.getPrecond(usecase);
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CCondition) tempV.elementAt(x)).getPhrases() ;
  //              if(extrans != null && extrans != "")
                ASimpleTable.addRow(
                    ((business.CCondition) tempV.elementAt(x)).getText(),
                    ownerName,
                    ((business.CCondition) tempV.elementAt(x)).getId()+"" ,
                    usecase.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }
          }
          if(ASuccessEndCond){
            tempV =  persistence.CUsecase.getSuccessEndcond(usecase);
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CCondition) tempV.elementAt(x)).getPhrases() ;
  //              if(extrans != null && extrans != "")
                ASimpleTable.addRow(
                    ((business.CCondition) tempV.elementAt(x)).getText(),
                    ownerName,
                    ((business.CCondition) tempV.elementAt(x)).getId()+"",
                    usecase.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }
          }

          if(AFailedEndCond){
            tempV =  persistence.CUsecase.getFailedEndcond(usecase);
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CCondition) tempV.elementAt(x)).getPhrases() ;
                ASimpleTable.addRow(
                    ((business.CCondition) tempV.elementAt(x)).getText(),
                    ownerName,
                    ((business.CCondition) tempV.elementAt(x)).getId()+"",
                    usecase.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );            }
          }



          if(ASuccessScenario){
            //if (usecase.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
              tempV =  persistence.CUsecase.getSuccessScenarioT1(usecase);
            //}else{
            //  tempV =  persistence.CUsecase.getSuccessScenarioT2(usecase);
            //}
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CStep) tempV.elementAt(x)).getPhrases() ;
                ASimpleTable.addRow(
                    ((business.CStep) tempV.elementAt(x)).getAction(),
                    ownerName,
                    ((business.CStep) tempV.elementAt(x)).getStep()+"",
                    usecase.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }
          }

          if(AExtension){
            //if (usecase.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
              tempV =  persistence.CUsecase.getExtensionT1(usecase);
            //}else{
            //  tempV =  persistence.CUsecase.getExtensionT2(usecase);
            //}

            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CStep) tempV.elementAt(x)).getPhrases() ;
                ASimpleTable.addRow(
                    ((business.CStep) tempV.elementAt(x)).getAction(),
                    ownerName,
                    ((business.CStep) tempV.elementAt(x)).getStep()+"",
                    usecase.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }
          }

          if(AVariation) {
            //if (usecase.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
              tempV =  persistence.CUsecase.getSubvariationT1(usecase);
            //}else{
            //  tempV =  persistence.CUsecase.getSubvariationT2(usecase);
            //}
            for(int x = 0 ; x <   tempV.size() ; x++){
                String extrans  = ((business.CStep) tempV.elementAt(x)).getPhrases() ;
                ASimpleTable.addRow(
                    ((business.CStep) tempV.elementAt(x)).getAction(),
                    ownerName,
                    ((business.CStep) tempV.elementAt(x)).getStep()+"",
                    usecase.getName(),
                    business.CRecocaseLogic.convertToVector( extrans)
                );
            }

          }
//      System.out.println("**---------------------------------------**");
//      ASimpleTable.printTable();
        return ASimpleTable;
//        new toms.ResolutionTable(ASimpleTable);
//        lattice
    }





}
