package contr;

import java.awt.Component;
import javax.swing.JOptionPane;
import java.io.*;
import java.sql.SQLException;


/**
 *
 * Description: This class is used to create and to show error messages
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CError {

  public static void showNoLogin(Component AComponent) {
    JOptionPane.showMessageDialog(AComponent,
      "Login is not valid !");
  }

  public static void showNoRights(Component AComponent) {
    JOptionPane.showMessageDialog(AComponent,
    "You are not allowed to change these data");
  }

  public static void showNoProjects(Component AComponent) {
    JOptionPane.showMessageDialog(
      AComponent, "There are no projects.");
  }

  public static void showNoViewpoint(Component AComponent) {
    JOptionPane.showMessageDialog(
      AComponent, "There are no viewpoints.");
  }

  public static void showAlreadyOpen(Component AComponent) {
    JOptionPane.showMessageDialog(
      AComponent, "Already open !");
  }

  public static void showContainsModalVerbs(Component AComponent) {
    JOptionPane.showMessageDialog(
      AComponent, "Do not use modal verbs !");
  }

  public static void showContainsPronouns(Component AComponent) {
    JOptionPane.showMessageDialog(
      AComponent, "Do not use pronouns !");
  }

  public static void showSelectRowInTable(Component AComponent) {
    JOptionPane.showMessageDialog(
      AComponent, "Select row in table !");
  }

  public static void showNotImplemented(Component AComponent) {
    JOptionPane.showMessageDialog(
      AComponent, "service not implemented yet !");
  }

  public static void showNotSaved(Component AComponent, String AMessage) {
    JOptionPane.showMessageDialog(
      AComponent, " Datas could not be saved into the database. \n" + AMessage);
  }

  public static void showNotRead(Component AComponent, String AMessage) {
    JOptionPane.showMessageDialog(
      AComponent, " Datas could not be read from the database. \n" + AMessage);
  }

  public static void showNotDelete(Component AComponent, String AMessage) {
    JOptionPane.showMessageDialog(
      AComponent, " Datas could not be deleted in the database. \n" + AMessage);
  }

  public static void showNoConnectionToDatabase(Component AComponent) {
    JOptionPane.showMessageDialog(
      AComponent, " No connection to database");
  }

  /** creates dialog with Ok-Option to show message
   *  @param AComponent parent of dialog
   *  @param AMessage message which shall be displayed
   */
  public static void showErrorMessage(Component AComponent, String AMessage) {
    JOptionPane.showMessageDialog(
      AComponent, AMessage);
  }

  /** creates an error message from a string and an SQLException object
   *  @param AMessage first part of the error message
   *  @param AException provides second part of the error message
   *  @return error message
   */
  public static String createSQLErrorMessage(String AMessage,
                                             SQLException AException) {

    while (AException != null) {
       AMessage = AMessage.concat(
         "Message  : " + AException.getMessage() + "\n" +
         "SQLState : " + AException.getSQLState() + "\n" +
         "ErrorCode: " + AException.getErrorCode() + "\n");
       AException = AException.getNextException();
    }

    return AMessage;
  }

  /** creates an error message from a string and an exception object
   *  @param AMessage first part of the error message
   *  @param AException AException.getMessage provides second part of the error message
   *  @return error message
   */
  public static String createErrorMessage(String AMessage,
                                          Exception AException) {

    while (AException != null) {
       AMessage = AMessage.concat(
         "Message  : " + AException.getMessage() + "\n");
    }
    return AMessage;
  }

}