package contr;


import javax.swing.*;
import java.util.Vector;

/**
 *
 * Description: controller for processing shared use cases
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */

public class CDiagram {

  //public Vector diagrams = new Vector();
  public CDiagram() {
  }

  // ========================================================
  //add diagram to the list of open windows
  // ========================================================
  public void addDiagram(diagram.DDiagram diagram){
    business.Global.diagramFV.addElement(diagram);
    business.Global.menuBar.reload();
    business.Global.recocase.reload();
  }

  // ========================================================
  //close a diagram and remove from list
  // ========================================================
  public void closeDiagram(diagram.DDiagram diagram){
    business.Global.diagramFV.remove(diagram);
    diagram.dispose();
    business.Global.menuBar.reload();
    business.Global.recocase.reload();
  }

  // ========================================================
  //close all diagrams in the list
  // ========================================================
  public void closeAll(){
    for(int i = 0 ; i < business.Global.diagramFV.size() ; i++){
      ((diagram.DDiagram ) business.Global.diagramFV.elementAt(i)).onFileExit();
    }
  }

  // ========================================================
  //get two diagrams and combine them to make a new one
  // ========================================================
  public void addDiagrams(diagram.DDiagram D1 ,diagram.DDiagram D2){
    diagram.DDiagram td = new diagram.DDiagram();//(true);
    business.fca.SimpleTable t1 = D1.getCrosstable().getSimpleTable();
    business.fca.SimpleTable t2 = D2.getCrosstable().getSimpleTable();
    business.fca.SimpleTable t3 = addSimpleTables( t1, t2);
    td.createFCA(t3);
  }

  // ========================================================
  //
  // ========================================================
  public business.fca.SimpleTable addSimpleTables(business.fca.SimpleTable t1, business.fca.SimpleTable t2){
    business.fca.SimpleTable finalTable =  new business.fca.SimpleTable();

    for(int i = 0 ; i<t1.rowSize();i++){
      if( !(t1.getObj(i).getAction().equals("-")) ){//remove object with all atributes from diagram
        finalTable.addRow(  t1.getObj(i).getCopy(),  t1.getRow(i));
      }
    }

    boolean found = false;
    for(int i = 0 ; i<t2.rowSize();i++){
      if (!t2.getObj(i).getAction().equals("-")){//remove object with all atributes from all diagrams
        for(int x = 0 ; x < finalTable.getObjSize();x++){
          if(finalTable.getObj(x).getAction().equals(t2.getObj(i).getAction()) ){
            found = true;
            //maybe ask question to see what attributes descrive the object better
            //finalTable.useSynonyms(true);
          }
        }
        if(!found){
          finalTable.addRow(  t2.getObj(i).getCopy() , t2.getRow(i));
        }
      }
    }
    finalTable.useSynonyms(true);
//    for(int i = 0 ; i<finalTable.rowSize();i++){
//      System.out.println("==================");
//      System.out.println( finalTable.getObj(i).getFullName());
//      System.out.println("==================");
//      for(int x = 0 ; x< finalTable.getAttrV().size(); x++){
//        System.out.println(finalTable.getAttrV().elementAt(x));
//      }
//    }
    return finalTable;
  }




  private Vector sentences = null;
  private Vector flags = null;

  // ========================================================
  // gets tha flag of that sentence for this usecase.
  // ========================================================
  private business.CUsecase tmpUsecase = null;
  public String getSentencesFlag(String sentence ) {
    if(tmpUsecase == null || business.Global.usecase != tmpUsecase){
      tmpUsecase = business.Global.usecase ;
      sentences = new Vector();
      flags= new Vector();
      persistence.CDiagram.getSentencesFlags(sentences,flags);
    }
    if(sentences == null){
      sentences = new Vector();
      flags= new Vector();
      persistence.CDiagram.getSentencesFlags(sentences,flags);
    }
    if(sentences.indexOf(sentence)>-1){
      //System.out.println("** =get="+ sentence+"="+sentences.elementAt(sentences.indexOf(sentence))+ "" +(String) flags.elementAt( sentences.indexOf(sentence)));
      return (String) flags.elementAt( sentences.indexOf(sentence));
    }else{
      return "-";
    }
  }

  // ========================================================
  // sets a flag on that sentence for all diagrams of that usecase
  // ========================================================
  public void setSentenceFlag(String sentence,String flag ) {
    if(sentences.indexOf(sentence)>-1){
      //System.out.println("-- =set="+sentence+"="+sentences.elementAt(sentences.indexOf(sentence))+" : "+flag);
      //update
      int index =  sentences.indexOf(sentence);
      flags.removeElementAt(index );
      sentences.removeElementAt(index);
      sentences.addElement(sentence);
      flags.addElement(flag);
      persistence.CDiagram.updateSentenceFlag(sentence,flag);
    }else{
      sentences.addElement(sentence);
      flags.addElement(flag);
      persistence.CDiagram.insertSentenceFlag(sentence,flag);
    }
  }

}