package business.fca;

import java.util.Vector;
import java.io.*;
import javax.swing.*;



/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2002
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */


/**------------------------------------------------------------------
 * simple cross TABLE using VECTORS
 *                          -------
 *
 * a business.fca.SimpleTable gives us more tools and more flexible
 * than a contextTable because it uses vectors rather than arrays
 * a simple table can then be converted into a context table to create a lattice
 *
 * ------------------------------------------------------------------
 */

public class SimpleTable {

      private String tableName = "";
      //data base id
      private String DBid = "";
      //group id
      private String groupId = "" ;
      //col names
      private Vector attrNames = new Vector(); //strings (attributes)
      //row names
      private Vector objNames = new Vector(); //strings (Objects)
      //row data
      private Vector rows = new Vector();     //contain vectos of strings(attr,attr...attr)
      //force attr
      private Vector forceAttrNames = new Vector(); //strings (force attributes)
      //use Synonyms
      public boolean useSynonyms;

      public SimpleTable(){
      }

      public SimpleTable(String aGroupID){
        groupId = aGroupID;
      }

      public String getAttrName(int i)
      { return (String) attrNames.elementAt(i);}

      public String getObjName(int i)
      {
         return ((business.fca.FCAObject)objNames.elementAt(i)).getFullName();
      }

      public int getAttrSize()
      { return attrNames.size();}

      public int getObjSize()
      {  return objNames.size();}

      public business.fca.FCAObject getObj(int number)
      {  return ((business.fca.FCAObject) objNames.elementAt(number));}


      public boolean getObjInLattice(int id){
        return ((Boolean)((business.fca.FCAObject)objNames.elementAt(id)).getInLattice()).booleanValue();
      }


      /**
       *
       */
      public void addRow(String action ,String owner,String step,String VPName,Vector Arow){
        business.fca.FCAObject rowObject = new business.fca.FCAObject(action,owner,step, VPName);
        addRow(rowObject , Arow );
      }

      public void addRow(String action ,String owner,String step,String VPName,Vector Arow, Boolean inLattice){
        business.fca.FCAObject rowObject = new business.fca.FCAObject(action,owner,step, VPName , inLattice);
        addRow(rowObject , Arow);
      }


      public void addRow( business.fca.FCAObject rowObject , Vector Arow){

        objNames.addElement(rowObject );
//        if(inLattice.booleanValue() == false)
//          {this.objNotinLattice.addElement(new Integer(objNames.indexOf(Aname)));}

        rows.addElement(Arow );
        for (int i = 0; i < Arow.size() ; i++){
          if(!attrNames.contains(Arow.elementAt(i))){
            attrNames.addElement(Arow.elementAt(i));
          }
        }
      }


      /**
       *
       */
      public int rowSize(){
        return rows.size();
      }
      public int attrSize(){
        return attrNames.size();
      }
      public Vector getRow(int i){
        return (Vector) rows.elementAt(i);
      }

      public Vector getAttrV(){
        return attrNames;
      }



      public void removeobjfromlattice(int objId)
      {
       ((business.fca.FCAObject)objNames.elementAt(objId)).setInLattice(new Boolean(false));
      }

      public void setAllObjInLattice()
      {
        for(int i = 0;i<objNames.size();i++){
          ((business.fca.FCAObject)objNames.elementAt(i)).setInLattice(new Boolean(true));
        }
      }

      public void reset(){
        setAllObjInLattice();
      }

      public void setAttributes(Vector AttrStringsV){// ,Vector AttrIntegerReplaceV )
        this.attrNames = AttrStringsV;
      }

      public void addAttribute(String attr){
        attrNames.addElement(attr);
      }

      public void addForceAttribute(String attr){
        forceAttrNames.addElement(attr);
      }

      public void clearForceAttributes(){
        forceAttrNames.clear();
      }

      public Vector getAllAttrInLatticeV(){
        Vector attrNamesL = new Vector();
        for (int i = 0; i < rows.size() ; i++){
          if(((business.fca.FCAObject)objNames.elementAt(i)).getInLattice().booleanValue())
          {
            Vector Arow = (Vector) rows.elementAt(i);
            for(int row = 0 ; row < Arow.size() ; row ++ ){

              String attr = (String) Arow.elementAt(row);
              //do replacement  here
                    //fix me
              if(useSynonyms ){
                int phraseId = business.Global.project.getSynonymTable().getPhraseId(attr);
                if(phraseId != -1){
                  int sysnId = business.Global.project.getSynonymTable().getSynonymId(phraseId);
                  if(sysnId != -1){
                    attr = business.Global.project.getSynonymTable().getPhrase(sysnId);
                  }
                }
              }
              if(!attrNamesL.contains(attr)){
                    attrNamesL.addElement(attr);
              }

            }//for a row.size()
          }//if obj in Lattice
        }//for rows
        for(int i = 0; i < forceAttrNames.size();i++)
        {
          String attr = (String) forceAttrNames.elementAt(i);
          if(!attrNamesL.contains(attr)){
            attrNamesL.add(attr);
          }
        }
        return attrNamesL;
      }

      public  void useSynonyms(boolean aUseSynonyms)
      {
        this.useSynonyms = aUseSynonyms;
      }

      public  business.fca.ContextTable createContextTable()
      {

          Vector attrVContextTable = getAllAttrInLatticeV();
          if( attrVContextTable.size() < 1){
             JOptionPane.showMessageDialog(null,"there are no objects");
             business.fca.ContextTable crossTable = new business.fca.ContextTable(1,1);
             crossTable.set_attr_name(1 , "EMPTY" );
             crossTable.set_obj(1, new business.fca.FCAObject("NO Objects","","",""));
             crossTable.set_box(1,1);//I dont know
             return crossTable;
          }else{
            //add 1 because croostable begins the firt object at 1
            //add 1 to add object with all atributes
            //remove dose objects not wanted in the lattice
            int objsInContextTable = rowSize()+1-objNotinLattice();
            business.fca.ContextTable crossTable = new business.fca.ContextTable(objsInContextTable,attrVContextTable.size());
            //set attributes
            for(int attr = 0 ; attr < attrVContextTable.size() ; attr ++ ){
              crossTable.set_attr_name(1+ attr , (String) attrVContextTable.elementAt(attr) );
            }
            //set rows eg (objects)(attr...attr)
            int objIdforContextTable = 0;
            for(int obj = 0 ; obj < rows.size() ; obj ++ ){
              if(getObjInLattice(obj)){
                objIdforContextTable ++;
//                crossTable.set_obj_name(objIdforContextTable,((business.fca.FCAObject)objNames.elementAt(obj)).getName());

                crossTable.set_obj(objIdforContextTable,(business.fca.FCAObject)objNames.elementAt(obj));

                for(int attr = 0; attr < getRow(obj).size() ; attr++){
                    //Check for replacement
                    //do replacement  here
                          //fix me
                    String attrName = (String) getRow(obj).elementAt(attr);

                    //int attrID = attrNames.indexOf(attrName);
                    if(useSynonyms ){
                      int phraseId = business.Global.project.getSynonymTable().getPhraseId(attrName);
                      if(phraseId != -1){
                        int sysnId = business.Global.project.getSynonymTable().getSynonymId(phraseId);
                        if(sysnId != -1){
                          attrName = business.Global.project.getSynonymTable().getPhrase(sysnId);
                        }
                      }
                    }
                    int attrIdContextTable = attrVContextTable.indexOf(attrName);
                    crossTable.set_box( objIdforContextTable , 1+attrIdContextTable );
                }
                for(int i = 0; i < forceAttrNames.size();i++)
                {
                  String attrName = (String)forceAttrNames.elementAt(i);
                  if( ((business.fca.FCAObject)objNames.elementAt(obj)).contains(attrName)){
                    int attrIdContextTable = attrVContextTable.indexOf(attrName);
                    crossTable.set_box( objIdforContextTable , 1+attrIdContextTable );
                  }
                }


              }//if in lattice
            }//for obj
            //ALL atributes
//            crossTable.set_obj_name(objsInContextTable,"-");
            crossTable.set_obj(objsInContextTable, new business.fca.FCAObject("-","","",""));
            for(int attr = 0; attr < attrVContextTable.size() ; attr++){
                crossTable.set_box(objsInContextTable , attr+1 );
            }
            crossTable.setName(this.getName());
            return crossTable;
          }
      }


      public void setTableName(String aTableName){
        tableName = aTableName;
      }

      public String getTableName(){
        return tableName;
      }

      public void setId(String aDBid){
        DBid = aDBid;
      }

      public String getId(){
        return DBid;
      }

      public String getGroupId(){
        return groupId;
      }

      //should be done in creation
      public void setGroupId(String ID){
        groupId = ID;
      }

      public int objNotinLattice(){
        int count=0;
        for(int i = 0;i<objNames.size();i++){
          if(!((Boolean)((business.fca.FCAObject)objNames.elementAt(i)).getInLattice()).booleanValue())  {
            count++;
          }
        }
        return count;
      }

      private String myName = "";
      public String getName(){
        return myName;
      }

      public void setName(String aName){
        myName = aName;
      }



//      public void printTable(){
//        for(int i = 0 ; i < rows.size() ; i++ ){
//          System.out.println("----------------------");
//          System.out.println(getObjName(i) );
//          for(int x = 0; x < getRow(i).size() ; x++){
//            System.out.println((String) getRow(i).elementAt(x));
//          }
//
//        }
//      }

}
