package business.fca;


/**
*
*	PROJECT			: MCRDR-FCA
* 	CLASS			: Set
*	AUTHOR			: Usama Malik
*	LAST MODIFIED	: 26/09/00
* 					: 14/220/00
*					: 15/220/00
* DESCRIPTION		:
*		This is optimized version of Set class.It uses bit map to represent
*		numbers.
*
*
**/

public class Set{

	private int[] set;		//bitmap of set

	public Set(){

		set  = new int[6]; //represents upto 5*32 numbers.

		set[0] =0;    //set[0] contains how many numbers are in
                              //the set , so that we don't have to scan all
		}

/**
* NOTE:	If we want to represent larger sets then we have to manually change above figure.This is
*		just to save extra processing for each KB file.
**/


	public void set_clear(){

        	for(int i=0;i<6;i++)set[i] =0;	//all set to Zero
        }
	public int get_size(){
	  return set[0];
    	}



	public void remove_elt(int element){
		int bit_index = element/32;
		set[bit_index+1] = set[bit_index+1]^(1<<element%32);
		set[0]--;

		}
	//Get the maximum integer of the set

	public void put_element(int element){

		int bit_index = element/32;
		if(((set[bit_index+1])&(1<<element%32))==0){
		set[bit_index+1] = set[bit_index+1]|(1<<element%32);
		set[0]++;


		 }
		}
//redundant method
/*	public boolean is_subset(Set a_set){
		boolean is_subset = true ;		//suppose it is

		Enumeration of_set = a_set.get_elements();
		while(of_set.hasMoreElements()){

			is_subset = is_subset&(set.contains(of_set.nextElement()));
			}

		return is_subset;
	}//method subset
	*/
  public boolean set_equal(Set a){
	boolean is_equal = true;	//suppose they are equal!!
	int[] input_set = a.set_bit_map();
	for(int i=0;i<6;i++)
		is_equal = is_equal&&(input_set[i]==set[i]);
	return is_equal;
  }//method equal


  public Set intersection(Set a){
	Set intersect = new Set();	//to return
	int elt_number =-1;	//to keep track
	int[] a_set = a.set_bit_map();
	 for(int i=1;i<6;i++){
		for(int j=0;j<32;j++){
			elt_number++;
			if( (((1<<j)&set[i])!=0)&
			    (((1<<j)&a_set[i])!=0) )
			 intersect.put_element(elt_number);
		}//inner for loop
	}
	return intersect;
  }//method intersection


  public void print_set(){
    int elt_number=-1;
    for(int i=1;i<6;i++){
          for(int j=0;j<32;j++){
		elt_number++;
		if(((1<<j)&set[i])!=0)	 System.out.println(elt_number + " ");
        }//inner for loop
    }//for loop
  }//method print_set


	//This returns an array of elements
  public int[] get_elements(){
	int[] set_array = new int[set[0]];
	int counter =0;
	int elt_number=-1;
	for(int i=1;i<6;i++){
		for(int j=0;j<32;j++){
			elt_number++;
			if(((1<<j)&set[i])!=0){
			 set_array[counter]=elt_number;
			 counter++;
			 }
		}//inner for loop
	}//for loop
	return set_array;
  }
  public Set clone_set(){
    Set clone = new Set();
    	int[] set_array = new int[set[0]];
	int counter =0;
	int elt_number=-1;
	for(int i=1;i<6;i++){
		for(int j=0;j<32;j++){
			elt_number++;
			if(((1<<j)&set[i])!=0){
			 clone.put_element(elt_number);
			 counter++;
			 }
		}//inner for loop
	}//for loop
	return clone;
  }


  public String to_string(){
        int[]  temp_array  = get_elements();
        String temp_s = "[";
        for (int j=0; j<temp_array.length-1; j++) {
            temp_s = temp_s + temp_array[j]+"," ;
        }

        if (temp_array.length > 0)
        {
            temp_s = temp_s + temp_array[temp_array.length-1]+"]";
        }else
        {
            temp_s = "[]";
        }

        return temp_s;
  }


  public Set minus(Set a){
    		//This method returns (a-this_set)
	int[] minued = a.set_bit_map();
	int elt_number=-1;
	Set difference = new Set();	//Set to be returned
	//if(minued[0]<set[0])
	//System.out.println("Set mismatch ");
        for(int i=1;i<6;i++){
	  for(int j=0;j<32;j++){
       		elt_number++;
		if( (((1<<j)&minued[i])!=0)&
			((((1<<j)&minued[i]) ^((1<<j)&set[i])   )!=0)		)//if
		 difference.put_element(elt_number);
                 }//inner for loop
	}//for loop
		return difference;
  }
		//This method retruns (this_set U a)


  public Set union(Set a){
	Set union = new Set();	//to return
	int elt_number =-1;	//to keep track
	int[] a_set = a.get_elements();
	 for(int i=1;i<6;i++){
		for(int j=0;j<32;j++){
			elt_number++;
			if( (((1<<j)&set[i])!=0)|
			    (((1<<j)&a_set[i])!=0) )
			 union.put_element(elt_number);
		}//inner for loop
	}
	return union;
  }

  public boolean has_element(int element){
    int bit_index = element/32;
    return (((set[bit_index+1])&(1<<element%32))!=0);
  }



  public int num_elements(){
    return set[0];
  }
  public int[] set_bit_map(){
	  return set;
  }


}//class Set

