package business.fca;

import java.util.Vector;
/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

 //this object holds data only it doesn't do any calculations
 //for cross table or finding scores between viewpoints

public class FCAObject {

//data that must be saved
private String action = "";
private String owner = "";
private String step = "";
private String VPName = "";
//-------  unsure of needing save vvv
Boolean inLattice = new Boolean(true);
//-----------------------------------




//scores are calculated by another object (eg toms.CReport)
Vector scores[] = new Vector[2];

  public FCAObject(String aAction,String aOwner,String aStep,String aViewpointName) {
    //asume that this object is in lattice
    init(aAction,aOwner, aStep, aViewpointName,new Boolean(true));
  }
  public FCAObject(String aAction,String aOwner,String aStep,String aViewpointName,Boolean aInLattice) {
    init(aAction,aOwner, aStep, aViewpointName,aInLattice);
  }
  private void init(String aAction,String aOwner,String aStep,String aViewpointName,Boolean aInLattice) {
    action = aAction;
    owner = aOwner;
    step = aStep;
    VPName = aViewpointName;
    inLattice = aInLattice;
    scores[0] = new Vector();
    scores[1] = new Vector();
  }

  public String getFullName(){
      return owner+"/"+VPName+"/"+step+"/"+action;
  }

  public String getName(){
    return action;
  }
  public String getAction(){
    return action;
  }
  public String getOwner(){
    return owner;
  }
  public String getStep(){
    return step;
  }
  public String getVPName(){
    return VPName;
  }
  public Boolean getInLattice(){
    return inLattice;
  }
  public void setInLattice(Boolean aInLattice){
    inLattice = aInLattice;
  }

  public void setScoreAgainstVP(Float score,String VPName){
    scores[0].addElement(VPName);
    scores[1].addElement(score);

  }
  public Float getScoreAgainstVP(String VPName){
    for(int i = 0;i<scores[0].size();i++){
      if(((String)scores[0].elementAt(i)).equals(VPName)){
          return  ((Float) scores[1].elementAt(i));
      }
    }
    return (new Float(0+""));
//    return null;
  }
  public String getScoresString(){
    String score = "";
    for(int i = 0;i<scores[0].size();i++){
      score = score +"["+(String) scores[0].elementAt(i)+":"+ ((Float) scores[1].elementAt(i)).toString()+"]";
    }
    return score;
  }
  private String flag = "";


  //used for calculating distance
  public void setFlag(String Flag){
    flag = Flag;
  }
  public String getFlag(){
    return flag;
  }


  //used for openig a diagram (obj id)
  int id = -1;
  public void setId(int ID){
    id = ID;
  }
  public int getId(){
    return id;
  }

  public boolean contains(String search){
      String test = " "+this.getAction()+" ";
      boolean found = false;
      for(int x = 0;x<(test.length()-search.length()+1)&&found==false;x++){
        if(test.regionMatches(true,0+x,search,0,search.length())){
          found = true;
        }//if
      }//for
      return found;
  }

  public FCAObject getCopy(){
    return new FCAObject( action, owner, step , VPName , inLattice );
  }




}