package business.fca;

import java.io.*;
import java.util.*;
import java.util.Vector;

/**
*
*	PROJECT			: MCRDR-FCA , RECOCASE
*	CLASS			: ContextTable
*	AUTHOR			: Usama Malik and Oscar Aguilera
*	LAST MODIFIED		: 26/09/00
* 				: 14/12/00
*                               : 12/03/02 Oscar Aguilera
*                               : 26/06/02 Oscar Aguilera
*                               : 01/02/03 Oscar Aguilera
*	DESCRIPTION		:
* 			  This class implements a Context Table.It's method support all operations that
*			  can be done on a context table, like setting the name of attributes, etc
*			  This formal context table will be used later on to find formal concepts.
*
**/


public class ContextTable{

        // d a ta     t o    b e    s a v e d
        //---------------------------------
	private business.fca.FCAObject[] object;        //Oscar Aguilera
	private String[] attributes;
        int no_objects = 0;
	private char[][] context_table;		        //sofar two_valued logic is used
	private int num_entries=0;
        //---------------------------------


/*
 * Constructor
 *
 */
	public ContextTable(int no_objs,int no_attrs){
                no_objects = no_objs;                           //Oscar aguilera
          	object = new business.fca.FCAObject[no_objs];   //Oscar aguilera
		//object_names = new String[no_objs];
		attributes	 = new String[no_attrs];
		context_table = new char[no_objs][no_attrs];

		/*initialise the table*/
		//System.out.println("CT called");
		for(int i=0;i<no_objs;i++){
			for(int y=0;y<no_attrs;y++)
				context_table[i][y] = '.';
		}

	}


/*method to set the name of an attribute*/

  public void set_attr_name(int attr_no, String attr_name){
    attributes[attr_no-1] = attr_name;
  }

  public void set_box(int obj_no,int attr){
    context_table[obj_no-1][attr-1] = 'X' ;
    num_entries++;
  }

  public boolean get_box(int obj_no,int attr){//Oscar Aguilera
    if(context_table[obj_no-1][attr-1] =='X')
    {
      return true;
    }else{
      return false;
    }
  }

  public int get_num_entries(){
      return num_entries;
  }




  public void swap(){}	//not yet implemented

  public int get_no_obj(){
    return no_objects;
  }

  public int get_no_attr(){
    return attributes.length;
  }

  public business.fca.Set get_intent(business.fca.Set extent){
    int[]  all_elements = extent.get_elements();
    business.fca.Set intent = new business.fca.Set();
    business.fca.Set temp;

    //System.out.println("Finding intent of ");
    if(all_elements.length==0){	//empty set
      for(int i=1;i<=no_objects;i++) intent.put_element(i);
      return intent;
    }//if

    intent = get_single_intent(all_elements[0]);
    for(int i=1;i<all_elements.length;i++){
      temp = get_single_intent(all_elements[i]);
      intent  = intent.intersection(temp);
    }
    return intent;

  }//method get_intent

  public business.fca.Set get_extent(business.fca.Set input){
    int[] all_elements = input.get_elements();
    business.fca.Set extent = new business.fca.Set();
    business.fca.Set temp;
    if(all_elements.length==0){	//empty set
      for(int i=1;i<=no_objects;i++)extent.put_element(i);
      return extent;
    }//if
    extent  = get_single_extent(all_elements[0]);
    for(int i=1;i<all_elements.length;i++){
      temp = get_single_extent(all_elements[i]);
      extent = extent.intersection(temp);
    }
    return extent;
  }//method get_intent

  public business.fca.Set get_single_intent(int obj_no){
    business.fca.Set single_intent = new business.fca.Set();
    for(int i=0;i<context_table[0].length;i++){
      //System.out.println(i);
      if(context_table[obj_no-1][i]=='X')
              single_intent.put_element(i+1);
      }//for loop
      //System.out.println("new ");
      return single_intent;
    }//method get_single_intent

  public business.fca.Set get_single_extent(int attr_no){
    business.fca.Set single_extent = new business.fca.Set();
    for(int i=0;i<no_objects;i++){
      //System.out.println("In single ex"+i);
      if(context_table[i][attr_no-1]=='X') single_extent.put_element(i+1);
    }
    return single_extent;
  }//method get_single_intent


  /*method to get the name of an object*/
  public business.fca.FCAObject get_obj(int obj_no){
    return object[obj_no-1];
  }

  /*method to set the name of an object*/
  public void set_obj(int obj_no,business.fca.FCAObject obj){
    object[obj_no-1] = obj;
  }
  public void set_FCAobject(int obj_no,business.fca.FCAObject obj){
    object[obj_no-1]= obj;
  }

  /*method to get the name of an attribute*/
  public String get_attr_name(int attr_no){
    return attributes[attr_no-1];
  }

//  public void saveFLT(String fileName){
//      //System.out.println("save:>\n" + this.stringFLT()+"<");
//      try
//      {
//            FileWriter file = new FileWriter(fileName);
//            file.write(this.stringFLT());
//            file.write('\n');
//            file.close();
//      }
//      catch (Exception e)
//      {
//        System.out.println("***  ERROR: Error trying to open file  " + fileName);
//      }
//
//  }

  /**
   *
   * table to Flt ???
   *
   */
//    public String stringFLT(){
//        String result = "";
//	for(int i=0;i<no_objects-1;i++){
//          boolean first = true;
//            for(int y=0;y<attributes.length;y++){
//              if(y==0){
//                  result = result + "step\t"+ "owner/"+  "obj_name(i+1)-%uoi\t" ;
//              }
//              if(context_table[i][y] == 'X')
//                 if(first){
//                    result = result +"("+attributes[y]+")";
//                    first = false;
//                  }else{
//                    result = result +";("+attributes[y]+")";
//                  }
//
//              if(y+1==attributes.length)
//                  result = result + "\n";
//            }
//	}
//        //String resTables = stringResolutionTables();
//        return result ;//+ resTables;
//  }



  // a business.fca.SimpleTable gives us more tools and more flexible
  // a simple table can then be converted into a context table to create a lattice
  public business.fca.SimpleTable  getSimpleTable(){
    business.fca.SimpleTable ST = new business.fca.SimpleTable();
    for(int i=0;i<no_objects;i++){
      Vector attr = new Vector();
      for(int y=0;y<attributes.length;y++){
	//System.out.print("\t"+context_table[i][y]);
        if(context_table[i][y] == 'X'){
          attr.addElement(this.attributes[y]);
        }
      }
      ST.addRow(this.object[i], attr);
    }
    ST.setName(this.getName());
    return ST;
  }

  private String myName = "";
  public String getName(){
    return myName;
  }

  public void setName(String aName){
    myName = aName;
  }



  public void  print_table(){
    for(int i=0;i<no_objects;i++){
      for(int y=0;y<attributes.length;y++){
        System.out.print("\t"+context_table[i][y]);
        if(y+1==attributes.length) System.out.println();
      }
    }
  }//print_table method

  public void  printTable(){
    for(int i=0;i<no_objects;i++){
      System.out.println( this.object[i].getAction());
      for(int y=0;y<attributes.length;y++){
        if(context_table[i][y] == 'X'){
          System.out.println( this.attributes[y]);
        }
      }
      System.out.println("=====================");
    }
  }








}//Class ContextTable