package business.fca;
import java.util.*;
import java.util.Vector;

/**
*
*  PROJECT        : MCRDR-FCA
*  CLASS        : ConceptGeneratorv2
*  AUTHOR       : Usama Malik
*  LAST MODIFIED    : 14/12/00
*                   : 15/12/00
*  DESCRIPTION  :
*       This class takes in a context table and generates a concept matrix out of it.It
*       uses next_concept algorithm from Ganter described in his book, Formal Concept Analysis.
*
*/


public class ConceptGeneratorv2{


  private int num_concepts =0,p_concepts=0;
  private business.fca.Set a,a_o_plus_i,i_temp, temp, temp_last_elt, g;

  private Vector vExtent;
  private Vector vIntent;

/** These sets represent:
* a     ==>A
* a_o_plus_i  ==> A o_plus i
* i_temp    ==>{1,2,3............i}
* temp    ==>pointer to temporary set
* g     ==>G
*       For a full understanding please refer to Ganter book.
**/


  public ConceptGeneratorv2(ContextTable in_table){

    //System.out.println("Constructor CG called");
    //initialise all sets declared above

    a       = new Set();
    a_o_plus_i    = new Set();
    i_temp      = new Set();
    temp_last_elt   = new Set();
    g         = new Set();
    this.vExtent = new Vector();
    this.vIntent = new Vector();

    all_extents(in_table);//start generating concepts

}

public void all_extents(ContextTable in_table){


    Set temp_u = new Set();
    int j;
    for(int i=1;i<=in_table.get_no_obj();i++)
      g.put_element(i);   //this is object set

    while(a.num_elements()<in_table.get_no_obj()){

       i_temp = a.minus(g);
       //Now j is the maximum element of above set.So we have to partition

       int[] elt_array = i_temp.get_elements();
       j = elt_array[elt_array.length-1];
       i_temp.set_clear();

        while(j>0){
          for(int z=1;z<j;z++)
            i_temp.put_element(z);
          temp_u = a.intersection(i_temp);
          temp_u.put_element(j);
          temp_u = in_table.get_extent( in_table.get_intent(temp_u));
          if(lectically_smaller(a,temp_u,j))
             break;
           j--;
           i_temp.set_clear();
         }//while
      num_concepts++;
      a = temp_u;
      temp_u=null;

//      System.out.println("Concept Number "+num_concepts);
      p_concepts++;
//      System.out.println("Extent is ");
//      a.print_set();
      this.vExtent.add(a);

      temp_u = in_table.get_intent(a);
//      System.out.println("Intent is ");
//      temp_u.print_set();
      this.vIntent.add(temp_u);

//      temp_u.set_clear(); error


    }//outer while
  }//method all_extents




//Test if s set is lectically smaller then other
  private boolean lectically_smaller(Set a, Set b, int i){
    Set temp = new Set();
    for(int j=1;j<i;j++)
      temp.put_element(j);  //prepare {1,2,3.....i-1}

    //bit of task for compiler!!!!!!
    return(a.minus(b).has_element(i)&(a.intersection(temp).set_equal(b.intersection(temp))));

  }//method lectically_smaller



/* ------------------------------------------------------------------


---------------------------------------------------------------------*/

    public  void print_table(){

      System.out.println( "-Extent-" );
      for (int i=0; i<this.vExtent.size(); i++) {
        System.out.println( "e-- " + i );
        business.fca.Set t_Set = (business.fca.Set) this.vExtent.elementAt(i);
        t_Set.print_set();
      }
        System.out.println( "-Intent-" );
      for (int i=0; i<this.vIntent.size(); i++) {
        System.out.println( "i-- " + i );
        business.fca.Set t_Set = (business.fca.Set) this.vIntent.elementAt(i);
        t_Set.print_set();
      }

  }
  public Vector get_extent(){
      return this.vExtent;
  }
  public Vector get_intent(){
      return this.vIntent;
  }








}//class ConceptGeneratorv2
