package business;

import java.util.*;
import java.util.Vector;

/**
 *
 * Description: an object of this class represents a use case viewpoint
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CViewpointUc extends CViewpoint {

  /** use case to which use case viewpoint is attached */
  private CUsecase usecase   = null;
  /** trigger of the use case viewpoint */
  private String trigger = null;
  /** actors of the use case viewpoint */
  private Vector actorV = null;
  /** conditions which has to be valid before */
  private Vector precond = null;
  /** conditions which are valid after a successful run */
  private Vector successEndcond = null;
  /** conditions which are valid after a failed run */
  private Vector failedEndcond = null;
  /** steps of success scenario of type business.Global.STYLE_STRUCT_WITHOUT_ACTOR */
  private Vector successScenarioT1V = null;
  /** extension steps of the success scenario of
   *  type business.Global.STYLE_STRUCT_WITHOUT_ACTOR
   */
  private Vector extensionT1V = null;
  /** variations of steps of the success scenario of
   *  type business.Global.STYLE_STRUCT_WITHOUT_ACTOR
   */
  private Vector subvariationT1V = null;

  /** steps of success scenario of type business.Global.STYLE_STRUCT_WITH_ACTOR */
  private Vector successScenarioT2V = null;
  /** extension steps of the success scenario of
   *  type business.Global.STYLE_STRUCT_WITH_ACTOR
   */
  private Vector extensionT2V = null;
  /** variations of steps of the success scenario of
   *  type business.Global.STYLE_STRUCT_WITH_ACTOR
   */
  private Vector subvariationT2V = null;

  /**
   * constructor
   */
  public CViewpointUc() {
    precond = new Vector();
    successEndcond = new Vector();
    failedEndcond = new Vector();

    successScenarioT1V = new Vector();
    extensionT1V = new Vector();
    subvariationT1V = new Vector();

    successScenarioT2V = new Vector();
    extensionT2V = new Vector();
    subvariationT2V = new Vector();
  }

  /**
   * constructor sets id, viewpoint agent, name, style, use case, trigger, and vector of actors
   * @param AId id of use case viewpoint
   * @param AOwner viewpoint agent
   * @param AName name of use case viewpoint
   * @param AStyle style of scenario steps of use case viewpoint
   *        (business.Global.STYLE_STRUCT_WITHOUT_ACTOR or
   *         business.Global.STYLE_STRUCT_WITH_ACTOR)
   * @param AUsecase use case to which use case viewpoint is attached
   * @param ATrigger trigger of the scenario steps
   * @param AActorV vector of actors
   */
  public CViewpointUc(long AId,
                      CViewpointAgent  ViewpointAgent, //contains a CUser AOwner,
                      String AName,
                      int AStyle,
	              CUsecase AUsecase,
                      String ATrigger,
                      Vector AActorV) {

	super(AId, ViewpointAgent, AName, AStyle);

    usecase = AUsecase;
    trigger = ATrigger;
    actorV = AActorV;
    precond = new Vector();

    successEndcond = new Vector();
    failedEndcond = new Vector();

    successScenarioT1V = new Vector();
    extensionT1V = new Vector();
    subvariationT1V = new Vector();

    successScenarioT2V = new Vector();
    extensionT2V = new Vector();
    subvariationT2V = new Vector();
  }

  /**
   * returns type eg senario or usecase
   * @return business.Global.TYPE_VP_USECASE;
   */
  public String getType(){
    return business.Global.TYPE_VP_USECASE;
  }
  /**
   * returns use case to which use case viewpoint is attached
   * @return use case to which use case viewpoint is attached
   */
  public CUsecase getUsecase() {
	return usecase;
  }

  /**
   * sets use case to which use case viewpoint is attached
   * @param AUsecase use case to which use case viewpoint is attached
   */
  public void setUsecase(CUsecase AUsecase) {
    usecase = AUsecase;
  }

  /**
   * returns trigger to start scenario steps
   * @return trigger to start scenario steps
   */
  public String getTrigger() {
	return trigger;
  }

  /**
   * sets trigger to start scenario steps
   * @param ATrigger trigger to start scenario steps
   */
  public void setTrigger(String ATrigger) {
    trigger = ATrigger;
  }

  /**
   * returns vector of actors of type business.CActor
   * @return vector of actors of type business.CActor
   */
  public Vector getActors() {
	return this.usecase.getActors();
  }

  /**
   * sets vector of actors of type business.CActor
   * @param AActorV vector of actors of type business.CActor
   */
//  public void setActors(Vector AActorV) {
//    actorV = AActorV;
//  }

  /**
   * returns vector of conditions of type business.CCondition which has to be
   * valid before scenario starts
   * @return vector of conditions of type business.CCondition which has to be
   * valid before scenario starts
   */
  public Vector getPrecond() {
	return precond;
  }

  /** sets vector of conditions of type business.CCondition which has to be
   * valid before scenario starts
   * @param APrecond vector of conditions of type business.CCondition which has to be
   * valid before scenario starts
   */
  public void setPrecond(Vector APrecond) {
    precond = APrecond;
  }

  /** returns vector of conditions which are valid after a successful run
   *  @return vector of conditions which are valid after a successful run
   */
  public Vector getSuccessEndcond() {
	return successEndcond;
  }

  /** sets vector of conditions which are valid after a successful run
   *  @param ASuccessEndcond vector of conditions which are valid after a successful run
   */
  public void setSuccessEndcond(Vector ASuccessEndcond) {
     successEndcond = ASuccessEndcond;
  }

  /** returns vector of conditions which are valid after a failed run
   *  @return vector of conditions which are valid after a failed run
   */
  public Vector getFailedEndcond() {
	return failedEndcond;
  }

  /** sets vector of conditions which are valid after a failed run
   *  @param AFailedEndcond vector of conditions which are valid after a failed run
   */
  public void setFailedEndcond(Vector AFailedEndcond) {
     failedEndcond = AFailedEndcond;
  }

  /** return vector of success scenario steps of type business.CStepStrT1
   * @return vector of success scenario steps of type business.CStepStrT1
   */
  public Vector getSuccessScenarioT1() {
	return successScenarioT1V;
  }

  /** sets vector of success scenario steps of type business.CStepStrT1
   *  @param ASuccessScenarioT1V vector of success scenario steps of type business.CStepStrT1
   */
  public void setSuccessScenarioT1(Vector ASuccessScenarioT1V) {
     successScenarioT1V = ASuccessScenarioT1V;
  }

  /** returns vector of extensions of success scenario of type business.CStepStrT1
   *  @return vector of extensions of success scenario of type business.CStepStrT1
   */
  public Vector getExtensionT1() {
	return extensionT1V;
  }

  /** sets vector of extensions of success scenario of type business.CStepStrT1
   *  @param AExtensionT1V vector of extensions of success scenario of type business.CStepStrT1
   */
  public void setExtensionT1(Vector AExtensionT1V) {
     extensionT1V = AExtensionT1V;
  }

  /** returns vector of variations of success scenario of type business.CStepStrT1
   *  @return vector of variations of success scenario of type business.CStepStrT1
   */
  public Vector getSubvariationT1() {
	return subvariationT1V;
  }

  /** sets vector of variations of success scenario of type business.CStepStrT1
   *  @param ASubvariationT1V vector of variations of success scenario of type business.CStepStrT1
   */
  public void setSubvariationT1(Vector ASubvariationT1V) {
     subvariationT1V = ASubvariationT1V;
  }

  /** return vector of success scenario steps of type business.CStepStrT2
   * @return vector of success scenario steps of type business.CStepStrT2
   */
  public Vector getSuccessScenarioT2() {
	return successScenarioT2V;
  }

  /** sets vector of success scenario steps of type business.CStepStrT2
   *  @param ASuccessScenarioT1V vector of success scenario steps of type business.CStepStrT2
   */
  public void setSuccessScenarioT2(Vector ASuccessScenarioT2V) {
     successScenarioT2V = ASuccessScenarioT2V;
  }

  /** returns vector of extensions of success scenario of type business.CStepStrT2
   *  @return vector of extensions of success scenario of type business.CStepStrT2
   */
  public Vector getExtensionT2() {
	return extensionT2V;
  }

  /** sets vector of extensions of success scenario of type business.CStepStrT2
   *  @param AExtensionT1V vector of extensions of success scenario of type business.CStepStrT2
   */
  public void setExtensionT2(Vector AExtensionT2V) {
     extensionT2V = AExtensionT2V;
  }

  /** returns vector of variations of success scenario of type business.CStepStrT2
   *  @return vector of variations of success scenario of type business.CStepStrT2
   */
  public Vector getSubvariationT2() {
	return subvariationT2V;
  }

  /** sets vector of variations of success scenario of type business.CStepStrT2
   *  @param ASubvariationT1V vector of variations of success scenario of type business.CStepStrT2
   */
  public void setSubvariationT2(Vector ASubvariationT2V) {
     subvariationT2V = ASubvariationT2V;
  }

  /**
   * creates string to be able to distinguish use case viewpoint;
   * e.g. used for tree of viewpoints (e.g. FCA)
   * @return string "viewpoint: 'name of use case viewpoint' ['viewpoint agent']"
   */
  public String toString() {
    return new String("viewpoint UC: " + this.getViewpointAgent().getName() + " [" + this.getUser().getName() + "]");
  }

  /**
   * finds out if actor with id 'AId' is already assigned to use case viewpoint
   * @return true if actor is already assigned to use case viewpoint, else false
   */
  public boolean containsActor(long AId) {

    if (actorV != null) {
      for (int i=0; i<actorV.size(); i++) {
        if (AId == ((business.CActor) actorV.elementAt(i)).getId())
          return true;
      }
    }
     return false;
  }

  /**
   * finds unknown words of all conditions and scenario steps
   * @return Vector of unknown words
   */
  public Vector getUnknownWords() {

    Vector unknownWordsV = new Vector();

    for (int i=0; i<this.getPrecond().size(); i++) {

      business.CRecocaseLogic.analyseSentence(
        ((business.CCondition) this.getPrecond().elementAt(i)).getText(), "");
      Vector outV = business.CRecocaseLogic.getUnknownWords();
      if (outV != null) {
        for (int j=0; j<outV.size(); j++)
          unknownWordsV.add(
            (String)
            business.CRecocaseLogic.convertToVector(
             (String) outV.elementAt(j)).elementAt(0)
          );
      }
    }

    for (int i=0; i<this.getSuccessEndcond().size(); i++) {

      business.CRecocaseLogic.analyseSentence(
        ((business.CCondition) this.getSuccessEndcond().elementAt(i)).getText(), "");
      Vector outV = business.CRecocaseLogic.getUnknownWords();
      if (outV != null) {
        for (int j=0; j<outV.size(); j++)
          unknownWordsV.add(
            (String)
            business.CRecocaseLogic.convertToVector(
             (String) outV.elementAt(j)).elementAt(0)
          );
      }
    }

    for (int i=0; i<this.getFailedEndcond().size(); i++) {

      business.CRecocaseLogic.analyseSentence(
        ((business.CCondition) this.getFailedEndcond().elementAt(i)).getText(), "");
      Vector outV = business.CRecocaseLogic.getUnknownWords();
      if (outV != null) {
        for (int j=0; j<outV.size(); j++)
          unknownWordsV.add(
            (String)
            business.CRecocaseLogic.convertToVector(
             (String) outV.elementAt(j)).elementAt(0)
          );
      }
    }

    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {

      for (int i=0; i<this.getSuccessScenarioT1().size(); i++) {

        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getSuccessScenarioT1().elementAt(i)).getAction(), "");
        Vector outV = business.CRecocaseLogic.getUnknownWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            unknownWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
      }

      for (int i=0; i<this.getExtensionT1().size(); i++) {

        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getExtensionT1().elementAt(i)).getAction(), "");
        Vector outV = business.CRecocaseLogic.getUnknownWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            unknownWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
      }

      for (int i=0; i<this.getSubvariationT1().size(); i++) {

        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getSubvariationT1().elementAt(i)).getAction(), "");
        Vector outV = business.CRecocaseLogic.getUnknownWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            unknownWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
      }

    } else {

      for (int i=0; i<this.getSuccessScenarioT2().size(); i++) {

        String sentence =
          ((business.CStepStrT2) this.getSuccessScenarioT2().elementAt(i)).getSentence();
        business.CRecocaseLogic.analyseSentence(
          sentence, "");
        Vector outV = business.CRecocaseLogic.getUnknownWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            unknownWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
      }

      for (int i=0; i<this.getExtensionT2().size(); i++) {

        String sentence =
          ((business.CStepStrT2) this.getExtensionT2().elementAt(i)).getSentence();
        business.CRecocaseLogic.analyseSentence(
          sentence, "");
        Vector outV = business.CRecocaseLogic.getUnknownWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            unknownWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
      }

      for (int i=0; i<this.getSubvariationT2().size(); i++) {

        String sentence =
          ((business.CStepStrT2) this.getSubvariationT2().elementAt(i)).getSentence();
        business.CRecocaseLogic.analyseSentence(
          sentence, "");
        Vector outV = business.CRecocaseLogic.getUnknownWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            unknownWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
      }
    }

    return unknownWordsV;
  }

  /**
   * finds keywords of all conditions and scenario steps
   * @return Vector of keywords
   */
//  public Vector getKeyWords() {
//
//    Vector keyWordsV = new Vector();
//
//    for (int i=0; i<this.getPrecond().size(); i++) {
//
//      business.CRecocaseLogic.analyseSentence(
//        ((business.CCondition) this.getPrecond().elementAt(i)).getText(), "");
//      Vector outV = business.CRecocaseLogic.getKeyWords();
//      if (outV != null) {
//        for (int j=0; j<outV.size(); j++)
//          keyWordsV.add(
//            (String)
//            business.CRecocaseLogic.convertToVector(
//             (String) outV.elementAt(j)).elementAt(0)
//          );
//      }
//    }
//
//    for (int i=0; i<this.getSuccessEndcond().size(); i++) {
//
//      business.CRecocaseLogic.analyseSentence(
//        ((business.CCondition) this.getSuccessEndcond().elementAt(i)).getText(), "");
//      Vector outV = business.CRecocaseLogic.getKeyWords();
//      if (outV != null) {
//        for (int j=0; j<outV.size(); j++)
//          keyWordsV.add(
//            (String)
//            business.CRecocaseLogic.convertToVector(
//             (String) outV.elementAt(j)).elementAt(0)
//          );
//      }
//    }
//
//    for (int i=0; i<this.getFailedEndcond().size(); i++) {
//
//      business.CRecocaseLogic.analyseSentence(
//        ((business.CCondition) this.getFailedEndcond().elementAt(i)).getText(), "");
//      Vector outV = business.CRecocaseLogic.getKeyWords();
//      if (outV != null) {
//        for (int j=0; j<outV.size(); j++)
//          keyWordsV.add(
//            (String)
//            business.CRecocaseLogic.convertToVector(
//             (String) outV.elementAt(j)).elementAt(0)
//          );
//      }
//    }
//
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//
//      for (int i=0; i<this.getSuccessScenarioT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getSuccessScenarioT1().elementAt(i)).getAction(), "");
//        Vector outV = business.CRecocaseLogic.getKeyWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            keyWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//
//      for (int i=0; i<this.getExtensionT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getExtensionT1().elementAt(i)).getAction(), "");
//
//        Vector outV = business.CRecocaseLogic.getKeyWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            keyWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//
//      for (int i=0; i<this.getSubvariationT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getSubvariationT1().elementAt(i)).getAction(), "");
//        Vector outV = business.CRecocaseLogic.getKeyWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            keyWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//
//    } else {
//
//      for (int i=0; i<this.getSuccessScenarioT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getSuccessScenarioT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector outV = business.CRecocaseLogic.getKeyWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            keyWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//
//      for (int i=0; i<this.getExtensionT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getExtensionT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector outV = business.CRecocaseLogic.getKeyWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            keyWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//
//      for (int i=0; i<this.getSubvariationT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getSubvariationT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector outV = business.CRecocaseLogic.getKeyWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            keyWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//    }
//
//    return keyWordsV;
//  }

  /**
   * finds used pronouns of all conditions and scenario steps
   * @return Vector of used pronouns
   */
//  public Vector getPronouns() {
//
//    Vector pronounsV = new Vector();
//
//    for (int i=0; i<this.getPrecond().size(); i++) {
//
//      business.CRecocaseLogic.analyseSentence(
//        ((business.CCondition) this.getPrecond().elementAt(i)).getText(), "");
//      Vector wordsV = business.CRecocaseLogic.getWords();
//      if (wordsV != null) {
//        for (int j=0; j<wordsV.size(); j++) {
//          String word = (String)
//            business.CRecocaseLogic.convertToVector(
//            (String) wordsV.elementAt(j)).elementAt(0);
//
//          for (int k=0; k<business.Global.pronouns.length; k++) {
//            word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//            if (word.equals(business.Global.pronouns[k]))
//              pronounsV.add(business.Global.pronouns[k]);
//          }
//        }
//      }
//    }
//
//    for (int i=0; i<this.getSuccessEndcond().size(); i++) {
//
//      business.CRecocaseLogic.analyseSentence(
//        ((business.CCondition) this.getSuccessEndcond().elementAt(i)).getText(), "");
//      Vector wordsV = business.CRecocaseLogic.getWords();
//      if (wordsV != null) {
//        for (int j=0; j<wordsV.size(); j++) {
//          String word = (String)
//            business.CRecocaseLogic.convertToVector(
//            (String) wordsV.elementAt(j)).elementAt(0);
//
//          for (int k=0; k<business.Global.pronouns.length; k++) {
//            word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//            if (word.equals(business.Global.pronouns[k]))
//              pronounsV.add(business.Global.pronouns[k]);
//          }
//        }
//      }
//    }
//
//    for (int i=0; i<this.getFailedEndcond().size(); i++) {
//
//      business.CRecocaseLogic.analyseSentence(
//        ((business.CCondition) this.getFailedEndcond().elementAt(i)).getText(), "");
//      Vector wordsV = business.CRecocaseLogic.getWords();
//      if (wordsV != null) {
//        for (int j=0; j<wordsV.size(); j++) {
//          String word = (String)
//            business.CRecocaseLogic.convertToVector(
//            (String) wordsV.elementAt(j)).elementAt(0);
//
//          for (int k=0; k<business.Global.pronouns.length; k++) {
//            word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//            if (word.equals(business.Global.pronouns[k]))
//              pronounsV.add(business.Global.pronouns[k]);
//          }
//        }
//      }
//    }
//
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//
//      for (int i=0; i<this.getSuccessScenarioT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getSuccessScenarioT1().elementAt(i)).getAction(), "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.pronouns.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.pronouns[k]))
//                pronounsV.add(business.Global.pronouns[k]);
//            }
//          }
//        }
//      }
//
//      for (int i=0; i<this.getExtensionT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getExtensionT1().elementAt(i)).getAction(), "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.pronouns.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.pronouns[k]))
//                pronounsV.add(business.Global.pronouns[k]);
//            }
//          }
//        }
//      }
//
//      for (int i=0; i<this.getSubvariationT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getSubvariationT1().elementAt(i)).getAction(), "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.pronouns.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.pronouns[k]))
//                pronounsV.add(business.Global.pronouns[k]);
//            }
//          }
//        }
//      }
//
//    } else {
//
//      for (int i=0; i<this.getSuccessScenarioT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getSuccessScenarioT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.pronouns.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.pronouns[k]))
//                pronounsV.add(business.Global.pronouns[k]);
//            }
//          }
//        }
//      }
//
//      for (int i=0; i<this.getExtensionT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getExtensionT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.pronouns.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.pronouns[k]))
//                pronounsV.add(business.Global.pronouns[k]);
//            }
//          }
//        }
//      }
//
//      for (int i=0; i<this.getSubvariationT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getSubvariationT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.pronouns.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.pronouns[k]))
//                pronounsV.add(business.Global.pronouns[k]);
//            }
//          }
//        }
//      }
//    }
//
//    return pronounsV;
//  }

  /**
   * finds used pronouns of all conditions and scenario steps
   * ... not finished
   * @return Vector of used pronouns
   */
//  public Vector getModalVerbs() {
//
//    Vector modalVerbsV = new Vector();
//
//    for (int i=0; i<this.getPrecond().size(); i++) {
//
//      business.CRecocaseLogic.analyseSentence(
//        ((business.CCondition) this.getPrecond().elementAt(i)).getText(), "");
//      Vector wordsV = business.CRecocaseLogic.getWords();
//      if (wordsV != null) {
//        for (int j=0; j<wordsV.size(); j++) {
//          String word = (String)
//            business.CRecocaseLogic.convertToVector(
//            (String) wordsV.elementAt(j)).elementAt(0);
//
//          for (int k=0; k<business.Global.modalVerbs.length; k++) {
//            word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//            if (word.equals(business.Global.modalVerbs[k]))
//              modalVerbsV.add(business.Global.modalVerbs[k]);
//          }
//        }
//      }
//    }
//
//    for (int i=0; i<this.getSuccessEndcond().size(); i++) {
//
//      business.CRecocaseLogic.analyseSentence(
//        ((business.CCondition) this.getSuccessEndcond().elementAt(i)).getText(), "");
//      Vector wordsV = business.CRecocaseLogic.getWords();
//      if (wordsV != null) {
//        for (int j=0; j<wordsV.size(); j++) {
//          String word = (String)
//            business.CRecocaseLogic.convertToVector(
//            (String) wordsV.elementAt(j)).elementAt(0);
//
//          for (int k=0; k<business.Global.modalVerbs.length; k++) {
//            word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//            if (word.equals(business.Global.modalVerbs[k]))
//              modalVerbsV.add(business.Global.modalVerbs[k]);
//          }
//        }
//      }
//    }
//
//    for (int i=0; i<this.getFailedEndcond().size(); i++) {
//
//      business.CRecocaseLogic.analyseSentence(
//        ((business.CCondition) this.getFailedEndcond().elementAt(i)).getText(), "");
//      Vector wordsV = business.CRecocaseLogic.getWords();
//      if (wordsV != null) {
//        for (int j=0; j<wordsV.size(); j++) {
//          String word = (String)
//            business.CRecocaseLogic.convertToVector(
//            (String) wordsV.elementAt(j)).elementAt(0);
//
//          for (int k=0; k<business.Global.modalVerbs.length; k++) {
//            word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//            if (word.equals(business.Global.modalVerbs[k]))
//              modalVerbsV.add(business.Global.modalVerbs[k]);
//          }
//        }
//      }
//    }
//
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//
//      for (int i=0; i<this.getSuccessScenarioT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getSuccessScenarioT1().elementAt(i)).getAction(), "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.modalVerbs.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.modalVerbs[k]))
//                modalVerbsV.add(business.Global.modalVerbs[k]);
//            }
//          }
//        }
//      }
//
//      for (int i=0; i<this.getExtensionT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getExtensionT1().elementAt(i)).getAction(), "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.modalVerbs.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.modalVerbs[k]))
//                modalVerbsV.add(business.Global.modalVerbs[k]);
//            }
//          }
//        }
//      }
//
//      for (int i=0; i<this.getSubvariationT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getSubvariationT1().elementAt(i)).getAction(), "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.modalVerbs.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.modalVerbs[k]))
//                modalVerbsV.add(business.Global.modalVerbs[k]);
//            }
//          }
//        }
//      }
//
//    } else {
//
//      for (int i=0; i<this.getSuccessScenarioT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getSuccessScenarioT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.modalVerbs.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.modalVerbs[k]))
//                modalVerbsV.add(business.Global.modalVerbs[k]);
//            }
//          }
//        }
//      }
//
//      for (int i=0; i<this.getExtensionT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getExtensionT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.modalVerbs.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.modalVerbs[k]))
//                modalVerbsV.add(business.Global.modalVerbs[k]);
//            }
//          }
//        }
//      }
//
//      for (int i=0; i<this.getSubvariationT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getSubvariationT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//              (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.modalVerbs.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.modalVerbs[k]))
//                modalVerbsV.add(business.Global.modalVerbs[k]);
//            }
//          }
//        }
//      }
//    }
//    return modalVerbsV;
// }

/**
 * find in the sentenses of this use case viewpoint
 * @return String Errors found in the sentenses of this use case viewpoint
 */

//  public String preVerifyViewpoint() {
//      Vector Simbols = new Vector();
//      Vector Pronouns = new Vector();
//      Vector PossessivePronouns = new Vector();
//      Vector ModalVerbs = new Vector();
//      boolean IfThen = false;
//      boolean pass = true;
//    //vector containg CSteps
//    Vector allSteps = new Vector();
//
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//        allSteps.add( getSuccessScenarioT1());
//    }else{
//        allSteps.add( getSuccessScenarioT2());
//    }
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//        allSteps.add(getExtensionT1());
//    }else{
//        allSteps.add(getExtensionT2());
//    }
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//        allSteps.add(getSubvariationT1());
//    }else{
//        allSteps.add( getSubvariationT2());
//    }
//
//    Vector steps;
//
//    steps = new Vector();
//    for(int v=0 ; v<allSteps.size() ; v++){
//      steps = (Vector) allSteps.elementAt(v);
//      for (int i = 0 ; i<steps.size() ; i++){
//              Sentence step = new Sentence( ((CStep) steps.elementAt(i)).getAction());
//              Vector results;
//
//              results = step.CheckForSimbols();
//              for (int j = 0 ; j<results.size() ; j++)
//                 Simbols.add ("\n line:"+((business.CStep)steps.elementAt(i)).getStep()+" : "+ results.elementAt(j));
//
//              results = step.CheckForPronouns();
//              for (int j = 0 ; j<results.size() ; j++) Pronouns.add (results.elementAt(j));
//
//              results = step.CheckForPossessivePronouns();
//              for (int j = 0 ; j<results.size() ; j++) PossessivePronouns.add (results.elementAt(j));
//
//              results = step.CheckForModalVerbs();
//              for (int j = 0 ; j<results.size() ; j++) ModalVerbs.add (results.elementAt(j));
//
//              if( step.CheckForIfThen() != 0 ) IfThen = true;
//
//      }//each step
//    }//all steps
//
//
//    //Vectors containg Strings
//    allSteps = new Vector();
//    allSteps.add(getPrecond());
//    allSteps.add(getSuccessEndcond());
//    allSteps.add(getFailedEndcond());
//
//
//    steps = new Vector();
//    for(int v=0 ; v<allSteps.size() ; v++){
//      steps = (Vector) allSteps.elementAt(v);
//      for (int i = 0 ; i<steps.size() ; i++){
//              Sentence step = new Sentence( ((business.CCondition) steps.elementAt(i)).getText());
//              Vector results;
//              results = step.CheckForSimbols();
//              for (int j = 0 ; j<results.size() ; j++)
//                Simbols.add (results.elementAt(j));
//
//              results = step.CheckForPronouns();
//              for (int j = 0 ; j<results.size() ; j++)
//                Pronouns.add (results.elementAt(j));
//
//              results = step.CheckForPossessivePronouns();
//              for (int j = 0 ; j<results.size() ; j++)
//                PossessivePronouns.add (results.elementAt(j));
//
//              results = step.CheckForModalVerbs();
//              for (int j = 0 ; j<results.size() ; j++)
//                ModalVerbs.add (results.elementAt(j));
//
//              if( step.CheckForIfThen() != 0 )
//                IfThen = true;
//
//      }//each step
//    }//all steps
//
//      //adding them all up
//          String Errors = "";
//          if(Simbols.size() != 0)
//          {
//            Errors = Errors + "*Do not use simbols\n";
//            Errors = Errors + "     found:";
//            for (int i = 0 ; i < Simbols.size() ; i++)
//            {
//              Errors = Errors + ((String) Simbols.elementAt(i));
//            }
//            Errors = Errors + "\n\n\n";
//            pass = false;
//          }
//          if(Pronouns.size() != 0)
//          {
//            Errors = Errors +"*Check for Pronouns\n";
//            Errors = Errors + "     found:";
//            for (int i = 0 ; i < Pronouns.size() ; i++)
//            {
//              Errors = Errors + ((String) Pronouns.elementAt(i));
//            }
//            Errors = Errors + "\n\n\n";
//          }
//          if(PossessivePronouns.size() != 0)
//          {
//            Errors = Errors +"*Check for Possesive Pronouns\n";
//            Errors = Errors + "     found:";
//            for (int i = 0 ; i < PossessivePronouns.size() ; i++)
//            {
//              Errors = Errors + ((String) PossessivePronouns.elementAt(i));
//            }
//            Errors = Errors + "\n\n\n";
//          }
//          if(ModalVerbs.size() != 0)
//          {
//            Errors = Errors +"*Check for Modal Verbs\n";
//            Errors = Errors + "     found:";
//            for (int i = 0 ; i < ModalVerbs.size() ; i++)
//            {
//              Errors = Errors + ((String) ModalVerbs.elementAt(i));
//            }
//            Errors = Errors + "\n\n\n";
//          }
//          if(IfThen){
//            Errors = Errors +"*Do not use \n"
//                            +"           #.a      | if [state] then [action] \n"
//                            +"      insted use \n"
//                            +"           #.a      | if [state]\n"
//                            +"           #.a.1   | [action]\n\n";
//            pass = false;}
//
//      if (Errors.equals("")){
//          return "No Errors found";
//      }else{
//          return Errors;
//      }
//  }



//  public String preVerifyViewpoint() {
//      Vector Simbols = new Vector();
//      Vector Pronouns = new Vector();
//      Vector PossessivePronouns = new Vector();
//      Vector ModalVerbs = new Vector();
//      boolean IfThen = false;
//      boolean pass = true;
//    //vector containg CSteps
//    Vector allSteps = new Vector();
//
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//        allSteps.add( getSuccessScenarioT1());
//    }else{
//        allSteps.add( getSuccessScenarioT2());
//    }
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//        allSteps.add(getExtensionT1());
//    }else{
//        allSteps.add(getExtensionT2());
//    }
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//        allSteps.add(getSubvariationT1());
//    }else{
//        allSteps.add( getSubvariationT2());
//    }
//
//    Vector steps;
//
//    steps = new Vector();
//    for(int v=0 ; v<allSteps.size() ; v++){
//      steps = (Vector) allSteps.elementAt(v);
//      for (int i = 0 ; i<steps.size() ; i++){
//              Sentence step = new Sentence( ((CStep) steps.elementAt(i)).getAction());
//              Vector results;
//
//              results = step.CheckForSimbols();
//              for (int j = 0 ; j<results.size() ; j++)
//                 Simbols.add ("\n line:"+((business.CStep)steps.elementAt(i)).getStep()+" : "+ results.elementAt(j));
//
//              results = step.CheckForPronouns();
//              for (int j = 0 ; j<results.size() ; j++) Pronouns.add (results.elementAt(j));
//
//              results = step.CheckForPossessivePronouns();
//              for (int j = 0 ; j<results.size() ; j++) PossessivePronouns.add (results.elementAt(j));
//
//              results = step.CheckForModalVerbs();
//              for (int j = 0 ; j<results.size() ; j++) ModalVerbs.add (results.elementAt(j));
//
//              if( step.CheckForIfThen() != 0 ) IfThen = true;
//
//      }//each step
//    }//all steps
//
//
//    //Vectors containg Strings
//    allSteps = new Vector();
//    allSteps.add(getPrecond());
//    allSteps.add(getSuccessEndcond());
//    allSteps.add(getFailedEndcond());
//
//
//    steps = new Vector();
//    for(int v=0 ; v<allSteps.size() ; v++){
//      steps = (Vector) allSteps.elementAt(v);
//      for (int i = 0 ; i<steps.size() ; i++){
//              Sentence step = new Sentence( ((business.CCondition) steps.elementAt(i)).getText());
//              Vector results;
//              results = step.CheckForSimbols();
//              for (int j = 0 ; j<results.size() ; j++)
//                Simbols.add (results.elementAt(j));
//
//              results = step.CheckForPronouns();
//              for (int j = 0 ; j<results.size() ; j++)
//                Pronouns.add (results.elementAt(j));
//
//              results = step.CheckForPossessivePronouns();
//              for (int j = 0 ; j<results.size() ; j++)
//                PossessivePronouns.add (results.elementAt(j));
//
//              results = step.CheckForModalVerbs();
//              for (int j = 0 ; j<results.size() ; j++)
//                ModalVerbs.add (results.elementAt(j));
//
//              if( step.CheckForIfThen() != 0 )
//                IfThen = true;
//
//      }//each step
//    }//all steps
//
//      //adding them all up
//          String Errors = "";
//          if(Simbols.size() != 0)
//          {
//            Errors = Errors + "*Do not use simbols\n";
//            Errors = Errors + "     found:";
//            for (int i = 0 ; i < Simbols.size() ; i++)
//            {
//              Errors = Errors + ((String) Simbols.elementAt(i));
//            }
//            Errors = Errors + "\n\n\n";
//            pass = false;
//          }
//          if(Pronouns.size() != 0)
//          {
//            Errors = Errors +"*Check for Pronouns\n";
//            Errors = Errors + "     found:";
//            for (int i = 0 ; i < Pronouns.size() ; i++)
//            {
//              Errors = Errors + ((String) Pronouns.elementAt(i));
//            }
//            Errors = Errors + "\n\n\n";
//          }
//          if(PossessivePronouns.size() != 0)
//          {
//            Errors = Errors +"*Check for Possesive Pronouns\n";
//            Errors = Errors + "     found:";
//            for (int i = 0 ; i < PossessivePronouns.size() ; i++)
//            {
//              Errors = Errors + ((String) PossessivePronouns.elementAt(i));
//            }
//            Errors = Errors + "\n\n\n";
//          }
//          if(ModalVerbs.size() != 0)
//          {
//            Errors = Errors +"*Check for Modal Verbs\n";
//            Errors = Errors + "     found:";
//            for (int i = 0 ; i < ModalVerbs.size() ; i++)
//            {
//              Errors = Errors + ((String) ModalVerbs.elementAt(i));
//            }
//            Errors = Errors + "\n\n\n";
//          }
//          if(IfThen){
//            Errors = Errors +"*Do not use \n"
//                            +"           #.a      | if [state] then [action] \n"
//                            +"      insted use \n"
//                            +"           #.a      | if [state]\n"
//                            +"           #.a.1   | [action]\n\n";
//            pass = false;}
//
//      if (Errors.equals("")){
//          return "No Errors found";
//      }else{
//          return Errors;
//      }
//  }
//


}


