package business;

import java.util.*;

/**
 *
 * Description: an object of this class represents a scenario viewpoint
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CViewpointSc extends CViewpoint {

  /** vp to which scenario viewpoint is attached */
  private business.CViewpointUc viewpointUc  = null;
  /** view of viewpoint agent */
  private CActor view = null;
  /** vector of agents */
  private Vector agentV = null;
  /** unstructured text of scenario steps */
  private String unstructText = null;
  /** scenario steps of type business.Global.STYLE_STRUCT_WITHOUT_ACTOR */
  private Vector stepStrT1V = null;
  /** scenario steps of type business.Global.STYLE_STRUCT_WITH_ACTOR */
  private Vector stepStrT2V = null;

  /**
   * constructor
   */
  public CViewpointSc() {
    stepStrT1V = new Vector();
    stepStrT2V = new Vector();
  }

  /**
   * constructor sets id, viewpoint agent, name, style, scenario, view, and vector of agent
   * @param AId id of scenario viewpoint
   * @param CViewpointAgent ViewpointAgent viewpoint agent
   * @param AName name of scenario viewpoint
   * @param AStyle style of scenario steps of scenario viewpoint
   *        (business.Global.STYLE_UNSTRUCT,
   *         business.Global.STYLE_STRUCT_WITHOUT_ACTOR or
   *         business.Global.STYLE_STRUCT_WITH_ACTOR)
   * @param CViewpointUc aViewpointUC a Viewpoint Use Case to which scenario viewpoint is attached
   * @param AView view of viewpoint agent
   *        (refers to an actor of the use case of the scenario ???? )
   * @param AAgentV vector of agents
   */

  public CViewpointSc(long AId,
                      business.CViewpointAgent  ViewpointAgent, //contains a CUser AOwner,
                      String AName,
                      int AStyle,
	              CViewpointUc aViewpointUc,
                      CActor AView,
                      Vector AAgentV) {

    super(AId, ViewpointAgent, AName, AStyle);

    viewpointUc = aViewpointUc;
    view = AView;
    agentV = AAgentV;

    stepStrT1V = new Vector();
    stepStrT2V = new Vector();
  }

  /**
   * returns scenario to which scenario viewpoint is attached
   * @return scenario to which scenario viewpoint is attached
   */
  public CViewpointUc getViewpointUc() {
	return viewpointUc;
  }

  /**
   * sets scenario to which scenario viewpoint is attached
   * @param AScenario scenario to which scenario viewpoint is attached
   */
  public void setViewpointUc(CViewpointUc AViewpointUc) {
    viewpointUc = AViewpointUc;
 }

 /**
   * returns view
   * @return view refering to an actor
   */
  public CActor getView() {
	return view;
  }

  /**
   * sets 'actor of use case' as view
   * @param AView view refering to an actor
   */
  public void setView(CActor AView) {
    view = AView;
  }

  /**
   * return vector of agents
   * @return vector of agents
   */
  public Vector getAgents() {
	return agentV;
  }

  /**
   * sets vector of agents
   * @param AAgentV vector of agents of type business.CAgent
   */
  public void setAgents(Vector AAgentV) {
   agentV = AAgentV;
  }

  /**
   * creates string to be able to distinguish scenario viewpoint;
   * e.g. used for tree of viewpoints (e.g. FCA)
   * @return string "viewpoint: 'name of scenario viewpoint' ['viewpoint agent']"
   */
  public String toString() {
    return new String("viewpoint SC: " + this.getName());// + " [" + this.viewpointUC().getName() + "]");
  }

  /**
   * returns the unstructured text of scenario steps
   * @return vector of scenario steps of type business.Global.STYLE_STRUCT_WITHOUT_ACTOR
   */
  public String getUnstructText() {
    return unstructText;
  }

  /**
   * sets the unstructured text of scenario steps
   * @param AUnstructText unstructured text of scenario
   */
  public void setUnstructText(String AUnstructText) {
    unstructText = AUnstructText;
  }

  /**
   * returns scenario steps of type business.Global.STYLE_STRUCT_WITHOUT_ACTOR
   * @return vector of scenario steps of type business.Global.STYLE_STRUCT_WITHOUT_ACTOR
   */
  public Vector getStepStrT1() {
    return stepStrT1V;
  }

  /**
   * sets vector of scenario steps of type business.Global.STYLE_STRUCT_WITHOUT_ACTOR
   * @param AStepStrT2V vector of scenario steps of type business.Global.STYLE_STRUCT_WITHOUT_ACTOR
   */
  public void setStepStrT1(Vector AStepStrT1V) {
    stepStrT1V = AStepStrT1V;
  }

  /**
   * returns scenario steps of type business.Global.STYLE_STRUCT_WITH_ACTOR
   * @return vector of scenario steps of type business.Global.STYLE_STRUCT_WITH_ACTOR
   */
  public Vector getStepStrT2() {
    return stepStrT2V;
  }

  /**
   * sets vector of scenario steps of type business.Global.STYLE_STRUCT_WITH_ACTOR
   * @param AStepStrT2V vector of scenario steps of type business.Global.STYLE_STRUCT_WITH_ACTOR
   */
  public void setStepStrT2(Vector AStepStrT2V) {
    stepStrT2V = AStepStrT2V;
  }

  /**
   * finds out if agent with id 'AId' is already assigned to scenario viewpoint
   * @return true if agent is already assigned to scenario viewpoint, else false
   */
  public boolean containsAgent(long AId) {

    if (agentV != null) {
      for (int i=0; i<agentV.size(); i++) {
        if (AId == ((business.CAgent) agentV.elementAt(i)).getId())
          return true;
      }
    }
     return false;
  }

  /**
   * finds out used pronouns
   * @return Vector of pronouns
   */
  public Vector getPronouns() {

    Vector pronounsV = new Vector();

    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {

      for (int i=0; i<this.getStepStrT1().size(); i++) {
        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getStepStrT1().elementAt(i)).getAction(), "");

        Vector wordsV = business.CRecocaseLogic.getWords();
        if (wordsV != null) {
          for (int j=0; j<wordsV.size(); j++) {
            String word = (String)
              business.CRecocaseLogic.convertToVector(
               (String) wordsV.elementAt(j)).elementAt(0);

            for (int k=0; k<business.Global.pronouns.length; k++) {
              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
              if (word.equals(business.Global.pronouns[k]))
                pronounsV.add(business.Global.pronouns[k]);
            }
          }
        }
      }
    } else {
      for (int i=0; i<this.getStepStrT2().size(); i++) {

        String sentence =
          ((business.CStepStrT2) this.getStepStrT2().elementAt(i)).getSentence();
        business.CRecocaseLogic.analyseSentence(
          sentence, "");

        Vector wordsV = business.CRecocaseLogic.getWords();
        if (wordsV != null) {
          for (int j=0; j<wordsV.size(); j++) {
            String word = (String)
              business.CRecocaseLogic.convertToVector(
               (String) wordsV.elementAt(j)).elementAt(0);

            for (int k=0; k<business.Global.pronouns.length; k++) {
              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
              if (word.equals(business.Global.pronouns[k]))
                pronounsV.add(business.Global.pronouns[k]);
            }
          }
        }
      }
    }

    return pronounsV;
  }

  /**
   * finds unknown words of the scenario steps
   * @return Vector of unknown words
   */
//  public Vector getUnknownWords() {
//
//    Vector unknownWordsV = new Vector();
//
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//
//      for (int i=0; i<this.getStepStrT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getStepStrT1().elementAt(i)).getAction(), "");
//        Vector outV = business.CRecocaseLogic.getUnknownWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            unknownWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//
//    } else {
//
//      for (int i=0; i<this.getStepStrT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getStepStrT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector outV = business.CRecocaseLogic.getUnknownWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            unknownWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//    }
//
//    return unknownWordsV;
//  }


  /**
   * finds keywords of the scenario steps
   * @return vector of keywords
   */
//  public Vector getKeyWords() {
//
//    Vector keyWordsV = new Vector();
//
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//
//      for (int i=0; i<this.getStepStrT1().size(); i++) {
//
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getStepStrT1().elementAt(i)).getAction(), "");
//
//        Vector outV = business.CRecocaseLogic.getKeyWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            keyWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//                (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//
//    } else {
//      for (int i=0; i<this.getStepStrT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getStepStrT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//        Vector outV = business.CRecocaseLogic.getKeyWords();
//        if (outV != null) {
//          for (int j=0; j<outV.size(); j++)
//            keyWordsV.add(
//              (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//    }
//
//    return keyWordsV;
//  }
//
//  /**
//   * finds out used modal verbs
//   * @return Vector of modal verbs
//   */
//  public Vector getModalVerbs() {
//    Vector modalVerbsV = new Vector();
//    if (this.getStyle() == business.Global.STYLE_STRUCT_WITHOUT_ACTOR) {
//
//      for (int i=0; i<this.getStepStrT1().size(); i++) {
//        business.CRecocaseLogic.analyseSentence(
//          ((business.CStep) this.getStepStrT1().elementAt(i)).getAction(), "");
//
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.modalVerbs.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.modalVerbs[k]))
//                modalVerbsV.add(business.Global.modalVerbs[k]);
//            }
//          }
//        }
//      }
//    } else {
//      for (int i=0; i<this.getStepStrT2().size(); i++) {
//
//        String sentence =
//          ((business.CStepStrT2) this.getStepStrT2().elementAt(i)).getSentence();
//        business.CRecocaseLogic.analyseSentence(
//          sentence, "");
//
//        Vector wordsV = business.CRecocaseLogic.getWords();
//        if (wordsV != null) {
//          for (int j=0; j<wordsV.size(); j++) {
//            String word = (String)
//              business.CRecocaseLogic.convertToVector(
//               (String) wordsV.elementAt(j)).elementAt(0);
//
//            for (int k=0; k<business.Global.modalVerbs.length; k++) {
//              word = word.toLowerCase(); /* added by Oscar Aguilera 09/09/2001 */
//              if (word.equals(business.Global.modalVerbs[k]))
//                modalVerbsV.add(business.Global.modalVerbs[k]);
//            }
//          }
//        }
//      }
//    }
//
//    return modalVerbsV;
//  }

  /**
   * @return use case to which scenario viewpoint is attached
   */
  public business.CUsecase getUsecase(){
  	return this.viewpointUc.getUsecase();
  }

  public String getType(){
    return business.Global.TYPE_VP_SCENARIO;
  }


}
