package business;

/**
 *
 * Description: abstract class for viewpoints
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public abstract class CViewpoint {

  /** id of viewpoint  */
  private long   id = 0;
  /** viewpoint agent */
  //private CUser  owner = null;
  private business.CViewpointAgent viewpointAgent=null;
  /** name of viewpoint */
  private String name = null;
  /** style of viewpoint */
  private int style = business.Global.STYLE_STRUCT_WITHOUT_ACTOR;
  /** constructor */
  public CViewpoint() {
  }

  /** constructor sets id, viewpoint agent, name and style
   *  @param AId id of viewpoint
   *  @param AOwner viewpoint agent of viewpoint
   *  @param name of viewpoint
   *  @param style of viewpoint
   */
  public CViewpoint(long   AId,
                    CViewpointAgent  AAgent,
                    String AName,
                    int AStyle) {

    id = AId;
    this.viewpointAgent = AAgent;
    name = AName;
    style = AStyle;
  }

  /** returns id of viewpoint
   *  @return id of viewpoint
   */
  public long getId() {
	return id;
  }

  /** sets id of viewpoint
   *  @param AId id of viewpoint
   */
  public void setId(long AId) {
    id = AId;
  }

  /** returns viewpoint user (as in login name)
   *  @return viewpoint user (as in login name)
   */
  public CUser getUser() {
	return viewpointAgent.getUser();
  }

  /**
   *  @return viewpointAgent (as in the role of the user)
   */
  public business.CViewpointAgent getViewpointAgent(){
    return viewpointAgent;
  }

  /**
   * @param ViewpointAgent: sets the viewpoint agent
   */
  public void setViewpointAgent(business.CViewpointAgent aViewpointAgent){
    viewpointAgent = aViewpointAgent;
  }

  /** returns name of viewpoint
   *  @return name of viewpoint
   */
  public String getName() {
    return name;
  }

  /** sets name of viewpoint
   *  @param AName name of viewpoint
   */
  public void setName(String AName) {
    name = AName;
  }

  /** returns style of viewpoint
   *  @return style of viewpoint
   */
  public int getStyle() {
	return style;
  }

  /** sets style of viewpoint
   *  @param AStyle style of viewpoint
   */
  public void setStyle(int AStyle) {
    style = AStyle;
  }

  public abstract String toString();
//  public abstract java.util.Vector getPronouns();
//  public abstract java.util.Vector getModalVerbs();
//  public abstract java.util.Vector getUnknownWords();
//  public abstract java.util.Vector getKeyWords();
  public abstract business.CUsecase getUsecase();
  public abstract String getType(); //Sc or UC
  //public abstract java.util.Vector checkSentenceStructure();

  public String preVerifyViewpoint() {
    return "Guide Lines:";
  }
}
