package business;

import java.util.*;
//import java.util.Vector;

/**
 *
 * Description: an object of this class represents a shared use case
 * @author Kathrin Boettger and Oscar Aguilera
 * @version 1.0
 *
 */

public class CUsecase {

  /** id of shared use case in database */
  private long id = -1;
  /** project to which shared use case is attached */
  private CProject project = null;
  /** functional requirement which is defined by shared use case */
  private String functReq = null;
  /** name of shared use case */
  private String name = null;
  /** trigger of scenario steps of shared use case */
  private String trigger = null;
  /** style of scenario steps of shared use case */
  private int style = 1;

  /** actors of shared use case */
  private Vector actorV = null;
  /** conditions which has to be valid before */
  private Vector precond = null;
  /** conditions which are valid after a successful run */
  private Vector successEndcond = null;
  /** conditions which are valid after a failed run */
  private Vector failedEndcond = null;
  /** steps of success scenario of type business.Global.STYLE_STRUCT_WITHOUT_ACTOR */
  private Vector successScenarioT1V = null;
  /** extension steps of the success scenario of
   *  type business.Global.STYLE_STRUCT_WITHOUT_ACTOR
   */
  private Vector extensionT1V = null;
  /** variations of steps of the success scenario of
   *  type business.Global.STYLE_STRUCT_WITHOUT_ACTOR
   */
  private Vector subvariationT1V = null;

  /**
   * constructor
   */
  public CUsecase() {

    precond = new Vector();
    successEndcond = new Vector();
    failedEndcond = new Vector();
    successScenarioT1V = new Vector();
    extensionT1V = new Vector();
    subvariationT1V = new Vector();
  }

  /**
   * constructor sets id, project, functional requirement, name, trigger, style, actors
   * @param AId id of shared use case
   * @param AProject project to which shared use case is attached
   * @param AName name of shared use case
   * @param ATrigger trigger of the scenario steps
   * @param AStyle style of scenario steps of shared use case
   *        (at the moment always business.Global.STYLE_STRUCT_WITHOUT_ACTOR)
   * @param AActorV vector of actors
   */
  public CUsecase(long AId,
                  CProject AProject,
                  String AFunctReq,
            	  String AName,
            	  String ATrigger,
            	  int AStyle,
            	  Vector AActorV) {



    id = AId;
    project = AProject;
    functReq = AFunctReq;
    name = AName;
    trigger = ATrigger;
    style = AStyle;
    actorV = AActorV;

    precond = new Vector();
    successEndcond = new Vector();
    failedEndcond = new Vector();
    successScenarioT1V = new Vector();
    extensionT1V = new Vector();
    subvariationT1V = new Vector();

  }

  /** returns id of shared use case in database
   *  @return id of shared use case in database
   */
  public long getId() {
	return id;
  }

  /** sets id of shared use case in database
   *  @param AId id of shared use case in database
   */
  public void setId(long AId) {
    id = AId;
  }

  /** returns project to which shared use case is attached
   *  @return project to which shared use case is attached
   */
  public CProject getProject() {
	return project;
  }

  /** sets project to which shared use case is attached
   *  @param AProject project to which shared use case is attached
   */
  public void setProject(CProject AProject) {
    project = AProject;
  }

  /** return functional requirement which is defined by shared use case
   *  @return functional requirement which is defined by shared use case
   */
  public String getFunctReq() {
	return functReq;
  }

  /** sets functional requirement which is defined by shared use case
   *  @param AFuncReq functional requirement which is defined by shared use case
   */
  public void setFunctReq(String AFunctReq) {
    functReq = AFunctReq;
  }

  /** returns name of shared use case
   *  @return name of shared use case
   */
  public String getName() {
    return name;
  }

  /** sets name of shared use case
   *  @param AName name of shared use case
   */
  public void setName(String AName) {
    name = AName;
  }

  /** returns trigger of scenario steps of shared use case
   *  @return trigger of scenario steps of shared use case
   */
  public String getTrigger() {
    return trigger;
  }

  /** sets trigger of scenario steps of shared use case
   *  @param ATrigger trigger of scenario steps of shared use case
   */
  public void setTrigger(String ATrigger) {
    trigger = ATrigger;
  }

  /** returns style of scenario steps of shared use case
   *  @return style of scenario steps of shared use case
   */
  public int getStyle() {
	return style;
  }

  /** sets style of scenario steps of shared use case
   *  @Param AStyle style of scenario steps of shared use case
   */
  public void setStyle(int AStyle) {
    style = AStyle;
  }

  /** returns vector of actors
   *  @return vector of actors
   */
  public Vector getActors() {
    return actorV;
  }

  /** sets vector of actors
   *  @param AActorV vector of actors
   */
  public void setActors(Vector AActorV) {
    actorV = AActorV;
  }

  /**
   * returns vector of conditions of type business.CCondition which has to be
   * valid before scenario starts
   * @return vector of conditions of type business.CCondition which has to be
   * valid before scenario starts
   */
  public Vector getPrecond() {
	return precond;
  }

  /** sets vector of conditions of type business.CCondition which has to be
   * valid before scenario starts
   * @param APrecond vector of conditions of type business.CCondition which has to be
   * valid before scenario starts
   */
  public void setPrecond(Vector APrecond) {
    precond = APrecond;
  }

  /** returns vector of conditions which are valid after a successful run
   *  @return vector of conditions which are valid after a successful run
   */
  public Vector getSuccessEndcond() {
	return successEndcond;
  }

  /** sets vector of conditions which are valid after a successful run
   *  @param ASuccessEndcond vector of conditions which are valid after a successful run
   */
  public void setSuccessEndcond(Vector ASuccessEndcond) {
     successEndcond = ASuccessEndcond;
  }

  /** returns vector of conditions which are valid after a failed run
   *  @return vector of conditions which are valid after a failed run
   */
  public Vector getFailedEndcond() {
	return failedEndcond;
  }

  /** sets vector of conditions which are valid after a failed run
   *  @param AFailedEndcond vector of conditions which are valid after a failed run
   */
  public void setFailedEndcond(Vector AFailedEndcond) {
     failedEndcond = AFailedEndcond;
  }

  /** return vector of success scenario steps of type business.CStepStrT1
   * @return vector of success scenario steps of type business.CStepStrT1
   */
  public Vector getSuccessScenarioT1() {
	return successScenarioT1V;
  }

  /** sets vector of success scenario steps of type business.CStepStrT1
   *  @param ASuccessScenarioT1V vector of success scenario steps of type business.CStepStrT1
   */
  public void setSuccessScenarioT1(Vector ASuccessScenarioT1V) {
     successScenarioT1V = ASuccessScenarioT1V;
  }

  /** returns vector of extensions of success scenario of type business.CStepStrT1
   *  @return vector of extensions of success scenario of type business.CStepStrT1
   */
  public Vector getExtensionT1() {
	return extensionT1V;
  }

  /** sets vector of extensions of success scenario of type business.CStepStrT1
   *  @param AExtensionT1V vector of extensions of success scenario of type business.CStepStrT1
   */
  public void setExtensionT1(Vector AExtensionT1V) {
     extensionT1V = AExtensionT1V;
  }

  /** returns vector of variations of success scenario of type business.CStepStrT1
   *  @return vector of variations of success scenario of type business.CStepStrT1
   */
  public Vector getSubvariationT1() {
	return subvariationT1V;
  }

  /** sets vector of variations of success scenario of type business.CStepStrT1
   *  @param ASubvariationT1V vector of variations of success scenario of type business.CStepStrT1
   */
  public void setSubvariationT1(Vector ASubvariationT1V) {
     subvariationT1V = ASubvariationT1V;
  }



  /** returns true if an actor with the id AId is an actor of the shared use case
   *  @param id of an actor
   *  @return true if an actor with the id AId is an actor of the shared use case
   */
  public boolean containsActor(long AId) {

    if (actorV != null) {
      for (int i=0; i<actorV.size(); i++) {
        if (AId == ((business.CActor) actorV.elementAt(i)).getId())
          return true;
      }
    }
     return false;
  }

  /** returns the actor of the shared use case of type AType, null if
   *  such an actor does not exist
   *  @param AType type of an actor
   *  @return the actor of the shared use case of type AType or null
   */
  public business.CActor getActor(String AType) {

    business.CActor actor = null;
    for (int i=0; i<this.getActors().size(); i++) {
      if (((business.CActor) this.getActors().elementAt(i)).getType().equals(AType)) {
        return (business.CActor) this.getActors().elementAt(i);
      }
    }

    return actor;
  }

  /**
   *  preVerifyViewpoint
   *  @return a string with the errors found
   */
  public String preVerifyViewpoint() {

      Vector Simbols = new Vector();
      Vector Pronouns = new Vector();
      Vector PossessivePronouns = new Vector();
      Vector ModalVerbs = new Vector();
      boolean IfThen = false;
      boolean pass = true;

//vector containg CSteps
    Vector allSteps = new Vector();

    allSteps.add(getSuccessScenarioT1());
    allSteps.add(getExtensionT1());
    allSteps.add(getSubvariationT1());

    Vector steps;

    steps = new Vector();
    for(int v=0 ; v<allSteps.size() ; v++){
      steps = (Vector) allSteps.elementAt(v);
      for (int i = 0 ; i<steps.size() ; i++){
              Sentence step = new Sentence( ((CStep) steps.elementAt(i)).getAction());

              Vector results;

              results = step.CheckForSimbols();
              for (int j = 0 ; j<results.size() ; j++)
                Simbols.add (results.elementAt(j));

              results = step.CheckForPronouns();
              for (int j = 0 ; j<results.size() ; j++)
                Pronouns.add (results.elementAt(j));

              results = step.CheckForPossessivePronouns();
              for (int j = 0 ; j<results.size() ; j++)
                PossessivePronouns.add (results.elementAt(j));

              results = step.CheckForModalVerbs();
              for (int j = 0 ; j<results.size() ; j++)
                ModalVerbs.add (results.elementAt(j));

              if( step.CheckForIfThen() != 0 )
                IfThen = true;
      }//each step
    }//all steps


    //Vectors containg Strings
    allSteps = new Vector();
    allSteps.add(getPrecond());
    allSteps.add(getSuccessEndcond());
    allSteps.add(getFailedEndcond());


    steps = new Vector();
    for(int v=0 ; v<allSteps.size() ; v++){
      steps = (Vector) allSteps.elementAt(v);
      for (int i = 0 ; i<steps.size() ; i++){
              Sentence step = new Sentence( ((business.CCondition) steps.elementAt(i)).getText());
              Vector results;
              results = step.CheckForSimbols();
              for (int j = 0 ; j<results.size() ; j++)
                Simbols.add (results.elementAt(j));

              results = step.CheckForPronouns();
              for (int j = 0 ; j<results.size() ; j++)
                Pronouns.add (results.elementAt(j));

              results = step.CheckForPossessivePronouns();
              for (int j = 0 ; j<results.size() ; j++)
                PossessivePronouns.add (results.elementAt(j));

              results = step.CheckForModalVerbs();
              for (int j = 0 ; j<results.size() ; j++)
                ModalVerbs.add (results.elementAt(j));

              if( step.CheckForIfThen() != 0 )
                IfThen = true;

      }//each step
    }//all steps

      //adding them all up
          String Errors = "";
          if(Simbols.size() != 0)
          {
            Errors = Errors + "*Do not use simbols\n";
            Errors = Errors + "     found:";
            for (int i = 0 ; i < Simbols.size() ; i++)
            {
              Errors = Errors + ((String) Simbols.elementAt(i));
            }
            Errors = Errors + "\n\n\n";
            pass = false;
          }
          if(Pronouns.size() != 0)
          {
            Errors = Errors +"*Check for Pronouns\n";
            Errors = Errors + "     found:";
            for (int i = 0 ; i < Pronouns.size() ; i++)
            {
              Errors = Errors + ((String) Pronouns.elementAt(i));
            }
            Errors = Errors + "\n\n\n";
          }
          if(PossessivePronouns.size() != 0)
          {
            Errors = Errors +"*Check for Possesive Pronouns\n";
            Errors = Errors + "     found:";
            for (int i = 0 ; i < PossessivePronouns.size() ; i++)
            {
              Errors = Errors + ((String) PossessivePronouns.elementAt(i));
            }
            Errors = Errors + "\n\n\n";
          }
          if(ModalVerbs.size() != 0)
          {
            Errors = Errors +"*Check for Modal Verbs\n";
            Errors = Errors + "     found:";
            for (int i = 0 ; i < ModalVerbs.size() ; i++)
            {
              Errors = Errors + ((String) ModalVerbs.elementAt(i));
            }
            Errors = Errors + "\n\n\n";
          }
          if(IfThen){
            Errors = Errors +"*Do not use \n"
                            +"           #.a      | if [state] then [action] \n"
                            +"      insted use \n"
                            +"           #.a      | if [state]\n"
                            +"           #.a.1   | [action]\n\n";
            pass = false;}

      if (Errors.equals("")){
          return "No Errors found";
      }else{
          return Errors;
      }
  }

  /**
   * finds keywords of all conditions and scenario steps
   * @return Vector of keywords
   */
  public Vector getKeyWords() {

    Vector keyWordsV = new Vector();


    for (int i=0; i<this.getPrecond().size(); i++) {

      business.CRecocaseLogic.analyseSentence(
        ((business.CCondition) this.getPrecond().elementAt(i)).getText(), "");
      Vector outV = business.CRecocaseLogic.getKeyWords();
      if (outV != null) {
        for (int j=0; j<outV.size(); j++)
          keyWordsV.add(
            (String)
            business.CRecocaseLogic.convertToVector(
             (String) outV.elementAt(j)).elementAt(0)
          );
      }
    }

    for (int i=0; i<this.getSuccessEndcond().size(); i++) {

      business.CRecocaseLogic.analyseSentence(
        ((business.CCondition) this.getSuccessEndcond().elementAt(i)).getText(), "");

      Vector outV = business.CRecocaseLogic.getKeyWords();
      if (outV != null) {
        for (int j=0; j<outV.size(); j++)
          keyWordsV.add(
            (String)
            business.CRecocaseLogic.convertToVector(
             (String) outV.elementAt(j)).elementAt(0)
          );
      }
    }

    for (int i=0; i<this.getFailedEndcond().size(); i++) {

      business.CRecocaseLogic.analyseSentence(
        ((business.CCondition) this.getFailedEndcond().elementAt(i)).getText(), "");
      Vector outV = business.CRecocaseLogic.getKeyWords();
      if (outV != null) {
        for (int j=0; j<outV.size(); j++)
          keyWordsV.add(
            (String)
            business.CRecocaseLogic.convertToVector(
             (String) outV.elementAt(j)).elementAt(0)
          );
      }
    }

    for (int i=0; i<this.getSuccessScenarioT1().size(); i++) {

        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getSuccessScenarioT1().elementAt(i)).getAction(), "");
        Vector outV = business.CRecocaseLogic.getKeyWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            keyWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
    }

    for (int i=0; i<this.getExtensionT1().size(); i++) {

        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getExtensionT1().elementAt(i)).getAction(), "");

        Vector outV = business.CRecocaseLogic.getKeyWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            keyWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
    }

    for (int i=0; i<this.getSubvariationT1().size(); i++) {

        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getSubvariationT1().elementAt(i)).getAction(), "");
        Vector outV = business.CRecocaseLogic.getKeyWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            keyWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
    }

    return keyWordsV;
  }



  /**
   * finds unknown words of all conditions and scenario steps
   * @return Vector of unknown words
   */
  public Vector getUnknownWords() {

    Vector unknownWordsV = new Vector();

    for (int i=0; i<this.getPrecond().size(); i++) {

      business.CRecocaseLogic.analyseSentence(
        ((business.CCondition) this.getPrecond().elementAt(i)).getText(), "");
      Vector outV = business.CRecocaseLogic.getUnknownWords();
      if (outV != null) {
        for (int j=0; j<outV.size(); j++)
          unknownWordsV.add(
            (String)
            business.CRecocaseLogic.convertToVector(
             (String) outV.elementAt(j)).elementAt(0)
          );
      }
    }

    for (int i=0; i<this.getSuccessEndcond().size(); i++) {

      business.CRecocaseLogic.analyseSentence(
        ((business.CCondition) this.getSuccessEndcond().elementAt(i)).getText(), "");
      Vector outV = business.CRecocaseLogic.getUnknownWords();
      if (outV != null) {
        for (int j=0; j<outV.size(); j++)
          unknownWordsV.add(
            (String)
            business.CRecocaseLogic.convertToVector(
             (String) outV.elementAt(j)).elementAt(0)
          );
      }
    }

    for (int i=0; i<this.getFailedEndcond().size(); i++) {

      business.CRecocaseLogic.analyseSentence(
        ((business.CCondition) this.getFailedEndcond().elementAt(i)).getText(), "");
      Vector outV = business.CRecocaseLogic.getUnknownWords();
      if (outV != null) {
        for (int j=0; j<outV.size(); j++)
          unknownWordsV.add(
            (String)
            business.CRecocaseLogic.convertToVector(
             (String) outV.elementAt(j)).elementAt(0)
          );
      }
    }

    for (int i=0; i<this.getSuccessScenarioT1().size(); i++) {

        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getSuccessScenarioT1().elementAt(i)).getAction(), "");
        Vector outV = business.CRecocaseLogic.getUnknownWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            unknownWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
    }

    for (int i=0; i<this.getExtensionT1().size(); i++) {

        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getExtensionT1().elementAt(i)).getAction(), "");
        Vector outV = business.CRecocaseLogic.getUnknownWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            unknownWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
    }

    for (int i=0; i<this.getSubvariationT1().size(); i++) {

        business.CRecocaseLogic.analyseSentence(
          ((business.CStep) this.getSubvariationT1().elementAt(i)).getAction(), "");
        Vector outV = business.CRecocaseLogic.getUnknownWords();
        if (outV != null) {
          for (int j=0; j<outV.size(); j++)
            unknownWordsV.add(
              (String)
              business.CRecocaseLogic.convertToVector(
               (String) outV.elementAt(j)).elementAt(0)
            );
        }
    }



    return unknownWordsV;
  }


  /**
   * @param sentence
   * @return a String that represents the step of the sentence
   */

  public String getStepOfSentence (String sentence){


    //type business.CStepStrT1
    Vector v = getSuccessScenarioT1();
    for(int i = 0; i < v.size() ; i++){
      business.CStep step = (business.CStep) v.elementAt(i);
      if( ((String)step.getAction()).equals(sentence)){
        return step.getStep();
      }
    }

    v = getExtensionT1() ;
    for(int i = 0; i < v.size() ; i++){
      business.CStep step = (business.CStep) v.elementAt(i);
      if( ((String)step.getAction()).equals(sentence)){
        return step.getStep();
      }
    }

    //type business.CStepStrT1
    v = getSubvariationT1();
    for(int i = 0; i < v.size() ; i++){
      business.CStep step = (business.CStep) v.elementAt(i);
      if( ((String)step.getAction()).equals(sentence)){
        return step.getStep();
      }
    }
    return null;

  }

  public String getType(){
    return business.Global.TYPE_USECASE;
  }
  /** returns a string (name of the shared use case) which is used to distinguish
   *  shared use cases (e.g. in a tree e.g. for FCA)
   */

  public String toString(){
    return "Use Case:"+ this.getName();
//    return name;
  }

   public CUsecase getUsecase() {
	return this;
  }

  /**
   * finds used pronouns of all conditions and scenario steps
   * ... not finished
   * @return Vector of used pronouns
   */
  public Vector getModalVerbs() {
    return new Vector();
  }
  /**
   * finds used pronouns of all conditions and scenario steps
   * ... not finished
   * @return Vector of used pronouns
   */
  public Vector getPronouns() {
    return new Vector();
  }



  public boolean existSentence(String sentence){
    //type business.CStepStrT1
    Vector v = getSuccessScenarioT1();
    for(int i = 0; i < v.size() ; i++){
      business.CStep step = (business.CStep) v.elementAt(i);
      if( ((String)step.getAction()).equals(sentence)){
        return true;
      }
    }

    v = getExtensionT1() ;
    for(int i = 0; i < v.size() ; i++){
      business.CStep step = (business.CStep) v.elementAt(i);
      if( ((String)step.getAction()).equals(sentence)){
        return true;
      }
    }

    //type business.CStepStrT1
    v = getSubvariationT1();
    for(int i = 0; i < v.size() ; i++){
      business.CStep step = (business.CStep) v.elementAt(i);
      if( ((String)step.getAction()).equals(sentence)){
        return true;
      }
    }
    return false;

  }

}
