package business;

import java.util.Vector;
import java.util.*;
import java.awt.event.*;
import java.awt.*;
import java.io.*;
import javax.swing.*;
/**
 * Title:        recocase
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Macquire uni
 * @author       Oscar Aguilera
 * @version 1.0
 */

public class CSynonymTable {

  private Vector phrases = new Vector();
  private Vector replacement = new Vector();

  /** constructor */
  public CSynonymTable() {
  }

  /**
   * @return size of the table
   */
  public int getSize(){
    return phrases.size();
  }

  /**
   * @return size of the table
   */
  public int size(){
    return getSize();
  }

  /**
   * @param phrace: phrase to be added to table
   * @param replacementId: id of phrase that will replace this phrase
   *                        (set to -1 if it will not be replaced)
   */
  public void addSynonym(String phrase,int replacementId){
    if(getPhraseId(phrase)== -1){
      phrases.addElement(phrase);
      replacement.addElement(new Integer(replacementId));
    }else{
      setSynonym(getPhraseId(phrase), replacementId);
    }
  }

  /**
   * @param phrace: phrase to be added to table
   * @param replacement: phrase that will replace the first phrase (phrase added to table if it does not exist)
   */
  public void addSynonym(String phrase,String replacement){
    addPhrase( phrase);
    addPhrase( replacement);
    this.setSynonym( getPhraseId(phrase),  getPhraseId(replacement));
  }

  /**
   * @param phrace: phrase to be added to table
   */
  public void addPhrase(String phrase){
    if(getPhraseId(phrase)== -1){
      phrases.addElement(phrase);
      replacement.addElement(new Integer(-1));
    }
  }

  /**
   * @param phracId:  Id of phrase to be deleted from the table
   */
  public void deletePhrase(int phraseID){
    boolean delete = true;
    for(int i = 0; i<replacement.size() && delete ; i++){
      if( ((Integer)replacement.elementAt(i)).intValue() == phraseID ){
        JOptionPane.showMessageDialog(null,"Cant Delete: this phrase is in use");
        delete = false;
      }
    }
    if(delete){
      for(int i = 0; i<replacement.size(); i++){
        int repID = ((Integer)replacement.elementAt(i)).intValue() ;
        if(repID > phraseID)  repID --;
        replacement.setElementAt( new Integer(repID),i);
      }
      if(phraseID!= -1 && phraseID < phrases.size()){
        phrases.remove(phraseID);
        replacement.remove(phraseID);
      }
    }
  }

  /**
   * @param org
   * @param rep
   * @return tue if both phrases exist
   * Not finished
   */
  public boolean setSynonym(String org,String rep){
     int replaceId = this.phrases.indexOf(rep);
     return this.setSynonym(org , replaceId);
  }
  /**
   * @param org
   * @param replaceId
   * @return tue if both phrases exist
   * Not finished
   */
  public boolean setSynonym(String org,int replaceId){
     int Id = this.phrases.indexOf(org);
     replacement.setElementAt(new Integer(replaceId), Id);
     return true;
  }

  /**
   * @param id
   * @param replaceId
   * Not finished
   * @return tue if both phrases exist
   */
  public boolean setSynonym(int id,int replaceId){
     replacement.setElementAt(new Integer(replaceId), id);
     return true;
  }

  /**
   * @param id: id of the phrace
   * @return Synonym of the phrace
   */

  public String getSynonym(int id){
    if( id >= 0 && id < phrases.size() &&
      this.getSynonymId(id) >= 0 && this.getSynonymId(id) < phrases.size())
    {
      return (String) phrases.elementAt(this.getSynonymId(id));
    }else{
      return "ERROR solution: getPhrase() insted of getSynonym() ???";
    }
  }

  /**
   * get the id of the Synonym of the phrace
   */
  public int getSynonymId(int id){
    return ((Integer) replacement.elementAt(id)).intValue();
  }

  /**
   * @param id get the id of the the phrace
   */
  public String getPhrase(int id){
    return (String) phrases.elementAt(id);
  }

  /**
   * @param phrase
   * @return id of phrase (-1 if not found)
   */
  public int getPhraseId(String phrase){
    return phrases.indexOf(phrase);
  }

  /**
   * @for debugging
   */
  public void print(){
    for(int i = 0; i<phrases.size() ; i++){
      System.out.println( i +" \t "+ getPhrase(i) +" \t "+ getSynonym(i) );
    }
  }

}