package business;

/**
 *
 * Description: an object represents a scenario step of type
 * business.Global.STYLE_STRUCT_WITH_ACTOR
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CStepStrT2 extends CStep {

  private business.CActor actor = null;
  private business.CAgent agent = null;
  private boolean systemStep = false;

  /** constructor */
  public CStepStrT2() {
    super();
  }

  /** constructor
   * @param AStep step
   */
  public CStepStrT2(business.CStep AStep) {
    super(AStep.getId(),
          AStep.getPosition(),
          AStep.getStep(),
          AStep.getAction(),
          AStep.getPhrases());
  }

  /** constructor
   *  @param AId id of step
   *  @param APosition position of the step within a scenario of steps
   *  @param AStep step of step
   *  @param AActionState action or state of step
   *  @param AActor actor, if action of actor, else null
   *  @param AAgent agent, of action of agent, else null
   *  @param ASystemStep true if step triggered by the system, else false
   */
  public CStepStrT2(long AId,
                    int APosition,
                    String AStep,
                    String AAction,
                    business.CActor AActor,
                    business.CAgent AAgent,
                    boolean ASystemStep,
                    String AExtransAction) {
    super(AId, APosition, AStep, AAction, AExtransAction);
    actor = AActor;
    agent = AAgent;
    systemStep = ASystemStep;
  }

  /** returns the actor of the action or null (used by usecase/vpuc type)
   *  @return the actor of the action or null
   */
  public business.CActor getActor() {
    return actor;
  }

  /** sets the actor of the action (used by usecase/vpuc type)
   *  @param AActor the actor of the action
   */
  public void setActor(business.CActor AActor) {

    if(actor == null || AActor == null){
      if(actor == null && AActor != null){
        this.setSentenceChanged(true);
        //System.out.println("******* true");
      }else if(actor != null && AActor == null){
        setSentenceChanged(true);
        //System.out.println("******* true");
      }
    }else if(!(actor.getType().equals( AActor.getType()))){
      setSentenceChanged(true);
      //System.out.println("******* true" + actor.getType() + " : " + AActor.getType());
    }
    actor = AActor;
  }

  /** returns the agent of the action or null(used by vpSc type)
   *  @return the agent of the action or null
   */
  public business.CAgent getAgent() {
    return agent;
  }

  /** sets the agent of the action (used by vpSc type)
   *  @param AAgent the agent of the action
   */
  public void setAgent(business.CAgent AAgent) {


    if(agent == null || AAgent == null){
      if(agent == null && AAgent != null){
        setSentenceChanged(true);
        //System.out.println("******* true");
      }else if(agent != null && AAgent == null){
        setSentenceChanged(true);
        //System.out.println("******* true");
      }
    }else if(!(agent.getName().equals( AAgent.getName()))){
      setSentenceChanged(true);
      //System.out.println("******* true" +agent.getName()+" : "+ AAgent.getName());
    }
    this.agent = AAgent;
  }

  /** sets if the action is triggered by the system
   *  @param ASystemStep true, if action is triggered by the system, else false
   */
  public void setSystemStep(boolean ASystemStep) {
    systemStep = ASystemStep;
  }

  /** returns if action is triggered by the system
   *  @return if action is triggered by the system
   */
  public boolean isSystemStep() {
    return systemStep;
  }

  /** reconstructs the sentence
   *  @return the sentence
   */
  public void setSentence(String text) {
    this.setAction(text);
  }

  public String getSentence() {

    String sentence = null;

    if (this.getAgent() != null) {
       sentence =
         "The " +
         this.getAgent().getName()
         + " " +
         this.getAction();

    }else if (this.getActor() != null) {
       sentence =
         "The " +
         this.getActor().getType()
         + " " +
         this.getAction();

    } else if (this.isSystemStep()) {

       sentence =
         "The " +
         business.Global.project.getSystem()
         + " " +
         this.getAction();
    } else {
         sentence =  this.getAction();
    }
    //if( sentence.length()<2) sentence = "The"; //cant have an empty sentence
    return sentence;
  }
}