package business;

import java.util.*;
import java.util.Vector;

/**
 *
 * Description: an object represents a scenario step
 *
 * @author Kathrin Boettger
 * modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CStep extends Sentence{

  //private boolean actionChangedValue = false;
  private static int MAX_NumberOfLevels = 20;

  /** id of step in the database */
  private long id = 0;
  /** position of step within a scenario */
  private int position = -1;
  /** number of a step;
   *  e.g. '1' for action and '1.a' for state as a result of the action
   */
  protected String step = null;
  /** action/state */
  private String actionState = null;

  /** Extrans action/state */
  //private String ExtransActionState = null;

  /** constructor */
  public CStep() {
    //super("");
    step = new String("");
    actionState = new String("");
  }

  /** constructor sets id, position, step and action/state
   *  @param AId id of the step in database
   *  @param APosition position of the step within a scenario of steps
   *  @param AStep step of step
   *  @param AActionState action or state of step
   *  @param AExtransActionState Extrans
   */
  public CStep(long AId, int APosition, String AStep, String AActionState, String Phrases) {
    //super("");
    id = AId;
    position = APosition;
    step = AStep;
    actionState = AActionState;
    this.setPhrases(Phrases);

  }



  /** returns id of step in database
   *  @return id of step in database
   */
  public long getId() {
    return id;
  }

  /** sets id of step in database
   *  @param AId id of step in database
   */
  public void setId(long AId) {
    id = AId;
  }

  /** returns position of the step within a scenario of steps
   *  @return position of the step within a scenario of steps
   */
  public int getPosition() {
    return position;
  }

  /** sets position of the step within a scenario of steps
   *  @param APosition position of the step within a scenario of steps
   */
  public void setPosition(int APosition) {
    position = APosition;
  }

  /** returns the step of the step
   *  @return the step of the step
   */
  public String getStep() {
    return step;
  }

  /** sets the step of the step
   *  @param AStep the step of the step
   */
  public void setStep(String AStep) {
    step = AStep;
  }

  /** returns action/state of the step
   *  @return action/state of the step
   */
  public String getAction() {
    //if( actionState.length()<2) actionState = "The"; //cant have an empty sentence
    return actionState;
  }

  public String getSentence() {
    return getAction();
  }


  /** sets action/state of the step
   *  @param action/state of the step
   */

  public void setSentence(String AActionState) {
    setAction(AActionState);
  }

  public void setAction(String AActionState) {
    if( actionState == null) actionState = "";
    if( AActionState == null) AActionState = "";

    if( ! actionState.equals( AActionState)){
      this.redoPhrases();
    }
    actionState = AActionState;
  }



  /** returns actor of the step
   *  @return actor of the step
   */
  public business.CActor getActor() {
    return null;
  }

  /** returns the agent of the step
   *  @return the agent of the step
   */
  public business.CAgent getAgent() {
    return null;
  }

  /** creates a new step 'action' before step
   *  @return new step 'action' before step
   */
  public business.CStep getNewActionBefore(Vector AStepV, int AIndex) {
    business.CStep newStep = null;

    char lastChar = step.charAt(step.length()-1);
    if (lastChar < 'a') { // number
      if (step.lastIndexOf('.') < 0) { // no full stop
        if (Integer.parseInt(this.getStep()) == 1)
          newStep = new business.CStep(-1, 0, new String("1"), new String(""),"");
        else
          newStep = new business.CStep(-1, 0, String.valueOf(Integer.parseInt(this.getStep())), new String(""),"");
      } else {
        String lastNum = step.substring(step.lastIndexOf('.')+1);
        if (Integer.parseInt(lastNum) == 1)
          newStep = new business.CStep(-1, 0, step.substring(0, step.lastIndexOf('.')+1) + new String("1"), new String(""),"");
        else
          newStep = new business.CStep(-1, 0, step.substring(0, step.lastIndexOf('.')+1) + String.valueOf(Integer.parseInt(lastNum)-1), new String(""),"");
      }

    } else { // character

      if (AIndex == 0) {
        newStep = new business.CStep(-1, 0, new String("1"), new String(""),"");
      } else {
        newStep = new business.CStep(-1, 0, step.substring(0, step.lastIndexOf('.')), new String(""),"");
      }
    }
    return newStep;
  }

  /** creates a new step 'action' after step
   *  @return new step 'action' after step
   */
  public business.CStep getNewActionAfter(Vector AStepV, int AIndex) {

    business.CStep newStep = null;

    char lastChar = step.charAt(step.length()-1);

    if (lastChar < 'a') { // number
      if (step.lastIndexOf('.') < 0) { // no full stop
        newStep = new business.CStep(-1, 0, String.valueOf(Integer.parseInt(this.getStep())+1), new String(""),"");
      } else {
        String lastNum = step.substring(step.lastIndexOf('.')+1);
        newStep = new business.CStep(-1, 0, step.substring(0, step.lastIndexOf('.')+1) + String.valueOf(Integer.parseInt(lastNum)+1), new String(""),"");
      }
    } else { // character
      if (step.lastIndexOf('.') < 0) { // no full stop // can't be
      } else {
        String withoutLast = step.substring(0, step.lastIndexOf('.'));
        if (withoutLast.lastIndexOf('.') < 0) {
          newStep = new business.CStep(-1, 0, String.valueOf(Integer.parseInt(withoutLast)+1), new String(""),"");
        } else {
          while (!(withoutLast.charAt(withoutLast.length()-1) < 'a')) {
            withoutLast = withoutLast.substring(0, withoutLast.lastIndexOf('.'));
          }
          if (withoutLast.lastIndexOf('.') < 0)
            newStep = new business.CStep(-1, 0, String.valueOf(Integer.parseInt(withoutLast)+1), new String(""),"");
          else
            newStep = new business.CStep(-1, 0, withoutLast.substring(0, withoutLast.lastIndexOf('.')+1) + String.valueOf(Integer.parseInt(step.substring((withoutLast.lastIndexOf('.')+1), withoutLast.length()))+1), new String(""),"");
        }
      }
    }
    return newStep;
  }

  /** creates a new substep 'action' of step
   *  @return new substep 'action' of step
   */
  public business.CStep getNewSubStep(Vector AStepV, int AIndex) {

    business.CStep newStep = null;

    char lastChar = step.charAt(step.length()-1);

    if (lastChar < 'a') { // number
      newStep = new business.CStep(-1, 0, this.getStep() + new String(".1"), new String(""),"");
    } else { // character
      newStep = new business.CStep(-1, 0, this.getStep() + new String(".1"), new String(""),"");
    }
    return newStep;
  }

  /** finds last if-condition of step
   *  @return last if-condition of step
   */
  public business.CStep findLastIfCond(Vector AAllStepV) {

    business.CStep lastIfStep = null;
    int index = AAllStepV.indexOf(this);
    int numberOfLevels = this.getNumberOfLevels();

    for (int i=index+1;
         i<AAllStepV.size();
         i++) {

      int numberOfLevelsConsideredStep =
        ((business.CStep) AAllStepV.elementAt(i)).getNumberOfLevels();
      if (numberOfLevels >= numberOfLevelsConsideredStep)
        return lastIfStep;
      if (numberOfLevels == numberOfLevelsConsideredStep-1) {
        if (!Character.isDigit(((business.CStep)
            AAllStepV.elementAt(i)).getLevel(numberOfLevels).charAt(0))) {
          lastIfStep = (business.CStep) AAllStepV.elementAt(i);
        }
      }
    }

    return lastIfStep;
  }

  /** creates new step 'if-condition' as result of step
   *  @return new step 'if-condition' as result of step
   */
  public business.CStep getIfAsResultOfStep(Vector AAllStepV) {

    business.CStep newStep = null;
    int index = AAllStepV.indexOf(this);
    int numberOfLevels = this.getNumberOfLevels();

    business.CStep lastIfStep = this.findLastIfCond(AAllStepV);

    if (lastIfStep == null) { // if-condition does not exist
      newStep =
      new business.CStep(-1, 0, this.getStep() + new String(".a"),
                         new String("If [conditions]"),"");
    } else {
      newStep =
      new business.CStep(-1, 0, this.getStep() + "." +
                         String.valueOf((char) (((int) lastIfStep.getLevel(numberOfLevels).charAt(0))+1)),
                         new String("If [conditions]"),"");
    }

    return newStep;
  }

  /** creates new step 'if-condition' after step
   *  @return new step 'if-condition' after step
   */
  public business.CStep getIfAsCondAfterStep(Vector AAllStepV) {

    business.CStep ifOfStep = null;
    business.CStep newStep = null;
    char lastChar = step.charAt(step.length()-1);

    if (Character.isDigit(lastChar)) { // number

      int lastNum;
      if (this.getStep().lastIndexOf('.') < 0) {
        lastNum = Integer.parseInt(this.getStep());
        ifOfStep = new business.CStep(-1, 0, String.valueOf(lastNum+1), "" ,"");
      } else {
        lastNum = Integer.parseInt(this.getStep().substring(this.getStep().lastIndexOf('.')+1));
        ifOfStep = new business.CStep(-1, 0,
        step.substring(0, step.lastIndexOf('.')+1) + String.valueOf(lastNum+1),"","");
      }

    } else {
      int lastInt = (int) lastChar;
      if (this.getStep().lastIndexOf('.') < 0) {
        ifOfStep = new business.CStep(-1, 0,
        String.valueOf((char) lastInt) + new String(".1"), "","");
      } else {
        ifOfStep = new business.CStep(-1, 0,
        step + new String(".1"),"","");
      }
    }

    int numberOfLevels = ifOfStep.getNumberOfLevels();
    business.CStep lastIfStep = ifOfStep.findLastIfCond(AAllStepV);

    if (lastIfStep == null) { // if-condition does not exist
      newStep =
      new business.CStep(-1, 0, ifOfStep.getStep() + new String(".a"),
                         new String("If [conditions]"),"");
    } else {
      newStep =
      new business.CStep(-1, 0, ifOfStep.getStep() + "." +
                         String.valueOf((char) (((int) lastIfStep.getLevel(numberOfLevels).charAt(0))+1)),
                         new String("If [conditions]"),"");
    }

    return newStep;
  }

  /** create new step 'repeat-while' before step
   *  @return new step 'repeat-while' before step
   */
  public business.CStep getNewRepeatWhileBefore(Vector AStepV, int AIndex) {
    business.CStep newStep = null;

    char lastChar = step.charAt(step.length()-1);

    if (lastChar < 'a') { // number
      if (step.lastIndexOf('.') < 0) { // no full stop
        if (Integer.parseInt(this.getStep()) == 1)
          newStep = new business.CStep(-1, 0, new String("0.a"), new String("Repeat while [conditions]"),"");
        else
          newStep = new business.CStep(-1, 0, String.valueOf(Integer.parseInt(this.getStep())-1) + new String(".a"), new String("Repeat while [conditions]"),"");
      } else {
        String lastNum = step.substring(step.lastIndexOf('.')+1);
        if (Integer.parseInt(lastNum) == 1)
          newStep = new business.CStep(-1, 0, step.substring(0, step.lastIndexOf('.')+1) + new String("1.a"), new String("Repeat while [conditions]"),"");
        else
          newStep = new business.CStep(-1, 0, step.substring(0, step.lastIndexOf('.')+1) + String.valueOf(Integer.parseInt(lastNum)-1) + new String(".a"), new String("Repeat while [conditions]"),"");
      }

    } else { // character
      if (step.lastIndexOf('.') < 0) { // no full stop // can't be
      } else {
        String withoutLast = step.substring(0, step.lastIndexOf('.'));
        if (withoutLast.lastIndexOf('.') < 0) {
          newStep = new business.CStep(-1, 0, String.valueOf(Integer.parseInt(withoutLast)) + step.substring(step.lastIndexOf('.')), new String("Repeat while [conditions]"),"");
        } else {
          newStep = new business.CStep(-1, 0, withoutLast.substring(0, withoutLast.lastIndexOf('.')+1) + String.valueOf(Integer.parseInt(step.substring(withoutLast.lastIndexOf('.'), step.lastIndexOf('.')))+1) + step.substring(step.lastIndexOf('.')), new String("Repeat while [conditions]"),"");
        }
      }
    }
    return newStep;
  }

  /** create new step 'repeat-while' after step
   *  @return new step 'repeat-while' after step
   */
  public business.CStep getNewRepeatWhileAfter(Vector AStepV, int AIndex) {

    business.CStep newStep = null;

    char lastChar = step.charAt(step.length()-1);

    if (lastChar < 'a') { // number
      if (step.lastIndexOf('.') < 0) { // no full stop
        newStep = new business.CStep(-1, 0, String.valueOf(Integer.parseInt(this.getStep())+1) + new String(".a"), new String("Repeat while [conditions]"),"");
      } else {
        String lastNum = step.substring(step.lastIndexOf('.')+1);
        newStep = new business.CStep(-1, 0, step.substring(0, step.lastIndexOf('.')+1) + String.valueOf(Integer.parseInt(lastNum)+1) + new String(".a"), new String("Repeat while [conditions]"),"");
      }
    } else { // character
      if (step.lastIndexOf('.') < 0) { // no full stop // can't be
      } else {
        String withoutLast = step.substring(0, step.lastIndexOf('.'));
        if (withoutLast.lastIndexOf('.') < 0) {
          newStep = new business.CStep(-1, 0, String.valueOf(Integer.parseInt(withoutLast)+1) + step.substring(step.lastIndexOf('.')), new String("Repeat while [conditions]"),"");
        } else {
          newStep = new business.CStep(-1, 0, withoutLast.substring(0, withoutLast.lastIndexOf('.')+1) + String.valueOf(Integer.parseInt(step.substring(withoutLast.lastIndexOf('.')+1, step.lastIndexOf('.')))+1) + step.substring(step.lastIndexOf('.')), new String("Repeat while [conditions]"),"");
        }
      }
    }
    return newStep;
  }

  /** create new substep 'repeat-while' of step
   *  @return new substep 'repeat-while' of step
   */
  public business.CStep getNewRepeatWhileSub(Vector AStepV, int AIndex) {
    business.CStep newStep = null;

    newStep = new business.CStep(-1, 0, step + new String(".1.a"), new String("Repeat while [conditions]") ,"");

    return newStep;
  }

  /** finds out the number of levels of step of step = number of full stops + 1
   *  @return number of levels of step of step
   */
  public String getLevel(int ALevel) {

    int index1=0;
    int index2=this.getStep().length();
    int fullStops=0;

    for (int i=0; i<this.getStep().length() && fullStops <= ALevel; i++) {
      if (this.getStep().charAt(i) == '.') {
        fullStops++;
        if (fullStops == ALevel) index1 = i+1;
        if (fullStops == ALevel+1) index2 = i;
      }
    }

    if (index2 == this.getStep().length())
      return this.getStep().substring(index1);
    else
      return this.getStep().substring(index1, index2);
  }

  /** finds out if step is following AStep
   *  @param AStep step to compare with
   *  @return true if step is following AStep
   */
  public boolean isBigger(business.CStep AStep) {

    int numberOfLevels1 = this.getNumberOfLevels();
    int numberOfLevels2 = AStep.getNumberOfLevels();
    for (int i=0; i<numberOfLevels1 && i<numberOfLevels2; i++) {

      if (Character.isDigit(this.getLevel(i).charAt(0)) &&
          Character.isDigit(AStep.getLevel(i).charAt(0))) { // number
        if (Integer.parseInt(this.getLevel(i)) >
            Integer.parseInt(AStep.getLevel(i)))
          return true;
      } else {
        if (this.getLevel(i).compareTo(AStep.getLevel(i)) > 0)
          return true;
      }
    }

    if (numberOfLevels1 > numberOfLevels2 &&
        this.getStep().startsWith(AStep.getStep())) return true;

    return false;
  }

  /** inserts step into vector AStepV before AStep
   *  @param AStepV vector into which step has to be inserted
   *  @param AStep step before which step has to be inserted
   */
  public int insertBeforeStep(Vector AStepV, business.CStep AStep) {

    int index = AStepV.indexOf(AStep);
    AStepV.insertElementAt(this, index);

    return index;
  }

  /** inserts step into vector AStepV after AStep
   *  @param AStepV vector into which step has to be inserted
   *  @param AStep step after which step has to be inserted
   */
  public int insertAfterStep(Vector AStepV, business.CStep AStep) {

    int index = AStepV.indexOf(AStep);
    index += 1;
    if (index == AStepV.size()) AStepV.add(this);
    else AStepV.insertElementAt(this, index);

    return index;
  }

  /** inserts step into vector AStepV
   *  @param AStepV vector into which step has to be inserted
   *  @return position in vector AStepV at which step has been inserted
   */
  public int insertStep(Vector AStepV) {

    boolean inserted = false;
    int i=0;
    while (i<AStepV.size() && inserted == false) {
      if (this.isBigger((business.CStep) AStepV.elementAt(i)) == false) {
        AStepV.insertElementAt(this, i);
        inserted = true;
      } else {i++;}
    }
    if (inserted == false) {
      AStepV.addElement(this);
      return AStepV.size()-1;
    }

    return i;
  }

  /** adds '1' to level ALevel of all steps after position AIndex in vector AAllStepV
   *  while number of levels of these steps is bigger than step
   *  @param AStepV vector of steps which have to be changed
   *  @param position in vector AStepV from which the steps have to be changed
   *  @param ALevel level that has to be changed
   */
  public void addToStepAtLevel(Vector AAllStepV, int AIndex, int ALevel) {


    if (ALevel < 0) return; // should not happen

    boolean finish = false;
    int index = AIndex;
    business.CStep step = null;
    while (index<AAllStepV.size() && finish == false) {

      step = (business.CStep) AAllStepV.elementAt(index);
      if (step.getNumberOfLevels() > ALevel &&
          !(Character.isDigit(this.getLevel(ALevel).charAt(0)) &&
           !Character.isDigit(step.getLevel(ALevel).charAt(0)))) {

        String newContentAtLevel = null;
        if (Character.isDigit(this.getLevel(ALevel).charAt(0)))
          newContentAtLevel =
          String.valueOf(Integer.parseInt(step.getLevel(ALevel))+1);
        else
          newContentAtLevel =
          String.valueOf((char) (((int) step.getLevel(ALevel).charAt(0))+1));

        step.setStep(step.getStringToLevel(ALevel) +
                     newContentAtLevel +
                     step.getStringFromLevel(ALevel+1));
        index++;
      } else {
        finish = true;
      }
    }
  }

  /** subtracts '1' from level ALevel of all steps after position AIndex in vector AAllStepV
   *  while number of levels of these steps is bigger than step
   *  @param AStepV vector of steps which have to be changed
   *  @param position in vector AStepV from which the steps have to be changed
   *  @param ALevel level that has to be changed
   */
  public void removeFromStepAtLevel(Vector AAllStepV, int AIndex, int ALevel) {

    boolean finish = false;
    int index = AIndex;
    business.CStep step = null;

    while (index<AAllStepV.size() && finish == false) {
      step = (business.CStep) AAllStepV.elementAt(index);
      if (step.getNumberOfLevels() > ALevel &&
          !(Character.isDigit(this.getLevel(ALevel).charAt(0)) &&
           !Character.isDigit(step.getLevel(ALevel).charAt(0)))) {

        String newContentAtLevel = null;
        if (Character.isDigit(this.getLevel(ALevel).charAt(0)))
          newContentAtLevel =
          String.valueOf(Integer.parseInt(step.getLevel(ALevel))-1);
        else
          newContentAtLevel =
          String.valueOf((char) (((int) step.getLevel(ALevel).charAt(0))-1));

        step.setStep(step.getStringToLevel(ALevel) +
                     newContentAtLevel +
                     step.getStringFromLevel(ALevel+1));

        index++;
      } else {
        finish = true;
      }
    }
  }

  /** finds out number of levels of step of step
   *  @return number of levels of step of step
   */
  public int getNumberOfLevels() {

    // = number of full stops + 1
    int numberOfLevels = 0;
    for (int i=0; i<this.getStep().length(); i++) {
      if (this.getStep().charAt(i) == '.') numberOfLevels++;
    }
    return numberOfLevels+1;
  }



  public String getStringToLevel(int ALevel) {
    if (ALevel <= 0) return new String("");
    else {
      int fullStops = 0;
      int index;
      for (index=0; index<this.getStep().length() &&
                    fullStops < ALevel; index++) {
        if (this.getStep().charAt(index) == '.') fullStops++;
      }
      return this.getStep().substring(0, index);
    }
  }

  /** creates substring of step of step from level ALevel
   *  @param ALevel first level substring
   *  @return substring of step of step from level ALevel
   */
  public String getStringFromLevel(int ALevel) {

    if (ALevel >= this.getNumberOfLevels()) return new String("");
    else {
      int fullStops = 0;
      int index;
      for (index=0; index<this.getStep().length() &&
                    fullStops < ALevel; index++) {
        if (this.getStep().charAt(index) == '.') fullStops++;
      }
      return this.getStep().substring(index-1);
    }
  }

  /** sets new substring AContent at level ALevel
   *  @param ALevel level which has to be replaced
   *  @param AContent new substring to which level ALevel has to be changed
   */
  public void setLevel(int ALevel, int AContent) {

    String newContentAtLevel = null;
    if (Character.isDigit(this.getLevel(ALevel).charAt(0)))
      newContentAtLevel = String.valueOf(AContent);
    else  newContentAtLevel = String.valueOf((char) AContent);

    this.setStep(this.getStringToLevel(ALevel) +
                 newContentAtLevel +
                 this.getStringFromLevel(ALevel+1));
  }


//  private Vector wordsV;
//  private Vector unknownWordsV;
//  private Vector keyWordsV;
//
//  public String getWordsS(){
//    String tmp = "";
//    for(int i = 0; i < wordsV.size();i++){
//      tmp = tmp +" "+wordsV.elementAt(i);
//    }
//    return tmp;
//  }
//  public Vector getWordsV(){
//    return wordsV;
//  }
//
//  public String getUnknownWordsS(){
//    String tmp = "";
//    for(int i = 0; i < unknownWordsV.size();i++){
//      tmp = tmp +" "+unknownWordsV.elementAt(i);
//    }
//    return tmp;
//  }
//  public Vector getUnknownWordsV(){
//    return unknownWordsV;
//  }
//
//  public String getKeyWordsS(){
//    String tmp = "";
//    for(int i = 0; i < keyWordsV.size();i++){
//      tmp = tmp +" "+keyWordsV.elementAt(i);
//    }
//    return tmp;
//  }
//  public Vector getKeyWordsV(){
//    return keyWordsV;
//  }
//
//
//  public void analyse(){
//      Vector AllphrasesV = new Vector();
//      Vector phrasesV;
//
//      String actors = business.CRecocaseLogic.getActorS(business.Global.project.getActors());
//      actors = actors + "-" + business.Global.project.getSystem();
//      business.CRecocaseLogic.analyseSentence(this.getSentence(),actors);
//
//      phrasesV  = business.CRecocaseLogic.convertToVector(business.CRecocaseLogic.getPhrases());
//      for (int x=0; x<phrasesV.size(); x++) {
//        String attr = (String) phrasesV.elementAt(x);
//        if(attr.equals("keyw")){
//          //System.out.println("K:" + attr);
//        }else{
//          System.out.println( attr );
//          if (!AllphrasesV.contains(attr)) AllphrasesV.add(attr);
//        }
//      }
//
//      Vector keyWords = business.CRecocaseLogic.getKeyWords();
//      if (keyWords != null) {
//        for (int x=0; x<keyWords.size(); x++) {
//          String key = (String)
//          business.CRecocaseLogic.convertToVector(
//          (String) keyWords.elementAt(x)).elementAt(0);
//          if (!AllphrasesV.contains(key)) AllphrasesV.add(key);
//        }
//      }
//      String  phrases = ", ";
//      for (int x=0; x<AllphrasesV.size(); x++) {
//        phrases = phrases + AllphrasesV.elementAt(x)+ ", ";
//      }
//      if(this.getActionChanged()) this.setExtransActionState(phrases);
//
//      wordsV = new Vector();
//      unknownWordsV= new Vector();
//      keyWordsV= new Vector();
//
//      Vector outV = business.CRecocaseLogic.getKeyWords();
//      if (outV != null) {
//        for (int j=0; j<outV.size(); j++){
//          String aa = (String) outV.elementAt(j);
//          String bb = (String) (business.CRecocaseLogic.convertToVector(aa).elementAt(0));
//          keyWordsV.add(bb);
//        }
//      }
//
//      outV = business.CRecocaseLogic.getUnknownWords();
//      if (outV != null) {
//        for (int j=0; j<outV.size(); j++){
//          String aa = (String) outV.elementAt(j);
//          String bb = (String) (business.CRecocaseLogic.convertToVector(aa).elementAt(0));
//          unknownWordsV.add(bb);
//        }
//      }
//
//      outV = business.CRecocaseLogic.getWords();
//      if (outV != null) {
//        for (int j=0; j<outV.size(); j++){
//          String aa = (String) outV.elementAt(j);
//          String bb = (String) (business.CRecocaseLogic.convertToVector(aa).elementAt(0));
//          wordsV.add(bb);
//        }
//      }
//  }//analyse
//
//
//
//  public boolean getIfThen(){
//    business.Sentence S = new       business.Sentence(this.getSentence());
//    if(S.CheckForIfThen()>0)return true; else return false;
//  }
//
//  //---
//  public Vector getModalVerbsV(){
//      business.Sentence S = new       business.Sentence(this.getSentence());
//      return S.CheckForModalVerbs();
//  }
//  public String getModalVerbsS(){
//      business.Sentence S = new       business.Sentence(this.getSentence());
//      Vector MV = S.CheckForModalVerbs();
//      String tmp = "";
//      for(int i = 0;i<MV.size();i++){
//        tmp = tmp+" "+MV.elementAt(i);
//      }
//      return tmp;
//  }
//  //---
//  public Vector getPossessivePronounsV(){
//      business.Sentence S = new       business.Sentence(this.getSentence());
//      return S.CheckForPossessivePronouns();
//  }
//  public String getPossessivePronounsS(){
//      business.Sentence S = new       business.Sentence(this.getSentence());
//      Vector MV = S.CheckForPossessivePronouns();
//      String tmp = "";
//      for(int i = 0;i<MV.size();i++){
//        tmp = tmp+" "+MV.elementAt(i);
//      }
//      return tmp;
//  }
//  //---
//  public Vector getPronounsV(){
//      business.Sentence S = new       business.Sentence(this.getSentence());
//      return S.CheckForPronouns();
//  }
//  public String getPronounsS(){
//      business.Sentence S = new       business.Sentence(this.getSentence());
//      Vector MV = S.CheckForPronouns();
//      String tmp = "";
//      for(int i = 0;i<MV.size();i++){
//        tmp = tmp+" "+MV.elementAt(i);
//      }
//      return tmp;
//  }
//  //---
//  public Vector getSimbolsV(){
//      business.Sentence S = new       business.Sentence(this.getSentence());
//      return S.CheckForSimbols();
//  }
//
//  public String getSimbolsS(){
//      business.Sentence S = new       business.Sentence(this.getSentence());
//      Vector MV = S.CheckForSimbols();
//      String tmp = "";
//      for(int i = 0;i<MV.size();i++){
//        tmp = tmp+" "+MV.elementAt(i);
//      }
//      return tmp;
//  }
//


//
//  public String getExtransActionState(){
//    if( getActionChanged() ){
//      return "";
//    }else{
//      return ExtransActionState;
//    }
//  }

//  public void setExtransActionState(String AExtransActionState ){
//    if (business.Global.DEBUG) System.out.println("set Extrans:"+AExtransActionState);
//    ExtransActionState = AExtransActionState.toLowerCase();
//    setActionChanged(false);
//  }

  /**
   * (if step has changed then extrans has to be called before saving)
   * sets actionChangedValue to true;
   */

//  public void redoExtrans(){
//    actionChangedValue = true;
//  }


  /**(if step has changed then extrans has to be called before saving)
   *@param flag change flag ActionChanged to flag(true or false)
   */
//  protected void setActionChanged(boolean flag){
//    actionChangedValue = flag;
//  }


  /**
   *@return true if action state has changed
   */
//  public boolean getActionChanged(){
//    if (business.Global.systemUnix){
//      if(ExtransActionState.equals(""))return true;//if the sentence was saved in windows (eg ExtransActionState = "" ) we need to find extrans sentences this time
//      return actionChangedValue;
//    }else{//can't use exrtans on windows
//      return false;
//    }
//  }
    public String toString(){
      return getStep()+":\t"+ getSentence();
    }
}

