package business;

import java.util.Vector;

/**
 *
 * Description: business.CExtrans is interface to RECOCASE-Logic-tool
 * and is used to convert the output of the RECOCASE-Logic-tool
 *
 * @author Kathrin Boettger modified by Oscar Aguilera
 *
 * @version 1.0
 */
public class CRecocaseLogic {

  public static String resultFile =
    new String("results.txt");
  public static String dictionaryFile =
    new String("dictionary_results.txt");
  public static String finalResultFile =
    new String("final_results.txt");
  public static String wordsFile =
    new String("words.txt");
  public static String keywordsFile =
    new String("keywords.txt");
  private static String analysePrologFile =
    new String("/home/comp/aguilera/diegos/extrans_1.7/analyse.pl");

  /**
   *  = native method to RECOCASE-Logic
   */
  public static native void analyse(String AFileData,
                                    String AFileWords,
                                    String AActors,
                                    String AFileResults,
                                    String ASaveWords);

  /**
   * initializes sicstus
   * @return sicstus-object
   */
  private static se.sics.jasper.SICStus loadSicstus() {
    se.sics.jasper.SICStus sp = null;
    try {

      if ((sp = se.sics.jasper.SICStus.getInitializedSICStus()) == null) {
        sp = new se.sics.jasper.SICStus();
        sp.load(analysePrologFile);
        sp.query("user", "start", new se.sics.jasper.SPTerm[] {});
      }

    } catch (Exception e) {
      e.printStackTrace();
    }

    return sp;
  }

  /**
   *  creates string of actors "actor_1-actor_2-...-actor_n"
   *  @param Vector of actors
   */
  public static String getActorS(Vector AActorV ) {

    String actorS = null;
    if (AActorV == null || AActorV.size() == 0) return new String("");
    else {
      actorS = ((business.CActor) AActorV.elementAt(0)).getType();
      for (int i=1; i<AActorV.size(); i++)
        actorS += "-" + ((business.CActor) AActorV.elementAt(i)).getType();
    }

    return actorS;
  }

  /**
   * creates string of agents "agent_1-agent_2-...-agent_n"
   *  @param Vector of agents
   */
  public static String getAgentS(Vector AAgentV) {

    String agentS = null;
    if (AAgentV == null || AAgentV.size() == 0) return new String("");
    else {
      agentS = ((business.CAgent) AAgentV.elementAt(0)).getName();
      for (int i=1; i<AAgentV.size(); i++)
        agentS += "-" + ((business.CAgent) AAgentV.elementAt(i)).getName();
    }

    return agentS;
  }

  /**
   *  calls RECOCASE-Logic,
   *  that
   *  analyses sentence
   *  - words
   *  - keywords
   *  - unknownWords
   *  - RECOCASE-phrases
   *  and writes output to files
   *
   *  @param ASentence sentence
   *  @param AActorsS actors
   */
  public static void analyseSentence(String ASentence, String AActorS) {
    //lowercase
    // ASentence = ASentence.toLowerCase();
    if( ASentence.length()<2) ASentence = "The"; //cant have an empty sentence
    se.sics.jasper.SICStus sp;
    se.sics.jasper.SPTerm sent;
    se.sics.jasper.SPQuery query;

    try {
      sp = loadSicstus();
      sent = new se.sics.jasper.SPTerm(sp).putString(ASentence);
      sp.query("user", "create_data_string", new se.sics.jasper.SPTerm[] {sent});

      business.CRecocaseLogic.analyse(
              business.CRecocaseLogic.resultFile,
              business.CRecocaseLogic.dictionaryFile,
              AActorS,
              business.CRecocaseLogic.finalResultFile,
              business.CRecocaseLogic.wordsFile);

    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * determines RECOCASE-phrases of sentence which was analysed before by
   * analyseSentence in format of Oscar's tool
   *
   * @return String of RECOCASE-phrases in format of Oscar's tool
   */
  public static String getPhrases() {
    se.sics.jasper.SICStus sp;
    se.sics.jasper.SPTerm file, no;
    se.sics.jasper.SPTerm resultPhrases;
    se.sics.jasper.SPQuery query;
    String result = null;
    try {
      sp = loadSicstus();
      file = new se.sics.jasper.SPTerm(sp).putString(finalResultFile);
      no = new se.sics.jasper.SPTerm(sp).putInteger(1);
      resultPhrases = new se.sics.jasper.SPTerm(sp).putVariable();
      query = sp.openQuery("user", "result_phrases",
        new se.sics.jasper.SPTerm[] {file, no, resultPhrases});
      if (business.Global.DEBUG)
        System.out.println(" ----> phrases: ");
      int i = 1;
      while (query.nextSolution()) {
        result = resultPhrases.toString();
        if (business.Global.DEBUG) {
          System.out.println("  result: " + result);
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    return result.toLowerCase();
  }

  /**
   * determines words of sentence which was analysed before by
   * analyseSentence in format of Oscar's tool
   *
   * @return Vector of words in format of Oscar's tool
   */
  public static Vector getWords() {
    se.sics.jasper.SICStus sp;
    se.sics.jasper.SPTerm file, no;
    se.sics.jasper.SPTerm resultWords;
    se.sics.jasper.SPQuery query;
    Vector result = new Vector();
    try {
      sp = loadSicstus();
      file = new se.sics.jasper.SPTerm(sp).putString(wordsFile);
      no = new se.sics.jasper.SPTerm(sp).putInteger(1);
      resultWords = new se.sics.jasper.SPTerm(sp).putVariable();
      query = sp.openQuery("user", "result_words",
        new se.sics.jasper.SPTerm[] {file, no, resultWords});
      if (business.Global.DEBUG)
        System.out.println(" ----> words: ");
      int i = 1;
      while (query.nextSolution()) {
        result.add(resultWords.toString());
        if (business.Global.DEBUG) {
          System.out.println(i + ". result: " + resultWords.toString());
          i++;
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    return result;
  }

  /**
   * determines unknown words of sentence which was analysed before by
   * analyseSentence in format of Oscar's tool
   *
   * @return Vector of unknown words in format of Oscar's tool
   */
  public static Vector getUnknownWords() {
    se.sics.jasper.SICStus sp;
    se.sics.jasper.SPTerm file, no;
    se.sics.jasper.SPTerm resultWords;
    se.sics.jasper.SPQuery query;
    Vector result = new Vector();
    try {
      sp = loadSicstus();
      file = new se.sics.jasper.SPTerm(sp).putString(wordsFile);
      no = new se.sics.jasper.SPTerm(sp).putInteger(1);
      resultWords = new se.sics.jasper.SPTerm(sp).putVariable();
      query = sp.openQuery("user", "result_words_unknown",
        new se.sics.jasper.SPTerm[] {file, no, resultWords});
      if (business.Global.DEBUG)
        System.out.println(" ----> unknown words: ");
      int i = 1;
      while (query.nextSolution()) {
        result.add(resultWords.toString());
        if (business.Global.DEBUG) {
          System.out.println(i + ". result: " + resultWords.toString());
          i++;
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    return result;
  }

  /**
   * determines key words of sentence which was analysed before by
   * analyseSentence in format of Oscar's tool
   *
   * @return Vector of keywords in format of Oscar's tool
   */
  public static Vector getKeyWords() {

    se.sics.jasper.SICStus sp;
    se.sics.jasper.SPTerm file, no;
    se.sics.jasper.SPTerm resultWords;
    se.sics.jasper.SPQuery query;
    Vector result = new Vector();
    try {
      sp = loadSicstus();
      file = new se.sics.jasper.SPTerm(sp).putString(keywordsFile);
      no = new se.sics.jasper.SPTerm(sp).putInteger(1);
      resultWords = new se.sics.jasper.SPTerm(sp).putVariable();
      query = sp.openQuery("user", "result_keywords",
        new se.sics.jasper.SPTerm[] {file, no, resultWords});
      if (business.Global.DEBUG)
        System.out.println(" ----> keywords: ");
      int i = 1;
      while (query.nextSolution()) {
        result.add(resultWords.toString());
        if (business.Global.DEBUG) {
          System.out.println(i + ". result: " + resultWords.toString());
          i++;
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    return result;
  }

  /**
   * converts output of Oscar's tool to vector of 'words'
   *
   * @return Vector of 'words'
   */
  public static Vector convertToVector(String AResultAnalyse) {
    String resultAnalyse = AResultAnalyse.substring(0);
    Vector result = new Vector();
    if (resultAnalyse == null) return null;
    else {
      resultAnalyse = resultAnalyse.replace('(', ' ');
      resultAnalyse = resultAnalyse.replace(')', ' ');
      resultAnalyse = resultAnalyse.replace('[', ' ');
      resultAnalyse = resultAnalyse.replace(']', ' ');
      resultAnalyse = resultAnalyse.replace('.', ' ');
      boolean foundFirstBlank = false;
      int begin = 0;
      for (int i=1; i<resultAnalyse.length(); i++) { // first char is blank in every case
        if (resultAnalyse.charAt(i-1) == ' ' &&
            resultAnalyse.charAt(i) != ' ' &&
            foundFirstBlank == false) {
            begin = i;
            foundFirstBlank = true;
        } else if (resultAnalyse.charAt(i) == ',' &&
                   foundFirstBlank == true) {
            foundFirstBlank = false;
            result.add(resultAnalyse.substring(begin, i));
        } else {
          // nothing
        }
      }
    }
    if (business.Global.DEBUG) {
      System.out.println(" ----> business.CRecocaseLogic.convertToVector:");
      for (int i=0; i<result.size(); i++) {
        System.out.println((String) result.elementAt(i));
      }
    }
    return result;
  }

//  public static Vector getKeyWordsV(){
//      Vector keyWordsV = new Vector();
//      Vector outV = getKeyWords();
//      if (outV != null) {
//        for (int j=0; j<outV.size(); j++)
//          keyWordsV.add(
//            (String) convertToVector(
//              (String) outV.elementAt(j)).elementAt(0)
//            );
//      }
//      return keyWordsV;
//  }
//
//  public static Vector getUnknownWordsV(){
//      Vector unknownWordsV = new Vector();
//      Vector outV = getUnknownWords();
//      if (outV != null) {
//        for (int j=0; j<outV.size(); j++){
//          unknownWordsV.add(
//            (String) convertToVector(
//              (String) outV.elementAt(j)).elementAt(0)
//            );
//        }
//      }
//      return unknownWordsV;
//  }
//
//  public static Vector getWordsV(){
//      Vector wordsV = new Vector();
//      Vector outV = getWords();
//      if (outV != null) {
//        for (int j=0; j<outV.size(); j++)
//          wordsV.add(
//            (String) convertToVector(
//              (String) outV.elementAt(j)).elementAt(0)
//            );
//      }
//      return wordsV;
//  }
//






}
