package business;

import java.util.*;

/**
 *
 * Description: an object of this class represents a project
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CProject {

  /** id of project in database */
  private long id = -1;
  /** name of the project */
  private String name = null;
  /** description of the project */
  private String description = "";//null;
  /** vector of actors of project = vector of actors of all shared use cases */
  private Vector actorV = null;
  /** name of the system */
  private String system = "";//null;

  private business.CSynonymTable synonymTable;

  /** constructor sets id, name, description and vector of actors
   *  @param AId id of project in database
   *  @param AName name of the project
   *  @param ADescription description of the project
   *  @param AActorV actors of the project
   */
  public CProject(long AId,
                  String AName,
                  String ADescription,
                  Vector AActorV) {

    id = AId;
    name = AName;
    description = ADescription;
    actorV = AActorV;
    if (actorV == null) actorV = new Vector();
    if(id>-1){
      this.synonymTable =  persistence.CSynonymTable.getSynonymTable(AId+"");
    }

  }

  /**
   * @return the projects  business.CSynonymTable
   */
  private gui.CSynonymTable synonymTableFrame = null;

  public business.CSynonymTable getSynonymTable(){
    if (this.synonymTable==null){
      return resetSynonymTable();
    }else{
      return  this.synonymTable;
    }
  }
  /**
   * @return the projects business.CSynonymTable as it is in the database
   */
  public business.CSynonymTable resetSynonymTable(){
    this.synonymTable =  persistence.CSynonymTable.getSynonymTable(this.getId()+"");
    if(synonymTableFrame != null)synonymTableFrame.dispose();
    synonymTableFrame = null;
    return  this.synonymTable;
  }

  /**
   * @return the projects gui.CSynonymTable if one does not excit one is created
   */
  public gui.CSynonymTable getSynonymTableFrame(){
    if(synonymTableFrame == null){
      synonymTableFrame = new gui.CSynonymTable(getSynonymTable());
    }
    return synonymTableFrame;
  }

  /** returns id of project
   *  @return id of project
   */
  public long getId() {
	return id;
  }

  /** sets id of project
   *  @param AId id of project
   */
  public void setId(long AId) {
	id = AId;
  }

  /** returns name of project
   *  @return name of project
   */
  public String getName() {
    return name;
  }

  /** sets name of project
   *  @param AName name of project
   */
  public void setName(String AName) {
    name = AName;
  }

  /** returns description of project
   *  @return description of project
   */
  public String getDescription() {
    return description;
  }

  /** sets description of project
   *  @param ADescription description of project
   */
  public void setDescription(String ADescription) {
    description = ADescription;
  }

  /** returns name of the system
   *  @return name of the system
   */
  public String getSystem() {
    return system;
  }

  /** sets name of the system
   *  @param name of the system
   */
  public void setSystem(String ASystem) {
    system = ASystem;
  }

  /** returns vector of actors of the project
   *  @return vector of actors of the project
   */
  public Vector getActors() {
    return actorV;
  }

  /** sets vector of actors of the project
   *  @param AActorV vector of actors of the project
   */
  public void setActors(Vector AActorV) {
    actorV = AActorV;
    if (actorV == null) actorV = new Vector();
  }
}
