package business;

import java.util.Vector;

/**
 *
 * Description: implements an observers
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CObserver implements business.IObserver {

  /** vector of listener */
  private Vector listenerV = null;

  /** type of message: read user input (from gui) */
  public static int Read_User_Input = 1;
  /** type of message: reload screen */
  public static int Reload_Screen = 2;

  /** constructor */
  public CObserver() {
    listenerV = new Vector();
  }

  /** adds listener to vector of listeners
   *  @param AListener listener
   */
  public void addListener(business.IListener AListener) {
    listenerV.add(AListener);
  }

  /** removes listener from vector of listeners
   *  @param AListener listener
   */
  public void removeListener(business.IListener AListener) {
    listenerV.remove(AListener);
  }

  /** sends message to all listener which are registered
   * @param AMessage type of message, which has to be sent
   */
  public void sendMessage(int AMessage) {
    for (int i=0; i<listenerV.size(); i++) {
      ((business.IListener)  listenerV.elementAt(i)).receiveMessage(AMessage);
    }
  }
}