package business;

/**
 *
 * Description: business.CLinkGrammar is the interface to LinkGrammar
 * and is used to analyse the sentence structure in the
 * intra-viewpoint analysis phase
 *
 * @author Kathrin Boettger
 *
 * @version 1.0
 */
public class CLinkGrammar {

  /**
   * = native method to initialize LinkGrammar
   */
  public static native void initLinkGrammar();

  /**
   * = native method to finish LinkGrammar
   */
  public static native void endLinkGrammar();

  /**
   * = native method providing the sentence structure (S, NP, VP, ...)
   * @param ASentence sentence
   */
  public static native String getSentenceStructure(String ASentence);

  /**
   * analyses sentence structure (S, NP, VP, ...)
   */
  public static String checkSentenceStructure(String ASentence) {

    System.out.println(" ----> business.CLinkGrammar.checkSentenceStructure:");
      System.out.println("  of sentence: " + ASentence);
    String sentenceStructure = business.CLinkGrammar.getSentenceStructure(ASentence);
    System.out.println("   sentence structure: " + sentenceStructure);

    return null;
  }


}