package business;

import java.util.*;
import java.util.Vector;


 /**
  *
  * Description: an object represents a condition
  *
  * @author Kathrin Boettger
  *
  * @version 1.0
  */
public class CCondition extends Sentence {

  long id = -1;
  int number = -1;
  String text = "";
  String extrans = "";
  boolean textChanged = false;

  /** constructor */
  public CCondition() {
    text = new String("");
  }

  /** constructor sets id, number and text
   *  @param AId id of the condition in database
   *  @param ANumber number of the condition within a set of conditions
   *  @param AText text of the condition
   */
  public CCondition(long AId, int ANumber, String AText, String Aextrans ) {
    id = AId;
    number = ANumber;
    text = AText;
    extrans = Aextrans;

  }

  /** returns the id of the condition in the database
   *  @return the id of the condition in the database
   */
  public long getId() {
    return id;
  }

  /** sets the id of the condition in the database
   *  @param AId the id of the condition in the database
   */
  public void setId(long AId) {
    id = AId;
  }

  /** returns the number of the condition within a set of conditions
   *  @return the number of the condition within a set of conditions
   */
  public int getNumber() {
    return number;
  }

  /** sets the number of the condition within a set of conditions
   *  @param ANumber the number of the condition within a set of conditions
   */
  public void setNumber(int ANumber) {
    number = ANumber;
  }

  /** returns the text of the condition within a set of conditions
   *  @return the text of the condition within a set of conditions
   */
  public String getSentence() {
    return getText();
  }
  /** returns the text of the condition within a set of conditions
   *  @return the text of the condition within a set of conditions
   */
  public String getText() {
    return text;
  }

  /** sets the text of the condition within a set of conditions
   *  @param AText the text of the condition within a set of conditions
   */
  public void setSentence(String AText) {
     setText(AText);
  }
  public void setText(String AText) {
    if (AText != null && text != null){
      if(!text.equals(AText)){
        this.setSentenceChanged(true);
      }
    }
    text = AText;
  }


  /**
   *  @returns true if the text has changed
   */
//  public boolean getTextChanged(){
//   return textChanged;
//  }

  /**
   *  @param AtextChanged sets flag "textchanged"
   */
//  public void setTextChanged(boolean  AtextChanged){
//    textChanged = AtextChanged ;
//  }

  /**
   * set Extrans text
   */
//  public void setExtransText(String AText) {
//    extrans = AText.toLowerCase();
//    setTextChanged(false);
//  }
  /**
   * get Extrans text
   */


//  public String getExtransText() {
//    return extrans;
//  }
//
//
//  public boolean getIfThen(){
//    business.Sentence S = new business.Sentence(this.getText());
//    if(S.CheckForIfThen()>0)return true; else return false;
//  }
//
//  public Vector getModalVerbsV(){
//      business.Sentence S = new       business.Sentence(this.getText());
//      return S.CheckForModalVerbs();
//  }
//  public String getModalVerbsS(){
//      business.Sentence S = new       business.Sentence(this.getText());
//      Vector MV = S.CheckForModalVerbs();
//      String tmp = "";
//      for(int i = 0;i<MV.size();i++){
//        tmp = tmp+" "+MV.elementAt(i);
//      }
//      return tmp;
//  }
//  //---
//  public Vector getPossessivePronounsV(){
//      business.Sentence S = new       business.Sentence(this.getText());
//      return S.CheckForPossessivePronouns();
//  }
//  public String getPossessivePronounsS(){
//      business.Sentence S = new       business.Sentence(this.getText());
//      Vector MV = S.CheckForPossessivePronouns();
//      String tmp = "";
//      for(int i = 0;i<MV.size();i++){
//        tmp = tmp+" "+MV.elementAt(i);
//      }
//      return tmp;
//  }
//  //---
//  public Vector getPronounsV(){
//      business.Sentence S = new       business.Sentence(this.getText());
//      return S.CheckForPronouns();
//  }
//  public String getPronounsS(){
//      business.Sentence S = new       business.Sentence(this.getText());
//      Vector MV = S.CheckForPronouns();
//      String tmp = "";
//      for(int i = 0;i<MV.size();i++){
//        tmp = tmp+" "+MV.elementAt(i);
//      }
//      return tmp;
//  }
//  //---
//  public Vector getSimbolsV(){
//      business.Sentence S = new       business.Sentence(this.getText());
//      return S.CheckForSimbols();
//  }
//
//  public String getSimbolsS(){
//      business.Sentence S = new       business.Sentence(this.getText());
//      Vector MV = S.CheckForSimbols();
//      String tmp = "";
//      for(int i = 0;i<MV.size();i++){
//        tmp = tmp+" "+MV.elementAt(i);
//      }
//      return tmp;
//  }



}
