package business;

 /**
  *
  * Description: an object represents an actor
  *
  * @author Kathrin Boettger modyfied by Oscar Aguilera
  *
  * @version 1.0
  */
public class CActor {

  private long id = -1;
  private String type = null;
  private String description = null;

  /** constructor */
  public CActor() {
    type = new String("");
  }

  /** constructor
   *  @param AId id of the actor in the database
   *  @param AType type of actor
   *  @param ADescription description of the actor (not used)
   */
  public CActor(long AId,
                String AType,
                String ADescription) {

	id = AId;
	type = AType;
	description = ADescription;
  }

  /** returns the id of the actor in the database
   *  @return the id of the actor in the database
   */
  public long getId() {
	return id;
  }

  /** sets the id of the actor in the database
   *  @param AId the id of the actor in the database
   */
  public void setId(long AId) {
    id = AId;
  }

  /** returns the type of the actor in the database
   *  @return the type of the actor in the database
   */
  public String getType() {
	return type;
  }

  /** sets the type of the actor in the database
   *  @param AType the type of the actor in the database
   */
  public void setType(String AType) {
    type = AType;
  }

  /** returns the description of the actor in the database
   *  @return the description of the actor in the database
   */
  public String getDescription() {
	return description;
  }
  /** returns the description of the actor in the database
   *  @param the description of the actor in the database
   */
  public void setDescription(String des) {
    description = des;
  }

  public String toString() {
    return type;
  }
}
