/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jasper;

import se.sics.jasper.AtomRegisterFailure;
import se.sics.jasper.ConversionFailedException;
import se.sics.jasper.IllegalTermException;
import se.sics.jasper.NativeCodeException;
import se.sics.jasper.SICStus;
import se.sics.jasper.SPCanonicalAtom;
import se.sics.jasper.SPException;
import se.sics.jasper.SPQuery;

public class SPTerm {
    SICStus sp;
    long nativeTermRef = 0L;
    SPTerm next;
    SPQuery context;
    Thread creating_thread = null;
    boolean fromGlue;
    public static final int SP_TYPE_VARIABLE = 1;
    public static final int SP_TYPE_INTEGER = 2;
    public static final int SP_TYPE_ATOM = 3;
    public static final int SP_TYPE_FLOAT = 4;
    public static final int SP_TYPE_COMPOUND = 5;
    static final long SP_ILLEGAL_TERM_REF = 0L;

    SPTerm() {
        this.initSPTerm(SICStus.spGlobal, true);
    }

    SPTerm(long l) {
        SICStus sICStus = SICStus.spGlobal;
        this.initSPTerm(sICStus, l, true);
    }

    public SPTerm(SICStus sICStus) {
        this.initSPTerm(sICStus);
    }

    public SPTerm(SICStus sICStus, double d) {
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            this.initSPTerm(sICStus);
            try {
                this.putFloat(d);
            }
            catch (ConversionFailedException conversionFailedException) {
            }
            catch (IllegalTermException illegalTermException) {}
        }
    }

    public SPTerm(SICStus sICStus, float f) {
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            this.initSPTerm(sICStus);
            try {
                this.putFloat(f);
            }
            catch (ConversionFailedException conversionFailedException) {
            }
            catch (IllegalTermException illegalTermException) {}
        }
    }

    public SPTerm(SICStus sICStus, int n) {
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            this.initSPTerm(sICStus);
            try {
                this.putInteger(n);
            }
            catch (ConversionFailedException conversionFailedException) {
            }
            catch (IllegalTermException illegalTermException) {}
        }
    }

    public SPTerm(SICStus sICStus, String string) throws ConversionFailedException {
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            this.initSPTerm(sICStus);
            try {
                this.putString(string);
            }
            catch (IllegalTermException illegalTermException) {}
        }
    }

    public SPTerm(SICStus sICStus, String string, int n, SPTerm[] sPTermArray) throws ConversionFailedException {
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            this.initSPTerm(sICStus);
            try {
                this.consFunctor(string, sPTermArray);
            }
            catch (IllegalTermException illegalTermException) {}
        }
    }

    public SPTerm(SICStus sICStus, String string, SPTerm[] sPTermArray) throws ConversionFailedException {
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            this.initSPTerm(sICStus);
            try {
                this.consFunctor(string, sPTermArray);
            }
            catch (IllegalTermException illegalTermException) {}
        }
    }

    public SPTerm(SICStus sICStus, SPTerm sPTerm) throws IllegalTermException, ConversionFailedException {
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            this.initSPTerm(sICStus);
            this.putTerm(sPTerm);
        }
    }

    final void CheckPut() throws IllegalTermException {
        if (this.age() < this.sp.age()) {
            if (this.debugging()) {
                SICStus.dbgPrintln("** Warning putting term (age " + this.sp.age() + ") into SPTerm (age " + this.age() + ")");
            }
            if (this.shouldCheckAge()) {
                throw new IllegalTermException(this.sp);
            }
        }
    }

    final void CheckPut(SPTerm sPTerm) throws IllegalTermException {
        if (this.age() < sPTerm.termAge()) {
            if (this.debugging()) {
                SICStus.dbgPrintln("** Warning putting SPTerm (age=" + sPTerm.age() + ", termAge=" + sPTerm.termAge() + ") into SPTerm (age " + this.age() + ")");
            }
            if (this.shouldCheckAge()) {
                throw new IllegalTermException(this.sp);
            }
        }
    }

    public void CheckValid() throws IllegalTermException {
        if (!this.isValid()) {
            if (this.debugging()) {
                SICStus.dbgPrintln("!SPTerm.isValid");
            }
            throw new IllegalTermException(this.sp);
        }
    }

    public void CheckValid(SICStus sICStus) throws IllegalTermException {
        if (!this.isValid(sICStus)) {
            if (this.debugging()) {
                SICStus.dbgPrintln("!SPTerm.isValid");
            }
            throw new IllegalTermException(this.sp);
        }
    }

    long GetNativeTermRef() throws IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            long l = this.nativeTermRef;
            Object var4_3 = null;
            return l;
        }
    }

    final int age() {
        return this.context == null ? 0 : this.context.age();
    }

    public int compare(SPTerm sPTerm) throws IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            sPTerm.CheckValid(this.sp);
            int n = this.spCompare(this.sp, this.nativeTermRef, sPTerm.nativeTermRef);
            Object var4_4 = null;
            return n;
        }
    }

    public SPTerm consFunctor(String string, int n, SPTerm[] sPTermArray) throws ConversionFailedException, IllegalTermException {
        return this.consFunctor(string, sPTermArray);
    }

    public SPTerm consFunctor(String string, SPTerm[] sPTermArray) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            if (sPTermArray.length > 0) {
                this.CheckPut();
            }
            try {
                this.spConsFunctor(this.sp, this.nativeTermRef, this.spGetAtomFromString(this.sp, string), this.sp.termArrayToLongArray(sPTermArray));
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to compound term");
            }
            SPTerm sPTerm = this;
            Object var5_5 = null;
            return sPTerm;
        }
    }

    public SPTerm consList(SPTerm sPTerm, SPTerm sPTerm2) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            this.CheckPut();
            sPTerm.CheckValid(this.sp);
            sPTerm2.CheckValid(this.sp);
            try {
                this.spConsList(this.sp, this.nativeTermRef, sPTerm.nativeTermRef, sPTerm2.nativeTermRef);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to list");
            }
            SPTerm sPTerm3 = this;
            Object var5_5 = null;
            return sPTerm3;
        }
    }

    private boolean debugging() {
        return this.debugging(1);
    }

    private boolean debugging(int n) {
        return n > 0 && this.sp != null && this.sp.debugging(n);
    }

    public void delete() throws SPException {
        this.delete(this.sp.reuseTermRefs());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void delete(boolean bl) throws SPException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            if (!this.isValid()) {
                return;
            }
            if (this.fromGlue) {
                throw new SPException(this.sp, 0, "Attempt to delete glue SPTerm");
            }
            long l = this.nativeTermRef;
            this.invalidate();
            if (!bl) return;
            this.unlink();
            this.spPutString(this.sp, l, "[]");
            this.context.reuseTermRef(l);
            return;
        }
    }

    void dumpTermStack() {
        SICStus.dbgPrintln("Term stack dump:");
        SPTerm sPTerm = this;
        sPTerm = this;
        while (sPTerm != null) {
            SICStus.dbgPrintln("Term " + sPTerm.superToString() + " nativeTermRef=" + sPTerm.nativeTermRef + " context=" + sPTerm.context);
            sPTerm = sPTerm.next;
        }
    }

    public SPTerm getArg(int n, SPTerm sPTerm) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            sPTerm.CheckValid(this.sp);
            try {
                this.spGetArg(this.sp, n, this.nativeTermRef, sPTerm.nativeTermRef);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "compound term to argument");
            }
            SPTerm sPTerm2 = this;
            Object var5_5 = null;
            return sPTerm2;
        }
    }

    public long getAtom() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                long l = this.spGetAtom(this.sp, this.nativeTermRef);
                Object var4_3 = null;
                return l;
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "term to atom (canonical)");
            }
        }
    }

    public SPCanonicalAtom getCanonicalAtom() throws ConversionFailedException, AtomRegisterFailure, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                SPCanonicalAtom sPCanonicalAtom = new SPCanonicalAtom(this.sp, this.spGetAtom(this.sp, this.nativeTermRef));
                Object var3_3 = null;
                return sPCanonicalAtom;
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "term to atom (canonical)");
            }
        }
    }

    public double getDouble() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                double d = this.spGetFloat(this.sp, this.nativeTermRef);
                Object var4_3 = null;
                return d;
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "term to double");
            }
        }
    }

    public int getFunctorArity() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                int n = this.spGetFunctorArity(this.sp, this.nativeTermRef);
                Object var3_3 = null;
                return n;
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "functor to arity");
            }
        }
    }

    public String getFunctorName() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                String string = this.spGetStringFromAtom(this.sp, this.spGetFunctorCanonical(this.sp, this.nativeTermRef));
                Object var3_3 = null;
                return string;
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "functor to canonical atom");
            }
        }
    }

    public long getInteger() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                long l = this.spGetInteger(this.sp, this.nativeTermRef);
                Object var4_3 = null;
                return l;
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "term to integer");
            }
        }
    }

    public SPTerm getList(SPTerm sPTerm, SPTerm sPTerm2) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            sPTerm.CheckValid(this.sp);
            sPTerm2.CheckValid(this.sp);
            try {
                this.spGetList(this.sp, this.nativeTermRef, sPTerm.nativeTermRef, sPTerm2.nativeTermRef);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "list to head/tail");
            }
            SPTerm sPTerm3 = this;
            Object var5_5 = null;
            return sPTerm3;
        }
    }

    public String getListChars() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                String string = this.spGetListChars(this.sp, this.nativeTermRef);
                Object var3_3 = null;
                return string;
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "list of character to string");
            }
        }
    }

    public String getNumberChars() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                String string = this.spGetNumberChars(this.sp, this.nativeTermRef);
                Object var3_3 = null;
                return string;
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "number to string");
            }
        }
    }

    public Object getObject() throws NativeCodeException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            Object object = this.spGetObject(this.sp, this.nativeTermRef);
            Object var3_3 = null;
            return object;
        }
    }

    public String getString() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                String string = this.spGetString(this.sp, this.nativeTermRef);
                Object var3_3 = null;
                return string;
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to atom (string)");
            }
        }
    }

    private void initSPTerm(SICStus sICStus) {
        this.initSPTerm(sICStus, false);
    }

    private void initSPTerm(SICStus sICStus, long l) {
        this.initSPTerm(sICStus, l, false);
    }

    private void initSPTerm(SICStus sICStus, long l, boolean bl) {
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            this.nativeTermRef = l;
            this.sp = sICStus;
            if (this.debugging(2)) {
                this.creating_thread = Thread.currentThread();
                SICStus.dbgPrintln("Created " + (bl ? "glue " : "") + "SPTerm " + this.superToString() + " nativeTermRef==" + l + " in Thread " + this.creating_thread.getName());
            }
            this.fromGlue = bl;
            this.next = sICStus.term_stack;
            sICStus.term_stack = this;
            this.context = sICStus.query_stack;
            if (this.context != null && this.context.term_stack_mark != null && this.context.term_stack_mark.nativeTermRef >= l) {
                String string = "** ERROR: Internal Jasper Error: ! (this.context.term_stack_mark.nativeTermRef (" + this.context.term_stack_mark.nativeTermRef + ") < nativeTermRef (" + l + ")";
                if (this.debugging()) {
                    SICStus.dbgPrintln(string);
                    this.dumpTermStack();
                    sICStus.query_stack.dumpQueryStack();
                }
                throw new NullPointerException(string);
            }
        }
    }

    private void initSPTerm(SICStus sICStus, boolean bl) {
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            long l = sICStus.makeTermRef();
            this.initSPTerm(sICStus, l, bl);
        }
    }

    void invalidate() {
        if (this.debugging(2)) {
            SICStus.dbgPrintln("Invalidate " + (this.fromGlue ? "glue" : "") + "SPTerm " + super.toString() + " nativeTermRef==" + this.nativeTermRef + " in " + Thread.currentThread() + (this.creating_thread == Thread.currentThread() ? "" : " Warning: creating thread was " + (this.creating_thread != null ? this.creating_thread.getName() : "null!?(ERROR)")));
            if (this.creating_thread != Thread.currentThread()) {
                Thread.currentThread();
                Thread.dumpStack();
            }
        }
        this.nativeTermRef = 0L;
    }

    public boolean isAtom() throws IllegalTermException {
        return this.type() == 3;
    }

    public boolean isAtomic() throws IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            boolean bl = this.spIsAtomic(this.sp, this.nativeTermRef);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isCompound() throws IllegalTermException {
        return this.type() == 5;
    }

    public boolean isEmptyList() throws IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            if (this.isAtom()) {
                try {
                    boolean bl = this.spGetAtom(this.sp, this.nativeTermRef) == SPCanonicalAtom.atomNil;
                    Object var3_5 = null;
                    return bl;
                }
                catch (SPException sPException) {
                    if (this.debugging()) {
                        SICStus.dbgPrintln("** Warning Exception in isEmptyList");
                    }
                    boolean bl = false;
                    Object var3_6 = null;
                    return bl;
                }
            }
            boolean bl = false;
            Object var3_7 = null;
            return bl;
        }
    }

    public boolean isFloat() throws IllegalTermException {
        return this.type() == 4;
    }

    public boolean isInteger() throws IllegalTermException {
        return this.type() == 2;
    }

    public boolean isList() throws IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            boolean bl = this.spIsList(this.sp, this.nativeTermRef);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isNumber() throws IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            boolean bl = this.spIsNumber(this.sp, this.nativeTermRef);
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isValid() {
        return this.nativeTermRef != 0L;
    }

    public boolean isValid(SICStus sICStus) {
        return this.isValid() && sICStus == this.sp;
    }

    public boolean isVariable() throws IllegalTermException {
        return this.type() == 1;
    }

    public SPTerm putAtom(long l) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                this.spPutAtom(this.sp, this.nativeTermRef, l);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to atom (canonical)");
            }
            SPTerm sPTerm = this;
            Object var5_4 = null;
            return sPTerm;
        }
    }

    public SPTerm putCanonicalAtom(SPCanonicalAtom sPCanonicalAtom) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            sPCanonicalAtom.CheckValid(this.sp);
            try {
                this.spPutAtom(this.sp, this.nativeTermRef, sPCanonicalAtom.getAtomNumber());
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to atom (canonical)");
            }
            SPTerm sPTerm = this;
            Object var4_4 = null;
            return sPTerm;
        }
    }

    public SPTerm putEmptyList() throws ConversionFailedException, IllegalTermException {
        return this.putString("[]");
    }

    public SPTerm putFloat(double d) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            this.CheckPut();
            try {
                this.spPutFloat(this.sp, this.nativeTermRef, d);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to float");
            }
            SPTerm sPTerm = this;
            Object var5_4 = null;
            return sPTerm;
        }
    }

    public SPTerm putFloat(float f) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            this.CheckPut();
            try {
                this.spPutFloat(this.sp, this.nativeTermRef, f);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to float");
            }
            SPTerm sPTerm = this;
            Object var4_4 = null;
            return sPTerm;
        }
    }

    public SPTerm putFunctor(String string, int n) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            if (n > 0) {
                this.CheckPut();
            }
            try {
                this.spPutFunctor(this.sp, this.nativeTermRef, this.spGetAtomFromString(this.sp, string), n);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to functor");
            }
            SPTerm sPTerm = this;
            Object var5_5 = null;
            return sPTerm;
        }
    }

    public SPTerm putInteger(int n) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            this.CheckPut();
            try {
                this.spPutInteger(this.sp, this.nativeTermRef, n);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to integer");
            }
            SPTerm sPTerm = this;
            Object var4_4 = null;
            return sPTerm;
        }
    }

    public SPTerm putList() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            this.CheckPut();
            try {
                this.spPutList(this.sp, this.nativeTermRef);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to empty list");
            }
            SPTerm sPTerm = this;
            Object var3_3 = null;
            return sPTerm;
        }
    }

    public SPTerm putListChars(String string) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            this.CheckPut();
            try {
                this.spPutListChars(this.sp, this.nativeTermRef, string);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to list of characters");
            }
            SPTerm sPTerm = this;
            Object var4_4 = null;
            return sPTerm;
        }
    }

    public SPTerm putNumberChars(String string) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            this.CheckPut();
            try {
                this.spPutNumberChars(this.sp, this.nativeTermRef, string);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to number");
            }
            SPTerm sPTerm = this;
            Object var4_4 = null;
            return sPTerm;
        }
    }

    public SPTerm putObject(Object object) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            this.CheckPut();
            try {
                long l = this.spCreateGlobalRef(this.sp, object);
                this.consFunctor("$java_object", new SPTerm[]{new SPTerm(this.sp, (int)l)});
            }
            catch (ConversionFailedException conversionFailedException) {
                throw new ConversionFailedException(this.sp, "to object-reference");
            }
            SPTerm sPTerm = this;
            Object var4_5 = null;
            return sPTerm;
        }
    }

    public SPTerm putString(String string) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            try {
                this.spPutString(this.sp, this.nativeTermRef, string);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to atom (string)");
            }
            SPTerm sPTerm = this;
            Object var4_4 = null;
            return sPTerm;
        }
    }

    public SPTerm putTerm(SPTerm sPTerm) throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            sPTerm.CheckValid(this.sp);
            this.CheckPut(sPTerm);
            try {
                this.spPutTerm(this.sp, this.nativeTermRef, sPTerm.nativeTermRef);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to term");
            }
            SPTerm sPTerm2 = this;
            Object var4_4 = null;
            return sPTerm2;
        }
    }

    public SPTerm putVariable() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            this.CheckPut();
            try {
                this.spPutVariable(this.sp, this.nativeTermRef);
            }
            catch (NativeCodeException nativeCodeException) {
                throw new ConversionFailedException(this.sp, "to variable");
            }
            SPTerm sPTerm = this;
            Object var3_3 = null;
            return sPTerm;
        }
    }

    private boolean shouldCheckAge() {
        return this.sp.shouldCheckAge();
    }

    private native int spCompare(SICStus var1, long var2, long var4);

    private native void spConsFunctor(SICStus var1, long var2, long var4, long[] var6) throws NativeCodeException;

    private native void spConsList(SICStus var1, long var2, long var4, long var6) throws NativeCodeException;

    private native long spCreateGlobalRef(SICStus var1, Object var2);

    private native void spGetArg(SICStus var1, long var2, long var4, long var6) throws NativeCodeException;

    private native long spGetAtom(SICStus var1, long var2) throws NativeCodeException;

    private native long spGetAtomFromString(SICStus var1, String var2);

    private native double spGetFloat(SICStus var1, long var2) throws NativeCodeException;

    private native int spGetFunctorArity(SICStus var1, long var2) throws NativeCodeException;

    private native long spGetFunctorCanonical(SICStus var1, long var2) throws NativeCodeException;

    private native long spGetInteger(SICStus var1, long var2) throws NativeCodeException;

    private native void spGetList(SICStus var1, long var2, long var4, long var6) throws NativeCodeException;

    private native String spGetListChars(SICStus var1, long var2) throws NativeCodeException;

    private native String spGetNumberChars(SICStus var1, long var2) throws NativeCodeException;

    private native Object spGetObject(SICStus var1, long var2) throws NativeCodeException;

    private native String spGetString(SICStus var1, long var2) throws NativeCodeException;

    private native String spGetStringFromAtom(SICStus var1, long var2);

    private native boolean spIsAtomic(SICStus var1, long var2);

    private native boolean spIsList(SICStus var1, long var2);

    private native boolean spIsNumber(SICStus var1, long var2);

    private native String spPrintVariable(SICStus var1, long var2);

    private native void spPutAtom(SICStus var1, long var2, long var4) throws NativeCodeException;

    private native void spPutFloat(SICStus var1, long var2, double var4) throws NativeCodeException;

    private native void spPutFunctor(SICStus var1, long var2, long var4, int var6) throws NativeCodeException;

    private native void spPutInteger(SICStus var1, long var2, long var4) throws NativeCodeException;

    private native void spPutList(SICStus var1, long var2) throws NativeCodeException;

    private native void spPutListChars(SICStus var1, long var2, String var4) throws NativeCodeException;

    private native void spPutNumberChars(SICStus var1, long var2, String var4) throws NativeCodeException;

    private native void spPutString(SICStus var1, long var2, String var4) throws NativeCodeException;

    private native void spPutTerm(SICStus var1, long var2, long var4) throws NativeCodeException;

    private native void spPutVariable(SICStus var1, long var2) throws NativeCodeException;

    private native void spRegisterAtom(SICStus var1, long var2);

    private native int spTermType(SICStus var1, long var2);

    private native void spUnRegisterAtom(SICStus var1, long var2);

    private native boolean spUnify(SICStus var1, long var2, long var4);

    String superToString() {
        return super.toString();
    }

    final int termAge() {
        return this.age();
    }

    public String toString() {
        return this.toStringRec(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String toStringRec(int n) {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            try {
                if (!this.isValid()) {
                    return "<error:invalid term>";
                }
                switch (this.type()) {
                    case 2: {
                        return Long.toString(this.getInteger());
                    }
                    case 4: {
                        return Double.toString(this.getDouble());
                    }
                    case 3: {
                        return this.getString();
                    }
                    case 1: {
                        return this.spPrintVariable(this.sp, this.nativeTermRef);
                    }
                    case 5: {
                        String string;
                        int n2;
                        SPTerm sPTerm = new SPTerm(this.sp);
                        StringBuffer stringBuffer = new StringBuffer();
                        try {
                            n2 = this.getFunctorArity();
                            string = this.getFunctorName();
                        }
                        catch (ConversionFailedException conversionFailedException) {
                            return "<cfexcp>";
                        }
                        if (string != null) {
                            stringBuffer.append(string);
                        } else {
                            stringBuffer.append("<null>");
                        }
                        if (n2 < 1) return stringBuffer.toString();
                        stringBuffer.append("(");
                        int n3 = 1;
                        while (n3 <= n2) {
                            try {
                                this.getArg(n3, sPTerm);
                                if (sPTerm != null) {
                                    stringBuffer.append(sPTerm.toStringRec(n + 1));
                                } else {
                                    stringBuffer.append("<null>");
                                }
                            }
                            catch (ConversionFailedException conversionFailedException) {
                                stringBuffer.append("<cfexcp>");
                            }
                            if (n3 < n2) {
                                stringBuffer.append(",");
                            }
                            ++n3;
                        }
                        stringBuffer.append(")");
                        return stringBuffer.toString();
                    }
                }
                return "<unknown>";
            }
            catch (SPException sPException) {
                return "<spexcp>";
            }
        }
    }

    public SPTerm[] toTermArray() throws ConversionFailedException, IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            int n = 1;
            SPTerm sPTerm = new SPTerm(this.sp);
            SPTerm sPTerm2 = new SPTerm(this.sp);
            this.getList(sPTerm, sPTerm2);
            while (sPTerm2.isList()) {
                ++n;
                sPTerm2.getList(sPTerm, sPTerm2);
            }
            SPTerm[] sPTermArray = new SPTerm[n];
            sPTerm2.putTerm(this);
            int n2 = 0;
            while (n2 < n) {
                SPTerm sPTerm3 = new SPTerm(this.sp);
                sPTerm2.getList(sPTerm3, sPTerm2);
                sPTermArray[n2] = sPTerm3;
                ++n2;
            }
            SPTerm[] sPTermArray2 = sPTermArray;
            Object var3_9 = null;
            return sPTermArray2;
        }
    }

    public int type() throws IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            int n = this.spTermType(this.sp, this.nativeTermRef);
            Object var3_3 = null;
            return n;
        }
    }

    public boolean unify(SPTerm sPTerm) throws IllegalTermException {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            this.CheckValid();
            sPTerm.CheckValid(this.sp);
            boolean bl = this.spUnify(this.sp, this.nativeTermRef, sPTerm.nativeTermRef);
            Object var4_4 = null;
            return bl;
        }
    }

    void unlink() throws SPException {
        this.sp.term_stack_unlink(this, this.context == null ? this.sp.query_stack : this.context.predecessor());
        this.next = null;
    }
}

