/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jasper;

import se.sics.jasper.AtomRegisterFailure;
import se.sics.jasper.IllegalTermException;
import se.sics.jasper.SICStus;

public class SPCanonicalAtom {
    SICStus sp;
    long cAtom;
    static long atomNil = 0xA0000000L;

    SPCanonicalAtom(long l) throws AtomRegisterFailure {
        this.sp = SICStus.spGlobal;
        this.cAtom = l;
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            if (this.spRegisterAtom(l) == 0) {
                throw new AtomRegisterFailure(this.sp, "could not register atom");
            }
        }
    }

    SPCanonicalAtom(SICStus sICStus, long l) throws AtomRegisterFailure {
        this.cAtom = l;
        this.sp = sICStus;
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            if (this.spRegisterAtom(l) == 0) {
                throw new AtomRegisterFailure(sICStus, "could not register atom");
            }
        }
    }

    public SPCanonicalAtom(SICStus sICStus, String string) throws AtomRegisterFailure {
        this.sp = sICStus;
        SICStus sICStus2 = sICStus;
        synchronized (sICStus2) {
            this.cAtom = this.spAtomFromString(sICStus, string);
            if (this.spRegisterAtom(this.cAtom) == 0) {
                throw new AtomRegisterFailure(sICStus, "could not register atom");
            }
        }
    }

    void CheckValid() throws IllegalTermException {
        if (!this.isValid()) {
            throw new IllegalTermException(this.sp);
        }
    }

    void CheckValid(SICStus sICStus) throws IllegalTermException {
        if (!this.isValid(sICStus)) {
            throw new IllegalTermException(this.sp);
        }
    }

    long getAtom() throws IllegalTermException {
        this.CheckValid();
        return this.getAtomNumber();
    }

    long getAtomNumber() {
        return this.cAtom;
    }

    public boolean isSameAtom(SPCanonicalAtom sPCanonicalAtom) throws IllegalTermException {
        this.CheckValid();
        sPCanonicalAtom.CheckValid(this.sp);
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            boolean bl = this.getAtomNumber() == sPCanonicalAtom.getAtomNumber();
            Object var4_4 = null;
            return bl;
        }
    }

    boolean isValid() {
        return true;
    }

    boolean isValid(SICStus sICStus) {
        return this.isValid() && sICStus == this.sp;
    }

    private native long spAtomFromString(SICStus var1, String var2);

    private native int spRegisterAtom(long var1);

    private native String spStringFromAtom(long var1);

    private native int spUnRegisterAtom(long var1);

    public String toString() {
        SICStus sICStus = this.sp;
        synchronized (sICStus) {
            String string = this.spStringFromAtom(this.cAtom);
            Object var3_3 = null;
            return string;
        }
    }
}

