// read-files.h
//
// Interface for read-files.l
//
// (c) Mark Johnson, 30th January 2001
//
// The main routine is process_files.


#ifndef READ_FILES_H
#define READ_FILES_H

#include <fstream>
#include <vector>

#include "sym.h"

using namespace std;

extern int    lineno;
extern string filename;

void read_files_new_file();
bool read_files_next_sentence(vector<symbol>& words, vector<symbol>& tags);

// process_files takes two arguments of arbitrary type.
//
// The filenamefile argument must be something that can be coerced into
// an argument for the ifstream() constructor, i.e., a string or a char*.
// It will be used as the name of a file, which should contain a list
// of filenames from which the data will be read.
//
// The proc argument must be a function object or a function pointer.
// proc will be called with two arguments proc(words,tags) for each
// sentence in the training data.  words and tags are both vectors of
// symbols.
//
template <class S, class P>
void process_files(const S& filenamefile, P& proc)
{
  ifstream is(filenamefile);
  if (!is) {
    cerr << "Could not open filename file: " << filenamefile << endl;
    abort();
  }

  vector<symbol> words;
  vector<symbol> tags;

  while (is >> filename) {
    read_files_new_file();
    while (read_files_next_sentence(words, tags))
      proc(words, tags);
  }
}

#endif
