// morph.cc
//
// (c) Mark Johnson, 10th March 2001

#include "morph.h"
#include "sym.h"

#include <wn.h>         // Wordnet include file

#include <ext/hash_map>
#include <string>

static const char* verb_exceptions[][2] = {
  { "'re", "be" },
  { "'ve", "have" },
  { "'ll", "will" },
  { "'d", "would" },
  { "'m", "be" },
  { "'s", "be" },
  { "wo", "will" },
  { "ca", "can" } };

inline symbol trivial_morphology(symbol word)
{
  const string& s = word.string_reference();
  const string::size_type ssize = s.size();
  if (ssize >= 2 && s[ssize-1] == 's' && s[ssize-2] != 's') 
    return symbol(string(s, 0, ssize-1));
  else
    return word;
}

symbol morph_base(symbol word, morph_pos pos)
{
  typedef hash_map<symbol,symbol> SS;
  static SS word_base[ADJECTIVE_SATELLITE];
  
  static bool not_initialized = true;

  if (not_initialized) {
    not_initialized = false;
    wninit();
    for (size_t i = 0; i < sizeof(verb_exceptions)/sizeof(verb_exceptions[0]); ++i)
      word_base[VERB-1].insert(make_pair(symbol(verb_exceptions[i][0]),
					 symbol(verb_exceptions[i][1])));

  }
 
  pair<SS::iterator,bool> wbf(word_base[pos-1].insert(make_pair(word,word)));
  char *w = const_cast<char*>(word.c_str());
  if (wbf.second == true) {                  // was there already an entry in the table?
    char* possible_base = morphword(w, pos); // Can Wordnet simplify this word?
    if (possible_base != NULL)               // Yes.  Insert the simplification into table
      wbf.first->second = symbol(possible_base);
    else                                     // No.
      if (in_wn(w, pos) == 0)                // Does Wordnet know this word?
	wbf.first->second = trivial_morphology(word);  // No.  Have a go at simplifying ourselves
  }
  return wbf.first->second;
}  
