#! /usr/bin/env python

usage = """%prog Version of 12th September 2008

(c) Mark Johnson

Counts how often a feature class is used in a features file

usage: %prog [options]"""

import gzip, optparse, sys

def linecount(inf):
    l_lcs = {}
    lc = 0
    for line in inf:
        lc += 1
        line = line.strip().split(None, 1)[1]
        if line in l_lcs:
            l_lcs[line].append(lc)
        else:
            l_lcs[line] = [lc]
    return l_lcs

if __name__ == "__main__":
    parser = optparse.OptionParser(usage=usage)
    (options,args) = parser.parse_args()

    if len(args) == 0:
        l_lcs = linecount(sys.stdin)
    elif len(args) == 1:
        l_lcs = linecount(gzip.open(args[0], "rU"))
    else:
        l_lcs = {}
        abort()

    for l,lcs in l_lcs.iteritems():
        if len(lcs) > 1:
            print lcs, l

        
