#! /usr/bin/env python

usage = """%prog Version of 12th September 2008

(c) Mark Johnson

Counts how often a feature class is used in a features file

usage: %prog [options]"""

import gzip, optparse, sys

def count_featureclasses(inf):
    feat_count = {}
    for line in inf:
        feat = line.split()[1].split(':')[0]
        if feat in feat_count:
            feat_count[feat] += 1
        else:
            feat_count[feat] = 1
    return feat_count

if __name__ == "__main__":
    parser = optparse.OptionParser(usage=usage)
    (options,args) = parser.parse_args()

    if len(args) == 0:
        fc = count_featureclasses(sys.stdin)
    elif len(args) == 1:
        fc = count_featureclasses(gzip.open(args[0], "rU"))
    else:
        fc = {}
        abort()

    keys = fc.keys()
    keys.sort()
    for f in keys:
        print f, fc[f]

        
