#!/usr/bin/python

# run a demo server
from SparqlEndpoint import SparqlWSGIEndpoint
from wsgiref.simple_server import make_server
import RDF
from paste.urlmap import URLMap

# rdf to query comes from google news
uri = "http://news.google.com/news?q=sparql&output=rss"
port = 8012
storage = RDF.Storage(name="test", storage_name='memory', options_string="")

application = SparqlWSGIEndpoint(storage, allow_default_graph=True, allow_from=True)

# add a model of our own, make it the default graph
model = RDF.Model(storage)
model.load(uri)
application.add_model(uri, model, default=True)


# use paste to set up a simple dispatch scheme
map = URLMap()
map['/sparql'] = application
map[''] = application.form  # everything else goes to the form

server = make_server('localhost', port, map)
print "Server running on http://localhost:%s/" % port

server.serve_forever()
    
    
