"""SPARQL endpoint for Python WSGI
===============================

This module implements a Sparql endpoint that can be run
under a Python WSGI web server.  

Basic usage requires a WSGI framework, the SparqlWSGIEndpoint
class implements a WSGI application:
    
    storage = RDF.Storage(...options...)
    application = SparqlEndpoint.SparqlWSGIEndpoint(storage)
    
    server = wsgiref.simple_server.make_server('localhost', 8080, application)
    server.serve_forever()
    
See demo.py for a working demo.
    
"""

__version__ = "0.1"

from sparql import SparqlWSGIEndpoint

