#! /usr/bin/env python 

usage = """%prog version of 28th May, 2010

(c) Mark Johnson

Write a bunch of PBS job files.

To submit these, run the shell command:

	for fname in *.sh; do qsub $fname; done
"""

ARG1S="berkeley8 berkeley_brown".split()
ARG2S="sp spnn logps sumlogp".split()


CONTENTS="""#! /bin/bash
#PBS -l ncpus=8,walltime=100:00:00,vmem=24000mb

cd $HOME/research/BLLIP/reranking-parser
NCPUS=16

# Mark Johnson, 2nd February 2010

# This script recompiles the reranker code, extracts the features
# from the nbest trees, and retrains and evaluates the reranker itself.

# You can change the flags below here

MAKEFILE=Makefile.BerkeleyMulti

# RERANKERDIR is the directory in which the reranker features
# and models will be stored
#
RERANKERDIR=second-stage

# NBESTPARSERNICKNAME is a nickname for the n-best parser.  If you 
# experiment with several n-best parsers, give each one a different
# nickname.
#
NBESTPARSERNICKNAME=%s

# NBESTDIR is the directory that holds the n-best parses for training
# the reranker.
#
NBESTDIR=second-stage/nbest/$NBESTPARSERNICKNAME

FEATURESNICKNAME=%s
FEATUREEXTRACTOR=second-stage/programs/features/extract-spmfeatures
FEATUREEXTRACTORFLAGS="-l -c -i -s 5 -f $FEATURESNICKNAME"

ESTIMATOR=second-stage/programs/wlle/cvlm-owlqn
ESTIMATORFLAGS="-l 1 -p 2 -c 10 -F 1 -d 10 -n -1 -t 1e-7"
ESTIMATORNICKNAME=owlqn-l1c10p2t1e-7

###############################################################################
#
# You shouldn't need to change anything below here
#
FLAGS="NBESTPARSERNICKNAME=$NBESTPARSERNICKNAME FEATUREEXTRACTOR=$FEATUREEXTRACTOR FEATURESNICKNAME=$FEATURESNICKNAME ESTIMATOR=$ESTIMATOR ESTIMATORNICKNAME=$ESTIMATORNICKNAME"

# The nonfinal version trains on sections 2-19, uses sections 20-21 as dev,
# section 22 as test1 and 24 as test2 (this is the "Collins' split")
#
echo
echo make -f $MAKEFILE eval-reranker VERSION=nonfinal $FLAGS FEATUREEXTRACTORFLAGS="$FEATUREEXTRACTORFLAGS" ESTIMATORFLAGS="$ESTIMATORFLAGS"
time make -f $MAKEFILE eval-reranker VERSION=nonfinal $FLAGS FEATUREEXTRACTORFLAGS="$FEATUREEXTRACTORFLAGS" ESTIMATORFLAGS="$ESTIMATORFLAGS" >& %s
"""

if __name__ == "__main__":
    for a1 in ARG1S:
        for a2 in ARG2S:
            stem = 'run/'+a1+'_'+a2+'_p2'
            outf = file(stem+'.sh', 'w')
            outf.write(CONTENTS%(a1,a2,stem+'.out'))

            
