#! /usr/bin/env python

usage = """%prog Version of 12th June 2010

(c) Mark Johnson

Usage: %prog [options]"""

import optparse, re, sys

fname_rex = re.compile(r"(?P<corpus>all|ec50)(?P<feats>[^/]+?)(?P<type>nonfinal|final)-(?P<opt>[^-/]+)-(?P<optflags>[^/]+)/weights-eval$")
weights_rex = re.compile(r" ([0-9]+) features .*? f-score = ([0-9.]+), .*?, f-score = ([0-9.]+), .*? f-score = ([0-9.]+),", re.DOTALL)
p_rex = re.compile(r"p([12])[st]")

def parse_file(fname):
    fmo = fname_rex.search(fname)
    if fmo:
        weightseval = file(fname, "rU").read()
        wmo = weights_rex.search(weightseval)
        if wmo:
            nfeatures = wmo.group(1)
            dev = wmo.group(2)
            test1 = wmo.group(3)
            test2 = wmo.group(4)
            test12 = "%5f"%((float(test1)+float(test2))/2)
            optflags = fmo.group('optflags')
            pmo = p_rex.search(optflags)
            if pmo:
                p = pmo.group(1)
            else:
                p = "unknown"
            # return (fname, fmo.group('corpus'), fmo.group('feats'), fmo.group('type'), fmo.group('opt'), p, dev, test1, test2)
            return (fmo.group('type'), fmo.group('corpus'), fmo.group('feats'), nfeatures, fmo.group('opt'), p, dev, test1, test2, test12)
        else:
            sys.stderr.write("Error: can't parse weights-eval file contents\n")
            sys.stderr.write(weightseval)
            sys.abort()
    else:
        sys.stderr.write("Error: can't parse file name %s"%fname)
        sys.abort()

    
if __name__ == '__main__':
    parser = optparse.OptionParser(usage=usage)
    (options,args) = parser.parse_args()
    
    results = map(parse_file, args)
    results.sort()
    print "Type\tCorpus\tFeatures\tNFeatures\tOptimizer\tRegularizer\tSections19-20\tSection22\tSection24\tAverage22+24"
    for result in results:
        print '\t'.join(result)
