// test file

const char usage[] =
  "main [-d debug] grammar.txt < strings";

#include <fstream>
#include <iostream>
#include <unistd.h>

#include "cky.h"

int debug = 0;

int main(int argc, char** argv) {

  pcfg_type g;

  int chr;
  while ((chr = getopt(argc, argv, "d:")) != -1)
    switch (chr) {
    case 'd':
      debug = atoi(optarg);
      break;
    default:
      std::cerr << "# Error in " << argv[0] 
		<< ": can't interpret argument -" << chr << std::endl;
      std::cerr << usage << std::endl;
      exit(EXIT_FAILURE);
    }

  if (argc - optind != 1) 
    std::cerr << "# Error in " << argv[0] << '\n' << usage << std::endl;

  {
    std::ifstream is(argv[optind]);
    is >> g;
  }

  std::cout << g << std::endl;

  cky_type parser(g);

  Ss terminals;
  while (readline_symbols(std::cin, terminals)) {
    parser.inside(terminals);
    for (int i = 0; i < 5; ++i) {
      float p = parser.inside(terminals);
      tree* tp = parser.random_tree();
      std::cout << p << ' ' << tp << std::endl;
      delete tp;
    }
  }
  
}
